# coding: utf-8

"""
    ExtremeCloud IQ API

    ExtremeCloud IQ RESTful API for external and internal applications.  # noqa: E501

    The version of the OpenAPI document: 23.1.0.40
    Contact: support@extremenetworks.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from extremecloudiq.api_client import ApiClient
from extremecloudiq.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class CopilotConnectivityExperienceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_wired_connectivity_experience(self, view_type, start_time, end_time, **kwargs):  # noqa: E501
        """get_wired_connectivity_experience  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wired_connectivity_experience(view_type, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqWiredViewType view_type: The type of View (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int page: Page number, min = 1
        :param int limit: Page Size, min = 1, max = 100
        :param XiqSortField sort_field: sort by name or quality index
        :param XiqSortOrder sort_order: The sorting order
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedXiqConnectivityExperienceData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_wired_connectivity_experience_with_http_info(view_type, start_time, end_time, **kwargs)  # noqa: E501

    def get_wired_connectivity_experience_with_http_info(self, view_type, start_time, end_time, **kwargs):  # noqa: E501
        """get_wired_connectivity_experience  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wired_connectivity_experience_with_http_info(view_type, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqWiredViewType view_type: The type of View (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int page: Page number, min = 1
        :param int limit: Page Size, min = 1, max = 100
        :param XiqSortField sort_field: sort by name or quality index
        :param XiqSortOrder sort_order: The sorting order
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedXiqConnectivityExperienceData, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'view_type',
            'start_time',
            'end_time',
            'page',
            'limit',
            'sort_field',
            'sort_order'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wired_connectivity_experience" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'view_type' is set
        if self.api_client.client_side_validation and ('view_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['view_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `view_type` when calling `get_wired_connectivity_experience`")  # noqa: E501
        # verify the required parameter 'start_time' is set
        if self.api_client.client_side_validation and ('start_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_time` when calling `get_wired_connectivity_experience`")  # noqa: E501
        # verify the required parameter 'end_time' is set
        if self.api_client.client_side_validation and ('end_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_time` when calling `get_wired_connectivity_experience`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view_type' in local_var_params and local_var_params['view_type'] is not None:  # noqa: E501
            query_params.append(('viewType', local_var_params['view_type']))  # noqa: E501
        if 'start_time' in local_var_params and local_var_params['start_time'] is not None:  # noqa: E501
            query_params.append(('startTime', local_var_params['start_time']))  # noqa: E501
        if 'end_time' in local_var_params and local_var_params['end_time'] is not None:  # noqa: E501
            query_params.append(('endTime', local_var_params['end_time']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'sort_field' in local_var_params and local_var_params['sort_field'] is not None:  # noqa: E501
            query_params.append(('sortField', local_var_params['sort_field']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/copilot/connectivity/wired/experience', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedXiqConnectivityExperienceData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_wired_events(self, view_type, start_time, end_time, forensic_bucket, score_type, **kwargs):  # noqa: E501
        """get_wired_events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wired_events(view_type, start_time, end_time, forensic_bucket, score_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqWiredViewType view_type: The type of View (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param XiqForensicBucket forensic_bucket: The selected time bucket (required)
        :param XiqCopilotWiredEventsScoreType score_type: The selected score type (required)
        :param int page: Page number, min = 1
        :param int limit: Page Size, min = 1, max = 100
        :param XiqCopilotEventsWiredSortField sort_by: The sort field
        :param XiqSortOrder sort_order: The sorting order
        :param str view_id: The view id based on view type
        :param str search_key: The selected search key
        :param str location_type: The selected location type
        :param str location_id: The selected location id
        :param int timestamp: The timestamp to query, epoch time in milliseconds since 1/1/1970
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedXiqWiredEventEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_wired_events_with_http_info(view_type, start_time, end_time, forensic_bucket, score_type, **kwargs)  # noqa: E501

    def get_wired_events_with_http_info(self, view_type, start_time, end_time, forensic_bucket, score_type, **kwargs):  # noqa: E501
        """get_wired_events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wired_events_with_http_info(view_type, start_time, end_time, forensic_bucket, score_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqWiredViewType view_type: The type of View (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param XiqForensicBucket forensic_bucket: The selected time bucket (required)
        :param XiqCopilotWiredEventsScoreType score_type: The selected score type (required)
        :param int page: Page number, min = 1
        :param int limit: Page Size, min = 1, max = 100
        :param XiqCopilotEventsWiredSortField sort_by: The sort field
        :param XiqSortOrder sort_order: The sorting order
        :param str view_id: The view id based on view type
        :param str search_key: The selected search key
        :param str location_type: The selected location type
        :param str location_id: The selected location id
        :param int timestamp: The timestamp to query, epoch time in milliseconds since 1/1/1970
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedXiqWiredEventEntity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'view_type',
            'start_time',
            'end_time',
            'forensic_bucket',
            'score_type',
            'page',
            'limit',
            'sort_by',
            'sort_order',
            'view_id',
            'search_key',
            'location_type',
            'location_id',
            'timestamp'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wired_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'view_type' is set
        if self.api_client.client_side_validation and ('view_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['view_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `view_type` when calling `get_wired_events`")  # noqa: E501
        # verify the required parameter 'start_time' is set
        if self.api_client.client_side_validation and ('start_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_time` when calling `get_wired_events`")  # noqa: E501
        # verify the required parameter 'end_time' is set
        if self.api_client.client_side_validation and ('end_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_time` when calling `get_wired_events`")  # noqa: E501
        # verify the required parameter 'forensic_bucket' is set
        if self.api_client.client_side_validation and ('forensic_bucket' not in local_var_params or  # noqa: E501
                                                        local_var_params['forensic_bucket'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `forensic_bucket` when calling `get_wired_events`")  # noqa: E501
        # verify the required parameter 'score_type' is set
        if self.api_client.client_side_validation and ('score_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['score_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `score_type` when calling `get_wired_events`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view_type' in local_var_params and local_var_params['view_type'] is not None:  # noqa: E501
            query_params.append(('viewType', local_var_params['view_type']))  # noqa: E501
        if 'start_time' in local_var_params and local_var_params['start_time'] is not None:  # noqa: E501
            query_params.append(('startTime', local_var_params['start_time']))  # noqa: E501
        if 'end_time' in local_var_params and local_var_params['end_time'] is not None:  # noqa: E501
            query_params.append(('endTime', local_var_params['end_time']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'view_id' in local_var_params and local_var_params['view_id'] is not None:  # noqa: E501
            query_params.append(('viewId', local_var_params['view_id']))  # noqa: E501
        if 'forensic_bucket' in local_var_params and local_var_params['forensic_bucket'] is not None:  # noqa: E501
            query_params.append(('forensicBucket', local_var_params['forensic_bucket']))  # noqa: E501
        if 'score_type' in local_var_params and local_var_params['score_type'] is not None:  # noqa: E501
            query_params.append(('scoreType', local_var_params['score_type']))  # noqa: E501
        if 'search_key' in local_var_params and local_var_params['search_key'] is not None:  # noqa: E501
            query_params.append(('searchKey', local_var_params['search_key']))  # noqa: E501
        if 'location_type' in local_var_params and local_var_params['location_type'] is not None:  # noqa: E501
            query_params.append(('locationType', local_var_params['location_type']))  # noqa: E501
        if 'location_id' in local_var_params and local_var_params['location_id'] is not None:  # noqa: E501
            query_params.append(('locationId', local_var_params['location_id']))  # noqa: E501
        if 'timestamp' in local_var_params and local_var_params['timestamp'] is not None:  # noqa: E501
            query_params.append(('timestamp', local_var_params['timestamp']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/copilot/connectivity/wired/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedXiqWiredEventEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_wired_hardware(self, view_type, start_time, end_time, forensic_bucket, **kwargs):  # noqa: E501
        """get_wired_hardware  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wired_hardware(view_type, start_time, end_time, forensic_bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqWiredViewType view_type: The type of View (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param XiqForensicBucket forensic_bucket: The selected time bucket (required)
        :param str view_id: The view id based on view type
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: XiqWiredHardwareResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_wired_hardware_with_http_info(view_type, start_time, end_time, forensic_bucket, **kwargs)  # noqa: E501

    def get_wired_hardware_with_http_info(self, view_type, start_time, end_time, forensic_bucket, **kwargs):  # noqa: E501
        """get_wired_hardware  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wired_hardware_with_http_info(view_type, start_time, end_time, forensic_bucket, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqWiredViewType view_type: The type of View (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param XiqForensicBucket forensic_bucket: The selected time bucket (required)
        :param str view_id: The view id based on view type
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(XiqWiredHardwareResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'view_type',
            'start_time',
            'end_time',
            'forensic_bucket',
            'view_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wired_hardware" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'view_type' is set
        if self.api_client.client_side_validation and ('view_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['view_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `view_type` when calling `get_wired_hardware`")  # noqa: E501
        # verify the required parameter 'start_time' is set
        if self.api_client.client_side_validation and ('start_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_time` when calling `get_wired_hardware`")  # noqa: E501
        # verify the required parameter 'end_time' is set
        if self.api_client.client_side_validation and ('end_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_time` when calling `get_wired_hardware`")  # noqa: E501
        # verify the required parameter 'forensic_bucket' is set
        if self.api_client.client_side_validation and ('forensic_bucket' not in local_var_params or  # noqa: E501
                                                        local_var_params['forensic_bucket'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `forensic_bucket` when calling `get_wired_hardware`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view_type' in local_var_params and local_var_params['view_type'] is not None:  # noqa: E501
            query_params.append(('viewType', local_var_params['view_type']))  # noqa: E501
        if 'start_time' in local_var_params and local_var_params['start_time'] is not None:  # noqa: E501
            query_params.append(('startTime', local_var_params['start_time']))  # noqa: E501
        if 'end_time' in local_var_params and local_var_params['end_time'] is not None:  # noqa: E501
            query_params.append(('endTime', local_var_params['end_time']))  # noqa: E501
        if 'view_id' in local_var_params and local_var_params['view_id'] is not None:  # noqa: E501
            query_params.append(('viewId', local_var_params['view_id']))  # noqa: E501
        if 'forensic_bucket' in local_var_params and local_var_params['forensic_bucket'] is not None:  # noqa: E501
            query_params.append(('forensicBucket', local_var_params['forensic_bucket']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/copilot/connectivity/wired/hardware', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='XiqWiredHardwareResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_wired_quality_index(self, start_time, end_time, **kwargs):  # noqa: E501
        """get_wired_quality_index  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wired_quality_index(start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param XiqWiredViewType view_type: The type of View
        :param str view_id: The view id based on view type
        :param XiqForensicBucket forensic_bucket: The selected time bucket
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: XiqWiredQualityIndexResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_wired_quality_index_with_http_info(start_time, end_time, **kwargs)  # noqa: E501

    def get_wired_quality_index_with_http_info(self, start_time, end_time, **kwargs):  # noqa: E501
        """get_wired_quality_index  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wired_quality_index_with_http_info(start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param XiqWiredViewType view_type: The type of View
        :param str view_id: The view id based on view type
        :param XiqForensicBucket forensic_bucket: The selected time bucket
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(XiqWiredQualityIndexResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'start_time',
            'end_time',
            'view_type',
            'view_id',
            'forensic_bucket'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wired_quality_index" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'start_time' is set
        if self.api_client.client_side_validation and ('start_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_time` when calling `get_wired_quality_index`")  # noqa: E501
        # verify the required parameter 'end_time' is set
        if self.api_client.client_side_validation and ('end_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_time` when calling `get_wired_quality_index`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view_type' in local_var_params and local_var_params['view_type'] is not None:  # noqa: E501
            query_params.append(('viewType', local_var_params['view_type']))  # noqa: E501
        if 'start_time' in local_var_params and local_var_params['start_time'] is not None:  # noqa: E501
            query_params.append(('startTime', local_var_params['start_time']))  # noqa: E501
        if 'end_time' in local_var_params and local_var_params['end_time'] is not None:  # noqa: E501
            query_params.append(('endTime', local_var_params['end_time']))  # noqa: E501
        if 'view_id' in local_var_params and local_var_params['view_id'] is not None:  # noqa: E501
            query_params.append(('viewId', local_var_params['view_id']))  # noqa: E501
        if 'forensic_bucket' in local_var_params and local_var_params['forensic_bucket'] is not None:  # noqa: E501
            query_params.append(('forensicBucket', local_var_params['forensic_bucket']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/copilot/connectivity/wired/quality-index', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='XiqWiredQualityIndexResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_wireless_apps(self, view_type, start_time, end_time, **kwargs):  # noqa: E501
        """get_wireless_apps  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wireless_apps(view_type, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqConnectivityExperienceViewType view_type: The type of View (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param str view_id: The view type identifier
        :param XiqForensicBucket forensic_bucket: The time period bucket detected
        :param str location_id: The location identifier
        :param str location_type: The location type
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: XiqWirelessAppsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_wireless_apps_with_http_info(view_type, start_time, end_time, **kwargs)  # noqa: E501

    def get_wireless_apps_with_http_info(self, view_type, start_time, end_time, **kwargs):  # noqa: E501
        """get_wireless_apps  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wireless_apps_with_http_info(view_type, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqConnectivityExperienceViewType view_type: The type of View (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param str view_id: The view type identifier
        :param XiqForensicBucket forensic_bucket: The time period bucket detected
        :param str location_id: The location identifier
        :param str location_type: The location type
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(XiqWirelessAppsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'view_type',
            'start_time',
            'end_time',
            'view_id',
            'forensic_bucket',
            'location_id',
            'location_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wireless_apps" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'view_type' is set
        if self.api_client.client_side_validation and ('view_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['view_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `view_type` when calling `get_wireless_apps`")  # noqa: E501
        # verify the required parameter 'start_time' is set
        if self.api_client.client_side_validation and ('start_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_time` when calling `get_wireless_apps`")  # noqa: E501
        # verify the required parameter 'end_time' is set
        if self.api_client.client_side_validation and ('end_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_time` when calling `get_wireless_apps`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view_type' in local_var_params and local_var_params['view_type'] is not None:  # noqa: E501
            query_params.append(('viewType', local_var_params['view_type']))  # noqa: E501
        if 'start_time' in local_var_params and local_var_params['start_time'] is not None:  # noqa: E501
            query_params.append(('startTime', local_var_params['start_time']))  # noqa: E501
        if 'end_time' in local_var_params and local_var_params['end_time'] is not None:  # noqa: E501
            query_params.append(('endTime', local_var_params['end_time']))  # noqa: E501
        if 'view_id' in local_var_params and local_var_params['view_id'] is not None:  # noqa: E501
            query_params.append(('viewId', local_var_params['view_id']))  # noqa: E501
        if 'forensic_bucket' in local_var_params and local_var_params['forensic_bucket'] is not None:  # noqa: E501
            query_params.append(('forensicBucket', local_var_params['forensic_bucket']))  # noqa: E501
        if 'location_id' in local_var_params and local_var_params['location_id'] is not None:  # noqa: E501
            query_params.append(('locationId', local_var_params['location_id']))  # noqa: E501
        if 'location_type' in local_var_params and local_var_params['location_type'] is not None:  # noqa: E501
            query_params.append(('locationType', local_var_params['location_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/copilot/connectivity/wireless/apps', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='XiqWirelessAppsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_wireless_connectivity_experience(self, view_type, start_time, end_time, **kwargs):  # noqa: E501
        """get_wireless_connectivity_experience  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wireless_connectivity_experience(view_type, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqConnectivityExperienceViewType view_type: View by location, ssid or osTypes (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int page: Page number, min = 1
        :param int limit: Number of Records, min = 1, max = 100
        :param XiqSortField sort_field: sort by name or quality index
        :param XiqSortOrder sort_order: The sorting order
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedXiqConnectivityExperienceData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_wireless_connectivity_experience_with_http_info(view_type, start_time, end_time, **kwargs)  # noqa: E501

    def get_wireless_connectivity_experience_with_http_info(self, view_type, start_time, end_time, **kwargs):  # noqa: E501
        """get_wireless_connectivity_experience  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wireless_connectivity_experience_with_http_info(view_type, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqConnectivityExperienceViewType view_type: View by location, ssid or osTypes (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int page: Page number, min = 1
        :param int limit: Number of Records, min = 1, max = 100
        :param XiqSortField sort_field: sort by name or quality index
        :param XiqSortOrder sort_order: The sorting order
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedXiqConnectivityExperienceData, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'view_type',
            'start_time',
            'end_time',
            'page',
            'limit',
            'sort_field',
            'sort_order'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wireless_connectivity_experience" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'view_type' is set
        if self.api_client.client_side_validation and ('view_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['view_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `view_type` when calling `get_wireless_connectivity_experience`")  # noqa: E501
        # verify the required parameter 'start_time' is set
        if self.api_client.client_side_validation and ('start_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_time` when calling `get_wireless_connectivity_experience`")  # noqa: E501
        # verify the required parameter 'end_time' is set
        if self.api_client.client_side_validation and ('end_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_time` when calling `get_wireless_connectivity_experience`")  # noqa: E501

        if self.api_client.client_side_validation and 'page' in local_var_params and local_var_params['page'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `get_wireless_connectivity_experience`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_wireless_connectivity_experience`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_wireless_connectivity_experience`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view_type' in local_var_params and local_var_params['view_type'] is not None:  # noqa: E501
            query_params.append(('viewType', local_var_params['view_type']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'start_time' in local_var_params and local_var_params['start_time'] is not None:  # noqa: E501
            query_params.append(('startTime', local_var_params['start_time']))  # noqa: E501
        if 'end_time' in local_var_params and local_var_params['end_time'] is not None:  # noqa: E501
            query_params.append(('endTime', local_var_params['end_time']))  # noqa: E501
        if 'sort_field' in local_var_params and local_var_params['sort_field'] is not None:  # noqa: E501
            query_params.append(('sortField', local_var_params['sort_field']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/copilot/connectivity/wireless/experience', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedXiqConnectivityExperienceData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_wireless_events(self, view_type, start_time, end_time, score_type, **kwargs):  # noqa: E501
        """get_wireless_events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wireless_events(view_type, start_time, end_time, score_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqConnectivityExperienceViewType view_type: View by location, ssid or osTypes (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param XiqCopilotWirelessEventsScoreType score_type: The wireless score type (required)
        :param int page: Page number, min = 1
        :param int limit: Number of Records, min = 1, max = 100
        :param XiqCopilotEventsWirelessSortField sort_field: the sort field
        :param XiqSortOrder sort_order: The sorting order
        :param str view_id: The view type identifier
        :param XiqForensicBucket forensic_bucket: The time period bucket detected
        :param str search_key: The search key
        :param str location_id: The location identifier
        :param str location_type: The location type
        :param int timestamp: The timestamp to query, epoch time in milliseconds since 1/1/1970
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PagedXiqCopilotWirelessEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_wireless_events_with_http_info(view_type, start_time, end_time, score_type, **kwargs)  # noqa: E501

    def get_wireless_events_with_http_info(self, view_type, start_time, end_time, score_type, **kwargs):  # noqa: E501
        """get_wireless_events  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wireless_events_with_http_info(view_type, start_time, end_time, score_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqConnectivityExperienceViewType view_type: View by location, ssid or osTypes (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param XiqCopilotWirelessEventsScoreType score_type: The wireless score type (required)
        :param int page: Page number, min = 1
        :param int limit: Number of Records, min = 1, max = 100
        :param XiqCopilotEventsWirelessSortField sort_field: the sort field
        :param XiqSortOrder sort_order: The sorting order
        :param str view_id: The view type identifier
        :param XiqForensicBucket forensic_bucket: The time period bucket detected
        :param str search_key: The search key
        :param str location_id: The location identifier
        :param str location_type: The location type
        :param int timestamp: The timestamp to query, epoch time in milliseconds since 1/1/1970
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PagedXiqCopilotWirelessEvent, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'view_type',
            'start_time',
            'end_time',
            'score_type',
            'page',
            'limit',
            'sort_field',
            'sort_order',
            'view_id',
            'forensic_bucket',
            'search_key',
            'location_id',
            'location_type',
            'timestamp'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wireless_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'view_type' is set
        if self.api_client.client_side_validation and ('view_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['view_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `view_type` when calling `get_wireless_events`")  # noqa: E501
        # verify the required parameter 'start_time' is set
        if self.api_client.client_side_validation and ('start_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_time` when calling `get_wireless_events`")  # noqa: E501
        # verify the required parameter 'end_time' is set
        if self.api_client.client_side_validation and ('end_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_time` when calling `get_wireless_events`")  # noqa: E501
        # verify the required parameter 'score_type' is set
        if self.api_client.client_side_validation and ('score_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['score_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `score_type` when calling `get_wireless_events`")  # noqa: E501

        if self.api_client.client_side_validation and 'page' in local_var_params and local_var_params['page'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `get_wireless_events`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_wireless_events`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_wireless_events`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view_type' in local_var_params and local_var_params['view_type'] is not None:  # noqa: E501
            query_params.append(('viewType', local_var_params['view_type']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'start_time' in local_var_params and local_var_params['start_time'] is not None:  # noqa: E501
            query_params.append(('startTime', local_var_params['start_time']))  # noqa: E501
        if 'end_time' in local_var_params and local_var_params['end_time'] is not None:  # noqa: E501
            query_params.append(('endTime', local_var_params['end_time']))  # noqa: E501
        if 'sort_field' in local_var_params and local_var_params['sort_field'] is not None:  # noqa: E501
            query_params.append(('sortField', local_var_params['sort_field']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'view_id' in local_var_params and local_var_params['view_id'] is not None:  # noqa: E501
            query_params.append(('viewId', local_var_params['view_id']))  # noqa: E501
        if 'score_type' in local_var_params and local_var_params['score_type'] is not None:  # noqa: E501
            query_params.append(('scoreType', local_var_params['score_type']))  # noqa: E501
        if 'forensic_bucket' in local_var_params and local_var_params['forensic_bucket'] is not None:  # noqa: E501
            query_params.append(('forensicBucket', local_var_params['forensic_bucket']))  # noqa: E501
        if 'search_key' in local_var_params and local_var_params['search_key'] is not None:  # noqa: E501
            query_params.append(('searchKey', local_var_params['search_key']))  # noqa: E501
        if 'location_id' in local_var_params and local_var_params['location_id'] is not None:  # noqa: E501
            query_params.append(('locationId', local_var_params['location_id']))  # noqa: E501
        if 'location_type' in local_var_params and local_var_params['location_type'] is not None:  # noqa: E501
            query_params.append(('locationType', local_var_params['location_type']))  # noqa: E501
        if 'timestamp' in local_var_params and local_var_params['timestamp'] is not None:  # noqa: E501
            query_params.append(('timestamp', local_var_params['timestamp']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/copilot/connectivity/wireless/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedXiqCopilotWirelessEvent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_wireless_performance(self, view_type, start_time, end_time, **kwargs):  # noqa: E501
        """get_wireless_performance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wireless_performance(view_type, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqConnectivityExperienceViewType view_type: The type of View (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param str view_id: The view type identifier
        :param XiqForensicBucket forensic_bucket: The time period bucket detected
        :param str location_id: The location identifier
        :param str location_type: The location type
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: XiqWirelessConnectivityPerformanceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_wireless_performance_with_http_info(view_type, start_time, end_time, **kwargs)  # noqa: E501

    def get_wireless_performance_with_http_info(self, view_type, start_time, end_time, **kwargs):  # noqa: E501
        """get_wireless_performance  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wireless_performance_with_http_info(view_type, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqConnectivityExperienceViewType view_type: The type of View (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param str view_id: The view type identifier
        :param XiqForensicBucket forensic_bucket: The time period bucket detected
        :param str location_id: The location identifier
        :param str location_type: The location type
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(XiqWirelessConnectivityPerformanceResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'view_type',
            'start_time',
            'end_time',
            'view_id',
            'forensic_bucket',
            'location_id',
            'location_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wireless_performance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'view_type' is set
        if self.api_client.client_side_validation and ('view_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['view_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `view_type` when calling `get_wireless_performance`")  # noqa: E501
        # verify the required parameter 'start_time' is set
        if self.api_client.client_side_validation and ('start_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_time` when calling `get_wireless_performance`")  # noqa: E501
        # verify the required parameter 'end_time' is set
        if self.api_client.client_side_validation and ('end_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_time` when calling `get_wireless_performance`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view_type' in local_var_params and local_var_params['view_type'] is not None:  # noqa: E501
            query_params.append(('viewType', local_var_params['view_type']))  # noqa: E501
        if 'start_time' in local_var_params and local_var_params['start_time'] is not None:  # noqa: E501
            query_params.append(('startTime', local_var_params['start_time']))  # noqa: E501
        if 'end_time' in local_var_params and local_var_params['end_time'] is not None:  # noqa: E501
            query_params.append(('endTime', local_var_params['end_time']))  # noqa: E501
        if 'view_id' in local_var_params and local_var_params['view_id'] is not None:  # noqa: E501
            query_params.append(('viewId', local_var_params['view_id']))  # noqa: E501
        if 'forensic_bucket' in local_var_params and local_var_params['forensic_bucket'] is not None:  # noqa: E501
            query_params.append(('forensicBucket', local_var_params['forensic_bucket']))  # noqa: E501
        if 'location_id' in local_var_params and local_var_params['location_id'] is not None:  # noqa: E501
            query_params.append(('locationId', local_var_params['location_id']))  # noqa: E501
        if 'location_type' in local_var_params and local_var_params['location_type'] is not None:  # noqa: E501
            query_params.append(('locationType', local_var_params['location_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/copilot/connectivity/wireless/performance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='XiqWirelessConnectivityPerformanceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_wireless_quality_index(self, view_type, start_time, end_time, **kwargs):  # noqa: E501
        """get_wireless_quality_index  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wireless_quality_index(view_type, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqConnectivityExperienceViewType view_type: The type of View (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param str view_id: The view type identifier
        :param XiqForensicBucket forensic_bucket: The time period bucket detected
        :param str location_id: The location identifier
        :param str location_type: The location type
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: XiqWirelessQualityIndexResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_wireless_quality_index_with_http_info(view_type, start_time, end_time, **kwargs)  # noqa: E501

    def get_wireless_quality_index_with_http_info(self, view_type, start_time, end_time, **kwargs):  # noqa: E501
        """get_wireless_quality_index  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wireless_quality_index_with_http_info(view_type, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqConnectivityExperienceViewType view_type: The type of View (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param str view_id: The view type identifier
        :param XiqForensicBucket forensic_bucket: The time period bucket detected
        :param str location_id: The location identifier
        :param str location_type: The location type
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(XiqWirelessQualityIndexResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'view_type',
            'start_time',
            'end_time',
            'view_id',
            'forensic_bucket',
            'location_id',
            'location_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wireless_quality_index" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'view_type' is set
        if self.api_client.client_side_validation and ('view_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['view_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `view_type` when calling `get_wireless_quality_index`")  # noqa: E501
        # verify the required parameter 'start_time' is set
        if self.api_client.client_side_validation and ('start_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_time` when calling `get_wireless_quality_index`")  # noqa: E501
        # verify the required parameter 'end_time' is set
        if self.api_client.client_side_validation and ('end_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_time` when calling `get_wireless_quality_index`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view_type' in local_var_params and local_var_params['view_type'] is not None:  # noqa: E501
            query_params.append(('viewType', local_var_params['view_type']))  # noqa: E501
        if 'start_time' in local_var_params and local_var_params['start_time'] is not None:  # noqa: E501
            query_params.append(('startTime', local_var_params['start_time']))  # noqa: E501
        if 'end_time' in local_var_params and local_var_params['end_time'] is not None:  # noqa: E501
            query_params.append(('endTime', local_var_params['end_time']))  # noqa: E501
        if 'view_id' in local_var_params and local_var_params['view_id'] is not None:  # noqa: E501
            query_params.append(('viewId', local_var_params['view_id']))  # noqa: E501
        if 'forensic_bucket' in local_var_params and local_var_params['forensic_bucket'] is not None:  # noqa: E501
            query_params.append(('forensicBucket', local_var_params['forensic_bucket']))  # noqa: E501
        if 'location_id' in local_var_params and local_var_params['location_id'] is not None:  # noqa: E501
            query_params.append(('locationId', local_var_params['location_id']))  # noqa: E501
        if 'location_type' in local_var_params and local_var_params['location_type'] is not None:  # noqa: E501
            query_params.append(('locationType', local_var_params['location_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/copilot/connectivity/wireless/quality-index', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='XiqWirelessQualityIndexResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_wireless_time_to_connect(self, view_type, start_time, end_time, **kwargs):  # noqa: E501
        """get_wireless_time_to_connect  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wireless_time_to_connect(view_type, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqConnectivityExperienceViewType view_type: The type of View (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param str view_id: The view type identifier
        :param XiqForensicBucket forensic_bucket: The time period bucket detected
        :param str location_id: The location identifier
        :param str location_type: The location type
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: XiqWirelessTimeToConnectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_wireless_time_to_connect_with_http_info(view_type, start_time, end_time, **kwargs)  # noqa: E501

    def get_wireless_time_to_connect_with_http_info(self, view_type, start_time, end_time, **kwargs):  # noqa: E501
        """get_wireless_time_to_connect  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wireless_time_to_connect_with_http_info(view_type, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqConnectivityExperienceViewType view_type: The type of View (required)
        :param int start_time: The start time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param int end_time: The end time to query, epoch time in milliseconds since 1/1/1970 (required)
        :param str view_id: The view type identifier
        :param XiqForensicBucket forensic_bucket: The time period bucket detected
        :param str location_id: The location identifier
        :param str location_type: The location type
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(XiqWirelessTimeToConnectResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'view_type',
            'start_time',
            'end_time',
            'view_id',
            'forensic_bucket',
            'location_id',
            'location_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wireless_time_to_connect" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'view_type' is set
        if self.api_client.client_side_validation and ('view_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['view_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `view_type` when calling `get_wireless_time_to_connect`")  # noqa: E501
        # verify the required parameter 'start_time' is set
        if self.api_client.client_side_validation and ('start_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['start_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `start_time` when calling `get_wireless_time_to_connect`")  # noqa: E501
        # verify the required parameter 'end_time' is set
        if self.api_client.client_side_validation and ('end_time' not in local_var_params or  # noqa: E501
                                                        local_var_params['end_time'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `end_time` when calling `get_wireless_time_to_connect`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view_type' in local_var_params and local_var_params['view_type'] is not None:  # noqa: E501
            query_params.append(('viewType', local_var_params['view_type']))  # noqa: E501
        if 'start_time' in local_var_params and local_var_params['start_time'] is not None:  # noqa: E501
            query_params.append(('startTime', local_var_params['start_time']))  # noqa: E501
        if 'end_time' in local_var_params and local_var_params['end_time'] is not None:  # noqa: E501
            query_params.append(('endTime', local_var_params['end_time']))  # noqa: E501
        if 'view_id' in local_var_params and local_var_params['view_id'] is not None:  # noqa: E501
            query_params.append(('viewId', local_var_params['view_id']))  # noqa: E501
        if 'forensic_bucket' in local_var_params and local_var_params['forensic_bucket'] is not None:  # noqa: E501
            query_params.append(('forensicBucket', local_var_params['forensic_bucket']))  # noqa: E501
        if 'location_id' in local_var_params and local_var_params['location_id'] is not None:  # noqa: E501
            query_params.append(('locationId', local_var_params['location_id']))  # noqa: E501
        if 'location_type' in local_var_params and local_var_params['location_type'] is not None:  # noqa: E501
            query_params.append(('locationType', local_var_params['location_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/copilot/connectivity/wireless/time-to-connect', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='XiqWirelessTimeToConnectResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_wireless_views(self, view_type, **kwargs):  # noqa: E501
        """get_wireless_views  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wireless_views(view_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqWirelessViewsListType view_type: The type of View (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: XiqWirelessViewsTypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_wireless_views_with_http_info(view_type, **kwargs)  # noqa: E501

    def get_wireless_views_with_http_info(self, view_type, **kwargs):  # noqa: E501
        """get_wireless_views  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_wireless_views_with_http_info(view_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param XiqWirelessViewsListType view_type: The type of View (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(XiqWirelessViewsTypeResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'view_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wireless_views" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'view_type' is set
        if self.api_client.client_side_validation and ('view_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['view_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `view_type` when calling `get_wireless_views`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'view_type' in local_var_params and local_var_params['view_type'] is not None:  # noqa: E501
            query_params.append(('viewType', local_var_params['view_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/copilot/connectivity/wireless/views', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='XiqWirelessViewsTypeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
