import os
import setuptools
from io import open

# read the contents of your README file
from os import path
this_directory = path.abspath(path.dirname(__file__))
with open(path.join(this_directory, 'README.md'), encoding='utf-8') as f:
    long_description = f.read()

setuptools.setup(
    name="blickfeld_scanner",
    version="2.10.2",
    author="Blickfeld GmbH",
    author_email="opensource@blickfeld.com",
    description="Python package to communicate with LiDAR devices of the Blickfeld GmbH.",
    long_description=long_description,
    long_description_content_type='text/markdown',
    url="https://github.com/Blickfeld/blickfeld-scanner-lib",
    packages=setuptools.find_packages(),
    classifiers=[
        "Programming Language :: Python :: 2",
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: BSD License",
        "Operating System :: OS Independent",
        "Topic :: Scientific/Engineering",
        "Topic :: Utilities",
    ],
    install_requires=[
    	'protobuf>=3.6.1',
    	'zeroconf'
	],
)
