import cv2
import numpy as np
import imutils
import random 
# A box is a tuple (category,(x,y,w,h)) where category is the category of the
# object, x and y represent the top-left corner, w is the width and h is the height.
def detectBox(imageShape,box,technique):
    mask = np.zeros(imageShape, dtype="uint8")
    if(len(box)==2):
        (category,(x,y,w,h)) = box
        confidence=1.0
    else:
        (category,(x,y,w,h),confidence) = box
    cv2.rectangle(mask, (int(x), int(y)), (int(x+w), int(y+h)), 255, -1)
    newmask = technique.apply(*[mask])

    cnts = cv2.findContours(newmask.copy(), cv2.RETR_EXTERNAL, cv2.CHAIN_APPROX_SIMPLE)
    cnts = cnts[0] if imutils.is_cv2() or imutils.is_cv4() else cnts[1]
    if(len(cnts)==0):
        return None
    return (category,cv2.boundingRect(cnts[0]),confidence)


# Boxes is a list of boxes with the following format: (category,(x,y,w,h),confidence)
def detectBoxes(imageShape,boxes,technique):
    return [detectBox(imageShape,box,technique) for box in boxes if detectBox(imageShape,box,technique) is not None]








