# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['iso8601']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'iso8601',
    'version': '1.0.0',
    'description': 'Simple module to parse ISO 8601 dates',
    'long_description': 'Simple module to parse ISO 8601 dates\n\nThis module parses the most common forms of ISO 8601 date strings (e.g. 2007-01-14T20:34:22+00:00) into datetime objects.\n\n>>> import iso8601\n>>> iso8601.parse_date("2007-01-25T12:00:00Z")\ndatetime.datetime(2007, 1, 25, 12, 0, tzinfo=<iso8601.Utc>)\n>>>\n\nSee the LICENSE file for the license this package is released under.\n\nIf you want more full featured parsing look at:\n\n- https://arrow.readthedocs.io - arrow\n- https://pendulum.eustace.io - pendulum\n- https://labix.org/python-dateutil - python-dateutil\n- https://docs.python.org/3/library/datetime.html#datetime.datetime.fromisoformat - Yes, Python 3 has built in parsing too!\n\nParsed Formats\n==============\n\nYou can parse full date + times, or just the date. In both cases a datetime instance is returned but with missing times defaulting to 0, and missing days / months defaulting to 1.\n\nDates\n-----\n\n- YYYY-MM-DD\n- YYYYMMDD\n- YYYY-MM (defaults to 1 for the day)\n- YYYY (defaults to 1 for month and day)\n\nTimes\n-----\n\n- hh:mm:ss.nn\n- hhmmss.nn\n- hh:mm (defaults to 0 for seconds)\n- hhmm (defaults to 0 for seconds)\n- hh (defaults to 0 for minutes and seconds)\n\nTime Zones\n----------\n\n- Nothing, will use the default timezone given (which in turn defaults to UTC).\n- Z (UTC)\n- +/-hh:mm\n- +/-hhmm\n- +/-hh\n\nWhere it Differs From ISO 8601\n==============================\n\nKnown differences from the ISO 8601 spec:\n\n- You can use a " " (space) instead of T for separating date from time.\n- Days and months without a leading 0 (2 vs 02) will be parsed.\n- If time zone information is omitted the default time zone given is used (which in turn defaults to UTC). Use a default of None to yield naive datetime instances.\n\nHomepage\n========\n\n- Documentation: https://pyiso8601.readthedocs.org/\n- Source: https://github.com/micktwomey/pyiso8601\n\nReferences\n==========\n\n- https://en.wikipedia.org/wiki/ISO_8601\n\n- https://www.cl.cam.ac.uk/~mgk25/iso-time.html - simple overview\n\n- https://web.archive.org/web/20090309040208/http://hydracen.com/dx/iso8601.htm - more detailed enumeration of valid formats.\n\nTesting\n=======\n\n1. `poetry install`\n2. `poetry run nox`\n\nNote that you need all the pythons installed to perform a tox run (see below). pyenv helps hugely, use pyenv install for the versions you need then use \'pyenv local version ...\' to link them in (the tox-pyenv plugin will pick them up).\n\nAlternatively, to test only with your current python:\n\n1. `poetry install`\n2. `pytest`\n\nReleasing\n=========\n\n1. Ensure there is a new version committed to main (use `poetry version <action>` to bump).\n2. Ensure README.rst changelog is up to date.\n3. Note new and previous version.\n4. `rm -rf dist`\n5. `poetry build`\n6. `git log --oneline $LAST_VERSION..@ > git_log.txt`\n7. `gh release create --notes-file git_log.txt --title $(poetry version -s) $(poetry version -s) dist/*`\n8. `poetry publish`\n\nSupported Python Versions\n=========================\n\nTested against:\n\n- Python 3.6\n- Python 3.7\n- Python 3.8\n- Python 3.9\n- Python 3.10\n- PyPy 3\n\nPython 3 versions < 3.6 are untested but should work.\n\nChanges\n=======\n\n1.0.0\n-----\n\n* Drop python < 3.6 support\n* Add type annotations to code\n* Remove external type annotations in pyi\n* Switch to poetry for packaging\n* Simplify internals and remove old compatability code\n* Switch to nox for testing\n* Lots of small project development changes\n\n0.1.16\n------\n\n* Include `docs/` into sdist tarball (thanks to kloczek in https://github.com/micktwomey/pyiso8601/issues/14)\n\n0.1.15\n------\n\n* Include .pyi files in built wheels and source tarballs\n\n0.1.14\n------\n\n* Add GitHub build actions for project\n* Add project URLs in setup.py (thanks to Steve Piercy)\n* Update README links (thanks to Steve Piercy)\n* Fix handling of README in setup.py (encoding fun in 3.5, 3.6 and pypy3)\n* Fix README links (thanks to Chris Barker)\n* Add Python 3.9 to test matrix (thanks to Luciano Mammino)\n* Add type hints (thanks to Brett Cannon)\n* Derive `ParseError` from `ValueError` (thanks to Lex Robinson)\n\n0.1.13\n------\n\n* Move to GitHub (https://github.com/micktwomey/pyiso8601). Thanks go to Martin Häcker for pointing out the bitbucket project had been deleted by Atlassian!\n* Remove python 2.6, 3.2, 3.3 and 3.4 from tests\n* Add python 3.7 and 3.8 to tests\n\n0.1.12\n------\n\n* Fix class reference for iso8601.Utc in module docstring (thanks to felixschwarz in https://bitbucket.org/micktwomey/pyiso8601/pull-requests/7/fix-class-reference-for-iso8601utc-in/diff)\n\n0.1.11\n------\n\n* Remove logging (thanks to Quentin Pradet in https://bitbucket.org/micktwomey/pyiso8601/pull-requests/6/remove-debug-logging/diff)\n* Add support for , as separator for fractional part (thanks to ecksun in https://bitbucket.org/micktwomey/pyiso8601/pull-requests/5/add-support-for-as-separator-for/diff)\n* Add Python 3.4 and 3.5 to tox test config.\n* Add PyPy 3 to tox test config.\n* Link to documentation at https://pyiso8601.readthedocs.org/\n\n\n0.1.10\n------\n\n* Fixes https://bitbucket.org/micktwomey/pyiso8601/issue/14/regression-yyyy-mm-no-longer-parses (thanks to Kevin Gill for reporting)\n* Adds YYYY as a valid date (uses 1 for both month and day)\n* Woo, semantic versioning, .10 at last.\n\n0.1.9\n-----\n\n* Lots of fixes tightening up parsing from jdanjou. In particular more invalid cases are treated as errors. Also includes fixes for tests (which is how these invalid cases got in in the first place).\n* Release addresses https://bitbucket.org/micktwomey/pyiso8601/issue/13/new-release-based-on-critical-bug-fix\n\n0.1.8\n-----\n\n* Remove +/- chars from README.rst and ensure tox tests run using LC_ALL=C. The setup.py egg_info command was failing in python 3.* on some setups (basically any where the system encoding wasn\'t UTF-8). (https://bitbucket.org/micktwomey/pyiso8601/issue/10/setuppy-broken-for-python-33) (thanks to klmitch)\n\n0.1.7\n-----\n\n* Fix parsing of microseconds (https://bitbucket.org/micktwomey/pyiso8601/issue/9/regression-parsing-microseconds) (Thanks to dims and bnemec)\n\n0.1.6\n-----\n\n* Correct negative timezone offsets (https://bitbucket.org/micktwomey/pyiso8601/issue/8/015-parses-negative-timezones-incorrectly) (thanks to Jonathan Lange)\n\n0.1.5\n-----\n\n* Wow, it\'s alive! First update since 2007\n* Moved over to https://bitbucket.org/micktwomey/pyiso8601\n* Add support for python 3. https://code.google.com/p/pyiso8601/issues/detail?id=23 (thanks to zefciu)\n* Switched to py.test and tox for testing\n* Make seconds optional in date format ("1997-07-16T19:20+01:00" now valid). https://bitbucket.org/micktwomey/pyiso8601/pull-request/1/make-the-inclusion-of-seconds-optional-in/diff (thanks to Chris Down)\n* Correctly raise ParseError for more invalid inputs (https://bitbucket.org/micktwomey/pyiso8601/issue/1/raise-parseerror-for-invalid-input) (thanks to manish.tomar)\n* Support more variations of ISO 8601 dates, times and time zone specs.\n* Fix microsecond rounding issues (https://bitbucket.org/micktwomey/pyiso8601/issue/2/roundoff-issues-when-parsing-decimal) (thanks to nielsenb@jetfuse.net)\n* Fix pickling and deepcopy of returned datetime objects (https://bitbucket.org/micktwomey/pyiso8601/issue/3/dates-returned-by-parse_date-do-not) (thanks to fogathmann and john@openlearning.com)\n* Fix timezone offsets without a separator (https://bitbucket.org/micktwomey/pyiso8601/issue/4/support-offsets-without-a-separator) (thanks to joe.walton.gglcd)\n* "Z" produces default timezone if one is specified (https://bitbucket.org/micktwomey/pyiso8601/issue/5/z-produces-default-timezone-if-one-is) (thanks to vfaronov). This one may cause problems if you\'ve been relying on default_timezone to use that timezone instead of UTC. Strictly speaking that was wrong but this is potentially backwards incompatible.\n* Handle compact date format (https://bitbucket.org/micktwomey/pyiso8601/issue/6/handle-compact-date-format) (thanks to rvandolson@esri.com)\n\n0.1.4\n-----\n\n* The default_timezone argument wasn\'t being passed through correctly, UTC was being used in every case. Fixes issue 10.\n\n0.1.3\n-----\n\n* Fixed the microsecond handling, the generated microsecond values were way too small. Fixes issue 9.\n\n0.1.2\n-----\n\n* Adding ParseError to __all__ in iso8601 module, allows people to import it. Addresses issue 7.\n* Be a little more flexible when dealing with dates without leading zeroes. This violates the spec a little, but handles more dates as seen in the field. Addresses issue 6.\n* Allow date/time separators other than T.\n\n0.1.1\n-----\n\n* When parsing dates without a timezone the specified default is used. If no default is specified then UTC is used. Addresses issue 4.\n',
    'author': 'Michael Twomey',
    'author_email': 'mick@twomeylee.name',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/micktwomey/pyiso8601',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.6.2,<4.0',
}


setup(**setup_kwargs)
