
import pandas as pd
import numpy as np
import feather
import matplotlib.pyplot as plt

##macOS
intensities_raw = feather.read_dataframe("/Users/lw/Nextcloud/Project212/src/data/example_dataset.feather")
annotation_metadata = feather.read_dataframe("/Users/lw/Nextcloud/Project212/src/data/example_metadata.feather")

##windows
intensities_raw = feather.read_dataframe("C:/Users/weidner.leopold/Nextcloud/Project212/src/data/example_dataset.feather")
##intensities_raw = feather.read_dataframe("C:/Users/weidner.leopold/Nextcloud/Project212/src/data/example_all_dataset.feather")

annotation_metadata = feather.read_dataframe("C:/Users/weidner.leopold/Nextcloud/Project212/src/data/example_metadata.feather")
##annotation_metadata = feather.read_dataframe("C:/Users/weidner.leopold/Nextcloud/Project212/src/data/example_all_metadata.feather")

#%%setup imp module
IDs = annotation_metadata["ID"]
intensities_raw = intensities_raw.drop("ID", axis = 1)

df = intensities_raw.copy()

#%%test imputation module

raw_imp = impute_intensities(intensities_raw, method = "linear")

## indices of oxygen series from C15H17O2N 55 -> 66 ->> 83 ->>> 99
#%%setup corr mudule
method = "spearman"

custom_adducts = None

mass_error = 0.1

masses = annotation_metadata.iloc[:,3]

threshold = 0.95

adducts =  identify_adducts(raw_imp, annotation_metadata["ThMass.Ion"], 
                         custom_adducts = pd.DataFrame({'deltamz': [47.984744], 'motive': ["O3"]}),
                         method = "spearman", threshold = 0.9, mass_error = 5)
   



#%%setup import from mgf
import os
from matchms.importing import load_from_mgf


path_data = "C:/Users/weidner.leopold/Nextcloud/Project212/src/data/"  
file_mgf = os.path.join(path_data, "example_dataset.mgf")
spectrums = list(load_from_mgf(file_mgf))

testXX = align_spectra(spectrums)


#%% import-export-cylce

from matchms import exporting

ftints = intensities_raw.copy()
ftints["mean"] = annotation_metadata["ThMass.Ion"]

testX =  export_to_spectra(ftints, 88)

exporting.save_as_mgf(testX, filename = "example_dataset.mgf")


os.getcwd()



O1 = reslist["O"]
O2 = reslist["O2"]
O3 = reslist["O3"]
H2O = reslist["H2O"]

x = np.intersect1d(O3["base_index"], np.intersect1d(O1["base_index"],O2["base_index"]))
a = np.intersect1d(x , H2O["base_index"])



#%% plotting module 

IDs = [55,66,83,99]
df = raw_imp.copy()
transform = True

test = plot_adducts([55,66,83,99], df = raw_imp)
test = plot_adducts(IDs, df, metadata = annotation_metadata, transform = False)















#%% from Huber

import numpy as np
import pytest
from matchms import Fragments


def test_fragments_init():

    mz = np.array([10, 20, 30], dtype="float")
    intensities = np.array([100, 20, 300], dtype="float")

    peaks = Fragments(mz=mz, intensities=intensities)

    assert peaks is not None
    assert np.allclose(mz, peaks.mz)
    assert np.allclose(intensities, peaks.intensities)


def test_fragments_mz_wrong_numpy_dtype():

    mz = np.array([10, 20, 30], dtype="int")
    intensities = np.array([100, 20, 300], dtype="float")

    with pytest.raises(AssertionError) as msg:
        _ = Fragments(mz=mz, intensities=intensities)

    assert str(msg.value) == "Input argument 'mz' should be an array of type float."


def test_fragments_intensities_wrong_numpy_dtype():

    mz = np.array([10, 20, 30], dtype="float")
    intensities = np.array([100, 20, 300], dtype="int")

    with pytest.raises(AssertionError) as msg:
        _ = Fragments(mz=mz, intensities=intensities)

    assert str(msg.value) == "Input argument 'intensities' should be an array of type float."


def test_fragments_same_shape():

    mz = np.array([10, 20, 30, 40], dtype="float")
    intensities = np.array([100, 20, 300], dtype="float")

    with pytest.raises(AssertionError) as msg:
        _ = Fragments(mz=mz, intensities=intensities)

    assert str(msg.value) == "Input arguments 'mz' and 'intensities' should be the same shape."


def test_fragments_mz_wrong_data_type():

    mz = [10, 20, 30]
    intensities = np.array([100, 20, 300], dtype="float")

    with pytest.raises(AssertionError) as msg:
        _ = Fragments(mz=mz, intensities=intensities)

    assert str(msg.value) == "Input argument 'mz' should be a np.array."


def test_fragments_intensities_wrong_data_type():

    mz = np.array([10, 20, 30], dtype="float")
    intensities = [100, 20, 300]

    with pytest.raises(AssertionError) as msg:
        _ = Fragments(mz=mz, intensities=intensities)

    assert str(msg.value) == "Input argument 'intensities' should be a np.array."


def test_fragments_dot_clone():

    mz = np.array([10, 20, 30], dtype="float")
    intensities = np.array([100, 20, 300], dtype="float")

    peaks = Fragments(mz=mz, intensities=intensities)

    peaks_cloned = peaks.clone()

    assert peaks == peaks_cloned
    assert peaks is not peaks_cloned


def test_fragments_getitem():

    mz = np.array([10, 20, 30], dtype="float")
    intensities = np.array([100, 20, 300], dtype="float")

    peaks = Fragments(mz=mz, intensities=intensities)

    assert np.allclose(peaks[1], np.array(mz[1], intensities[1]))
    assert np.allclose(peaks[:],
                          np.stack((peaks.mz, peaks.intensities)))


def test_fragments_to_numpy():
    """Test conversion to stacked numpy array"""
    mz = np.array([10, 20, 30], dtype="float")
    intensities = np.array([100, 99.9, 300], dtype="float")

    peaks = Fragments(mz=mz, intensities=intensities)

    assert np.allclose(peaks.to_numpy, np.array([[10., 100.],
                                                       [20., 99.9],
                                                       [30., 300.]]))