"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TlsValidationTrust = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Defines the TLS validation context trust.
 *
 * @experimental
 */
class TlsValidationTrust {
    /**
     * (experimental) Tells envoy where to fetch the validation context from.
     *
     * @experimental
     */
    static file(props) {
        return new TlsValidationFileTrust(props);
    }
    /**
     * (experimental) TLS validation context trust for ACM Private Certificate Authority (CA).
     *
     * @experimental
     */
    static acm(props) {
        return new TlsValidationAcmTrust(props);
    }
}
exports.TlsValidationTrust = TlsValidationTrust;
_a = JSII_RTTI_SYMBOL_1;
TlsValidationTrust[_a] = { fqn: "@aws-cdk/aws-appmesh.TlsValidationTrust", version: "1.108.0" };
class TlsValidationAcmTrust extends TlsValidationTrust {
    constructor(props) {
        super();
        this.certificateAuthorities = props.certificateAuthorities;
    }
    bind(_scope) {
        if (this.certificateAuthorities.length === 0) {
            throw new Error('you must provide at least one Certificate Authority when creating an ACM Trust ClientPolicy');
        }
        else {
            return {
                virtualNodeClientTlsValidationTrust: {
                    acm: {
                        certificateAuthorityArns: this.certificateAuthorities.map(certificateArn => certificateArn.certificateAuthorityArn),
                    },
                },
                virtualGatewayClientTlsValidationTrust: {
                    acm: {
                        certificateAuthorityArns: this.certificateAuthorities.map(certificateArn => certificateArn.certificateAuthorityArn),
                    },
                },
            };
        }
    }
}
class TlsValidationFileTrust extends TlsValidationTrust {
    constructor(props) {
        super();
        this.certificateChain = props.certificateChain;
    }
    bind(_scope) {
        return {
            virtualNodeClientTlsValidationTrust: {
                file: {
                    certificateChain: this.certificateChain,
                },
            },
            virtualGatewayClientTlsValidationTrust: {
                file: {
                    certificateChain: this.certificateChain,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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