import { TlsCertificate } from './tls-certificate';
/**
 * (experimental) Enum of supported TLS modes.
 *
 * @experimental
 */
export declare enum TlsMode {
    /**
     * (experimental) Only accept encrypted traffic.
     *
     * @experimental
     */
    STRICT = "STRICT",
    /**
     * (experimental) Accept encrypted and plaintext traffic.
     *
     * @experimental
     */
    PERMISSIVE = "PERMISSIVE",
    /**
     * (experimental) TLS is disabled, only accept plaintext traffic.
     *
     * @experimental
     */
    DISABLED = "DISABLED"
}
/**
 * (experimental) Represents TLS properties for listener.
 *
 * @experimental
 */
export interface TlsListener {
    /**
     * (experimental) Represents TLS certificate.
     *
     * @experimental
     */
    readonly certificate: TlsCertificate;
    /**
     * (experimental) The TLS mode.
     *
     * @experimental
     */
    readonly mode: TlsMode;
}
