"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderTlsClientPolicy = void 0;
/**
 * This is the helper method to render TLS property of client policy.
 *
 */
function renderTlsClientPolicy(scope, tlsClientPolicy, extractor) {
    return tlsClientPolicy
        ? {
            ports: tlsClientPolicy.ports,
            enforce: tlsClientPolicy.enforce,
            validation: {
                trust: extractor(tlsClientPolicy.validation.trust.bind(scope)),
            },
        }
        : undefined;
}
exports.renderTlsClientPolicy = renderTlsClientPolicy;
//# sourceMappingURL=data:application/json;base64,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