"""calvineComments URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.11/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.conf.urls import url, include
    2. Add a URL to urlpatterns:  url(r'^blog/', include('blog.urls'))
"""
from django.conf.urls import url, include
from django.contrib import admin
from django.views.generic import TemplateView
from search import views as search_views 

from .views import LoginUrlTestTemplateView
urlpatterns = [
    url(r'^$', TemplateView.as_view(template_name="home.html")),
    url(r'^1234/$', LoginUrlTestTemplateView.as_view(template_name="home.html")),
    url(r'^admin/', admin.site.urls),
    url(r'^api/comments/', include('comments.api.urls')),
    # url('', include('django_prometheus.urls')),
    url('comments/', include('comments.urls')),
    url(r'^search/', search_views.search, name='search'),
]




# from django.conf import settings
# from django.conf.urls.static import static

# if settings.DEBUG:
#     urlpatterns += (static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT))
#     urlpatterns += (static(settings.STATIC_URL, document_root=settings.STATIC_ROOT))

