"""init_db

迁移 ID: 6f1edf4c1af7
父迁移:
创建时间: 2024-09-27 22:15:36.517594

"""

from __future__ import annotations

from collections.abc import Sequence

from alembic import op
import sqlalchemy as sa

revision: str = "6f1edf4c1af7"
down_revision: str | Sequence[str] | None = None
branch_labels: str | Sequence[str] | None = ("nonebot_plugin_uninfo",)
depends_on: str | Sequence[str] | None = None


def upgrade(name: str = "") -> None:
    if name:
        return
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "nonebot_plugin_uninfo_sessionmodel",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("self_id", sa.String(length=64), nullable=False),
        sa.Column("adapter", sa.String(length=32), nullable=False),
        sa.Column("scope", sa.String(length=32), nullable=False),
        sa.Column("scene_id", sa.String(length=64), nullable=False),
        sa.Column("scene_type", sa.Integer(), nullable=False),
        sa.Column("scene_data", sa.JSON(), nullable=False),
        sa.Column("parent_scene_id", sa.String(length=64), nullable=False),
        sa.Column("parent_scene_type", sa.Integer(), nullable=False),
        sa.Column("parent_scene_data", sa.JSON(), nullable=True),
        sa.Column("user_id", sa.String(length=64), nullable=False),
        sa.Column("user_data", sa.JSON(), nullable=False),
        sa.Column("member_data", sa.JSON(), nullable=True),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_nonebot_plugin_uninfo_sessionmodel")),
        sa.UniqueConstraint(
            "self_id",
            "adapter",
            "scope",
            "scene_type",
            "scene_id",
            "parent_scene_type",
            "parent_scene_id",
            "user_id",
            name="unique_session",
        ),
        info={"bind_key": "nonebot_plugin_uninfo"},
    )
    # ### end Alembic commands ###


def downgrade(name: str = "") -> None:
    if name:
        return
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("nonebot_plugin_uninfo_sessionmodel")
    # ### end Alembic commands ###
