"""
********************************************************************************
rapid_clay_formations_fab
********************************************************************************

.. currentmodule:: rapid_clay_formations_fab

python module for MAS DFAB project Rapid Clay Formations

Fabrication data setup and configuration
----------------------------------------

.. toctree::
   :maxdepth: 3

   rapid_clay_formations_fab.fab_data

Robot system specific code
--------------------------

.. toctree::
   :maxdepth: 3

   rapid_clay_formations_fab.abb

Tools
-----

.. toctree::
   :maxdepth: 3

   rapid_clay_formations_fab.docker
   rapid_clay_formations_fab.rhino
   rapid_clay_formations_fab.utils
   rapid_clay_formations_fab.ui
"""
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from os import path

HERE = path.dirname(__file__)
HOME = path.abspath(path.join(HERE, "../.."))
DOCKER_COMPOSE_DIR = path.join(HERE, "_compose_files")

# from https://smarie.github.io/python-getversion/#package-versioning-best-practices
try:
    # -- Distribution mode --
    # import from _version.py generated by setuptools_scm during release
    from ._version import version as __version__
except ImportError:
    try:
        # -- Source mode --
        # use setuptools_scm to get the current version from src using git
        from setuptools_scm import get_version

        __version__ = get_version(HOME)
    except ImportError:
        __version__ = "src"

__author__ = "Anton T Johansson"
__copyright__ = "MAS DFAB 1920 students and tutors"
__license__ = "MIT License"
__email__ = "anton@tetov.se"
