import { FargateTaskDefinition, FargateTaskDefinitionProps, ICluster, Secret } from 'aws-cdk-lib/aws-ecs';
import { Construct } from 'constructs';
import { Certificates } from 'kong-core';
import { KongFeatureProps } from '../../kong-ecs';
export interface KongTaskDefinitionProps {
    readonly cluster: ICluster;
    readonly hostedZoneName: string;
    readonly image: string;
    readonly secrets: {
        [key: string]: Secret;
    };
    readonly dbInstanceEndpointAddress: string;
    readonly dbInstanceEndpointPort: string;
    readonly certificates: Certificates;
    readonly kongFeaturesProps: KongFeatureProps;
    readonly kongTaskProps: FargateTaskDefinitionProps;
}
export declare class KongAdminTaskdefinition extends FargateTaskDefinition {
    constructor(scope: Construct, id: string, props: KongTaskDefinitionProps);
}
