"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
// import * as kong_core from '../../kong-core/';
const kong_core = require("kong-core");
const index_1 = require("./resources/eks/helm-charts/kong/index");
class KongEks extends constructs_1.Construct {
    // public endpoints: DnsProps;
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        // this.endpoints = {
        //   adminDns: `admin.${props.hostedZoneName}:443`,
        //   clusterDns: `cluster.${props.hostedZoneName}:443`,
        //   telemetryDns: `telemetry.${props.hostedZoneName}:443`,
        //   managerDns: `manager.${props.hostedZoneName}:443`,
        // };
        const control_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'CPSecretsKey', {
            enableKeyRotation: true,
        });
        this.controlPlane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'CP', {
            ...props.controlPlaneClusterProps.eksClusterProps,
            secretsEncryptionKey: control_plane_secretskey,
            defaultCapacity: 0,
            albController: {
                version: aws_cdk_lib_1.aws_eks.AlbControllerVersion.V2_4_1,
            },
        });
        const cp_nodegroup = this.controlPlane.addNodegroupCapacity('CpASG', props.controlPlaneNodeProps);
        cp_nodegroup.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: this.controlPlane,
        //   nodegroup: cp_nodegroup,
        // });
        new kong_core.MetricsServer(this, 'MetricsServer', {
            cluster: this.controlPlane,
        });
        const kong_rds_instance = new kong_core.RdsStack(this, 'KongRds', {
            ...props.rdsProps,
            vpc: this.controlPlane.vpc,
        });
        const kong_pre_requisites_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongPreReqsStack');
        new kong_core.AutoScalar(this, 'AutoScalar', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
        });
        new kong_core.SecretsManager(kong_pre_requisites_nested_stack, 'SecretsCsi', {
            cluster: this.controlPlane,
        });
        new kong_core.ExternalDns(kong_pre_requisites_nested_stack, 'ExtDns', {
            cluster: this.controlPlane,
            hostedZoneName: props.dnsProps.hostedZoneName,
        });
        const aws_acm_pca = new kong_core.AcmPca(kong_pre_requisites_nested_stack, 'KongCpCa', {
            // hostedZoneName: props.dnsProps.hostedZoneName,
            // vpc: this.controlPlane.vpc,
            // dnsNames: [
            //   props.dnsProps.adminDns,
            //   props.dnsProps.clusterDns,
            //   props.dnsProps.telemetryDns,
            //   props.dnsProps.managerDns,
            //   props.dnsProps.hostedZoneName,
            // ],
            subjectRootCa: {
                organization: 'Amazon',
            },
            subjectSubCa: {
                organization: 'AWS',
            },
        });
        new kong_core.AwsCertManager(kong_pre_requisites_nested_stack, 'KongCpCertManager', {
            cluster: this.controlPlane,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            privateCaArn: aws_acm_pca.privateCaArn,
        });
        this.privateCaArn = aws_acm_pca.privateCaArn;
        const kong_control_plane_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongCpNestedStack');
        new index_1.KongControlPlaneEKS(kong_control_plane_nested_stack, 'KongCPHelmInstall', {
            cluster: this.controlPlane,
            rds: kong_rds_instance.kongPostgresSql,
            namespace: props.namespace,
            // nodegroup: cp_nodegroup,
            license_secret_name: props.licenseSecretsName,
            cacertname: kong_core.Tls.KONG_CP_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            // commonname: 'www.dummy.com',
            // hostedZoneName: props.dnsProps.hostedZoneName,
            HelmOptions: props.controlPlaneClusterProps.kongHelmOptions,
            endpoints: props.dnsProps,
        });
        kong_control_plane_nested_stack.node.addDependency(kong_pre_requisites_nested_stack, kong_rds_instance);
        const telemetry_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongTelemetryNestedStack');
        const telemetry_stack = new kong_core.Telemetry(telemetry_nested_stack, 'KongLogging', {
            createPrometheusWorkspace: props.controlPlaneClusterProps.kongTelemetryOptions.createPrometheusWorkspace,
            cluster: this.controlPlane,
            namespace: kong_core.Namespace.TELEMETRY,
        });
        this.prometheusEndpoint = telemetry_stack.prometheusEndpoint;
        telemetry_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
    }
    ;
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-control-plane.KongEks", version: "3.0.0-dev.20" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia29uZy1la3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMva29uZy1la3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw2Q0FBOEU7QUFDOUUsMkNBQXVDO0FBQ3ZDLGlEQUFpRDtBQUNqRCx1Q0FBdUM7QUFDdkMsa0VBQTZFO0FBd0Q3RSxNQUFhLE9BQVEsU0FBUSxzQkFBUztJQUtwQyw4QkFBOEI7SUFFOUI7Ozs7Ozs7U0FPSztJQUNMLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMkI7UUFDbkUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixxQkFBcUI7UUFDckIsbURBQW1EO1FBQ25ELHVEQUF1RDtRQUN2RCwyREFBMkQ7UUFDM0QsdURBQXVEO1FBQ3ZELEtBQUs7UUFFTCxNQUFNLHdCQUF3QixHQUFHLElBQUkscUJBQU8sQ0FBQyxHQUFHLENBQUMsSUFBSSxFQUFFLGNBQWMsRUFBRTtZQUNyRSxpQkFBaUIsRUFBRSxJQUFJO1NBQ3hCLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxZQUFZLEdBQUcsSUFBSSxxQkFBTyxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUsSUFBSSxFQUFFO1lBQ2xELEdBQUcsS0FBSyxDQUFDLHdCQUF3QixDQUFDLGVBQWU7WUFDakQsb0JBQW9CLEVBQUUsd0JBQXdCO1lBQzlDLGVBQWUsRUFBRSxDQUFDO1lBQ2xCLGFBQWEsRUFBRTtnQkFDYixPQUFPLEVBQUUscUJBQU8sQ0FBQyxvQkFBb0IsQ0FBQyxNQUFNO2FBQzdDO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsTUFBTSxZQUFZLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyxvQkFBb0IsQ0FBQyxPQUFPLEVBQUUsS0FBSyxDQUFDLHFCQUFxQixDQUFDLENBQUM7UUFDbEcsWUFBWSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxxQkFBTyxDQUFDLGFBQWEsQ0FBQyx3QkFBd0IsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDLENBQUM7UUFFbkgsNENBQTRDO1FBQzVDLGdDQUFnQztRQUNoQyw2QkFBNkI7UUFDN0IsTUFBTTtRQUVOLElBQUksU0FBUyxDQUFDLGFBQWEsQ0FBQyxJQUFJLEVBQUUsZUFBZSxFQUFFO1lBQ2pELE9BQU8sRUFBRSxJQUFJLENBQUMsWUFBWTtTQUMzQixDQUFDLENBQUM7UUFFSCxNQUFNLGlCQUFpQixHQUFHLElBQUksU0FBUyxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsU0FBUyxFQUFFO1lBQ2hFLEdBQUcsS0FBSyxDQUFDLFFBQVE7WUFDakIsR0FBRyxFQUFFLElBQUksQ0FBQyxZQUFZLENBQUMsR0FBRztTQUMzQixDQUFDLENBQUM7UUFFSCxNQUFNLGdDQUFnQyxHQUFHLElBQUkseUJBQVcsQ0FBQyxJQUFJLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztRQUVuRixJQUFJLFNBQVMsQ0FBQyxVQUFVLENBQUMsSUFBSSxFQUFFLFlBQVksRUFBRTtZQUMzQyxPQUFPLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDMUIsU0FBUyxFQUFFLFlBQVk7U0FDeEIsQ0FBQyxDQUFDO1FBRUgsSUFBSSxTQUFTLENBQUMsY0FBYyxDQUFDLGdDQUFnQyxFQUFFLFlBQVksRUFBRTtZQUMzRSxPQUFPLEVBQUUsSUFBSSxDQUFDLFlBQVk7U0FDM0IsQ0FBQyxDQUFDO1FBRUgsSUFBSSxTQUFTLENBQUMsV0FBVyxDQUFDLGdDQUFnQyxFQUFFLFFBQVEsRUFBRTtZQUNwRSxPQUFPLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDMUIsY0FBYyxFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsY0FBYztTQUM5QyxDQUFDLENBQUM7UUFFSCxNQUFNLFdBQVcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxNQUFNLENBQUMsZ0NBQWdDLEVBQUUsVUFBVSxFQUFFO1lBQ3JGLGlEQUFpRDtZQUNqRCw4QkFBOEI7WUFDOUIsY0FBYztZQUNkLDZCQUE2QjtZQUM3QiwrQkFBK0I7WUFDL0IsaUNBQWlDO1lBQ2pDLCtCQUErQjtZQUMvQixtQ0FBbUM7WUFDbkMsS0FBSztZQUNMLGFBQWEsRUFBRTtnQkFDYixZQUFZLEVBQUUsUUFBUTthQUN2QjtZQUNELFlBQVksRUFBRTtnQkFDWixZQUFZLEVBQUUsS0FBSzthQUNwQjtTQUNGLENBQUMsQ0FBQztRQUNILElBQUksU0FBUyxDQUFDLGNBQWMsQ0FBQyxnQ0FBZ0MsRUFBRSxtQkFBbUIsRUFBRTtZQUNsRixPQUFPLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDMUIsaUJBQWlCLEVBQUUsU0FBUyxDQUFDLEdBQUcsQ0FBQywyQkFBMkI7WUFDNUQsWUFBWSxFQUFFLFdBQVcsQ0FBQyxZQUFZO1NBQ3ZDLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxZQUFZLEdBQUMsV0FBVyxDQUFDLFlBQVksQ0FBQztRQUUzQyxNQUFNLCtCQUErQixHQUFHLElBQUkseUJBQVcsQ0FBQyxJQUFJLEVBQUUsbUJBQW1CLENBQUMsQ0FBQztRQUNuRixJQUFJLDJCQUFtQixDQUFDLCtCQUErQixFQUFFLG1CQUFtQixFQUFFO1lBQzVFLE9BQU8sRUFBRSxJQUFJLENBQUMsWUFBWTtZQUMxQixHQUFHLEVBQUUsaUJBQWlCLENBQUMsZUFBZTtZQUN0QyxTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIsMkJBQTJCO1lBQzNCLG1CQUFtQixFQUFFLEtBQUssQ0FBQyxrQkFBa0I7WUFDN0MsVUFBVSxFQUFFLFNBQVMsQ0FBQyxHQUFHLENBQUMsZ0JBQWdCO1lBQzFDLGlCQUFpQixFQUFFLFNBQVMsQ0FBQyxHQUFHLENBQUMsMkJBQTJCO1lBQzVELCtCQUErQjtZQUMvQixpREFBaUQ7WUFDakQsV0FBVyxFQUFFLEtBQUssQ0FBQyx3QkFBd0IsQ0FBQyxlQUFlO1lBQzNELFNBQVMsRUFBRSxLQUFLLENBQUMsUUFBUTtTQUMxQixDQUNBLENBQUM7UUFFRiwrQkFBK0IsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLGdDQUFnQyxFQUFFLGlCQUFpQixDQUFDLENBQUM7UUFFeEcsTUFBTSxzQkFBc0IsR0FBRyxJQUFJLHlCQUFXLENBQUMsSUFBSSxFQUFFLDBCQUEwQixDQUFDLENBQUM7UUFFakYsTUFBTSxlQUFlLEdBQUcsSUFBSSxTQUFTLENBQUMsU0FBUyxDQUFDLHNCQUFzQixFQUFFLGFBQWEsRUFBRTtZQUNyRix5QkFBeUIsRUFBRSxLQUFLLENBQUMsd0JBQXdCLENBQUMsb0JBQW9CLENBQUMseUJBQXlCO1lBQ3hHLE9BQU8sRUFBRSxJQUFJLENBQUMsWUFBWTtZQUMxQixTQUFTLEVBQUUsU0FBUyxDQUFDLFNBQVMsQ0FBQyxTQUFTO1NBQ3pDLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxrQkFBa0IsR0FBRyxlQUFlLENBQUMsa0JBQWtCLENBQUM7UUFFN0Qsc0JBQXNCLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBRTlFLENBQUM7SUFBQSxDQUFDOztBQTlISiwwQkFnSUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBhd3NfcmRzLCBhd3NfZWtzLCBhd3NfaWFtLCBhd3Nfa21zLCBOZXN0ZWRTdGFjayB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuLy8gaW1wb3J0ICogYXMga29uZ19jb3JlIGZyb20gJy4uLy4uL2tvbmctY29yZS8nO1xuaW1wb3J0ICogYXMga29uZ19jb3JlIGZyb20gJ2tvbmctY29yZSc7XG5pbXBvcnQgeyBLb25nQ29udHJvbFBsYW5lRUtTIH0gZnJvbSAnLi9yZXNvdXJjZXMvZWtzL2hlbG0tY2hhcnRzL2tvbmcvaW5kZXgnO1xuaW1wb3J0IHsgRG5zUHJvcHMgfSBmcm9tICcuL3Jlc291cmNlcy9la3MvaW50ZXJmYWNlcy9kbnMtcHJvcHMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEVrc0NvbnRyb2xQbGFuZVByb3BzIHtcblxuICAvKipcbiAgICAqIEBzdW1tYXJ5IE5hbWUgb2YgdGhlIGhvc3RlZCB6b25lXG4gICAgKi9cbiAgcmVhZG9ubHkgZG5zUHJvcHM6IERuc1Byb3BzO1xuICAvKipcbiAqIEBzdW1tYXJ5IEt1YmVybmV0ZXMgTmFtZXNwYWNlIHRvIGluc3RhbGwgS29uZyBDb250cm9sIFBsYW5lXG4gKi9cbiAgcmVhZG9ubHkgbmFtZXNwYWNlOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAgKiBAc3VtbWFyeSBOYW1lIG9mIHRoZSBTZWNyZXQgaW4gQVdTIFNlY3JldHMgTWFuYWdlclxuICAgICovXG4gIHJlYWRvbmx5IGxpY2Vuc2VTZWNyZXRzTmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgICAqIEBzdW1tYXJ5IENvbnRyb2wgUGxhbmUgRUtTIENsdXN0ZXIgcHJvcGVydGllc1xuICAgICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nkay9hcGkvbGF0ZXN0L2RvY3MvQGF3cy1jZGtfYXdzLWVrcy5DbHVzdGVyUHJvcHMuaHRtbFxuICAgICAqL1xuICByZWFkb25seSBjb250cm9sUGxhbmVDbHVzdGVyUHJvcHM6IENvbnRyb2xQbGFuZUNsdXN0ZXJQcm9wcztcbiAgLyoqXG4gICAgICogQHN1bW1hcnkgRGF0YSBQbGFuZSBFS1MgQ2x1c3RlciBwcm9wZXJ0aWVzXG4gICAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2RrL2FwaS9sYXRlc3QvZG9jcy9AYXdzLWNka19hd3MtZWtzLkNsdXN0ZXJQcm9wcy5odG1sXG4gICAgICovXG4gIC8vICByZWFkb25seSBkYXRhUGxhbmVDbHVzdGVyUHJvcHM6IGVrcy5DbHVzdGVyUHJvcHM7XG4gIC8qKlxuICAgICAqIEBzdW1tYXJ5IFJEUyBEYXRhYmFzZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gIHJlYWRvbmx5IHJkc1Byb3BzOiBhd3NfcmRzLkRhdGFiYXNlSW5zdGFuY2VQcm9wcztcblxuICAvKipcbiAgICAgKiBAc3VtbWFyeSBLb25nIENvbnRyb2wgUGxhbmUgRUtTIE5vZGVzIHByb3BlcnRpZXNcbiAgICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jZGsvYXBpL2xhdGVzdC9kb2NzL0Bhd3MtY2RrX2F3cy1la3MuQXV0b1NjYWxpbmdHcm91cENhcGFjaXR5T3B0aW9ucy5odG1sXG4gICAgICovXG4gIHJlYWRvbmx5IGNvbnRyb2xQbGFuZU5vZGVQcm9wczogYXdzX2Vrcy5Ob2RlZ3JvdXBPcHRpb25zO1xuXG4gIC8qKlxuICAgICAqIEBzdW1tYXJ5IEtvbmcgRGF0YSBQbGFuZSBFS1MgTm9kZXMgcHJvcGVydGllc1xuICAgICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nkay9hcGkvbGF0ZXN0L2RvY3MvQGF3cy1jZGtfYXdzLWVrcy5BdXRvU2NhbGluZ0dyb3VwQ2FwYWNpdHlPcHRpb25zLmh0bWxcbiAgICAgKi9cbn1cblxuZXhwb3J0IGludGVyZmFjZSBDb250cm9sUGxhbmVDbHVzdGVyUHJvcHMge1xuICByZWFkb25seSBla3NDbHVzdGVyUHJvcHMgOiBhd3NfZWtzLkNsdXN0ZXJQcm9wcztcbiAgcmVhZG9ubHkga29uZ0hlbG1PcHRpb25zPzogYXdzX2Vrcy5IZWxtQ2hhcnRPcHRpb25zO1xuICByZWFkb25seSBrb25nVGVsZW1ldHJ5T3B0aW9uczogQ29udHJvbFBsYW5lVGVsZW1ldHJ5UHJvcHM7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQ29udHJvbFBsYW5lVGVsZW1ldHJ5UHJvcHMge1xuICByZWFkb25seSBjcmVhdGVQcm9tZXRoZXVzV29ya3NwYWNlOiBCb29sZWFuO1xuICByZWFkb25seSBwcm9tZXRoZXVzRW5kcG9pbnQ/OiBzdHJpbmc7XG59XG5leHBvcnQgY2xhc3MgS29uZ0VrcyBleHRlbmRzIENvbnN0cnVjdCB7XG5cbiAgcHVibGljIHJlYWRvbmx5IGNvbnRyb2xQbGFuZTogYXdzX2Vrcy5DbHVzdGVyO1xuICBwdWJsaWMgcHJpdmF0ZUNhQXJuIDogc3RyaW5nO1xuICBwdWJsaWMgcHJvbWV0aGV1c0VuZHBvaW50OiBzdHJpbmcgfCB1bmRlZmluZWQ7XG4gIC8vIHB1YmxpYyBlbmRwb2ludHM6IERuc1Byb3BzO1xuXG4gIC8qKlxuICAgICAqIEBzdW1tYXJ5IENvbnN0cnVjdHMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhlIEtvbmdFa3MgY2xhc3MuXG4gICAgICogQHBhcmFtIHtjZGsuQXBwfSBzY29wZSAtIHJlcHJlc2VudHMgdGhlIHNjb3BlIGZvciBhbGwgdGhlIHJlc291cmNlcy5cbiAgICAgKiBAcGFyYW0ge3N0cmluZ30gaWQgLSB0aGlzIGlzIGEgYSBzY29wZS11bmlxdWUgaWQuXG4gICAgICogQHBhcmFtIHtDbG91ZEZyb250VG9BcGlHYXRld2F5VG9MYW1iZGFQcm9wc30gcHJvcHMgLSB1c2VyIHByb3ZpZGVkIHByb3BzIGZvciB0aGUgY29uc3RydWN0LlxuICAgICAqIEBzaW5jZSAwLjEuMFxuICAgICAqIEBhY2Nlc3MgcHVibGljXG4gICAgICovXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBFa3NDb250cm9sUGxhbmVQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAvLyB0aGlzLmVuZHBvaW50cyA9IHtcbiAgICAvLyAgIGFkbWluRG5zOiBgYWRtaW4uJHtwcm9wcy5ob3N0ZWRab25lTmFtZX06NDQzYCxcbiAgICAvLyAgIGNsdXN0ZXJEbnM6IGBjbHVzdGVyLiR7cHJvcHMuaG9zdGVkWm9uZU5hbWV9OjQ0M2AsXG4gICAgLy8gICB0ZWxlbWV0cnlEbnM6IGB0ZWxlbWV0cnkuJHtwcm9wcy5ob3N0ZWRab25lTmFtZX06NDQzYCxcbiAgICAvLyAgIG1hbmFnZXJEbnM6IGBtYW5hZ2VyLiR7cHJvcHMuaG9zdGVkWm9uZU5hbWV9OjQ0M2AsXG4gICAgLy8gfTtcblxuICAgIGNvbnN0IGNvbnRyb2xfcGxhbmVfc2VjcmV0c2tleSA9IG5ldyBhd3Nfa21zLktleSh0aGlzLCAnQ1BTZWNyZXRzS2V5Jywge1xuICAgICAgZW5hYmxlS2V5Um90YXRpb246IHRydWUsXG4gICAgfSk7XG5cbiAgICB0aGlzLmNvbnRyb2xQbGFuZSA9IG5ldyBhd3NfZWtzLkNsdXN0ZXIodGhpcywgJ0NQJywge1xuICAgICAgLi4ucHJvcHMuY29udHJvbFBsYW5lQ2x1c3RlclByb3BzLmVrc0NsdXN0ZXJQcm9wcyxcbiAgICAgIHNlY3JldHNFbmNyeXB0aW9uS2V5OiBjb250cm9sX3BsYW5lX3NlY3JldHNrZXksXG4gICAgICBkZWZhdWx0Q2FwYWNpdHk6IDAsXG4gICAgICBhbGJDb250cm9sbGVyOiB7XG4gICAgICAgIHZlcnNpb246IGF3c19la3MuQWxiQ29udHJvbGxlclZlcnNpb24uVjJfNF8xLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIGNvbnN0IGNwX25vZGVncm91cCA9IHRoaXMuY29udHJvbFBsYW5lLmFkZE5vZGVncm91cENhcGFjaXR5KCdDcEFTRycsIHByb3BzLmNvbnRyb2xQbGFuZU5vZGVQcm9wcyk7XG4gICAgY3Bfbm9kZWdyb3VwLnJvbGUuYWRkTWFuYWdlZFBvbGljeShhd3NfaWFtLk1hbmFnZWRQb2xpY3kuZnJvbUF3c01hbmFnZWRQb2xpY3lOYW1lKCdBbWF6b25TU01NYW5hZ2VkSW5zdGFuY2VDb3JlJykpO1xuXG4gICAgLy8gbmV3IEVrc05vZGVIYW5kbGVyKHRoaXMsICdOb2RlSGFuZGxlcicsIHtcbiAgICAvLyAgIGNsdXN0ZXI6IHRoaXMuY29udHJvbFBsYW5lLFxuICAgIC8vICAgbm9kZWdyb3VwOiBjcF9ub2RlZ3JvdXAsXG4gICAgLy8gfSk7XG5cbiAgICBuZXcga29uZ19jb3JlLk1ldHJpY3NTZXJ2ZXIodGhpcywgJ01ldHJpY3NTZXJ2ZXInLCB7XG4gICAgICBjbHVzdGVyOiB0aGlzLmNvbnRyb2xQbGFuZSxcbiAgICB9KTtcblxuICAgIGNvbnN0IGtvbmdfcmRzX2luc3RhbmNlID0gbmV3IGtvbmdfY29yZS5SZHNTdGFjayh0aGlzLCAnS29uZ1JkcycsIHtcbiAgICAgIC4uLnByb3BzLnJkc1Byb3BzLFxuICAgICAgdnBjOiB0aGlzLmNvbnRyb2xQbGFuZS52cGMsXG4gICAgfSk7XG5cbiAgICBjb25zdCBrb25nX3ByZV9yZXF1aXNpdGVzX25lc3RlZF9zdGFjayA9IG5ldyBOZXN0ZWRTdGFjayh0aGlzLCAnS29uZ1ByZVJlcXNTdGFjaycpO1xuXG4gICAgbmV3IGtvbmdfY29yZS5BdXRvU2NhbGFyKHRoaXMsICdBdXRvU2NhbGFyJywge1xuICAgICAgY2x1c3RlcjogdGhpcy5jb250cm9sUGxhbmUsXG4gICAgICBub2RlZ3JvdXA6IGNwX25vZGVncm91cCxcbiAgICB9KTtcblxuICAgIG5ldyBrb25nX2NvcmUuU2VjcmV0c01hbmFnZXIoa29uZ19wcmVfcmVxdWlzaXRlc19uZXN0ZWRfc3RhY2ssICdTZWNyZXRzQ3NpJywge1xuICAgICAgY2x1c3RlcjogdGhpcy5jb250cm9sUGxhbmUsXG4gICAgfSk7XG5cbiAgICBuZXcga29uZ19jb3JlLkV4dGVybmFsRG5zKGtvbmdfcHJlX3JlcXVpc2l0ZXNfbmVzdGVkX3N0YWNrLCAnRXh0RG5zJywge1xuICAgICAgY2x1c3RlcjogdGhpcy5jb250cm9sUGxhbmUsXG4gICAgICBob3N0ZWRab25lTmFtZTogcHJvcHMuZG5zUHJvcHMuaG9zdGVkWm9uZU5hbWUsXG4gICAgfSk7XG5cbiAgICBjb25zdCBhd3NfYWNtX3BjYSA9IG5ldyBrb25nX2NvcmUuQWNtUGNhKGtvbmdfcHJlX3JlcXVpc2l0ZXNfbmVzdGVkX3N0YWNrLCAnS29uZ0NwQ2EnLCB7XG4gICAgICAvLyBob3N0ZWRab25lTmFtZTogcHJvcHMuZG5zUHJvcHMuaG9zdGVkWm9uZU5hbWUsXG4gICAgICAvLyB2cGM6IHRoaXMuY29udHJvbFBsYW5lLnZwYyxcbiAgICAgIC8vIGRuc05hbWVzOiBbXG4gICAgICAvLyAgIHByb3BzLmRuc1Byb3BzLmFkbWluRG5zLFxuICAgICAgLy8gICBwcm9wcy5kbnNQcm9wcy5jbHVzdGVyRG5zLFxuICAgICAgLy8gICBwcm9wcy5kbnNQcm9wcy50ZWxlbWV0cnlEbnMsXG4gICAgICAvLyAgIHByb3BzLmRuc1Byb3BzLm1hbmFnZXJEbnMsXG4gICAgICAvLyAgIHByb3BzLmRuc1Byb3BzLmhvc3RlZFpvbmVOYW1lLFxuICAgICAgLy8gXSxcbiAgICAgIHN1YmplY3RSb290Q2E6IHtcbiAgICAgICAgb3JnYW5pemF0aW9uOiAnQW1hem9uJyxcbiAgICAgIH0sXG4gICAgICBzdWJqZWN0U3ViQ2E6IHtcbiAgICAgICAgb3JnYW5pemF0aW9uOiAnQVdTJyxcbiAgICAgIH0sXG4gICAgfSk7XG4gICAgbmV3IGtvbmdfY29yZS5Bd3NDZXJ0TWFuYWdlcihrb25nX3ByZV9yZXF1aXNpdGVzX25lc3RlZF9zdGFjaywgJ0tvbmdDcENlcnRNYW5hZ2VyJywge1xuICAgICAgY2x1c3RlcjogdGhpcy5jb250cm9sUGxhbmUsXG4gICAgICBjbHVzdGVySXNzdWVyTmFtZToga29uZ19jb3JlLlRscy5LT05HX0NQX0NMVVNURVJfSVNTVUVSX05BTUUsXG4gICAgICBwcml2YXRlQ2FBcm46IGF3c19hY21fcGNhLnByaXZhdGVDYUFybixcbiAgICB9KTtcblxuICAgIHRoaXMucHJpdmF0ZUNhQXJuPWF3c19hY21fcGNhLnByaXZhdGVDYUFybjtcblxuICAgIGNvbnN0IGtvbmdfY29udHJvbF9wbGFuZV9uZXN0ZWRfc3RhY2sgPSBuZXcgTmVzdGVkU3RhY2sodGhpcywgJ0tvbmdDcE5lc3RlZFN0YWNrJyk7XG4gICAgbmV3IEtvbmdDb250cm9sUGxhbmVFS1Moa29uZ19jb250cm9sX3BsYW5lX25lc3RlZF9zdGFjaywgJ0tvbmdDUEhlbG1JbnN0YWxsJywge1xuICAgICAgY2x1c3RlcjogdGhpcy5jb250cm9sUGxhbmUsXG4gICAgICByZHM6IGtvbmdfcmRzX2luc3RhbmNlLmtvbmdQb3N0Z3Jlc1NxbCxcbiAgICAgIG5hbWVzcGFjZTogcHJvcHMubmFtZXNwYWNlLFxuICAgICAgLy8gbm9kZWdyb3VwOiBjcF9ub2RlZ3JvdXAsXG4gICAgICBsaWNlbnNlX3NlY3JldF9uYW1lOiBwcm9wcy5saWNlbnNlU2VjcmV0c05hbWUsXG4gICAgICBjYWNlcnRuYW1lOiBrb25nX2NvcmUuVGxzLktPTkdfQ1BfQ0VSVE5BTUUsXG4gICAgICBjbHVzdGVySXNzdWVyTmFtZToga29uZ19jb3JlLlRscy5LT05HX0NQX0NMVVNURVJfSVNTVUVSX05BTUUsXG4gICAgICAvLyBjb21tb25uYW1lOiAnd3d3LmR1bW15LmNvbScsXG4gICAgICAvLyBob3N0ZWRab25lTmFtZTogcHJvcHMuZG5zUHJvcHMuaG9zdGVkWm9uZU5hbWUsXG4gICAgICBIZWxtT3B0aW9uczogcHJvcHMuY29udHJvbFBsYW5lQ2x1c3RlclByb3BzLmtvbmdIZWxtT3B0aW9ucyxcbiAgICAgIGVuZHBvaW50czogcHJvcHMuZG5zUHJvcHMsXG4gICAgfSxcbiAgICApO1xuXG4gICAga29uZ19jb250cm9sX3BsYW5lX25lc3RlZF9zdGFjay5ub2RlLmFkZERlcGVuZGVuY3koa29uZ19wcmVfcmVxdWlzaXRlc19uZXN0ZWRfc3RhY2ssIGtvbmdfcmRzX2luc3RhbmNlKTtcblxuICAgIGNvbnN0IHRlbGVtZXRyeV9uZXN0ZWRfc3RhY2sgPSBuZXcgTmVzdGVkU3RhY2sodGhpcywgJ0tvbmdUZWxlbWV0cnlOZXN0ZWRTdGFjaycpO1xuXG4gICAgY29uc3QgdGVsZW1ldHJ5X3N0YWNrID0gbmV3IGtvbmdfY29yZS5UZWxlbWV0cnkodGVsZW1ldHJ5X25lc3RlZF9zdGFjaywgJ0tvbmdMb2dnaW5nJywge1xuICAgICAgY3JlYXRlUHJvbWV0aGV1c1dvcmtzcGFjZTogcHJvcHMuY29udHJvbFBsYW5lQ2x1c3RlclByb3BzLmtvbmdUZWxlbWV0cnlPcHRpb25zLmNyZWF0ZVByb21ldGhldXNXb3Jrc3BhY2UsXG4gICAgICBjbHVzdGVyOiB0aGlzLmNvbnRyb2xQbGFuZSxcbiAgICAgIG5hbWVzcGFjZToga29uZ19jb3JlLk5hbWVzcGFjZS5URUxFTUVUUlksXG4gICAgfSk7XG5cbiAgICB0aGlzLnByb21ldGhldXNFbmRwb2ludCA9IHRlbGVtZXRyeV9zdGFjay5wcm9tZXRoZXVzRW5kcG9pbnQ7XG5cbiAgICB0ZWxlbWV0cnlfbmVzdGVkX3N0YWNrLm5vZGUuYWRkRGVwZW5kZW5jeShrb25nX3ByZV9yZXF1aXNpdGVzX25lc3RlZF9zdGFjayk7XG5cbiAgfTtcblxufSJdfQ==