<img src="https://mbcdn.sfo2.cdn.digitaloceanspaces.com/Foxify.png">

# foxify-cli
[![GitHub issues](https://img.shields.io/github/issues/M4cs/foxify-cli)](https://github.com/M4cs/foxify-cli/issues)
[![GitHub stars](https://img.shields.io/github/stars/M4cs/foxify-cli)](https://github.com/M4cs/foxify-cli/stargazers)
[![GitHub forks](https://img.shields.io/github/forks/M4cs/foxify-cli)](https://github.com/M4cs/foxify-cli/network/members)

Customize Firefox from the command line and control all your custom userChrome CSS themes with one tool!

Supports Windows, Mac, and Linux

No Support For Waterfox

[Troubleshooting Guide Can Be Found Here!](https://github.com/M4cs/foxify-cli/wiki/Troubleshooting)

<p align="center">
 <p align="center"><img src="https://raw.githubusercontent.com/M4cs/foxify-cli/master/preview.gif" width="720"></p>
</p>

# Overview

As of Firefox 57 (the Quantum Update), Mozilla has enabled custom user customization using userChrome.css. This file is found in the chrome folder of your profile and allows you to customize the look of your browser. There is a huge community around this sort of themeing and it can get easy to mess up your theme or lose it when you install a new theme. With Foxify you have the ability to manage your themes for Firefox and apply them dynamically!

Foxify was heavily inspired by the command-line program [Spiceify for Spotify](https://github.com/khanhas/spicetify-cli), which offers similiar features but for Spotify!

## Features:

 - #### Easy Theme Management for Firefox Themes
 - #### Safe Backups and Restores of Themes
 - #### Easily Remove Custom Themes Entirely
 - #### Easy To Use Commands
 - #### Command Suggestions When Entering Incorrect Arguments

<a href="https://www.reddit.com/r/FirefoxCSS/comments/fz8h2o/moonlight_userchrome/"><img src="https://i.redd.it/rma9z4itq7s41.png"  alt="img" align="right" width="400px"></a>
### Where To Find Themes:

#### FirefoxCSS Reddit: [Link](https://www.reddit.com/r/FirefoxCSS/)

#### UserChrome Tweaks: [Link](https://github.com/Timvde/UserChrome-Tweaks)

#### Firefox CSS Hacks: [Link](https://github.com/MrOtherGuy/firefox-csshacks)

### Requirements:

<a href="https://www.reddit.com/r/nordtheme/comments/g0mnyt/nordic_firefox_theme/"><img src="https://i.redd.it/omdp7nyz6ms41.png" alt="img" align="right" width="400px"></a>
**OS:** Windows, Mac, Linux

**Software Reqs:**

  - Python 3.6+
  - Firefox 57 or Higher
  

<br><br><br><br>

## [Wiki](https://github.com/M4cs/foxify-cli/wiki)

#### I. [Table of Contents](https://github.com/M4cs/foxify-cli/wiki)
#### II. [Overview](https://github.com/M4cs/foxify-cli/wiki/Overview)
  1. [**Description**](https://github.com/M4cs/foxify-cli/wiki/Overview)
  2. [**Features**](https://github.com/M4cs/foxify-cli/wiki/Overview)
  3. [**Where to Find Themes**](https://github.com/M4cs/foxify-cli/wiki/Overview)
  4. [**Requirements**](https://github.com/M4cs/foxify-cli/wiki/Overview)

#### III. [Getting Started](https://github.com/M4cs/foxify-cli/wiki/Getting-Started)
  1. [**Installation**](https://github.com/M4cs/foxify-cli/wiki/Getting-Started#installing-foxify)
  2. [**Adding Themes**](https://github.com/M4cs/foxify-cli/wiki/Getting-Started#adding-themes)
#### IV. [Usage](https://github.com/M4cs/foxify-cli/wiki/Usage)
  1. [**Command List**](https://github.com/M4cs/foxify-cli/wiki/Usage)
  2. [**Common Commands**](https://github.com/M4cs/foxify-cli/wiki/Usage#common-command-combinations)

# License

Licensed under the GNU GPUv3 License by Max Bridgland, 2020
