"""Pre-generated unicode punctuation characters.

Run this module to generate and print an up-to-date set of characters.
"""
UNICODE_PUNCTUATION = frozenset(
    {
        "』",
        "᱾",
        "𑓆",
        "―",
        "⌈",
        "⸗",
        "⸅",
        "𑁉",
        "꓿",
        "𐫶",
        "᭠",
        "꣏",
        "𑇞",
        "″",
        "𑈻",
        "=",
        "᭛",
        "⸨",
        "״",
        "𑗈",
        "꧆",
        "𐩑",
        "︑",
        "܅",
        "᠆",
        "›",
        "꧟",
        "⸧",
        "❱",
        "٫",
        "⸂",
        "⁆",
        "𐩓",
        "፡",
        "᪨",
        "࠻",
        "𑗎",
        "፥",
        "⦑",
        "‶",
        "჻",
        "𑪢",
        "࠸",
        "𑩆",
        "༑",
        "⟩",
        "꫰",
        "𑂼",
        "⟯",
        "𐩕",
        "⸖",
        "︳",
        "𖬸",
        "〉",
        "꤯",
        "⸐",
        "﹑",
        "𑪞",
        "᭝",
        "࿐",
        "٪",
        "᪫",
        "᪬",
        "𑿿",
        "𑑌",
        "゠",
        "𐩖",
        "❵",
        "〈",
        "¿",
        "⸌",
        "︹",
        "⟭",
        "‗",
        "꡵",
        "⁗",
        "𐮜",
        "᰻",
        "‱",
        "＊",
        "⦋",
        "⸛",
        "|",
        "𑻷",
        "⳾",
        "𖿢",
        "𖭄",
        "》",
        "𞥟",
        "︱",
        "⧽",
        "𐫳",
        "﹄",
        "⹍",
        "៘",
        "〚",
        "＃",
        "︲",
        "⸸",
        "〔",
        "𑗑",
        "܊",
        "⌋",
        "⹁",
        "࠵",
        "¶",
        "፠",
        "’",
        "܍",
        "❮",
        "「",
        "𑱄",
        "⁂",
        "﹟",
        "𝪊",
        "꙳",
        "᠄",
        "𑗃",
        "།",
        "܁",
        "〛",
        "⹃",
        "⦌",
        "⸾",
        "𐩘",
        "੶",
        "꧌",
        "｡",
        "（",
        "⁈",
        "𝪇",
        "᪩",
        "︷",
        "༼",
        "𖺙",
        "𑃀",
        "⟅",
        "⦗",
        "﹐",
        "𑜾",
        "﹇",
        "【",
        "𑗇",
        "𒑱",
        "⦃",
        "-",
        "𑁈",
        "𑗒",
        "﹊",
        "꓾",
        "𑗖",
        "𐬺",
        "‣",
        "․",
        "⹌",
        "︽",
        "⸀",
        "⸠",
        "﹛",
        "⟬",
        "๚",
        "⁔",
        "…",
        "⳹",
        "𑂻",
        "&",
        "”",
        "⸪",
        "」",
        "𑗌",
        "‛",
        "᳂",
        "﹂",
        "𖩯",
        "⁜",
        "⸱",
        "𑙡",
        "꫱",
        "⳿",
        "᳅",
        "⟧",
        "𐽗",
        "᰾",
        "꛴",
        "।",
        "་",
        "𑗉",
        "﹫",
        "꧊",
        "﹡",
        "𖺘",
        "𞥞",
        "༔",
        "𐬹",
        "՟",
        "༈",
        "𑇟",
        "⁍",
        "᪤",
        "⟮",
        "＇",
        "๛",
        "༽",
        "﹋",
        "⧛",
        "𝪋",
        "𑁊",
        "⸴",
        "׆",
        "‘",
        "࠱",
        "߸",
        "𑙣",
        "﴿",
        "৽",
        "༅",
        "࠷",
        "⸋",
        "⦊",
        "¡",
        "؞",
        "＆",
        "፤",
        "꥟",
        "꧂",
        "՚",
        "⁝",
        "⦄",
        "﹠",
        "。",
        "⹈",
        "⸒",
        "﹒",
        "+",
        "܉",
        "※",
        "⸦",
        "፨",
        "𑙤",
        "᠅",
        "⹅",
        "༉",
        "𑅃",
        "‴",
        "⁽",
        "𑗆",
        "‥",
        "﹆",
        "⸝",
        "*",
        "－",
        "𑅵",
        "𐎟",
        "︰",
        "࠺",
        "𑙠",
        "։",
        "⸡",
        "𐽙",
        "࿚",
        "‹",
        "𑙫",
        "𑗓",
        "〃",
        "︼",
        "᭜",
        "𐽘",
        "︓",
        "᚜",
        "𐩗",
        "𝪉",
        "❳",
        "꣸",
        ";",
        "､",
        "𑩃",
        "﹉",
        "‼",
        "｢",
        "᯽",
        "᭚",
        "𑙃",
        "꩟",
        "⸳",
        "„",
        "༎",
        "︕",
        "︺",
        "𑙧",
        "‾",
        "‽",
        "᠁",
        "⸈",
        "៚",
        "។",
        "𐄂",
        "⁞",
        "꣼",
        "܇",
        "𑇍",
        "꧄",
        "𑂿",
        "⧙",
        "𑗊",
        "﹣",
        "𑩂",
        "܀",
        "‿",
        "⸼",
        "⦕",
        "܂",
        "꧅",
        "𑱱",
        "𑗄",
        "᪪",
        "࡞",
        "‷",
        "⸔",
        "﹁",
        "‰",
        "྅",
        "︻",
        "‚",
        "~",
        "꧉",
        "﹨",
        "«",
        "𑱃",
        "❪",
        "꛵",
        "༺",
        "＼",
        "߷",
        "—",
        "𖬺",
        "⁌",
        "؍",
        "⸕",
        "﹔",
        "⁅",
        "⸆",
        "𑙦",
        "𑂾",
        "·",
        "༌",
        "﹞",
        "಄",
        "〙",
        "꩞",
        "܆",
        "⁕",
        "】",
        "﹅",
        "᛭",
        "︙",
        "𑁍",
        "૰",
        "𑇈",
        "𑜼",
        ";",
        "〟",
        "﹘",
        "₍",
        "}",
        "𑁇",
        "𑗏",
        "＂",
        "᪣",
        "𑱁",
        "٬",
        "⁉",
        "࠰",
        "⸤",
        "᭞",
        "꧈",
        "⹎",
        "⸙",
        "｠",
        "⸏",
        "‵",
        "𑩅",
        "^",
        "⸲",
        "၍",
        "꘏",
        "］",
        ".",
        "⁏",
        "՝",
        "⸞",
        "‧",
        "@",
        "𑪡",
        "𑱂",
        "⸓",
        "᪦",
        "༏",
        "﹗",
        "⹀",
        "꣎",
        "༊",
        "⁚",
        "՞",
        "᠉",
        "꧍",
        "<",
        "⦔",
        "﹏",
        "𑑛",
        "𐩐",
        "⸚",
        "֊",
        "꛶",
        "⸷",
        "𑇅",
        "᐀",
        "❰",
        "𑑋",
        "𑑎",
        "᪡",
        "⁙",
        "⸥",
        "𑗕",
        "꛷",
        "𑙥",
        "᥅",
        "⹇",
        "꧃",
        "⦖",
        "𑙢",
        "༇",
        "︾",
        "；",
        "𐤿",
        "﹈",
        "᚛",
        "⦍",
        "⦅",
        "⦇",
        "𝪈",
        "܈",
        "༆",
        "｣",
        "»",
        "{",
        "᠀",
        "𑪛",
        "〜",
        "౷",
        "⳺",
        "｟",
        "❨",
        "𑗍",
        "`",
        "꩜",
        "𒑰",
        "፣",
        "𐮚",
        "﴾",
        "꩝",
        "⦎",
        "៙",
        "׃",
        "𑱰",
        "༄",
        "⁘",
        "𑩀",
        ")",
        "［",
        "⟫",
        "〗",
        "⁾",
        "𑪟",
        "𐬾",
        "𑈺",
        "︐",
        "𒑲",
        "︿",
        "⸁",
        "𑧢",
        "〞",
        "៕",
        "᙮",
        "𐮛",
        "࿙",
        "᯿",
        "၊",
        "⦏",
        "⹂",
        "⸢",
        "⁖",
        "．",
        "⹏",
        "꡴",
        "𐬽",
        "॰",
        "⸜",
        "﹪",
        "𐩔",
        "᳇",
        "𑈽",
        "§",
        "⸿",
        "።",
        "፧",
        "⟪",
        "𖫵",
        "‸",
        "(",
        "⸉",
        "𐬿",
        "𐽖",
        "܃",
        "⳻",
        ">",
        "⁐",
        "؊",
        "𑊩",
        "⸵",
        "᭟",
        "𐫴",
        "–",
        "𑑝",
        "“",
        "꧋",
        "〕",
        "%",
        "⸶",
        "•",
        "𑇆",
        "𑗅",
        "⁛",
        "｛",
        "؟",
        "⸭",
        "％",
        "⁇",
        "᳃",
        "𑅂",
        "\\",
        "𑗂",
        "'",
        "·",
        "〉",
        "᥄",
        "܌",
        "𐫰",
        "𖩮",
        "꡶",
        "꡷",
        "⦉",
        "／",
        "𑻸",
        "⸄",
        "《",
        "᳁",
        "𐩒",
        "⌊",
        "﹜",
        "𑙩",
        "﹎",
        "꣹",
        "′",
        "⵰",
        "᱿",
        "𐫲",
        "᛫",
        "༐",
        "؛",
        "‐",
        "⸫",
        "⦒",
        "꤮",
        "︘",
        "〖",
        "၎",
        "︒",
        "︶",
        "⳼",
        "᠃",
        "𐫵",
        "᜵",
        "𐬼",
        "𑩁",
        "𖬷",
        "𑇛",
        "᰽",
        "᳄",
        "︖",
        "〽",
        "׳",
        "⌉",
        "⸘",
        "⸇",
        "𑗁",
        "꣺",
        "꯫",
        "❬",
        "﹃",
        "𑈸",
        "⧼",
        "𑙨",
        "᳓",
        "꘍",
        "𑑍",
        "⟆",
        "𑙂",
        "𖬹",
        "：",
        "꙾",
        "⧘",
        "༻",
        "᪢",
        "〝",
        "，",
        "᳀",
        "๏",
        "꘎",
        "𑈹",
        "❭",
        "⧚",
        "⁋",
        "࠳",
        "⟨",
        "᠈",
        "𐮙",
        "⁁",
        "𑅴",
        ":",
        "、",
        "࿔",
        "۔",
        "⦘",
        "⸃",
        "᨟",
        "⁃",
        "𑪚",
        "՛",
        "⁑",
        "𑠻",
        "︸",
        "𑁌",
        "⸣",
        "՜",
        "׀",
        "꫞",
        "꧞",
        "᯼",
        "❫",
        "‑",
        "᪭",
        "＿",
        "፦",
        "𐄀",
        "〘",
        "𑗋",
        "$",
        "᠂",
        "?",
        "࠲",
        "𖺚",
        "𖬻",
        "︔",
        "࠹",
        "࠾",
        "။",
        "﹌",
        "𐕯",
        "𑁋",
        "𐡗",
        "၏",
        "﹝",
        "︵",
        "⁊",
        "𐄁",
        ",",
        "＠",
        "﹙",
        "𑪜",
        "⸺",
        "‟",
        "᪠",
        "᨞",
        "⸊",
        "†",
        "𑙪",
        "᰿",
        "꛲",
        "‒",
        "⸩",
        "𑈼",
        "𑗐",
        '"',
        "⸍",
        "࠶",
        "𑇇",
        "𑇝",
        "॥",
        "⦐",
        "𐽕",
        "⸰",
        "𖺗",
        "᪥",
        "！",
        "⹆",
        "･",
        "𒑳",
        "𑱅",
        "⸬",
        "_",
        "𐤟",
        "࿑",
        "⁎",
        "︗",
        "𐏐",
        "၌",
        "？",
        "‡",
        "⸽",
        "❯",
        "𐬻",
        "᯾",
        "〈",
        "[",
        "﹚",
        "܄",
        "𑗔",
        "܋",
        "٭",
        "﹍",
        "𛲟",
        "⹊",
        "﹕",
        "𑙬",
        "𑅀",
        "｝",
        "❲",
        "𑃁",
        "❩",
        "𒑴",
        "᰼",
        "𑙁",
        "᠊",
        "#",
        "⹄",
        "﹀",
        "𐩿",
        "߹",
        "⦆",
        "!",
        "⹉",
        "⟦",
        "﹖",
        "؉",
        "『",
        "⁓",
        "₎",
        "⸎",
        "࿓",
        "꫟",
        "⦓",
        "𐫱",
        "𑑏",
        "᳆",
        "෴",
        "𑗗",
        "꧇",
        "࿒",
        "᛬",
        "⸮",
        "︴",
        "）",
        "𑩄",
        "❴",
        "⸟",
        "᜶",
        "〰",
        "⸑",
        "𑅁",
        "᠇",
        "]",
        "⹋",
        "꧁",
        "⁀",
        "༒",
        "꛳",
        "࠴",
        "־",
        "⸻",
        "𑨿",
        "𑜽",
        "⦈",
        "/",
        "・",
        "࠽",
        "‖",
        "،",
        "⸹",
        "៖",
        "𑪠",
        "࠼",
    }
)

if __name__ == "__main__":
    import string
    import sys
    import unicodedata

    UNICODE_CHARS = frozenset(chr(c) for c in range(sys.maxunicode + 1))
    UNICODE_PUNCTUATION = frozenset(
        c for c in UNICODE_CHARS if unicodedata.category(c).startswith("P")
    ) | frozenset(string.punctuation)
    print(repr(UNICODE_PUNCTUATION))
