# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[str],
                 account_expires: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 enable_change_password: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 next_login_change_password: Optional[pulumi.Input[bool]] = None,
                 password_never_expires: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] email: Specifies the email address of user. The value can contain `1` to `64` characters.
        :param pulumi.Input[str] account_expires: Specifies the user's valid period configuration.
               + Never expires: **0**.
               + Expires at a certain time: account expires must in RFC3339 format like `yyyy-MM-ddTHH:mm:ssZ`.
               The times is in local time, depending on the timezone.
        :param pulumi.Input[str] description: Specifies the description of user. The maximum length is `255` characters.
        :param pulumi.Input[bool] disabled: Specifies whether the user is disabled.
               Defualts to **false**.
        :param pulumi.Input[bool] enable_change_password: Specifies whether to allow password modification.
               Defualts to **true**.
        :param pulumi.Input[str] name: Specifies the user name.
               + Pure numeric: the valid length is between `1` and `20`.
               + Non-pure numeric: the name can contain `1` to `20` characters, only letters, digits, hyphens (-), underscore (_) and
               dots (.) are allowed. The name must start with a letter.
        :param pulumi.Input[bool] next_login_change_password: Specifies whether the next login requires a password reset.
               Defualts to **true**.
        :param pulumi.Input[bool] password_never_expires: Specifies whether the password will never expires.
               Defualts to **false**.
        :param pulumi.Input[str] region: The region in which to create the Workspace user resource.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        pulumi.set(__self__, "email", email)
        if account_expires is not None:
            pulumi.set(__self__, "account_expires", account_expires)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if enable_change_password is not None:
            pulumi.set(__self__, "enable_change_password", enable_change_password)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_login_change_password is not None:
            pulumi.set(__self__, "next_login_change_password", next_login_change_password)
        if password_never_expires is not None:
            pulumi.set(__self__, "password_never_expires", password_never_expires)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        Specifies the email address of user. The value can contain `1` to `64` characters.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="accountExpires")
    def account_expires(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user's valid period configuration.
        + Never expires: **0**.
        + Expires at a certain time: account expires must in RFC3339 format like `yyyy-MM-ddTHH:mm:ssZ`.
        The times is in local time, depending on the timezone.
        """
        return pulumi.get(self, "account_expires")

    @account_expires.setter
    def account_expires(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_expires", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of user. The maximum length is `255` characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the user is disabled.
        Defualts to **false**.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="enableChangePassword")
    def enable_change_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to allow password modification.
        Defualts to **true**.
        """
        return pulumi.get(self, "enable_change_password")

    @enable_change_password.setter
    def enable_change_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_change_password", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user name.
        + Pure numeric: the valid length is between `1` and `20`.
        + Non-pure numeric: the name can contain `1` to `20` characters, only letters, digits, hyphens (-), underscore (_) and
        dots (.) are allowed. The name must start with a letter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextLoginChangePassword")
    def next_login_change_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the next login requires a password reset.
        Defualts to **true**.
        """
        return pulumi.get(self, "next_login_change_password")

    @next_login_change_password.setter
    def next_login_change_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "next_login_change_password", value)

    @property
    @pulumi.getter(name="passwordNeverExpires")
    def password_never_expires(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the password will never expires.
        Defualts to **false**.
        """
        return pulumi.get(self, "password_never_expires")

    @password_never_expires.setter
    def password_never_expires(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_never_expires", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the Workspace user resource.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 account_expires: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 enable_change_password: Optional[pulumi.Input[bool]] = None,
                 locked: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 next_login_change_password: Optional[pulumi.Input[bool]] = None,
                 password_never_expires: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 total_desktops: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[str] account_expires: Specifies the user's valid period configuration.
               + Never expires: **0**.
               + Expires at a certain time: account expires must in RFC3339 format like `yyyy-MM-ddTHH:mm:ssZ`.
               The times is in local time, depending on the timezone.
        :param pulumi.Input[str] description: Specifies the description of user. The maximum length is `255` characters.
        :param pulumi.Input[bool] disabled: Specifies whether the user is disabled.
               Defualts to **false**.
        :param pulumi.Input[str] email: Specifies the email address of user. The value can contain `1` to `64` characters.
        :param pulumi.Input[bool] enable_change_password: Specifies whether to allow password modification.
               Defualts to **true**.
        :param pulumi.Input[bool] locked: Whether the user is locked.
        :param pulumi.Input[str] name: Specifies the user name.
               + Pure numeric: the valid length is between `1` and `20`.
               + Non-pure numeric: the name can contain `1` to `20` characters, only letters, digits, hyphens (-), underscore (_) and
               dots (.) are allowed. The name must start with a letter.
        :param pulumi.Input[bool] next_login_change_password: Specifies whether the next login requires a password reset.
               Defualts to **true**.
        :param pulumi.Input[bool] password_never_expires: Specifies whether the password will never expires.
               Defualts to **false**.
        :param pulumi.Input[str] region: The region in which to create the Workspace user resource.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[int] total_desktops: The number of desktops the user has.
        """
        if account_expires is not None:
            pulumi.set(__self__, "account_expires", account_expires)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if enable_change_password is not None:
            pulumi.set(__self__, "enable_change_password", enable_change_password)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_login_change_password is not None:
            pulumi.set(__self__, "next_login_change_password", next_login_change_password)
        if password_never_expires is not None:
            pulumi.set(__self__, "password_never_expires", password_never_expires)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if total_desktops is not None:
            pulumi.set(__self__, "total_desktops", total_desktops)

    @property
    @pulumi.getter(name="accountExpires")
    def account_expires(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user's valid period configuration.
        + Never expires: **0**.
        + Expires at a certain time: account expires must in RFC3339 format like `yyyy-MM-ddTHH:mm:ssZ`.
        The times is in local time, depending on the timezone.
        """
        return pulumi.get(self, "account_expires")

    @account_expires.setter
    def account_expires(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_expires", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of user. The maximum length is `255` characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the user is disabled.
        Defualts to **false**.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the email address of user. The value can contain `1` to `64` characters.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="enableChangePassword")
    def enable_change_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to allow password modification.
        Defualts to **true**.
        """
        return pulumi.get(self, "enable_change_password")

    @enable_change_password.setter
    def enable_change_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_change_password", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the user is locked.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user name.
        + Pure numeric: the valid length is between `1` and `20`.
        + Non-pure numeric: the name can contain `1` to `20` characters, only letters, digits, hyphens (-), underscore (_) and
        dots (.) are allowed. The name must start with a letter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextLoginChangePassword")
    def next_login_change_password(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the next login requires a password reset.
        Defualts to **true**.
        """
        return pulumi.get(self, "next_login_change_password")

    @next_login_change_password.setter
    def next_login_change_password(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "next_login_change_password", value)

    @property
    @pulumi.getter(name="passwordNeverExpires")
    def password_never_expires(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the password will never expires.
        Defualts to **false**.
        """
        return pulumi.get(self, "password_never_expires")

    @password_never_expires.setter
    def password_never_expires(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_never_expires", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the Workspace user resource.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="totalDesktops")
    def total_desktops(self) -> Optional[pulumi.Input[int]]:
        """
        The number of desktops the user has.
        """
        return pulumi.get(self, "total_desktops")

    @total_desktops.setter
    def total_desktops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_desktops", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_expires: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 enable_change_password: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 next_login_change_password: Optional[pulumi.Input[bool]] = None,
                 password_never_expires: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Workspace user resource within HuaweiCloud.

        ## Example Usage
        ### Create a user that never expires

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        user_name = config.require_object("userName")
        email_address = config.require_object("emailAddress")
        test = huaweicloud.workspace.User("test",
            email=email_address,
            account_expires="0",
            password_never_expires=False,
            enable_change_password=True,
            next_login_change_password=True,
            disabled=False)
        ```

        ## Import

        Users can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Workspace/user:User test a96e632a399d452eb29e5091e0af806a
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_expires: Specifies the user's valid period configuration.
               + Never expires: **0**.
               + Expires at a certain time: account expires must in RFC3339 format like `yyyy-MM-ddTHH:mm:ssZ`.
               The times is in local time, depending on the timezone.
        :param pulumi.Input[str] description: Specifies the description of user. The maximum length is `255` characters.
        :param pulumi.Input[bool] disabled: Specifies whether the user is disabled.
               Defualts to **false**.
        :param pulumi.Input[str] email: Specifies the email address of user. The value can contain `1` to `64` characters.
        :param pulumi.Input[bool] enable_change_password: Specifies whether to allow password modification.
               Defualts to **true**.
        :param pulumi.Input[str] name: Specifies the user name.
               + Pure numeric: the valid length is between `1` and `20`.
               + Non-pure numeric: the name can contain `1` to `20` characters, only letters, digits, hyphens (-), underscore (_) and
               dots (.) are allowed. The name must start with a letter.
        :param pulumi.Input[bool] next_login_change_password: Specifies whether the next login requires a password reset.
               Defualts to **true**.
        :param pulumi.Input[bool] password_never_expires: Specifies whether the password will never expires.
               Defualts to **false**.
        :param pulumi.Input[str] region: The region in which to create the Workspace user resource.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Workspace user resource within HuaweiCloud.

        ## Example Usage
        ### Create a user that never expires

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        user_name = config.require_object("userName")
        email_address = config.require_object("emailAddress")
        test = huaweicloud.workspace.User("test",
            email=email_address,
            account_expires="0",
            password_never_expires=False,
            enable_change_password=True,
            next_login_change_password=True,
            disabled=False)
        ```

        ## Import

        Users can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Workspace/user:User test a96e632a399d452eb29e5091e0af806a
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_expires: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 enable_change_password: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 next_login_change_password: Optional[pulumi.Input[bool]] = None,
                 password_never_expires: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["account_expires"] = account_expires
            __props__.__dict__["description"] = description
            __props__.__dict__["disabled"] = disabled
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["enable_change_password"] = enable_change_password
            __props__.__dict__["name"] = name
            __props__.__dict__["next_login_change_password"] = next_login_change_password
            __props__.__dict__["password_never_expires"] = password_never_expires
            __props__.__dict__["region"] = region
            __props__.__dict__["locked"] = None
            __props__.__dict__["total_desktops"] = None
        super(User, __self__).__init__(
            'huaweicloud:Workspace/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_expires: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            email: Optional[pulumi.Input[str]] = None,
            enable_change_password: Optional[pulumi.Input[bool]] = None,
            locked: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            next_login_change_password: Optional[pulumi.Input[bool]] = None,
            password_never_expires: Optional[pulumi.Input[bool]] = None,
            region: Optional[pulumi.Input[str]] = None,
            total_desktops: Optional[pulumi.Input[int]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_expires: Specifies the user's valid period configuration.
               + Never expires: **0**.
               + Expires at a certain time: account expires must in RFC3339 format like `yyyy-MM-ddTHH:mm:ssZ`.
               The times is in local time, depending on the timezone.
        :param pulumi.Input[str] description: Specifies the description of user. The maximum length is `255` characters.
        :param pulumi.Input[bool] disabled: Specifies whether the user is disabled.
               Defualts to **false**.
        :param pulumi.Input[str] email: Specifies the email address of user. The value can contain `1` to `64` characters.
        :param pulumi.Input[bool] enable_change_password: Specifies whether to allow password modification.
               Defualts to **true**.
        :param pulumi.Input[bool] locked: Whether the user is locked.
        :param pulumi.Input[str] name: Specifies the user name.
               + Pure numeric: the valid length is between `1` and `20`.
               + Non-pure numeric: the name can contain `1` to `20` characters, only letters, digits, hyphens (-), underscore (_) and
               dots (.) are allowed. The name must start with a letter.
        :param pulumi.Input[bool] next_login_change_password: Specifies whether the next login requires a password reset.
               Defualts to **true**.
        :param pulumi.Input[bool] password_never_expires: Specifies whether the password will never expires.
               Defualts to **false**.
        :param pulumi.Input[str] region: The region in which to create the Workspace user resource.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[int] total_desktops: The number of desktops the user has.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["account_expires"] = account_expires
        __props__.__dict__["description"] = description
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["email"] = email
        __props__.__dict__["enable_change_password"] = enable_change_password
        __props__.__dict__["locked"] = locked
        __props__.__dict__["name"] = name
        __props__.__dict__["next_login_change_password"] = next_login_change_password
        __props__.__dict__["password_never_expires"] = password_never_expires
        __props__.__dict__["region"] = region
        __props__.__dict__["total_desktops"] = total_desktops
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountExpires")
    def account_expires(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the user's valid period configuration.
        + Never expires: **0**.
        + Expires at a certain time: account expires must in RFC3339 format like `yyyy-MM-ddTHH:mm:ssZ`.
        The times is in local time, depending on the timezone.
        """
        return pulumi.get(self, "account_expires")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of user. The maximum length is `255` characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the user is disabled.
        Defualts to **false**.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        Specifies the email address of user. The value can contain `1` to `64` characters.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="enableChangePassword")
    def enable_change_password(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to allow password modification.
        Defualts to **true**.
        """
        return pulumi.get(self, "enable_change_password")

    @property
    @pulumi.getter
    def locked(self) -> pulumi.Output[bool]:
        """
        Whether the user is locked.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the user name.
        + Pure numeric: the valid length is between `1` and `20`.
        + Non-pure numeric: the name can contain `1` to `20` characters, only letters, digits, hyphens (-), underscore (_) and
        dots (.) are allowed. The name must start with a letter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextLoginChangePassword")
    def next_login_change_password(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the next login requires a password reset.
        Defualts to **true**.
        """
        return pulumi.get(self, "next_login_change_password")

    @property
    @pulumi.getter(name="passwordNeverExpires")
    def password_never_expires(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the password will never expires.
        Defualts to **false**.
        """
        return pulumi.get(self, "password_never_expires")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the Workspace user resource.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="totalDesktops")
    def total_desktops(self) -> pulumi.Output[int]:
        """
        The number of desktops the user has.
        """
        return pulumi.get(self, "total_desktops")

