# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetPublicServicesResult',
    'AwaitableGetPublicServicesResult',
    'get_public_services',
    'get_public_services_output',
]

@pulumi.output_type
class GetPublicServicesResult:
    """
    A collection of values returned by getPublicServices.
    """
    def __init__(__self__, id=None, region=None, service_id=None, service_name=None, services=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if service_id and not isinstance(service_id, str):
            raise TypeError("Expected argument 'service_id' to be a str")
        pulumi.set(__self__, "service_id", service_id)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[str]:
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        The name of the public VPC endpoint service.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def services(self) -> Sequence['outputs.GetPublicServicesServiceResult']:
        """
        Indicates the public VPC endpoint services information. Structure is documented below.
        """
        return pulumi.get(self, "services")


class AwaitableGetPublicServicesResult(GetPublicServicesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublicServicesResult(
            id=self.id,
            region=self.region,
            service_id=self.service_id,
            service_name=self.service_name,
            services=self.services)


def get_public_services(region: Optional[str] = None,
                        service_id: Optional[str] = None,
                        service_name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublicServicesResult:
    """
    Use this data source to get available public VPC endpoint services.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    all_services = huaweicloud.Vpcep.get_public_services()
    dns_service = huaweicloud.Vpcep.get_public_services(service_name="dns")
    ```


    :param str region: The region in which to obtain the public VPC endpoint services. If omitted, the
           provider-level region will be used.
    :param str service_id: Specifies the unique ID of the public VPC endpoint service.
    :param str service_name: Specifies the name of the public VPC endpoint service. The value is not
           case-sensitive and supports fuzzy match.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['serviceId'] = service_id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Vpcep/getPublicServices:getPublicServices', __args__, opts=opts, typ=GetPublicServicesResult).value

    return AwaitableGetPublicServicesResult(
        id=__ret__.id,
        region=__ret__.region,
        service_id=__ret__.service_id,
        service_name=__ret__.service_name,
        services=__ret__.services)


@_utilities.lift_output_func(get_public_services)
def get_public_services_output(region: Optional[pulumi.Input[Optional[str]]] = None,
                               service_id: Optional[pulumi.Input[Optional[str]]] = None,
                               service_name: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPublicServicesResult]:
    """
    Use this data source to get available public VPC endpoint services.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    all_services = huaweicloud.Vpcep.get_public_services()
    dns_service = huaweicloud.Vpcep.get_public_services(service_name="dns")
    ```


    :param str region: The region in which to obtain the public VPC endpoint services. If omitted, the
           provider-level region will be used.
    :param str service_id: Specifies the unique ID of the public VPC endpoint service.
    :param str service_name: Specifies the name of the public VPC endpoint service. The value is not
           case-sensitive and supports fuzzy match.
    """
    ...
