# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecgroupRuleInitArgs', 'SecgroupRule']

@pulumi.input_type
class SecgroupRuleInitArgs:
    def __init__(__self__, *,
                 direction: pulumi.Input[str],
                 ethertype: pulumi.Input[str],
                 security_group_id: pulumi.Input[str],
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 port_range_max: Optional[pulumi.Input[int]] = None,
                 port_range_min: Optional[pulumi.Input[int]] = None,
                 ports: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 remote_address_group_id: Optional[pulumi.Input[str]] = None,
                 remote_group_id: Optional[pulumi.Input[str]] = None,
                 remote_ip_prefix: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecgroupRule resource.
        :param pulumi.Input[str] direction: Specifies the direction of the rule, valid values are **ingress** or
               **egress**. Changing this creates a new security group rule.
        :param pulumi.Input[str] ethertype: Specifies the layer 3 protocol type, valid values are **IPv4** or **IPv6**.
               Changing this creates a new security group rule.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID the rule should belong to. Changing
               this creates a new security group rule.
        :param pulumi.Input[str] action: Specifies the effective policy. The valid values are **allow** and **deny**.
               This parameter is not used with `port_range_min` and `port_range_max`.
               Changing this creates a new security group rule.
        :param pulumi.Input[str] description: Specifies the supplementary information about the networking security
               group rule. This parameter can contain a maximum of 255 characters and cannot contain angle brackets (< or >).
               Changing this creates a new security group rule.
        :param pulumi.Input[int] port_range_max: Specifies the higher part of the allowed port range, valid integer value
               needs to be between `1` and `65,535`. Changing this creates a new security group rule.
               This parameter and `ports` are alternative.
        :param pulumi.Input[int] port_range_min: Specifies the lower part of the allowed port range, valid integer value
               needs to be between `1` and `65,535`. Changing this creates a new security group rule.
               This parameter and `ports` are alternative.
        :param pulumi.Input[str] ports: Specifies the allowed port value range, which supports single port (80),
               continuous port (1-30) and discontinous port (22, 3389, 80) The valid port values is range form `1` to `65,535`.
               Changing this creates a new security group rule.
        :param pulumi.Input[int] priority: Specifies the priority number.
               The valid value is range from **1** to **100**. The default value is **1**.
               This parameter is not used with `port_range_min` and `port_range_max`.
               Changing this creates a new security group rule.
        :param pulumi.Input[str] protocol: Specifies the layer 4 protocol type, valid values are **tcp**, **udp**,
               **icmp** and **icmpv6**. If omitted, the protocol means that all protocols are supported.
               This is required if you want to specify a port range. Changing this creates a new security group rule.
        :param pulumi.Input[str] region: Specifies the region in which to create the security group rule resource. If
               omitted, the provider-level region will be used. Changing this creates a new security group rule.
        :param pulumi.Input[str] remote_address_group_id: Specifies the remote address group ID.
               This parameter is not used with `port_range_min` and `port_range_max`.
               Changing this creates a new security group rule.
        :param pulumi.Input[str] remote_group_id: Specifies the remote group ID. Changing this creates a new security
               group rule.
        :param pulumi.Input[str] remote_ip_prefix: Specifies the remote CIDR, the value needs to be a valid CIDR (i.e.
               192.168.0.0/16). Changing this creates a new security group rule.
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "ethertype", ethertype)
        pulumi.set(__self__, "security_group_id", security_group_id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if port_range_max is not None:
            pulumi.set(__self__, "port_range_max", port_range_max)
        if port_range_min is not None:
            pulumi.set(__self__, "port_range_min", port_range_min)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remote_address_group_id is not None:
            pulumi.set(__self__, "remote_address_group_id", remote_address_group_id)
        if remote_group_id is not None:
            pulumi.set(__self__, "remote_group_id", remote_group_id)
        if remote_ip_prefix is not None:
            pulumi.set(__self__, "remote_ip_prefix", remote_ip_prefix)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[str]:
        """
        Specifies the direction of the rule, valid values are **ingress** or
        **egress**. Changing this creates a new security group rule.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[str]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def ethertype(self) -> pulumi.Input[str]:
        """
        Specifies the layer 3 protocol type, valid values are **IPv4** or **IPv6**.
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "ethertype")

    @ethertype.setter
    def ethertype(self, value: pulumi.Input[str]):
        pulumi.set(self, "ethertype", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        Specifies the security group ID the rule should belong to. Changing
        this creates a new security group rule.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the effective policy. The valid values are **allow** and **deny**.
        This parameter is not used with `port_range_min` and `port_range_max`.
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the supplementary information about the networking security
        group rule. This parameter can contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="portRangeMax")
    def port_range_max(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the higher part of the allowed port range, valid integer value
        needs to be between `1` and `65,535`. Changing this creates a new security group rule.
        This parameter and `ports` are alternative.
        """
        return pulumi.get(self, "port_range_max")

    @port_range_max.setter
    def port_range_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_range_max", value)

    @property
    @pulumi.getter(name="portRangeMin")
    def port_range_min(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the lower part of the allowed port range, valid integer value
        needs to be between `1` and `65,535`. Changing this creates a new security group rule.
        This parameter and `ports` are alternative.
        """
        return pulumi.get(self, "port_range_min")

    @port_range_min.setter
    def port_range_min(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_range_min", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the allowed port value range, which supports single port (80),
        continuous port (1-30) and discontinous port (22, 3389, 80) The valid port values is range form `1` to `65,535`.
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the priority number.
        The valid value is range from **1** to **100**. The default value is **1**.
        This parameter is not used with `port_range_min` and `port_range_max`.
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the layer 4 protocol type, valid values are **tcp**, **udp**,
        **icmp** and **icmpv6**. If omitted, the protocol means that all protocols are supported.
        This is required if you want to specify a port range. Changing this creates a new security group rule.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the security group rule resource. If
        omitted, the provider-level region will be used. Changing this creates a new security group rule.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="remoteAddressGroupId")
    def remote_address_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the remote address group ID.
        This parameter is not used with `port_range_min` and `port_range_max`.
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "remote_address_group_id")

    @remote_address_group_id.setter
    def remote_address_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_address_group_id", value)

    @property
    @pulumi.getter(name="remoteGroupId")
    def remote_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the remote group ID. Changing this creates a new security
        group rule.
        """
        return pulumi.get(self, "remote_group_id")

    @remote_group_id.setter
    def remote_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_group_id", value)

    @property
    @pulumi.getter(name="remoteIpPrefix")
    def remote_ip_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the remote CIDR, the value needs to be a valid CIDR (i.e.
        192.168.0.0/16). Changing this creates a new security group rule.
        """
        return pulumi.get(self, "remote_ip_prefix")

    @remote_ip_prefix.setter
    def remote_ip_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_ip_prefix", value)


@pulumi.input_type
class _SecgroupRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 ethertype: Optional[pulumi.Input[str]] = None,
                 port_range_max: Optional[pulumi.Input[int]] = None,
                 port_range_min: Optional[pulumi.Input[int]] = None,
                 ports: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 remote_address_group_id: Optional[pulumi.Input[str]] = None,
                 remote_group_id: Optional[pulumi.Input[str]] = None,
                 remote_ip_prefix: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecgroupRule resources.
        :param pulumi.Input[str] action: Specifies the effective policy. The valid values are **allow** and **deny**.
               This parameter is not used with `port_range_min` and `port_range_max`.
               Changing this creates a new security group rule.
        :param pulumi.Input[str] description: Specifies the supplementary information about the networking security
               group rule. This parameter can contain a maximum of 255 characters and cannot contain angle brackets (< or >).
               Changing this creates a new security group rule.
        :param pulumi.Input[str] direction: Specifies the direction of the rule, valid values are **ingress** or
               **egress**. Changing this creates a new security group rule.
        :param pulumi.Input[str] ethertype: Specifies the layer 3 protocol type, valid values are **IPv4** or **IPv6**.
               Changing this creates a new security group rule.
        :param pulumi.Input[int] port_range_max: Specifies the higher part of the allowed port range, valid integer value
               needs to be between `1` and `65,535`. Changing this creates a new security group rule.
               This parameter and `ports` are alternative.
        :param pulumi.Input[int] port_range_min: Specifies the lower part of the allowed port range, valid integer value
               needs to be between `1` and `65,535`. Changing this creates a new security group rule.
               This parameter and `ports` are alternative.
        :param pulumi.Input[str] ports: Specifies the allowed port value range, which supports single port (80),
               continuous port (1-30) and discontinous port (22, 3389, 80) The valid port values is range form `1` to `65,535`.
               Changing this creates a new security group rule.
        :param pulumi.Input[int] priority: Specifies the priority number.
               The valid value is range from **1** to **100**. The default value is **1**.
               This parameter is not used with `port_range_min` and `port_range_max`.
               Changing this creates a new security group rule.
        :param pulumi.Input[str] protocol: Specifies the layer 4 protocol type, valid values are **tcp**, **udp**,
               **icmp** and **icmpv6**. If omitted, the protocol means that all protocols are supported.
               This is required if you want to specify a port range. Changing this creates a new security group rule.
        :param pulumi.Input[str] region: Specifies the region in which to create the security group rule resource. If
               omitted, the provider-level region will be used. Changing this creates a new security group rule.
        :param pulumi.Input[str] remote_address_group_id: Specifies the remote address group ID.
               This parameter is not used with `port_range_min` and `port_range_max`.
               Changing this creates a new security group rule.
        :param pulumi.Input[str] remote_group_id: Specifies the remote group ID. Changing this creates a new security
               group rule.
        :param pulumi.Input[str] remote_ip_prefix: Specifies the remote CIDR, the value needs to be a valid CIDR (i.e.
               192.168.0.0/16). Changing this creates a new security group rule.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID the rule should belong to. Changing
               this creates a new security group rule.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if ethertype is not None:
            pulumi.set(__self__, "ethertype", ethertype)
        if port_range_max is not None:
            pulumi.set(__self__, "port_range_max", port_range_max)
        if port_range_min is not None:
            pulumi.set(__self__, "port_range_min", port_range_min)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remote_address_group_id is not None:
            pulumi.set(__self__, "remote_address_group_id", remote_address_group_id)
        if remote_group_id is not None:
            pulumi.set(__self__, "remote_group_id", remote_group_id)
        if remote_ip_prefix is not None:
            pulumi.set(__self__, "remote_ip_prefix", remote_ip_prefix)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the effective policy. The valid values are **allow** and **deny**.
        This parameter is not used with `port_range_min` and `port_range_max`.
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the supplementary information about the networking security
        group rule. This parameter can contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the direction of the rule, valid values are **ingress** or
        **egress**. Changing this creates a new security group rule.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def ethertype(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the layer 3 protocol type, valid values are **IPv4** or **IPv6**.
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "ethertype")

    @ethertype.setter
    def ethertype(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ethertype", value)

    @property
    @pulumi.getter(name="portRangeMax")
    def port_range_max(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the higher part of the allowed port range, valid integer value
        needs to be between `1` and `65,535`. Changing this creates a new security group rule.
        This parameter and `ports` are alternative.
        """
        return pulumi.get(self, "port_range_max")

    @port_range_max.setter
    def port_range_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_range_max", value)

    @property
    @pulumi.getter(name="portRangeMin")
    def port_range_min(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the lower part of the allowed port range, valid integer value
        needs to be between `1` and `65,535`. Changing this creates a new security group rule.
        This parameter and `ports` are alternative.
        """
        return pulumi.get(self, "port_range_min")

    @port_range_min.setter
    def port_range_min(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port_range_min", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the allowed port value range, which supports single port (80),
        continuous port (1-30) and discontinous port (22, 3389, 80) The valid port values is range form `1` to `65,535`.
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the priority number.
        The valid value is range from **1** to **100**. The default value is **1**.
        This parameter is not used with `port_range_min` and `port_range_max`.
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the layer 4 protocol type, valid values are **tcp**, **udp**,
        **icmp** and **icmpv6**. If omitted, the protocol means that all protocols are supported.
        This is required if you want to specify a port range. Changing this creates a new security group rule.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the security group rule resource. If
        omitted, the provider-level region will be used. Changing this creates a new security group rule.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="remoteAddressGroupId")
    def remote_address_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the remote address group ID.
        This parameter is not used with `port_range_min` and `port_range_max`.
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "remote_address_group_id")

    @remote_address_group_id.setter
    def remote_address_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_address_group_id", value)

    @property
    @pulumi.getter(name="remoteGroupId")
    def remote_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the remote group ID. Changing this creates a new security
        group rule.
        """
        return pulumi.get(self, "remote_group_id")

    @remote_group_id.setter
    def remote_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_group_id", value)

    @property
    @pulumi.getter(name="remoteIpPrefix")
    def remote_ip_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the remote CIDR, the value needs to be a valid CIDR (i.e.
        192.168.0.0/16). Changing this creates a new security group rule.
        """
        return pulumi.get(self, "remote_ip_prefix")

    @remote_ip_prefix.setter
    def remote_ip_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_ip_prefix", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security group ID the rule should belong to. Changing
        this creates a new security group rule.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)


class SecgroupRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 ethertype: Optional[pulumi.Input[str]] = None,
                 port_range_max: Optional[pulumi.Input[int]] = None,
                 port_range_min: Optional[pulumi.Input[int]] = None,
                 ports: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 remote_address_group_id: Optional[pulumi.Input[str]] = None,
                 remote_group_id: Optional[pulumi.Input[str]] = None,
                 remote_ip_prefix: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Security Group Rule resource within HuaweiCloud.

        ## Example Usage
        ### Create an ingress rule that opens TCP port 8080 with port range parameters

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        security_group_id = config.require_object("securityGroupId")
        test = huaweicloud.vpc.SecgroupRule("test",
            security_group_id=security_group_id,
            direction="ingress",
            ethertype="IPv4",
            protocol="tcp",
            port_range_min=8080,
            port_range_max=8080,
            remote_ip_prefix="0.0.0.0/0")
        ```
        ### Create an ingress rule that enable the remote address group and open some TCP ports

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        group_name = config.require_object("groupName")
        security_group_id = config.require_object("securityGroupId")
        test_address_group = huaweicloud.vpc.AddressGroup("testAddressGroup", addresses=[
            "192.168.10.12",
            "192.168.11.0-192.168.11.240",
        ])
        test_secgroup_rule = huaweicloud.vpc.SecgroupRule("testSecgroupRule",
            security_group_id=security_group_id,
            direction="ingress",
            action="allow",
            ethertype="IPv4",
            ports="80,500,600-800",
            protocol="tcp",
            priority=5,
            remote_address_group_id=test_address_group.id)
        ```

        ## Import

        Security Group Rules can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/secgroupRule:SecgroupRule secgroup_rule_1 aeb68ee3-6e9d-4256-955c-9584a6212745
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: Specifies the effective policy. The valid values are **allow** and **deny**.
               This parameter is not used with `port_range_min` and `port_range_max`.
               Changing this creates a new security group rule.
        :param pulumi.Input[str] description: Specifies the supplementary information about the networking security
               group rule. This parameter can contain a maximum of 255 characters and cannot contain angle brackets (< or >).
               Changing this creates a new security group rule.
        :param pulumi.Input[str] direction: Specifies the direction of the rule, valid values are **ingress** or
               **egress**. Changing this creates a new security group rule.
        :param pulumi.Input[str] ethertype: Specifies the layer 3 protocol type, valid values are **IPv4** or **IPv6**.
               Changing this creates a new security group rule.
        :param pulumi.Input[int] port_range_max: Specifies the higher part of the allowed port range, valid integer value
               needs to be between `1` and `65,535`. Changing this creates a new security group rule.
               This parameter and `ports` are alternative.
        :param pulumi.Input[int] port_range_min: Specifies the lower part of the allowed port range, valid integer value
               needs to be between `1` and `65,535`. Changing this creates a new security group rule.
               This parameter and `ports` are alternative.
        :param pulumi.Input[str] ports: Specifies the allowed port value range, which supports single port (80),
               continuous port (1-30) and discontinous port (22, 3389, 80) The valid port values is range form `1` to `65,535`.
               Changing this creates a new security group rule.
        :param pulumi.Input[int] priority: Specifies the priority number.
               The valid value is range from **1** to **100**. The default value is **1**.
               This parameter is not used with `port_range_min` and `port_range_max`.
               Changing this creates a new security group rule.
        :param pulumi.Input[str] protocol: Specifies the layer 4 protocol type, valid values are **tcp**, **udp**,
               **icmp** and **icmpv6**. If omitted, the protocol means that all protocols are supported.
               This is required if you want to specify a port range. Changing this creates a new security group rule.
        :param pulumi.Input[str] region: Specifies the region in which to create the security group rule resource. If
               omitted, the provider-level region will be used. Changing this creates a new security group rule.
        :param pulumi.Input[str] remote_address_group_id: Specifies the remote address group ID.
               This parameter is not used with `port_range_min` and `port_range_max`.
               Changing this creates a new security group rule.
        :param pulumi.Input[str] remote_group_id: Specifies the remote group ID. Changing this creates a new security
               group rule.
        :param pulumi.Input[str] remote_ip_prefix: Specifies the remote CIDR, the value needs to be a valid CIDR (i.e.
               192.168.0.0/16). Changing this creates a new security group rule.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID the rule should belong to. Changing
               this creates a new security group rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecgroupRuleInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Security Group Rule resource within HuaweiCloud.

        ## Example Usage
        ### Create an ingress rule that opens TCP port 8080 with port range parameters

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        security_group_id = config.require_object("securityGroupId")
        test = huaweicloud.vpc.SecgroupRule("test",
            security_group_id=security_group_id,
            direction="ingress",
            ethertype="IPv4",
            protocol="tcp",
            port_range_min=8080,
            port_range_max=8080,
            remote_ip_prefix="0.0.0.0/0")
        ```
        ### Create an ingress rule that enable the remote address group and open some TCP ports

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        group_name = config.require_object("groupName")
        security_group_id = config.require_object("securityGroupId")
        test_address_group = huaweicloud.vpc.AddressGroup("testAddressGroup", addresses=[
            "192.168.10.12",
            "192.168.11.0-192.168.11.240",
        ])
        test_secgroup_rule = huaweicloud.vpc.SecgroupRule("testSecgroupRule",
            security_group_id=security_group_id,
            direction="ingress",
            action="allow",
            ethertype="IPv4",
            ports="80,500,600-800",
            protocol="tcp",
            priority=5,
            remote_address_group_id=test_address_group.id)
        ```

        ## Import

        Security Group Rules can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/secgroupRule:SecgroupRule secgroup_rule_1 aeb68ee3-6e9d-4256-955c-9584a6212745
        ```

        :param str resource_name: The name of the resource.
        :param SecgroupRuleInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecgroupRuleInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 ethertype: Optional[pulumi.Input[str]] = None,
                 port_range_max: Optional[pulumi.Input[int]] = None,
                 port_range_min: Optional[pulumi.Input[int]] = None,
                 ports: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 remote_address_group_id: Optional[pulumi.Input[str]] = None,
                 remote_group_id: Optional[pulumi.Input[str]] = None,
                 remote_ip_prefix: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecgroupRuleInitArgs.__new__(SecgroupRuleInitArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["description"] = description
            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            if ethertype is None and not opts.urn:
                raise TypeError("Missing required property 'ethertype'")
            __props__.__dict__["ethertype"] = ethertype
            __props__.__dict__["port_range_max"] = port_range_max
            __props__.__dict__["port_range_min"] = port_range_min
            __props__.__dict__["ports"] = ports
            __props__.__dict__["priority"] = priority
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            __props__.__dict__["remote_address_group_id"] = remote_address_group_id
            __props__.__dict__["remote_group_id"] = remote_group_id
            __props__.__dict__["remote_ip_prefix"] = remote_ip_prefix
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
        super(SecgroupRule, __self__).__init__(
            'huaweicloud:Vpc/secgroupRule:SecgroupRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            direction: Optional[pulumi.Input[str]] = None,
            ethertype: Optional[pulumi.Input[str]] = None,
            port_range_max: Optional[pulumi.Input[int]] = None,
            port_range_min: Optional[pulumi.Input[int]] = None,
            ports: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            remote_address_group_id: Optional[pulumi.Input[str]] = None,
            remote_group_id: Optional[pulumi.Input[str]] = None,
            remote_ip_prefix: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None) -> 'SecgroupRule':
        """
        Get an existing SecgroupRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: Specifies the effective policy. The valid values are **allow** and **deny**.
               This parameter is not used with `port_range_min` and `port_range_max`.
               Changing this creates a new security group rule.
        :param pulumi.Input[str] description: Specifies the supplementary information about the networking security
               group rule. This parameter can contain a maximum of 255 characters and cannot contain angle brackets (< or >).
               Changing this creates a new security group rule.
        :param pulumi.Input[str] direction: Specifies the direction of the rule, valid values are **ingress** or
               **egress**. Changing this creates a new security group rule.
        :param pulumi.Input[str] ethertype: Specifies the layer 3 protocol type, valid values are **IPv4** or **IPv6**.
               Changing this creates a new security group rule.
        :param pulumi.Input[int] port_range_max: Specifies the higher part of the allowed port range, valid integer value
               needs to be between `1` and `65,535`. Changing this creates a new security group rule.
               This parameter and `ports` are alternative.
        :param pulumi.Input[int] port_range_min: Specifies the lower part of the allowed port range, valid integer value
               needs to be between `1` and `65,535`. Changing this creates a new security group rule.
               This parameter and `ports` are alternative.
        :param pulumi.Input[str] ports: Specifies the allowed port value range, which supports single port (80),
               continuous port (1-30) and discontinous port (22, 3389, 80) The valid port values is range form `1` to `65,535`.
               Changing this creates a new security group rule.
        :param pulumi.Input[int] priority: Specifies the priority number.
               The valid value is range from **1** to **100**. The default value is **1**.
               This parameter is not used with `port_range_min` and `port_range_max`.
               Changing this creates a new security group rule.
        :param pulumi.Input[str] protocol: Specifies the layer 4 protocol type, valid values are **tcp**, **udp**,
               **icmp** and **icmpv6**. If omitted, the protocol means that all protocols are supported.
               This is required if you want to specify a port range. Changing this creates a new security group rule.
        :param pulumi.Input[str] region: Specifies the region in which to create the security group rule resource. If
               omitted, the provider-level region will be used. Changing this creates a new security group rule.
        :param pulumi.Input[str] remote_address_group_id: Specifies the remote address group ID.
               This parameter is not used with `port_range_min` and `port_range_max`.
               Changing this creates a new security group rule.
        :param pulumi.Input[str] remote_group_id: Specifies the remote group ID. Changing this creates a new security
               group rule.
        :param pulumi.Input[str] remote_ip_prefix: Specifies the remote CIDR, the value needs to be a valid CIDR (i.e.
               192.168.0.0/16). Changing this creates a new security group rule.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID the rule should belong to. Changing
               this creates a new security group rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecgroupRuleState.__new__(_SecgroupRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["description"] = description
        __props__.__dict__["direction"] = direction
        __props__.__dict__["ethertype"] = ethertype
        __props__.__dict__["port_range_max"] = port_range_max
        __props__.__dict__["port_range_min"] = port_range_min
        __props__.__dict__["ports"] = ports
        __props__.__dict__["priority"] = priority
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["remote_address_group_id"] = remote_address_group_id
        __props__.__dict__["remote_group_id"] = remote_group_id
        __props__.__dict__["remote_ip_prefix"] = remote_ip_prefix
        __props__.__dict__["security_group_id"] = security_group_id
        return SecgroupRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        """
        Specifies the effective policy. The valid values are **allow** and **deny**.
        This parameter is not used with `port_range_min` and `port_range_max`.
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the supplementary information about the networking security
        group rule. This parameter can contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[str]:
        """
        Specifies the direction of the rule, valid values are **ingress** or
        **egress**. Changing this creates a new security group rule.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def ethertype(self) -> pulumi.Output[str]:
        """
        Specifies the layer 3 protocol type, valid values are **IPv4** or **IPv6**.
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "ethertype")

    @property
    @pulumi.getter(name="portRangeMax")
    def port_range_max(self) -> pulumi.Output[int]:
        """
        Specifies the higher part of the allowed port range, valid integer value
        needs to be between `1` and `65,535`. Changing this creates a new security group rule.
        This parameter and `ports` are alternative.
        """
        return pulumi.get(self, "port_range_max")

    @property
    @pulumi.getter(name="portRangeMin")
    def port_range_min(self) -> pulumi.Output[int]:
        """
        Specifies the lower part of the allowed port range, valid integer value
        needs to be between `1` and `65,535`. Changing this creates a new security group rule.
        This parameter and `ports` are alternative.
        """
        return pulumi.get(self, "port_range_min")

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Output[str]:
        """
        Specifies the allowed port value range, which supports single port (80),
        continuous port (1-30) and discontinous port (22, 3389, 80) The valid port values is range form `1` to `65,535`.
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        Specifies the priority number.
        The valid value is range from **1** to **100**. The default value is **1**.
        This parameter is not used with `port_range_min` and `port_range_max`.
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        Specifies the layer 4 protocol type, valid values are **tcp**, **udp**,
        **icmp** and **icmpv6**. If omitted, the protocol means that all protocols are supported.
        This is required if you want to specify a port range. Changing this creates a new security group rule.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the security group rule resource. If
        omitted, the provider-level region will be used. Changing this creates a new security group rule.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="remoteAddressGroupId")
    def remote_address_group_id(self) -> pulumi.Output[str]:
        """
        Specifies the remote address group ID.
        This parameter is not used with `port_range_min` and `port_range_max`.
        Changing this creates a new security group rule.
        """
        return pulumi.get(self, "remote_address_group_id")

    @property
    @pulumi.getter(name="remoteGroupId")
    def remote_group_id(self) -> pulumi.Output[str]:
        """
        Specifies the remote group ID. Changing this creates a new security
        group rule.
        """
        return pulumi.get(self, "remote_group_id")

    @property
    @pulumi.getter(name="remoteIpPrefix")
    def remote_ip_prefix(self) -> pulumi.Output[str]:
        """
        Specifies the remote CIDR, the value needs to be a valid CIDR (i.e.
        192.168.0.0/16). Changing this creates a new security group rule.
        """
        return pulumi.get(self, "remote_ip_prefix")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        Specifies the security group ID the rule should belong to. Changing
        this creates a new security group rule.
        """
        return pulumi.get(self, "security_group_id")

