# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetVpcResult',
    'AwaitableGetVpcResult',
    'get_vpc',
    'get_vpc_output',
]

@pulumi.output_type
class GetVpcResult:
    """
    A collection of values returned by getVpc.
    """
    def __init__(__self__, cidr=None, description=None, enterprise_project_id=None, id=None, name=None, region=None, routes=None, status=None, tags=None):
        if cidr and not isinstance(cidr, str):
            raise TypeError("Expected argument 'cidr' to be a str")
        pulumi.set(__self__, "cidr", cidr)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if routes and not isinstance(routes, list):
            raise TypeError("Expected argument 'routes' to be a list")
        if routes is not None:
            warnings.warn("""use huaweicloud_vpc_route_table data source to get all routes""", DeprecationWarning)
            pulumi.log.warn("""routes is deprecated: use huaweicloud_vpc_route_table data source to get all routes""")

        pulumi.set(__self__, "routes", routes)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def cidr(self) -> str:
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The supplementary information about the VPC. The value is a string of
        no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetVpcRouteResult']:
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        The key/value pairs to associate with the VPC.
        """
        return pulumi.get(self, "tags")


class AwaitableGetVpcResult(GetVpcResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcResult(
            cidr=self.cidr,
            description=self.description,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            name=self.name,
            region=self.region,
            routes=self.routes,
            status=self.status,
            tags=self.tags)


def get_vpc(cidr: Optional[str] = None,
            enterprise_project_id: Optional[str] = None,
            id: Optional[str] = None,
            name: Optional[str] = None,
            region: Optional[str] = None,
            status: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcResult:
    """
    Provides details about a specific VPC.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    vpc_name = config.require_object("vpcName")
    vpc = huaweicloud.Vpc.get_vpc(name=vpc_name)
    ```


    :param str cidr: Specifies the cidr block of the desired VPC.
    :param str id: Specifies the id of the VPC to retrieve.
    :param str name: Specifies an unique name for the VPC. The value is a string of no more than 64 characters
           and can contain digits, letters, underscores (_), and hyphens (-).
    :param str region: Specifies the region in which to obtain the VPC. If omitted, the provider-level region
           will be used.
    :param str status: Specifies the current status of the desired VPC. The value can be CREATING, OK or ERROR.
    """
    __args__ = dict()
    __args__['cidr'] = cidr
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Vpc/getVpc:getVpc', __args__, opts=opts, typ=GetVpcResult).value

    return AwaitableGetVpcResult(
        cidr=__ret__.cidr,
        description=__ret__.description,
        enterprise_project_id=__ret__.enterprise_project_id,
        id=__ret__.id,
        name=__ret__.name,
        region=__ret__.region,
        routes=__ret__.routes,
        status=__ret__.status,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_vpc)
def get_vpc_output(cidr: Optional[pulumi.Input[Optional[str]]] = None,
                   enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                   id: Optional[pulumi.Input[Optional[str]]] = None,
                   name: Optional[pulumi.Input[Optional[str]]] = None,
                   region: Optional[pulumi.Input[Optional[str]]] = None,
                   status: Optional[pulumi.Input[Optional[str]]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVpcResult]:
    """
    Provides details about a specific VPC.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    vpc_name = config.require_object("vpcName")
    vpc = huaweicloud.Vpc.get_vpc(name=vpc_name)
    ```


    :param str cidr: Specifies the cidr block of the desired VPC.
    :param str id: Specifies the id of the VPC to retrieve.
    :param str name: Specifies an unique name for the VPC. The value is a string of no more than 64 characters
           and can contain digits, letters, underscores (_), and hyphens (-).
    :param str region: Specifies the region in which to obtain the VPC. If omitted, the provider-level region
           will be used.
    :param str status: Specifies the current status of the desired VPC. The value can be CREATING, OK or ERROR.
    """
    ...
