# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSubnetsResult',
    'AwaitableGetSubnetsResult',
    'get_subnets',
    'get_subnets_output',
]

@pulumi.output_type
class GetSubnetsResult:
    """
    A collection of values returned by getSubnets.
    """
    def __init__(__self__, availability_zone=None, cidr=None, gateway_ip=None, id=None, name=None, primary_dns=None, region=None, secondary_dns=None, status=None, subnets=None, tags=None, vpc_id=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if cidr and not isinstance(cidr, str):
            raise TypeError("Expected argument 'cidr' to be a str")
        pulumi.set(__self__, "cidr", cidr)
        if gateway_ip and not isinstance(gateway_ip, str):
            raise TypeError("Expected argument 'gateway_ip' to be a str")
        pulumi.set(__self__, "gateway_ip", gateway_ip)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if primary_dns and not isinstance(primary_dns, str):
            raise TypeError("Expected argument 'primary_dns' to be a str")
        pulumi.set(__self__, "primary_dns", primary_dns)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if secondary_dns and not isinstance(secondary_dns, str):
            raise TypeError("Expected argument 'secondary_dns' to be a str")
        pulumi.set(__self__, "secondary_dns", secondary_dns)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnets and not isinstance(subnets, list):
            raise TypeError("Expected argument 'subnets' to be a list")
        pulumi.set(__self__, "subnets", subnets)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def cidr(self) -> Optional[str]:
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> Optional[str]:
        return pulumi.get(self, "gateway_ip")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryDns")
    def primary_dns(self) -> Optional[str]:
        return pulumi.get(self, "primary_dns")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secondaryDns")
    def secondary_dns(self) -> Optional[str]:
        return pulumi.get(self, "secondary_dns")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence['outputs.GetSubnetsSubnetResult']:
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        return pulumi.get(self, "vpc_id")


class AwaitableGetSubnetsResult(GetSubnetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubnetsResult(
            availability_zone=self.availability_zone,
            cidr=self.cidr,
            gateway_ip=self.gateway_ip,
            id=self.id,
            name=self.name,
            primary_dns=self.primary_dns,
            region=self.region,
            secondary_dns=self.secondary_dns,
            status=self.status,
            subnets=self.subnets,
            tags=self.tags,
            vpc_id=self.vpc_id)


def get_subnets(availability_zone: Optional[str] = None,
                cidr: Optional[str] = None,
                gateway_ip: Optional[str] = None,
                id: Optional[str] = None,
                name: Optional[str] = None,
                primary_dns: Optional[str] = None,
                region: Optional[str] = None,
                secondary_dns: Optional[str] = None,
                status: Optional[str] = None,
                tags: Optional[Mapping[str, str]] = None,
                vpc_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubnetsResult:
    """
    Use this data source to get a list of VPC subnet.

    ## **Attributes Reference**

    The following attributes are exported:

    * `id` - Indicates a data source ID.
    * `subnets` - Indicates a list of all subnets found. Structure is documented below.

    The `subnets` block supports:

    * `id` - Indicates the ID of the subnet.
    * `name` - Indicates the name of the subnet.
    * `description` - Indicates the description of the subnet.
    * `cidr` - Indicates the cidr block of the subnet.
    * `status` - Indicates the current status of the subnet.
    * `vpc_id` - Indicates the Id of the VPC that the subnet belongs to.
    * `gateway_ip` - Indicates the subnet gateway address of the subnet.
    * `primary_dns` - Indicates the IP address of DNS server 1 on the subnet.
    * `secondary_dns` - Indicates the IP address of DNS server 2 on the subnet.
    * `availability_zone` - Indicates the availability zone (AZ) to which the subnet belongs to.
    * `dhcp_enable` - Indicates whether the DHCP is enabled.
    * `dns_list` - Indicates The IP address list of DNS servers on the subnet.
    * `ipv4_subnet_id` - Indicates the ID of the IPv4 subnet (Native OpenStack API).
    * `ipv6_enable` - Indicates whether the IPv6 is enabled.
    * `ipv6_subnet_id` - Indicates the ID of the IPv6 subnet (Native OpenStack API).
    * `ipv6_cidr` - Indicates the IPv6 subnet CIDR block.
    * `ipv6_gateway` - Indicates the IPv6 subnet gateway.
    * `tags` - Indicates the key/value pairs which associated with the subnet.


    :param str availability_zone: Specifies the availability zone (AZ) to which the desired subnet belongs to.
    :param str cidr: Specifies the network segment of desired subnet. The value must be in CIDR format.
    :param str gateway_ip: Specifies the subnet gateway address of desired subnet.
    :param str id: - Specifies the id of the desired subnet.
    :param str name: Specifies the name of the desired subnet.
    :param str primary_dns: Specifies the IP address of DNS server 1 on the desired subnet.
    :param str region: Specifies the region in which to obtain the subnet. If omitted, the provider-level
           region will be used.
    :param str secondary_dns: Specifies the IP address of DNS server 2 on the desired subnet.
    :param str status: Specifies the current status of the desired subnet.
           the value can be ACTIVE, DOWN, UNKNOWN, or ERROR.
    :param Mapping[str, str] tags: Specifies the included key/value pairs which associated with the desired subnet.
    :param str vpc_id: Specifies the id of the VPC that the desired subnet belongs to.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['cidr'] = cidr
    __args__['gatewayIp'] = gateway_ip
    __args__['id'] = id
    __args__['name'] = name
    __args__['primaryDns'] = primary_dns
    __args__['region'] = region
    __args__['secondaryDns'] = secondary_dns
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Vpc/getSubnets:getSubnets', __args__, opts=opts, typ=GetSubnetsResult).value

    return AwaitableGetSubnetsResult(
        availability_zone=__ret__.availability_zone,
        cidr=__ret__.cidr,
        gateway_ip=__ret__.gateway_ip,
        id=__ret__.id,
        name=__ret__.name,
        primary_dns=__ret__.primary_dns,
        region=__ret__.region,
        secondary_dns=__ret__.secondary_dns,
        status=__ret__.status,
        subnets=__ret__.subnets,
        tags=__ret__.tags,
        vpc_id=__ret__.vpc_id)


@_utilities.lift_output_func(get_subnets)
def get_subnets_output(availability_zone: Optional[pulumi.Input[Optional[str]]] = None,
                       cidr: Optional[pulumi.Input[Optional[str]]] = None,
                       gateway_ip: Optional[pulumi.Input[Optional[str]]] = None,
                       id: Optional[pulumi.Input[Optional[str]]] = None,
                       name: Optional[pulumi.Input[Optional[str]]] = None,
                       primary_dns: Optional[pulumi.Input[Optional[str]]] = None,
                       region: Optional[pulumi.Input[Optional[str]]] = None,
                       secondary_dns: Optional[pulumi.Input[Optional[str]]] = None,
                       status: Optional[pulumi.Input[Optional[str]]] = None,
                       tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                       vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSubnetsResult]:
    """
    Use this data source to get a list of VPC subnet.

    ## **Attributes Reference**

    The following attributes are exported:

    * `id` - Indicates a data source ID.
    * `subnets` - Indicates a list of all subnets found. Structure is documented below.

    The `subnets` block supports:

    * `id` - Indicates the ID of the subnet.
    * `name` - Indicates the name of the subnet.
    * `description` - Indicates the description of the subnet.
    * `cidr` - Indicates the cidr block of the subnet.
    * `status` - Indicates the current status of the subnet.
    * `vpc_id` - Indicates the Id of the VPC that the subnet belongs to.
    * `gateway_ip` - Indicates the subnet gateway address of the subnet.
    * `primary_dns` - Indicates the IP address of DNS server 1 on the subnet.
    * `secondary_dns` - Indicates the IP address of DNS server 2 on the subnet.
    * `availability_zone` - Indicates the availability zone (AZ) to which the subnet belongs to.
    * `dhcp_enable` - Indicates whether the DHCP is enabled.
    * `dns_list` - Indicates The IP address list of DNS servers on the subnet.
    * `ipv4_subnet_id` - Indicates the ID of the IPv4 subnet (Native OpenStack API).
    * `ipv6_enable` - Indicates whether the IPv6 is enabled.
    * `ipv6_subnet_id` - Indicates the ID of the IPv6 subnet (Native OpenStack API).
    * `ipv6_cidr` - Indicates the IPv6 subnet CIDR block.
    * `ipv6_gateway` - Indicates the IPv6 subnet gateway.
    * `tags` - Indicates the key/value pairs which associated with the subnet.


    :param str availability_zone: Specifies the availability zone (AZ) to which the desired subnet belongs to.
    :param str cidr: Specifies the network segment of desired subnet. The value must be in CIDR format.
    :param str gateway_ip: Specifies the subnet gateway address of desired subnet.
    :param str id: - Specifies the id of the desired subnet.
    :param str name: Specifies the name of the desired subnet.
    :param str primary_dns: Specifies the IP address of DNS server 1 on the desired subnet.
    :param str region: Specifies the region in which to obtain the subnet. If omitted, the provider-level
           region will be used.
    :param str secondary_dns: Specifies the IP address of DNS server 2 on the desired subnet.
    :param str status: Specifies the current status of the desired subnet.
           the value can be ACTIVE, DOWN, UNKNOWN, or ERROR.
    :param Mapping[str, str] tags: Specifies the included key/value pairs which associated with the desired subnet.
    :param str vpc_id: Specifies the id of the VPC that the desired subnet belongs to.
    """
    ...
