# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecgroupsResult',
    'AwaitableGetSecgroupsResult',
    'get_secgroups',
    'get_secgroups_output',
]

@pulumi.output_type
class GetSecgroupsResult:
    """
    A collection of values returned by getSecgroups.
    """
    def __init__(__self__, description=None, enterprise_project_id=None, id=None, name=None, region=None, security_groups=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_groups and not isinstance(security_groups, list):
            raise TypeError("Expected argument 'security_groups' to be a list")
        pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[str]:
        """
        The enterprise project ID of the security group.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the security group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence['outputs.GetSecgroupsSecurityGroupResult']:
        """
        The list of security groups. The object is documented below.
        """
        return pulumi.get(self, "security_groups")


class AwaitableGetSecgroupsResult(GetSecgroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecgroupsResult(
            description=self.description,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            name=self.name,
            region=self.region,
            security_groups=self.security_groups)


def get_secgroups(description: Optional[str] = None,
                  enterprise_project_id: Optional[str] = None,
                  name: Optional[str] = None,
                  region: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecgroupsResult:
    """
    Use this data source to get the list of the available HuaweiCloud security groups.

    ## Example Usage
    ### Filter the list of security groups by a description keyword

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    key_word = config.require_object("keyWord")
    test = huaweicloud.Vpc.get_secgroups(description=key_word)
    ```


    :param str description: Specifies the description of the security group. The security groups can be
           filtered by keywords in the description.
    :param str enterprise_project_id: Specifies the enterprise project ID of the security group.
    :param str name: Specifies the name of the security group.
    :param str region: Specifies the region in which to obtain the security group list.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Vpc/getSecgroups:getSecgroups', __args__, opts=opts, typ=GetSecgroupsResult).value

    return AwaitableGetSecgroupsResult(
        description=__ret__.description,
        enterprise_project_id=__ret__.enterprise_project_id,
        id=__ret__.id,
        name=__ret__.name,
        region=__ret__.region,
        security_groups=__ret__.security_groups)


@_utilities.lift_output_func(get_secgroups)
def get_secgroups_output(description: Optional[pulumi.Input[Optional[str]]] = None,
                         enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                         name: Optional[pulumi.Input[Optional[str]]] = None,
                         region: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecgroupsResult]:
    """
    Use this data source to get the list of the available HuaweiCloud security groups.

    ## Example Usage
    ### Filter the list of security groups by a description keyword

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    key_word = config.require_object("keyWord")
    test = huaweicloud.Vpc.get_secgroups(description=key_word)
    ```


    :param str description: Specifies the description of the security group. The security groups can be
           filtered by keywords in the description.
    :param str enterprise_project_id: Specifies the enterprise project ID of the security group.
    :param str name: Specifies the name of the security group.
    :param str region: Specifies the region in which to obtain the security group list.
           If omitted, the provider-level region will be used.
    """
    ...
