# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['EipAssociateArgs', 'EipAssociate']

@pulumi.input_type
class EipAssociateArgs:
    def __init__(__self__, *,
                 public_ip: pulumi.Input[str],
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EipAssociate resource.
        :param pulumi.Input[str] public_ip: Specifies the EIP address to associate. Changing this creates a new resource.
        :param pulumi.Input[str] fixed_ip: Specifies a private IP address to associate with the EIP.
               Changing this creates a new resource.
        :param pulumi.Input[str] network_id: Specifies the ID of the network to which the **fixed_ip** belongs.
               It is mandatory when `fixed_ip` is set. Changing this creates a new resource.
        :param pulumi.Input[str] port_id: Specifies an existing port ID to associate with the EIP.
               This parameter and `fixed_ip` are alternative. Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to associate the EIP. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "public_ip", public_ip)
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Input[str]:
        """
        Specifies the EIP address to associate. Changing this creates a new resource.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a private IP address to associate with the EIP.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_ip", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the network to which the **fixed_ip** belongs.
        It is mandatory when `fixed_ip` is set. Changing this creates a new resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an existing port ID to associate with the EIP.
        This parameter and `fixed_ip` are alternative. Changing this creates a new resource.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to associate the EIP. If omitted, the provider-level
        region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _EipAssociateState:
    def __init__(__self__, *,
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EipAssociate resources.
        :param pulumi.Input[str] fixed_ip: Specifies a private IP address to associate with the EIP.
               Changing this creates a new resource.
        :param pulumi.Input[str] mac_address: The MAC address of the private IP.
        :param pulumi.Input[str] network_id: Specifies the ID of the network to which the **fixed_ip** belongs.
               It is mandatory when `fixed_ip` is set. Changing this creates a new resource.
        :param pulumi.Input[str] port_id: Specifies an existing port ID to associate with the EIP.
               This parameter and `fixed_ip` are alternative. Changing this creates a new resource.
        :param pulumi.Input[str] public_ip: Specifies the EIP address to associate. Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to associate the EIP. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] status: The status of EIP, should be **BOUND**.
        """
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a private IP address to associate with the EIP.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_ip", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        """
        The MAC address of the private IP.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the network to which the **fixed_ip** belongs.
        It is mandatory when `fixed_ip` is set. Changing this creates a new resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an existing port ID to associate with the EIP.
        This parameter and `fixed_ip` are alternative. Changing this creates a new resource.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_id", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the EIP address to associate. Changing this creates a new resource.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to associate the EIP. If omitted, the provider-level
        region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of EIP, should be **BOUND**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class EipAssociate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Associates an EIP to a specified IP address or port.

        ## Example Usage
        ### Associate with a fixed IP

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        public_address = config.require_object("publicAddress")
        network_id = config.require_object("networkId")
        associated = huaweicloud.vpc.EipAssociate("associated",
            public_ip=public_address,
            network_id=network_id,
            fixed_ip="192.168.0.100")
        ```
        ### Associate with a port

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        network_id = config.require_object("networkId")
        myport = huaweicloud.Vpc.get_port(network_id=network_id,
            fixed_ip="192.168.0.100")
        myeip = huaweicloud.vpc.Eip("myeip",
            publicip=huaweicloud.vpc.EipPublicipArgs(
                type="5_bgp",
            ),
            bandwidth=huaweicloud.vpc.EipBandwidthArgs(
                name="test",
                size=5,
                share_type="PER",
                charge_mode="traffic",
            ))
        associated = huaweicloud.vpc.EipAssociate("associated",
            public_ip=myeip.address,
            port_id=myport.id)
        ```

        ## Import

        EIP associations can be imported using the `id` of the EIP, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/eipAssociate:EipAssociate eip 2c7f39f3-702b-48d1-940c-b50384177ee1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] fixed_ip: Specifies a private IP address to associate with the EIP.
               Changing this creates a new resource.
        :param pulumi.Input[str] network_id: Specifies the ID of the network to which the **fixed_ip** belongs.
               It is mandatory when `fixed_ip` is set. Changing this creates a new resource.
        :param pulumi.Input[str] port_id: Specifies an existing port ID to associate with the EIP.
               This parameter and `fixed_ip` are alternative. Changing this creates a new resource.
        :param pulumi.Input[str] public_ip: Specifies the EIP address to associate. Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to associate the EIP. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EipAssociateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Associates an EIP to a specified IP address or port.

        ## Example Usage
        ### Associate with a fixed IP

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        public_address = config.require_object("publicAddress")
        network_id = config.require_object("networkId")
        associated = huaweicloud.vpc.EipAssociate("associated",
            public_ip=public_address,
            network_id=network_id,
            fixed_ip="192.168.0.100")
        ```
        ### Associate with a port

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        network_id = config.require_object("networkId")
        myport = huaweicloud.Vpc.get_port(network_id=network_id,
            fixed_ip="192.168.0.100")
        myeip = huaweicloud.vpc.Eip("myeip",
            publicip=huaweicloud.vpc.EipPublicipArgs(
                type="5_bgp",
            ),
            bandwidth=huaweicloud.vpc.EipBandwidthArgs(
                name="test",
                size=5,
                share_type="PER",
                charge_mode="traffic",
            ))
        associated = huaweicloud.vpc.EipAssociate("associated",
            public_ip=myeip.address,
            port_id=myport.id)
        ```

        ## Import

        EIP associations can be imported using the `id` of the EIP, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/eipAssociate:EipAssociate eip 2c7f39f3-702b-48d1-940c-b50384177ee1
        ```

        :param str resource_name: The name of the resource.
        :param EipAssociateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipAssociateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipAssociateArgs.__new__(EipAssociateArgs)

            __props__.__dict__["fixed_ip"] = fixed_ip
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["port_id"] = port_id
            if public_ip is None and not opts.urn:
                raise TypeError("Missing required property 'public_ip'")
            __props__.__dict__["public_ip"] = public_ip
            __props__.__dict__["region"] = region
            __props__.__dict__["mac_address"] = None
            __props__.__dict__["status"] = None
        super(EipAssociate, __self__).__init__(
            'huaweicloud:Vpc/eipAssociate:EipAssociate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            fixed_ip: Optional[pulumi.Input[str]] = None,
            mac_address: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            port_id: Optional[pulumi.Input[str]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'EipAssociate':
        """
        Get an existing EipAssociate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] fixed_ip: Specifies a private IP address to associate with the EIP.
               Changing this creates a new resource.
        :param pulumi.Input[str] mac_address: The MAC address of the private IP.
        :param pulumi.Input[str] network_id: Specifies the ID of the network to which the **fixed_ip** belongs.
               It is mandatory when `fixed_ip` is set. Changing this creates a new resource.
        :param pulumi.Input[str] port_id: Specifies an existing port ID to associate with the EIP.
               This parameter and `fixed_ip` are alternative. Changing this creates a new resource.
        :param pulumi.Input[str] public_ip: Specifies the EIP address to associate. Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to associate the EIP. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] status: The status of EIP, should be **BOUND**.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipAssociateState.__new__(_EipAssociateState)

        __props__.__dict__["fixed_ip"] = fixed_ip
        __props__.__dict__["mac_address"] = mac_address
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["port_id"] = port_id
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        return EipAssociate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> pulumi.Output[str]:
        """
        Specifies a private IP address to associate with the EIP.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "fixed_ip")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Output[str]:
        """
        The MAC address of the private IP.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the network to which the **fixed_ip** belongs.
        It is mandatory when `fixed_ip` is set. Changing this creates a new resource.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Output[str]:
        """
        Specifies an existing port ID to associate with the EIP.
        This parameter and `fixed_ip` are alternative. Changing this creates a new resource.
        """
        return pulumi.get(self, "port_id")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        Specifies the EIP address to associate. Changing this creates a new resource.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to associate the EIP. If omitted, the provider-level
        region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of EIP, should be **BOUND**.
        """
        return pulumi.get(self, "status")

