# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AddressGroupArgs', 'AddressGroup']

@pulumi.input_type
class AddressGroupArgs:
    def __init__(__self__, *,
                 addresses: pulumi.Input[Sequence[pulumi.Input[str]]],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AddressGroup resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] addresses: Specifies an array of one or more IPv4 addresses. The address can be a single IP
               address (such as 192.168.10.10), IP address range (such as 192.168.1.1-192.168.1.50) or IP address CIDR (such as 192.168.0.0/16).
               The maximum length is 20.
        :param pulumi.Input[str] description: Specifies the supplementary information about the IP address group.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[str] name: Specifies the IP address group name. The value is a string of 1 to 64 characters that can contain
               letters, digits, underscores (_), hyphens (-) and periods (.).
        :param pulumi.Input[str] region: Specifies tThe region in which to create the IP address group. If omitted, the
               provider-level region will be used. Changing this creates a new address group.
        """
        pulumi.set(__self__, "addresses", addresses)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def addresses(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies an array of one or more IPv4 addresses. The address can be a single IP
        address (such as 192.168.10.10), IP address range (such as 192.168.1.1-192.168.1.50) or IP address CIDR (such as 192.168.0.0/16).
        The maximum length is 20.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the supplementary information about the IP address group.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IP address group name. The value is a string of 1 to 64 characters that can contain
        letters, digits, underscores (_), hyphens (-) and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies tThe region in which to create the IP address group. If omitted, the
        provider-level region will be used. Changing this creates a new address group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AddressGroupState:
    def __init__(__self__, *,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AddressGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] addresses: Specifies an array of one or more IPv4 addresses. The address can be a single IP
               address (such as 192.168.10.10), IP address range (such as 192.168.1.1-192.168.1.50) or IP address CIDR (such as 192.168.0.0/16).
               The maximum length is 20.
        :param pulumi.Input[str] description: Specifies the supplementary information about the IP address group.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[int] ip_version: The IP version of the address group. The value is 4.
        :param pulumi.Input[str] name: Specifies the IP address group name. The value is a string of 1 to 64 characters that can contain
               letters, digits, underscores (_), hyphens (-) and periods (.).
        :param pulumi.Input[str] region: Specifies tThe region in which to create the IP address group. If omitted, the
               provider-level region will be used. Changing this creates a new address group.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies an array of one or more IPv4 addresses. The address can be a single IP
        address (such as 192.168.10.10), IP address range (such as 192.168.1.1-192.168.1.50) or IP address CIDR (such as 192.168.0.0/16).
        The maximum length is 20.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the supplementary information about the IP address group.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[int]]:
        """
        The IP version of the address group. The value is 4.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IP address group name. The value is a string of 1 to 64 characters that can contain
        letters, digits, underscores (_), hyphens (-) and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies tThe region in which to create the IP address group. If omitted, the
        provider-level region will be used. Changing this creates a new address group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


class AddressGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a VPC IP address group resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.vpc.AddressGroup("test", addresses=[
            "192.168.10.10",
            "192.168.1.1-192.168.1.50",
        ])
        ```

        ## Import

        IP address groups can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/addressGroup:AddressGroup test bc96f6b0-ca2c-42ee-b719-0f26bc9c8661
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] addresses: Specifies an array of one or more IPv4 addresses. The address can be a single IP
               address (such as 192.168.10.10), IP address range (such as 192.168.1.1-192.168.1.50) or IP address CIDR (such as 192.168.0.0/16).
               The maximum length is 20.
        :param pulumi.Input[str] description: Specifies the supplementary information about the IP address group.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[str] name: Specifies the IP address group name. The value is a string of 1 to 64 characters that can contain
               letters, digits, underscores (_), hyphens (-) and periods (.).
        :param pulumi.Input[str] region: Specifies tThe region in which to create the IP address group. If omitted, the
               provider-level region will be used. Changing this creates a new address group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AddressGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPC IP address group resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.vpc.AddressGroup("test", addresses=[
            "192.168.10.10",
            "192.168.1.1-192.168.1.50",
        ])
        ```

        ## Import

        IP address groups can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/addressGroup:AddressGroup test bc96f6b0-ca2c-42ee-b719-0f26bc9c8661
        ```

        :param str resource_name: The name of the resource.
        :param AddressGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddressGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddressGroupArgs.__new__(AddressGroupArgs)

            if addresses is None and not opts.urn:
                raise TypeError("Missing required property 'addresses'")
            __props__.__dict__["addresses"] = addresses
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["ip_version"] = None
        super(AddressGroup, __self__).__init__(
            'huaweicloud:Vpc/addressGroup:AddressGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            ip_version: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'AddressGroup':
        """
        Get an existing AddressGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] addresses: Specifies an array of one or more IPv4 addresses. The address can be a single IP
               address (such as 192.168.10.10), IP address range (such as 192.168.1.1-192.168.1.50) or IP address CIDR (such as 192.168.0.0/16).
               The maximum length is 20.
        :param pulumi.Input[str] description: Specifies the supplementary information about the IP address group.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[int] ip_version: The IP version of the address group. The value is 4.
        :param pulumi.Input[str] name: Specifies the IP address group name. The value is a string of 1 to 64 characters that can contain
               letters, digits, underscores (_), hyphens (-) and periods (.).
        :param pulumi.Input[str] region: Specifies tThe region in which to create the IP address group. If omitted, the
               provider-level region will be used. Changing this creates a new address group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddressGroupState.__new__(_AddressGroupState)

        __props__.__dict__["addresses"] = addresses
        __props__.__dict__["description"] = description
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        return AddressGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies an array of one or more IPv4 addresses. The address can be a single IP
        address (such as 192.168.10.10), IP address range (such as 192.168.1.1-192.168.1.50) or IP address CIDR (such as 192.168.0.0/16).
        The maximum length is 20.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the supplementary information about the IP address group.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[int]:
        """
        The IP version of the address group. The value is 4.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the IP address group name. The value is a string of 1 to 64 characters that can contain
        letters, digits, underscores (_), hyphens (-) and periods (.).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies tThe region in which to create the IP address group. If omitted, the
        provider-level region will be used. Changing this creates a new address group.
        """
        return pulumi.get(self, "region")

