# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'MediaAssetThumbnail',
    'TranscodingTemplateGroupQualityInfo',
    'TranscodingTemplateGroupQualityInfoAudio',
    'TranscodingTemplateGroupQualityInfoVideo',
]

@pulumi.output_type
class MediaAssetThumbnail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aspectRatio":
            suggest = "aspect_ratio"
        elif key == "coverPosition":
            suggest = "cover_position"
        elif key == "maxLength":
            suggest = "max_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MediaAssetThumbnail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MediaAssetThumbnail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MediaAssetThumbnail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 aspect_ratio: Optional[int] = None,
                 cover_position: Optional[int] = None,
                 dots: Optional[Sequence[int]] = None,
                 format: Optional[int] = None,
                 max_length: Optional[int] = None,
                 time: Optional[int] = None):
        """
        :param str type: Specifies the screenshot type. Valid values are: **time** and **dots**.
               Changing this creates a new resource.
        :param int aspect_ratio: Specifies the screenshot aspect ratio. The value can be:
               + **0**: adaptive (maintain the original aspect ratio).
               + **1**: 16:9.
        :param int cover_position: Specifies the number of screenshots as the cover. Defaults to: **1**.
               Changing this creates a new resource.
        :param Sequence[int] dots: Specifies an array of time points of screenshot. Required when `type` is **dots**.
               Changing this creates a new resource.
        :param int format: Specifies the screenshot file format. Currently, only **1** (jpg) is supported.
               Defaults to: **1**. Changing this creates a new resource.
        :param int max_length: Specifies the size of the longest side of the screenshot. Unit: pixel.
               The width dimension is calculated by scaling the dimension proportional to the original video pixels.
               Changing this creates a new resource.
        :param int time: Specifies the screenshot time interval (unit: second). The value range is 1 to 12.
               Required when `type` is **time**. Changing this creates a new resource.
        """
        pulumi.set(__self__, "type", type)
        if aspect_ratio is not None:
            pulumi.set(__self__, "aspect_ratio", aspect_ratio)
        if cover_position is not None:
            pulumi.set(__self__, "cover_position", cover_position)
        if dots is not None:
            pulumi.set(__self__, "dots", dots)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the screenshot type. Valid values are: **time** and **dots**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="aspectRatio")
    def aspect_ratio(self) -> Optional[int]:
        """
        Specifies the screenshot aspect ratio. The value can be:
        + **0**: adaptive (maintain the original aspect ratio).
        + **1**: 16:9.
        """
        return pulumi.get(self, "aspect_ratio")

    @property
    @pulumi.getter(name="coverPosition")
    def cover_position(self) -> Optional[int]:
        """
        Specifies the number of screenshots as the cover. Defaults to: **1**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "cover_position")

    @property
    @pulumi.getter
    def dots(self) -> Optional[Sequence[int]]:
        """
        Specifies an array of time points of screenshot. Required when `type` is **dots**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "dots")

    @property
    @pulumi.getter
    def format(self) -> Optional[int]:
        """
        Specifies the screenshot file format. Currently, only **1** (jpg) is supported.
        Defaults to: **1**. Changing this creates a new resource.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[int]:
        """
        Specifies the size of the longest side of the screenshot. Unit: pixel.
        The width dimension is calculated by scaling the dimension proportional to the original video pixels.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "max_length")

    @property
    @pulumi.getter
    def time(self) -> Optional[int]:
        """
        Specifies the screenshot time interval (unit: second). The value range is 1 to 12.
        Required when `type` is **time**. Changing this creates a new resource.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class TranscodingTemplateGroupQualityInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputFormat":
            suggest = "output_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TranscodingTemplateGroupQualityInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TranscodingTemplateGroupQualityInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TranscodingTemplateGroupQualityInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_format: str,
                 audio: Optional['outputs.TranscodingTemplateGroupQualityInfoAudio'] = None,
                 video: Optional['outputs.TranscodingTemplateGroupQualityInfoVideo'] = None):
        """
        :param str output_format: Specifies the output format. The value can be: **HLS**, **MP4**, **DASH**,
               **DASH_HLS**, **MP3** and **ADTS**.
        :param 'TranscodingTemplateGroupQualityInfoAudioArgs' audio: Specifies the audio configurations.
               The object structure is documented below.
        :param 'TranscodingTemplateGroupQualityInfoVideoArgs' video: Specifies the video configurations.
               The object structure is documented below.
        """
        pulumi.set(__self__, "output_format", output_format)
        if audio is not None:
            pulumi.set(__self__, "audio", audio)
        if video is not None:
            pulumi.set(__self__, "video", video)

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> str:
        """
        Specifies the output format. The value can be: **HLS**, **MP4**, **DASH**,
        **DASH_HLS**, **MP3** and **ADTS**.
        """
        return pulumi.get(self, "output_format")

    @property
    @pulumi.getter
    def audio(self) -> Optional['outputs.TranscodingTemplateGroupQualityInfoAudio']:
        """
        Specifies the audio configurations.
        The object structure is documented below.
        """
        return pulumi.get(self, "audio")

    @property
    @pulumi.getter
    def video(self) -> Optional['outputs.TranscodingTemplateGroupQualityInfoVideo']:
        """
        Specifies the video configurations.
        The object structure is documented below.
        """
        return pulumi.get(self, "video")


@pulumi.output_type
class TranscodingTemplateGroupQualityInfoAudio(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sampleRate":
            suggest = "sample_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TranscodingTemplateGroupQualityInfoAudio. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TranscodingTemplateGroupQualityInfoAudio.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TranscodingTemplateGroupQualityInfoAudio.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channels: int,
                 sample_rate: int,
                 bitrate: Optional[int] = None):
        """
        :param int channels: Specifies the audio channels. The value can be:
               + **1**: Mono
               + **2**: Stereo
        :param int sample_rate: Specifies the audio sample rate. The value can be:
               + **1**: AUTO
               + **2**: 22,050 Hz
               + **3**: 32,000 Hz
               + **4**: 44,100 Hz
               + **5**: 48,000 Hz
               + **6**: 96,000 Hz
        :param int bitrate: Specifies the audio bitrate. The value can be **0** or range from
               **8** to **1000**. Defaults to: **0**. If set to **0**, the output audio will be produced at the recommended bitrate.
        """
        pulumi.set(__self__, "channels", channels)
        pulumi.set(__self__, "sample_rate", sample_rate)
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)

    @property
    @pulumi.getter
    def channels(self) -> int:
        """
        Specifies the audio channels. The value can be:
        + **1**: Mono
        + **2**: Stereo
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter(name="sampleRate")
    def sample_rate(self) -> int:
        """
        Specifies the audio sample rate. The value can be:
        + **1**: AUTO
        + **2**: 22,050 Hz
        + **3**: 32,000 Hz
        + **4**: 44,100 Hz
        + **5**: 48,000 Hz
        + **6**: 96,000 Hz
        """
        return pulumi.get(self, "sample_rate")

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[int]:
        """
        Specifies the audio bitrate. The value can be **0** or range from
        **8** to **1000**. Defaults to: **0**. If set to **0**, the output audio will be produced at the recommended bitrate.
        """
        return pulumi.get(self, "bitrate")


@pulumi.output_type
class TranscodingTemplateGroupQualityInfoVideo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "frameRate":
            suggest = "frame_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TranscodingTemplateGroupQualityInfoVideo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TranscodingTemplateGroupQualityInfoVideo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TranscodingTemplateGroupQualityInfoVideo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 quality: str,
                 bitrate: Optional[int] = None,
                 frame_rate: Optional[int] = None,
                 height: Optional[int] = None,
                 width: Optional[int] = None):
        """
        :param str quality: Specifies the video quality.
               The value can be: **4K**, **2K**, **FHD**, **SD**, **LD** and **HD**.
        :param int bitrate: Specifies the audio bitrate. The value can be **0** or range from
               **8** to **1000**. Defaults to: **0**. If set to **0**, the output audio will be produced at the recommended bitrate.
        :param int frame_rate: Specifies the video frame rate. The value ranges from **1** to **75**.
               Defaults to: **1**. If set to **1**, the frame rate of the transcoded video is the same as that of the
               untransocded video.
        :param int height: Specifies the video height. The value can be **0** or range from **128** to **2160**.
               Defaults to: **0**. If set to **0**, the system will automatically adjust the `height` according to the `width`.
        :param int width: Specifies the video width. The value can be **0** or range from **128** to **3840**.
               Defaults to: **0**. If set to **0**, the system will automatically adjust the `width` according to the `height`.
        """
        pulumi.set(__self__, "quality", quality)
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if frame_rate is not None:
            pulumi.set(__self__, "frame_rate", frame_rate)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def quality(self) -> str:
        """
        Specifies the video quality.
        The value can be: **4K**, **2K**, **FHD**, **SD**, **LD** and **HD**.
        """
        return pulumi.get(self, "quality")

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[int]:
        """
        Specifies the audio bitrate. The value can be **0** or range from
        **8** to **1000**. Defaults to: **0**. If set to **0**, the output audio will be produced at the recommended bitrate.
        """
        return pulumi.get(self, "bitrate")

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> Optional[int]:
        """
        Specifies the video frame rate. The value ranges from **1** to **75**.
        Defaults to: **1**. If set to **1**, the frame rate of the transcoded video is the same as that of the
        untransocded video.
        """
        return pulumi.get(self, "frame_rate")

    @property
    @pulumi.getter
    def height(self) -> Optional[int]:
        """
        Specifies the video height. The value can be **0** or range from **128** to **2160**.
        Defaults to: **0**. If set to **0**, the system will automatically adjust the `height` according to the `width`.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def width(self) -> Optional[int]:
        """
        Specifies the video width. The value can be **0** or range from **128** to **3840**.
        Defaults to: **0**. If set to **0**, the system will automatically adjust the `width` according to the `height`.
        """
        return pulumi.get(self, "width")


