# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TaskArgs', 'Task']

@pulumi.input_type
class TaskArgs:
    def __init__(__self__, *,
                 os_type: pulumi.Input[str],
                 source_server_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 action: Optional[pulumi.Input[str]] = None,
                 migration_ip: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 start_target_server: Optional[pulumi.Input[bool]] = None,
                 syncing: Optional[pulumi.Input[bool]] = None,
                 target_server_disks: Optional[pulumi.Input[Sequence[pulumi.Input['TaskTargetServerDiskArgs']]]] = None,
                 target_server_id: Optional[pulumi.Input[str]] = None,
                 use_public_ip: Optional[pulumi.Input[bool]] = None,
                 vm_template_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Task resource.
        :param pulumi.Input[str] os_type: Specifies the OS type of the source server. The value can be **WINDOWS** and **LINUX**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] source_server_id: Specifies the ID of the source server.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] type: Specifies the type of the migration task. Available values are
               **MIGRATE_FILE**(file-level migration) and **MIGRATE_BLOCK**(block-level migration).
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] action: Specifies the operation after the task is created.
               The value can be **start**, **stop** and **restart**.
        :param pulumi.Input[str] migration_ip: Specifies the IP address of the target server.
               Use the EIP of the target server if the migration network type is Internet.
               Use the private IP address of the target server if the migration network type is Direct Connect or VPN.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] project_id: Specifies the project ID where the target server is located.
               If omitted, the default project in the region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region where the target server is located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] start_target_server: Specifies whether to start the target server after the migration.
               The default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] syncing: - Specifies whether to perform a continuous synchronization after the first replication.
               The default value is `false`. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['TaskTargetServerDiskArgs']]] target_server_disks: Specifies the disk configurations of the target server.
               If omitted, it will be obtained from the source server. The object
               is documented below. Changing this parameter will create a new resource.
        :param pulumi.Input[str] target_server_id: Specifies the existing server ID as the target server.
               This parameter and `vm_template_id` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] use_public_ip: Specifies whether to use a public IP address for migration.
               The default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] vm_template_id: Specifies the template used to create the target server automatically.
               This parameter and `target_server_id` are alternative. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "source_server_id", source_server_id)
        pulumi.set(__self__, "type", type)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if migration_ip is not None:
            pulumi.set(__self__, "migration_ip", migration_ip)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if start_target_server is not None:
            pulumi.set(__self__, "start_target_server", start_target_server)
        if syncing is not None:
            pulumi.set(__self__, "syncing", syncing)
        if target_server_disks is not None:
            pulumi.set(__self__, "target_server_disks", target_server_disks)
        if target_server_id is not None:
            pulumi.set(__self__, "target_server_id", target_server_id)
        if use_public_ip is not None:
            pulumi.set(__self__, "use_public_ip", use_public_ip)
        if vm_template_id is not None:
            pulumi.set(__self__, "vm_template_id", vm_template_id)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input[str]:
        """
        Specifies the OS type of the source server. The value can be **WINDOWS** and **LINUX**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="sourceServerId")
    def source_server_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the source server.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_server_id")

    @source_server_id.setter
    def source_server_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_server_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of the migration task. Available values are
        **MIGRATE_FILE**(file-level migration) and **MIGRATE_BLOCK**(block-level migration).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the operation after the task is created.
        The value can be **start**, **stop** and **restart**.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="migrationIp")
    def migration_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IP address of the target server.
        Use the EIP of the target server if the migration network type is Internet.
        Use the private IP address of the target server if the migration network type is Direct Connect or VPN.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "migration_ip")

    @migration_ip.setter
    def migration_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migration_ip", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the project ID where the target server is located.
        If omitted, the default project in the region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region where the target server is located.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="startTargetServer")
    def start_target_server(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to start the target server after the migration.
        The default value is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "start_target_server")

    @start_target_server.setter
    def start_target_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start_target_server", value)

    @property
    @pulumi.getter
    def syncing(self) -> Optional[pulumi.Input[bool]]:
        """
        - Specifies whether to perform a continuous synchronization after the first replication.
        The default value is `false`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "syncing")

    @syncing.setter
    def syncing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "syncing", value)

    @property
    @pulumi.getter(name="targetServerDisks")
    def target_server_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskTargetServerDiskArgs']]]]:
        """
        Specifies the disk configurations of the target server.
        If omitted, it will be obtained from the source server. The object
        is documented below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "target_server_disks")

    @target_server_disks.setter
    def target_server_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskTargetServerDiskArgs']]]]):
        pulumi.set(self, "target_server_disks", value)

    @property
    @pulumi.getter(name="targetServerId")
    def target_server_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the existing server ID as the target server.
        This parameter and `vm_template_id` are alternative. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "target_server_id")

    @target_server_id.setter
    def target_server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_server_id", value)

    @property
    @pulumi.getter(name="usePublicIp")
    def use_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use a public IP address for migration.
        The default value is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "use_public_ip")

    @use_public_ip.setter
    def use_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_public_ip", value)

    @property
    @pulumi.getter(name="vmTemplateId")
    def vm_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the template used to create the target server automatically.
        This parameter and `target_server_id` are alternative. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vm_template_id")

    @vm_template_id.setter
    def vm_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_template_id", value)


@pulumi.input_type
class _TaskState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 migrate_speed: Optional[pulumi.Input[float]] = None,
                 migration_ip: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 source_server_id: Optional[pulumi.Input[str]] = None,
                 start_target_server: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 syncing: Optional[pulumi.Input[bool]] = None,
                 target_server_disks: Optional[pulumi.Input[Sequence[pulumi.Input['TaskTargetServerDiskArgs']]]] = None,
                 target_server_id: Optional[pulumi.Input[str]] = None,
                 target_server_name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 use_public_ip: Optional[pulumi.Input[bool]] = None,
                 vm_template_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Task resources.
        :param pulumi.Input[str] action: Specifies the operation after the task is created.
               The value can be **start**, **stop** and **restart**.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the target server.
        :param pulumi.Input[float] migrate_speed: The migration rate, in MB/s.
        :param pulumi.Input[str] migration_ip: Specifies the IP address of the target server.
               Use the EIP of the target server if the migration network type is Internet.
               Use the private IP address of the target server if the migration network type is Direct Connect or VPN.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] os_type: Specifies the OS type of the source server. The value can be **WINDOWS** and **LINUX**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] project_id: Specifies the project ID where the target server is located.
               If omitted, the default project in the region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region where the target server is located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] source_server_id: Specifies the ID of the source server.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] start_target_server: Specifies whether to start the target server after the migration.
               The default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] state: The status of the migration task.
        :param pulumi.Input[bool] syncing: - Specifies whether to perform a continuous synchronization after the first replication.
               The default value is `false`. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['TaskTargetServerDiskArgs']]] target_server_disks: Specifies the disk configurations of the target server.
               If omitted, it will be obtained from the source server. The object
               is documented below. Changing this parameter will create a new resource.
        :param pulumi.Input[str] target_server_id: Specifies the existing server ID as the target server.
               This parameter and `vm_template_id` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[str] target_server_name: The name of the target server.
        :param pulumi.Input[str] type: Specifies the type of the migration task. Available values are
               **MIGRATE_FILE**(file-level migration) and **MIGRATE_BLOCK**(block-level migration).
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] use_public_ip: Specifies whether to use a public IP address for migration.
               The default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] vm_template_id: Specifies the template used to create the target server automatically.
               This parameter and `target_server_id` are alternative. Changing this parameter will create a new resource.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if migrate_speed is not None:
            pulumi.set(__self__, "migrate_speed", migrate_speed)
        if migration_ip is not None:
            pulumi.set(__self__, "migration_ip", migration_ip)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_server_id is not None:
            pulumi.set(__self__, "source_server_id", source_server_id)
        if start_target_server is not None:
            pulumi.set(__self__, "start_target_server", start_target_server)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if syncing is not None:
            pulumi.set(__self__, "syncing", syncing)
        if target_server_disks is not None:
            pulumi.set(__self__, "target_server_disks", target_server_disks)
        if target_server_id is not None:
            pulumi.set(__self__, "target_server_id", target_server_id)
        if target_server_name is not None:
            pulumi.set(__self__, "target_server_name", target_server_name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if use_public_ip is not None:
            pulumi.set(__self__, "use_public_ip", use_public_ip)
        if vm_template_id is not None:
            pulumi.set(__self__, "vm_template_id", vm_template_id)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the operation after the task is created.
        The value can be **start**, **stop** and **restart**.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the target server.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="migrateSpeed")
    def migrate_speed(self) -> Optional[pulumi.Input[float]]:
        """
        The migration rate, in MB/s.
        """
        return pulumi.get(self, "migrate_speed")

    @migrate_speed.setter
    def migrate_speed(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "migrate_speed", value)

    @property
    @pulumi.getter(name="migrationIp")
    def migration_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IP address of the target server.
        Use the EIP of the target server if the migration network type is Internet.
        Use the private IP address of the target server if the migration network type is Direct Connect or VPN.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "migration_ip")

    @migration_ip.setter
    def migration_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migration_ip", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OS type of the source server. The value can be **WINDOWS** and **LINUX**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the project ID where the target server is located.
        If omitted, the default project in the region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region where the target server is located.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sourceServerId")
    def source_server_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the source server.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_server_id")

    @source_server_id.setter
    def source_server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_server_id", value)

    @property
    @pulumi.getter(name="startTargetServer")
    def start_target_server(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to start the target server after the migration.
        The default value is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "start_target_server")

    @start_target_server.setter
    def start_target_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start_target_server", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the migration task.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def syncing(self) -> Optional[pulumi.Input[bool]]:
        """
        - Specifies whether to perform a continuous synchronization after the first replication.
        The default value is `false`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "syncing")

    @syncing.setter
    def syncing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "syncing", value)

    @property
    @pulumi.getter(name="targetServerDisks")
    def target_server_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskTargetServerDiskArgs']]]]:
        """
        Specifies the disk configurations of the target server.
        If omitted, it will be obtained from the source server. The object
        is documented below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "target_server_disks")

    @target_server_disks.setter
    def target_server_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskTargetServerDiskArgs']]]]):
        pulumi.set(self, "target_server_disks", value)

    @property
    @pulumi.getter(name="targetServerId")
    def target_server_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the existing server ID as the target server.
        This parameter and `vm_template_id` are alternative. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "target_server_id")

    @target_server_id.setter
    def target_server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_server_id", value)

    @property
    @pulumi.getter(name="targetServerName")
    def target_server_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the target server.
        """
        return pulumi.get(self, "target_server_name")

    @target_server_name.setter
    def target_server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_server_name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the migration task. Available values are
        **MIGRATE_FILE**(file-level migration) and **MIGRATE_BLOCK**(block-level migration).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="usePublicIp")
    def use_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use a public IP address for migration.
        The default value is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "use_public_ip")

    @use_public_ip.setter
    def use_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_public_ip", value)

    @property
    @pulumi.getter(name="vmTemplateId")
    def vm_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the template used to create the target server automatically.
        This parameter and `target_server_id` are alternative. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vm_template_id")

    @vm_template_id.setter
    def vm_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_template_id", value)


class Task(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 migration_ip: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 source_server_id: Optional[pulumi.Input[str]] = None,
                 start_target_server: Optional[pulumi.Input[bool]] = None,
                 syncing: Optional[pulumi.Input[bool]] = None,
                 target_server_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TaskTargetServerDiskArgs']]]]] = None,
                 target_server_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 use_public_ip: Optional[pulumi.Input[bool]] = None,
                 vm_template_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an SMS migration task resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        source_server = config.require_object("sourceServer")
        template_id = config.require_object("templateId")
        migration = huaweicloud.sms.Task("migration",
            type="MIGRATE_FILE",
            os_type="LINUX",
            source_server_id=source_server,
            vm_template_id=template_id,
            action="start")
        ```

        ## Import

        SMS migration tasks can be imported by `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Sms/task:Task demo 6402c49b-7d9a-413e-8b5f-a7307f7d5679
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response. The missing attributes include`use_public_ip`, `syncing` and `action`. It is generally recommended running `terraform plan` after importing a migration task. You can then decide if changes should be applied to the task, or the resource definition should be updated to align with the task. Also you can ignore changes as below. resource "huaweicloud_sms_task" "demo" {

         ...

         lifecycle {

         ignore_changes = [

         use_public_ip, syncing, action,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: Specifies the operation after the task is created.
               The value can be **start**, **stop** and **restart**.
        :param pulumi.Input[str] migration_ip: Specifies the IP address of the target server.
               Use the EIP of the target server if the migration network type is Internet.
               Use the private IP address of the target server if the migration network type is Direct Connect or VPN.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] os_type: Specifies the OS type of the source server. The value can be **WINDOWS** and **LINUX**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] project_id: Specifies the project ID where the target server is located.
               If omitted, the default project in the region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region where the target server is located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] source_server_id: Specifies the ID of the source server.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] start_target_server: Specifies whether to start the target server after the migration.
               The default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] syncing: - Specifies whether to perform a continuous synchronization after the first replication.
               The default value is `false`. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TaskTargetServerDiskArgs']]]] target_server_disks: Specifies the disk configurations of the target server.
               If omitted, it will be obtained from the source server. The object
               is documented below. Changing this parameter will create a new resource.
        :param pulumi.Input[str] target_server_id: Specifies the existing server ID as the target server.
               This parameter and `vm_template_id` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[str] type: Specifies the type of the migration task. Available values are
               **MIGRATE_FILE**(file-level migration) and **MIGRATE_BLOCK**(block-level migration).
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] use_public_ip: Specifies whether to use a public IP address for migration.
               The default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] vm_template_id: Specifies the template used to create the target server automatically.
               This parameter and `target_server_id` are alternative. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an SMS migration task resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        source_server = config.require_object("sourceServer")
        template_id = config.require_object("templateId")
        migration = huaweicloud.sms.Task("migration",
            type="MIGRATE_FILE",
            os_type="LINUX",
            source_server_id=source_server,
            vm_template_id=template_id,
            action="start")
        ```

        ## Import

        SMS migration tasks can be imported by `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Sms/task:Task demo 6402c49b-7d9a-413e-8b5f-a7307f7d5679
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response. The missing attributes include`use_public_ip`, `syncing` and `action`. It is generally recommended running `terraform plan` after importing a migration task. You can then decide if changes should be applied to the task, or the resource definition should be updated to align with the task. Also you can ignore changes as below. resource "huaweicloud_sms_task" "demo" {

         ...

         lifecycle {

         ignore_changes = [

         use_public_ip, syncing, action,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param TaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 migration_ip: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 source_server_id: Optional[pulumi.Input[str]] = None,
                 start_target_server: Optional[pulumi.Input[bool]] = None,
                 syncing: Optional[pulumi.Input[bool]] = None,
                 target_server_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TaskTargetServerDiskArgs']]]]] = None,
                 target_server_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 use_public_ip: Optional[pulumi.Input[bool]] = None,
                 vm_template_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TaskArgs.__new__(TaskArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["migration_ip"] = migration_ip
            if os_type is None and not opts.urn:
                raise TypeError("Missing required property 'os_type'")
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            if source_server_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_server_id'")
            __props__.__dict__["source_server_id"] = source_server_id
            __props__.__dict__["start_target_server"] = start_target_server
            __props__.__dict__["syncing"] = syncing
            __props__.__dict__["target_server_disks"] = target_server_disks
            __props__.__dict__["target_server_id"] = target_server_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["use_public_ip"] = use_public_ip
            __props__.__dict__["vm_template_id"] = vm_template_id
            __props__.__dict__["enterprise_project_id"] = None
            __props__.__dict__["migrate_speed"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["target_server_name"] = None
        super(Task, __self__).__init__(
            'huaweicloud:Sms/task:Task',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            migrate_speed: Optional[pulumi.Input[float]] = None,
            migration_ip: Optional[pulumi.Input[str]] = None,
            os_type: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            source_server_id: Optional[pulumi.Input[str]] = None,
            start_target_server: Optional[pulumi.Input[bool]] = None,
            state: Optional[pulumi.Input[str]] = None,
            syncing: Optional[pulumi.Input[bool]] = None,
            target_server_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TaskTargetServerDiskArgs']]]]] = None,
            target_server_id: Optional[pulumi.Input[str]] = None,
            target_server_name: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            use_public_ip: Optional[pulumi.Input[bool]] = None,
            vm_template_id: Optional[pulumi.Input[str]] = None) -> 'Task':
        """
        Get an existing Task resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: Specifies the operation after the task is created.
               The value can be **start**, **stop** and **restart**.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the target server.
        :param pulumi.Input[float] migrate_speed: The migration rate, in MB/s.
        :param pulumi.Input[str] migration_ip: Specifies the IP address of the target server.
               Use the EIP of the target server if the migration network type is Internet.
               Use the private IP address of the target server if the migration network type is Direct Connect or VPN.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] os_type: Specifies the OS type of the source server. The value can be **WINDOWS** and **LINUX**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] project_id: Specifies the project ID where the target server is located.
               If omitted, the default project in the region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region where the target server is located.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] source_server_id: Specifies the ID of the source server.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] start_target_server: Specifies whether to start the target server after the migration.
               The default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] state: The status of the migration task.
        :param pulumi.Input[bool] syncing: - Specifies whether to perform a continuous synchronization after the first replication.
               The default value is `false`. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TaskTargetServerDiskArgs']]]] target_server_disks: Specifies the disk configurations of the target server.
               If omitted, it will be obtained from the source server. The object
               is documented below. Changing this parameter will create a new resource.
        :param pulumi.Input[str] target_server_id: Specifies the existing server ID as the target server.
               This parameter and `vm_template_id` are alternative. Changing this parameter will create a new resource.
        :param pulumi.Input[str] target_server_name: The name of the target server.
        :param pulumi.Input[str] type: Specifies the type of the migration task. Available values are
               **MIGRATE_FILE**(file-level migration) and **MIGRATE_BLOCK**(block-level migration).
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] use_public_ip: Specifies whether to use a public IP address for migration.
               The default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] vm_template_id: Specifies the template used to create the target server automatically.
               This parameter and `target_server_id` are alternative. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TaskState.__new__(_TaskState)

        __props__.__dict__["action"] = action
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["migrate_speed"] = migrate_speed
        __props__.__dict__["migration_ip"] = migration_ip
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["source_server_id"] = source_server_id
        __props__.__dict__["start_target_server"] = start_target_server
        __props__.__dict__["state"] = state
        __props__.__dict__["syncing"] = syncing
        __props__.__dict__["target_server_disks"] = target_server_disks
        __props__.__dict__["target_server_id"] = target_server_id
        __props__.__dict__["target_server_name"] = target_server_name
        __props__.__dict__["type"] = type
        __props__.__dict__["use_public_ip"] = use_public_ip
        __props__.__dict__["vm_template_id"] = vm_template_id
        return Task(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the operation after the task is created.
        The value can be **start**, **stop** and **restart**.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        The enterprise project id of the target server.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="migrateSpeed")
    def migrate_speed(self) -> pulumi.Output[float]:
        """
        The migration rate, in MB/s.
        """
        return pulumi.get(self, "migrate_speed")

    @property
    @pulumi.getter(name="migrationIp")
    def migration_ip(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the IP address of the target server.
        Use the EIP of the target server if the migration network type is Internet.
        Use the private IP address of the target server if the migration network type is Direct Connect or VPN.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "migration_ip")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[str]:
        """
        Specifies the OS type of the source server. The value can be **WINDOWS** and **LINUX**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        Specifies the project ID where the target server is located.
        If omitted, the default project in the region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region where the target server is located.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sourceServerId")
    def source_server_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the source server.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_server_id")

    @property
    @pulumi.getter(name="startTargetServer")
    def start_target_server(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to start the target server after the migration.
        The default value is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "start_target_server")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The status of the migration task.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def syncing(self) -> pulumi.Output[Optional[bool]]:
        """
        - Specifies whether to perform a continuous synchronization after the first replication.
        The default value is `false`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "syncing")

    @property
    @pulumi.getter(name="targetServerDisks")
    def target_server_disks(self) -> pulumi.Output[Sequence['outputs.TaskTargetServerDisk']]:
        """
        Specifies the disk configurations of the target server.
        If omitted, it will be obtained from the source server. The object
        is documented below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "target_server_disks")

    @property
    @pulumi.getter(name="targetServerId")
    def target_server_id(self) -> pulumi.Output[str]:
        """
        Specifies the existing server ID as the target server.
        This parameter and `vm_template_id` are alternative. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "target_server_id")

    @property
    @pulumi.getter(name="targetServerName")
    def target_server_name(self) -> pulumi.Output[str]:
        """
        The name of the target server.
        """
        return pulumi.get(self, "target_server_name")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the type of the migration task. Available values are
        **MIGRATE_FILE**(file-level migration) and **MIGRATE_BLOCK**(block-level migration).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="usePublicIp")
    def use_public_ip(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to use a public IP address for migration.
        The default value is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "use_public_ip")

    @property
    @pulumi.getter(name="vmTemplateId")
    def vm_template_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the template used to create the target server automatically.
        This parameter and `target_server_id` are alternative. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vm_template_id")

