# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'TaskTargetServerDisk',
    'TaskTargetServerDiskPhysicalVolume',
    'GetSourceServersServerResult',
    'GetSourceServersServerDiskResult',
]

@pulumi.output_type
class TaskTargetServerDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceType":
            suggest = "device_type"
        elif key == "diskId":
            suggest = "disk_id"
        elif key == "physicalVolumes":
            suggest = "physical_volumes"
        elif key == "usedSize":
            suggest = "used_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskTargetServerDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskTargetServerDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskTargetServerDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_type: str,
                 name: str,
                 size: int,
                 disk_id: Optional[str] = None,
                 physical_volumes: Optional[Sequence['outputs.TaskTargetServerDiskPhysicalVolume']] = None,
                 used_size: Optional[int] = None):
        """
        :param str device_type: Specifies the partition type. The value can be **NORMAL** and **OS**.
               Changing this parameter will create a new resource.
        :param str name: Specifies the volume name. In Windows, it indicates the drive letter,
               and in Linux, it indicates the device ID, e.g. "/dev/sda1".
               Changing this parameter will create a new resource.
        :param int size: Specifies the volume size in MB. Changing this parameter will create a new resource.
        :param str disk_id: Specifies the disk index, e.g. "0".
               Changing this parameter will create a new resource.
        :param Sequence['TaskTargetServerDiskPhysicalVolumeArgs'] physical_volumes: Specifies an array of physical volume informations.
               The object is documented below. Changing this parameter will create a new resource.
        :param int used_size: Specifies the used space in MB.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "device_type", device_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if physical_volumes is not None:
            pulumi.set(__self__, "physical_volumes", physical_volumes)
        if used_size is not None:
            pulumi.set(__self__, "used_size", used_size)

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> str:
        """
        Specifies the partition type. The value can be **NORMAL** and **OS**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "device_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the volume name. In Windows, it indicates the drive letter,
        and in Linux, it indicates the device ID, e.g. "/dev/sda1".
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Specifies the volume size in MB. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[str]:
        """
        Specifies the disk index, e.g. "0".
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="physicalVolumes")
    def physical_volumes(self) -> Optional[Sequence['outputs.TaskTargetServerDiskPhysicalVolume']]:
        """
        Specifies an array of physical volume informations.
        The object is documented below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "physical_volumes")

    @property
    @pulumi.getter(name="usedSize")
    def used_size(self) -> Optional[int]:
        """
        Specifies the used space in MB.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "used_size")


@pulumi.output_type
class TaskTargetServerDiskPhysicalVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceType":
            suggest = "device_type"
        elif key == "fileSystem":
            suggest = "file_system"
        elif key == "mountPoint":
            suggest = "mount_point"
        elif key == "usedSize":
            suggest = "used_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskTargetServerDiskPhysicalVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskTargetServerDiskPhysicalVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskTargetServerDiskPhysicalVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_type: str,
                 file_system: str,
                 index: int,
                 mount_point: str,
                 name: str,
                 size: int,
                 used_size: Optional[int] = None,
                 uuid: Optional[str] = None):
        """
        :param str device_type: Specifies the partition type. The value can be **NORMAL** and **OS**.
               Changing this parameter will create a new resource.
        :param str file_system: Specifies the file system type, e.g. "ext4".
               Changing this parameter will create a new resource.
        :param int index: Specifies the serial number of the volume.
               Changing this parameter will create a new resource.
        :param str mount_point: Specifies the mount point, e.g. "/".
               Changing this parameter will create a new resource.
        :param str name: Specifies the volume name. In Windows, it indicates the drive letter,
               and in Linux, it indicates the device ID, e.g. "/dev/sda1".
               Changing this parameter will create a new resource.
        :param int size: Specifies the volume size in MB. Changing this parameter will create a new resource.
        :param int used_size: Specifies the used space in MB.
               Changing this parameter will create a new resource.
        :param str uuid: Specifies the GUID of the volume.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "device_type", device_type)
        pulumi.set(__self__, "file_system", file_system)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        if used_size is not None:
            pulumi.set(__self__, "used_size", used_size)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> str:
        """
        Specifies the partition type. The value can be **NORMAL** and **OS**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "device_type")

    @property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> str:
        """
        Specifies the file system type, e.g. "ext4".
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "file_system")

    @property
    @pulumi.getter
    def index(self) -> int:
        """
        Specifies the serial number of the volume.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        Specifies the mount point, e.g. "/".
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the volume name. In Windows, it indicates the drive letter,
        and in Linux, it indicates the device ID, e.g. "/dev/sda1".
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Specifies the volume size in MB. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="usedSize")
    def used_size(self) -> Optional[int]:
        """
        Specifies the used space in MB.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "used_size")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[str]:
        """
        Specifies the GUID of the volume.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class GetSourceServersServerResult(dict):
    def __init__(__self__, *,
                 agent_version: str,
                 connected: bool,
                 disks: Sequence['outputs.GetSourceServersServerDiskResult'],
                 id: str,
                 ip: str,
                 memory: int,
                 name: str,
                 os_type: str,
                 os_version: str,
                 registered_time: str,
                 state: str,
                 vcpus: int):
        """
        :param str agent_version: The version of Agent installed on the source server.
        :param bool connected: Whether the source server is properly connected to SMS.
        :param Sequence['GetSourceServersServerDiskArgs'] disks: The disk information of the source server. Structure is documented below.
        :param str id: Specifies the ID of the source server.
        :param str ip: Specifies the IP address of the source server.
        :param int memory: The memory size in MB.
        :param str name: Specifies the name of the source server.
        :param str os_type: The OS type of the source server. The value can be **WINDOWS** and **LINUX**.
        :param str os_version: The OS version of the source server, for example, UBUNTU_20_4_64BIT.
        :param str registered_time: The UTC time when the source server is registered.
        :param int vcpus: The vcpus count of the source server.
        """
        pulumi.set(__self__, "agent_version", agent_version)
        pulumi.set(__self__, "connected", connected)
        pulumi.set(__self__, "disks", disks)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "os_version", os_version)
        pulumi.set(__self__, "registered_time", registered_time)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "vcpus", vcpus)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> str:
        """
        The version of Agent installed on the source server.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter
    def connected(self) -> bool:
        """
        Whether the source server is properly connected to SMS.
        """
        return pulumi.get(self, "connected")

    @property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.GetSourceServersServerDiskResult']:
        """
        The disk information of the source server. Structure is documented below.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Specifies the ID of the source server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        Specifies the IP address of the source server.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        The memory size in MB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the source server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The OS type of the source server. The value can be **WINDOWS** and **LINUX**.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        """
        The OS version of the source server, for example, UBUNTU_20_4_64BIT.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="registeredTime")
    def registered_time(self) -> str:
        """
        The UTC time when the source server is registered.
        """
        return pulumi.get(self, "registered_time")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def vcpus(self) -> int:
        """
        The vcpus count of the source server.
        """
        return pulumi.get(self, "vcpus")


@pulumi.output_type
class GetSourceServersServerDiskResult(dict):
    def __init__(__self__, *,
                 device_type: str,
                 name: str,
                 size: int):
        """
        :param str device_type: The disk type. The value can be **BOOT**, **OS** and **NORMAL**.
        :param str name: Specifies the name of the source server.
        :param int size: The disk size in MB.
        """
        pulumi.set(__self__, "device_type", device_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> str:
        """
        The disk type. The value can be **BOOT**, **OS** and **NORMAL**.
        """
        return pulumi.get(self, "device_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the source server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The disk size in MB.
        """
        return pulumi.get(self, "size")


