# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TopicArgs', 'Topic']

@pulumi.input_type
class TopicArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Topic resource.
        :param pulumi.Input[str] display_name: Specifies the topic display name, which is presented as the name of the email
               sender in an email message. The name can contains of 0 to 192 characters.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the SMN Topic, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the name of the topic to be created. The name can contains of 1 to 255
               characters and must start with a letter or digit, and can only contain letters, digits, underscores (_), and hyphens (-).
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the SMN topic resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of the SMN topic, key/value pair format.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the topic display name, which is presented as the name of the email
        sender in an email message. The name can contains of 0 to 192 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the SMN Topic, Value 0
        indicates the default enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the topic to be created. The name can contains of 1 to 255
        characters and must start with a letter or digit, and can only contain letters, digits, underscores (_), and hyphens (-).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the SMN topic resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags of the SMN topic, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _TopicState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 push_policy: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 topic_urn: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Topic resources.
        :param pulumi.Input[str] create_time: Time when the topic was created.
        :param pulumi.Input[str] display_name: Specifies the topic display name, which is presented as the name of the email
               sender in an email message. The name can contains of 0 to 192 characters.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the SMN Topic, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the name of the topic to be created. The name can contains of 1 to 255
               characters and must start with a letter or digit, and can only contain letters, digits, underscores (_), and hyphens (-).
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] push_policy: Message pushing policy. 0 indicates that the message sending fails and the message is cached in the
               queue. 1 indicates that the failed message is discarded.
        :param pulumi.Input[str] region: The region in which to create the SMN topic resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of the SMN topic, key/value pair format.
        :param pulumi.Input[str] topic_urn: Resource identifier of a topic, which is unique.
        :param pulumi.Input[str] update_time: Time when the topic was updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if push_policy is not None:
            pulumi.set(__self__, "push_policy", push_policy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if topic_urn is not None:
            pulumi.set(__self__, "topic_urn", topic_urn)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the topic was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the topic display name, which is presented as the name of the email
        sender in an email message. The name can contains of 0 to 192 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the SMN Topic, Value 0
        indicates the default enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the topic to be created. The name can contains of 1 to 255
        characters and must start with a letter or digit, and can only contain letters, digits, underscores (_), and hyphens (-).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pushPolicy")
    def push_policy(self) -> Optional[pulumi.Input[int]]:
        """
        Message pushing policy. 0 indicates that the message sending fails and the message is cached in the
        queue. 1 indicates that the failed message is discarded.
        """
        return pulumi.get(self, "push_policy")

    @push_policy.setter
    def push_policy(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "push_policy", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the SMN topic resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the tags of the SMN topic, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> Optional[pulumi.Input[str]]:
        """
        Resource identifier of a topic, which is unique.
        """
        return pulumi.get(self, "topic_urn")

    @topic_urn.setter
    def topic_urn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_urn", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the topic was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class Topic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages an SMN Topic resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        topic1 = huaweicloud.smn.Topic("topic1", display_name="The display name of topic_1")
        ```

        ## Import

        SMN topic can be imported using the `id` (topic urn), e.g.

        ```sh
         $ pulumi import huaweicloud:Smn/topic:Topic topic_1 urn:smn:cn-north-4:0970dd7a1300f5672ff2c003c60ae115:topic_1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: Specifies the topic display name, which is presented as the name of the email
               sender in an email message. The name can contains of 0 to 192 characters.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the SMN Topic, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the name of the topic to be created. The name can contains of 1 to 255
               characters and must start with a letter or digit, and can only contain letters, digits, underscores (_), and hyphens (-).
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the SMN topic resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of the SMN topic, key/value pair format.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TopicArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an SMN Topic resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        topic1 = huaweicloud.smn.Topic("topic1", display_name="The display name of topic_1")
        ```

        ## Import

        SMN topic can be imported using the `id` (topic urn), e.g.

        ```sh
         $ pulumi import huaweicloud:Smn/topic:Topic topic_1 urn:smn:cn-north-4:0970dd7a1300f5672ff2c003c60ae115:topic_1
        ```

        :param str resource_name: The name of the resource.
        :param TopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TopicArgs.__new__(TopicArgs)

            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["push_policy"] = None
            __props__.__dict__["topic_urn"] = None
            __props__.__dict__["update_time"] = None
        super(Topic, __self__).__init__(
            'huaweicloud:Smn/topic:Topic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            push_policy: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            topic_urn: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Topic':
        """
        Get an existing Topic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: Time when the topic was created.
        :param pulumi.Input[str] display_name: Specifies the topic display name, which is presented as the name of the email
               sender in an email message. The name can contains of 0 to 192 characters.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the SMN Topic, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the name of the topic to be created. The name can contains of 1 to 255
               characters and must start with a letter or digit, and can only contain letters, digits, underscores (_), and hyphens (-).
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] push_policy: Message pushing policy. 0 indicates that the message sending fails and the message is cached in the
               queue. 1 indicates that the failed message is discarded.
        :param pulumi.Input[str] region: The region in which to create the SMN topic resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the tags of the SMN topic, key/value pair format.
        :param pulumi.Input[str] topic_urn: Resource identifier of a topic, which is unique.
        :param pulumi.Input[str] update_time: Time when the topic was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TopicState.__new__(_TopicState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["name"] = name
        __props__.__dict__["push_policy"] = push_policy
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["topic_urn"] = topic_urn
        __props__.__dict__["update_time"] = update_time
        return Topic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when the topic was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the topic display name, which is presented as the name of the email
        sender in an email message. The name can contains of 0 to 192 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise project id of the SMN Topic, Value 0
        indicates the default enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the topic to be created. The name can contains of 1 to 255
        characters and must start with a letter or digit, and can only contain letters, digits, underscores (_), and hyphens (-).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pushPolicy")
    def push_policy(self) -> pulumi.Output[int]:
        """
        Message pushing policy. 0 indicates that the message sending fails and the message is cached in the
        queue. 1 indicates that the failed message is discarded.
        """
        return pulumi.get(self, "push_policy")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the SMN topic resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the tags of the SMN topic, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> pulumi.Output[str]:
        """
        Resource identifier of a topic, which is unique.
        """
        return pulumi.get(self, "topic_urn")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Time when the topic was updated.
        """
        return pulumi.get(self, "update_time")

