# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TurboArgs', 'Turbo']

@pulumi.input_type
class TurboArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[str],
                 security_group_id: pulumi.Input[str],
                 size: pulumi.Input[int],
                 subnet_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 crypt_key_id: Optional[pulumi.Input[str]] = None,
                 enhanced: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 share_proto: Optional[pulumi.Input[str]] = None,
                 share_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Turbo resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone where the file system is located.
               Changing this will create a new resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Changing this will create a new
               resource.
        :param pulumi.Input[int] size: Specifies the capacity of a common file system, in GB. The value ranges from 500 to 32768,
               and must be large than 10240 for an enhanced file system.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of the subnet. Changing this will create a new
               resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this will create a new resource.
        :param pulumi.Input[str] crypt_key_id: Specifies the ID of a KMS key to encrypt the file system. Changing this
               will create a new resource.
        :param pulumi.Input[bool] enhanced: Specifies whether the file system is enhanced or not. Changing this will
               create a new resource.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the file system. Changing this
               will create a new resource.
        :param pulumi.Input[str] name: Specifies the name of an SFS Turbo file system. The value contains 4 to 64
               characters and must start with a letter. Changing this will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the SFS Turbo resource. If omitted, the
               provider-level region will be used. Changing this creates a new SFS Turbo resource.
        :param pulumi.Input[str] share_proto: Specifies the protocol for sharing file systems. The valid value is NFS.
               Changing this will create a new resource.
        :param pulumi.Input[str] share_type: Specifies the file system type. The valid values are STANDARD and
               PERFORMANCE Changing this will create a new resource.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if crypt_key_id is not None:
            pulumi.set(__self__, "crypt_key_id", crypt_key_id)
        if enhanced is not None:
            pulumi.set(__self__, "enhanced", enhanced)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if share_proto is not None:
            pulumi.set(__self__, "share_proto", share_proto)
        if share_type is not None:
            pulumi.set(__self__, "share_type", share_type)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[str]:
        """
        Specifies the availability zone where the file system is located.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        Specifies the security group ID. Changing this will create a new
        resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Specifies the capacity of a common file system, in GB. The value ranges from 500 to 32768,
        and must be large than 10240 for an enhanced file system.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Specifies the network ID of the subnet. Changing this will create a new
        resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the VPC ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="cryptKeyId")
    def crypt_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of a KMS key to encrypt the file system. Changing this
        will create a new resource.
        """
        return pulumi.get(self, "crypt_key_id")

    @crypt_key_id.setter
    def crypt_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crypt_key_id", value)

    @property
    @pulumi.getter
    def enhanced(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the file system is enhanced or not. Changing this will
        create a new resource.
        """
        return pulumi.get(self, "enhanced")

    @enhanced.setter
    def enhanced(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enhanced", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the file system. Changing this
        will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of an SFS Turbo file system. The value contains 4 to 64
        characters and must start with a letter. Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the SFS Turbo resource. If omitted, the
        provider-level region will be used. Changing this creates a new SFS Turbo resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="shareProto")
    def share_proto(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the protocol for sharing file systems. The valid value is NFS.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "share_proto")

    @share_proto.setter
    def share_proto(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "share_proto", value)

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the file system type. The valid values are STANDARD and
        PERFORMANCE Changing this will create a new resource.
        """
        return pulumi.get(self, "share_type")

    @share_type.setter
    def share_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "share_type", value)


@pulumi.input_type
class _TurboState:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 available_capacity: Optional[pulumi.Input[str]] = None,
                 crypt_key_id: Optional[pulumi.Input[str]] = None,
                 enhanced: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 export_location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 share_proto: Optional[pulumi.Input[str]] = None,
                 share_type: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Turbo resources.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone where the file system is located.
               Changing this will create a new resource.
        :param pulumi.Input[str] available_capacity: The available capacity of the SFS Turbo file system in the unit of GB.
        :param pulumi.Input[str] crypt_key_id: Specifies the ID of a KMS key to encrypt the file system. Changing this
               will create a new resource.
        :param pulumi.Input[bool] enhanced: Specifies whether the file system is enhanced or not. Changing this will
               create a new resource.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the file system. Changing this
               will create a new resource.
        :param pulumi.Input[str] export_location: Tthe mount point of the SFS Turbo file system.
        :param pulumi.Input[str] name: Specifies the name of an SFS Turbo file system. The value contains 4 to 64
               characters and must start with a letter. Changing this will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the SFS Turbo resource. If omitted, the
               provider-level region will be used. Changing this creates a new SFS Turbo resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Changing this will create a new
               resource.
        :param pulumi.Input[str] share_proto: Specifies the protocol for sharing file systems. The valid value is NFS.
               Changing this will create a new resource.
        :param pulumi.Input[str] share_type: Specifies the file system type. The valid values are STANDARD and
               PERFORMANCE Changing this will create a new resource.
        :param pulumi.Input[int] size: Specifies the capacity of a common file system, in GB. The value ranges from 500 to 32768,
               and must be large than 10240 for an enhanced file system.
        :param pulumi.Input[str] status: The status of the SFS Turbo file system.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of the subnet. Changing this will create a new
               resource.
        :param pulumi.Input[str] version: The version ID of the SFS Turbo file system.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this will create a new resource.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if available_capacity is not None:
            pulumi.set(__self__, "available_capacity", available_capacity)
        if crypt_key_id is not None:
            pulumi.set(__self__, "crypt_key_id", crypt_key_id)
        if enhanced is not None:
            pulumi.set(__self__, "enhanced", enhanced)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if export_location is not None:
            pulumi.set(__self__, "export_location", export_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if share_proto is not None:
            pulumi.set(__self__, "share_proto", share_proto)
        if share_type is not None:
            pulumi.set(__self__, "share_type", share_type)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone where the file system is located.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="availableCapacity")
    def available_capacity(self) -> Optional[pulumi.Input[str]]:
        """
        The available capacity of the SFS Turbo file system in the unit of GB.
        """
        return pulumi.get(self, "available_capacity")

    @available_capacity.setter
    def available_capacity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "available_capacity", value)

    @property
    @pulumi.getter(name="cryptKeyId")
    def crypt_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of a KMS key to encrypt the file system. Changing this
        will create a new resource.
        """
        return pulumi.get(self, "crypt_key_id")

    @crypt_key_id.setter
    def crypt_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crypt_key_id", value)

    @property
    @pulumi.getter
    def enhanced(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the file system is enhanced or not. Changing this will
        create a new resource.
        """
        return pulumi.get(self, "enhanced")

    @enhanced.setter
    def enhanced(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enhanced", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the file system. Changing this
        will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="exportLocation")
    def export_location(self) -> Optional[pulumi.Input[str]]:
        """
        Tthe mount point of the SFS Turbo file system.
        """
        return pulumi.get(self, "export_location")

    @export_location.setter
    def export_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "export_location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of an SFS Turbo file system. The value contains 4 to 64
        characters and must start with a letter. Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the SFS Turbo resource. If omitted, the
        provider-level region will be used. Changing this creates a new SFS Turbo resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security group ID. Changing this will create a new
        resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="shareProto")
    def share_proto(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the protocol for sharing file systems. The valid value is NFS.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "share_proto")

    @share_proto.setter
    def share_proto(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "share_proto", value)

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the file system type. The valid values are STANDARD and
        PERFORMANCE Changing this will create a new resource.
        """
        return pulumi.get(self, "share_type")

    @share_type.setter
    def share_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "share_type", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the capacity of a common file system, in GB. The value ranges from 500 to 32768,
        and must be large than 10240 for an enhanced file system.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the SFS Turbo file system.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the network ID of the subnet. Changing this will create a new
        resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version ID of the SFS Turbo file system.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Turbo(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 crypt_key_id: Optional[pulumi.Input[str]] = None,
                 enhanced: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 share_proto: Optional[pulumi.Input[str]] = None,
                 share_type: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an Shared File System (SFS) Turbo resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        test_az = config.require_object("testAz")
        sfs_turbo_1 = huaweicloud.sfs.Turbo("sfs-turbo-1",
            size=500,
            share_proto="NFS",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id,
            availability_zone=test_az)
        ```

        ## Import

        SFS Turbo can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Sfs/turbo:Turbo huaweicloud_sfs_turbo 1e3d5306-24c9-4316-9185-70e9787d71ab
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone where the file system is located.
               Changing this will create a new resource.
        :param pulumi.Input[str] crypt_key_id: Specifies the ID of a KMS key to encrypt the file system. Changing this
               will create a new resource.
        :param pulumi.Input[bool] enhanced: Specifies whether the file system is enhanced or not. Changing this will
               create a new resource.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the file system. Changing this
               will create a new resource.
        :param pulumi.Input[str] name: Specifies the name of an SFS Turbo file system. The value contains 4 to 64
               characters and must start with a letter. Changing this will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the SFS Turbo resource. If omitted, the
               provider-level region will be used. Changing this creates a new SFS Turbo resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Changing this will create a new
               resource.
        :param pulumi.Input[str] share_proto: Specifies the protocol for sharing file systems. The valid value is NFS.
               Changing this will create a new resource.
        :param pulumi.Input[str] share_type: Specifies the file system type. The valid values are STANDARD and
               PERFORMANCE Changing this will create a new resource.
        :param pulumi.Input[int] size: Specifies the capacity of a common file system, in GB. The value ranges from 500 to 32768,
               and must be large than 10240 for an enhanced file system.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of the subnet. Changing this will create a new
               resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TurboArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Shared File System (SFS) Turbo resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        test_az = config.require_object("testAz")
        sfs_turbo_1 = huaweicloud.sfs.Turbo("sfs-turbo-1",
            size=500,
            share_proto="NFS",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id,
            availability_zone=test_az)
        ```

        ## Import

        SFS Turbo can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Sfs/turbo:Turbo huaweicloud_sfs_turbo 1e3d5306-24c9-4316-9185-70e9787d71ab
        ```

        :param str resource_name: The name of the resource.
        :param TurboArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TurboArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 crypt_key_id: Optional[pulumi.Input[str]] = None,
                 enhanced: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 share_proto: Optional[pulumi.Input[str]] = None,
                 share_type: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TurboArgs.__new__(TurboArgs)

            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["crypt_key_id"] = crypt_key_id
            __props__.__dict__["enhanced"] = enhanced
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["share_proto"] = share_proto
            __props__.__dict__["share_type"] = share_type
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["available_capacity"] = None
            __props__.__dict__["export_location"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["version"] = None
        super(Turbo, __self__).__init__(
            'huaweicloud:Sfs/turbo:Turbo',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            available_capacity: Optional[pulumi.Input[str]] = None,
            crypt_key_id: Optional[pulumi.Input[str]] = None,
            enhanced: Optional[pulumi.Input[bool]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            export_location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            share_proto: Optional[pulumi.Input[str]] = None,
            share_type: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Turbo':
        """
        Get an existing Turbo resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone where the file system is located.
               Changing this will create a new resource.
        :param pulumi.Input[str] available_capacity: The available capacity of the SFS Turbo file system in the unit of GB.
        :param pulumi.Input[str] crypt_key_id: Specifies the ID of a KMS key to encrypt the file system. Changing this
               will create a new resource.
        :param pulumi.Input[bool] enhanced: Specifies whether the file system is enhanced or not. Changing this will
               create a new resource.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the file system. Changing this
               will create a new resource.
        :param pulumi.Input[str] export_location: Tthe mount point of the SFS Turbo file system.
        :param pulumi.Input[str] name: Specifies the name of an SFS Turbo file system. The value contains 4 to 64
               characters and must start with a letter. Changing this will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the SFS Turbo resource. If omitted, the
               provider-level region will be used. Changing this creates a new SFS Turbo resource.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID. Changing this will create a new
               resource.
        :param pulumi.Input[str] share_proto: Specifies the protocol for sharing file systems. The valid value is NFS.
               Changing this will create a new resource.
        :param pulumi.Input[str] share_type: Specifies the file system type. The valid values are STANDARD and
               PERFORMANCE Changing this will create a new resource.
        :param pulumi.Input[int] size: Specifies the capacity of a common file system, in GB. The value ranges from 500 to 32768,
               and must be large than 10240 for an enhanced file system.
        :param pulumi.Input[str] status: The status of the SFS Turbo file system.
        :param pulumi.Input[str] subnet_id: Specifies the network ID of the subnet. Changing this will create a new
               resource.
        :param pulumi.Input[str] version: The version ID of the SFS Turbo file system.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TurboState.__new__(_TurboState)

        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["available_capacity"] = available_capacity
        __props__.__dict__["crypt_key_id"] = crypt_key_id
        __props__.__dict__["enhanced"] = enhanced
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["export_location"] = export_location
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["share_proto"] = share_proto
        __props__.__dict__["share_type"] = share_type
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_id"] = vpc_id
        return Turbo(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Specifies the availability zone where the file system is located.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="availableCapacity")
    def available_capacity(self) -> pulumi.Output[str]:
        """
        The available capacity of the SFS Turbo file system in the unit of GB.
        """
        return pulumi.get(self, "available_capacity")

    @property
    @pulumi.getter(name="cryptKeyId")
    def crypt_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ID of a KMS key to encrypt the file system. Changing this
        will create a new resource.
        """
        return pulumi.get(self, "crypt_key_id")

    @property
    @pulumi.getter
    def enhanced(self) -> pulumi.Output[bool]:
        """
        Specifies whether the file system is enhanced or not. Changing this will
        create a new resource.
        """
        return pulumi.get(self, "enhanced")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        The enterprise project id of the file system. Changing this
        will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="exportLocation")
    def export_location(self) -> pulumi.Output[str]:
        """
        Tthe mount point of the SFS Turbo file system.
        """
        return pulumi.get(self, "export_location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of an SFS Turbo file system. The value contains 4 to 64
        characters and must start with a letter. Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the SFS Turbo resource. If omitted, the
        provider-level region will be used. Changing this creates a new SFS Turbo resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        Specifies the security group ID. Changing this will create a new
        resource.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="shareProto")
    def share_proto(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the protocol for sharing file systems. The valid value is NFS.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "share_proto")

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the file system type. The valid values are STANDARD and
        PERFORMANCE Changing this will create a new resource.
        """
        return pulumi.get(self, "share_type")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        Specifies the capacity of a common file system, in GB. The value ranges from 500 to 32768,
        and must be large than 10240 for an enhanced file system.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the SFS Turbo file system.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Specifies the network ID of the subnet. Changing this will create a new
        resource.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The version ID of the SFS Turbo file system.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the VPC ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

