# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTurbosResult',
    'AwaitableGetTurbosResult',
    'get_turbos',
    'get_turbos_output',
]

@pulumi.output_type
class GetTurbosResult:
    """
    A collection of values returned by getTurbos.
    """
    def __init__(__self__, enterprise_project_id=None, id=None, name=None, region=None, share_proto=None, share_type=None, size=None, turbos=None):
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if share_proto and not isinstance(share_proto, str):
            raise TypeError("Expected argument 'share_proto' to be a str")
        pulumi.set(__self__, "share_proto", share_proto)
        if share_type and not isinstance(share_type, str):
            raise TypeError("Expected argument 'share_type' to be a str")
        pulumi.set(__self__, "share_type", share_type)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if turbos and not isinstance(turbos, list):
            raise TypeError("Expected argument 'turbos' to be a list")
        pulumi.set(__self__, "turbos", turbos)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[str]:
        """
        The enterprise project ID of the SFS turbo file system.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the SFS turbo file system.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="shareProto")
    def share_proto(self) -> Optional[str]:
        """
        The protocol of the SFS turbo file system.
        """
        return pulumi.get(self, "share_proto")

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> Optional[str]:
        """
        The type of the SFS turbo file system.
        """
        return pulumi.get(self, "share_type")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        The capacity of the SFS turbo file system.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def turbos(self) -> Sequence['outputs.GetTurbosTurboResult']:
        """
        The list of the SFS turbo file systems. The object structure is documented below.
        """
        return pulumi.get(self, "turbos")


class AwaitableGetTurbosResult(GetTurbosResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTurbosResult(
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            name=self.name,
            region=self.region,
            share_proto=self.share_proto,
            share_type=self.share_type,
            size=self.size,
            turbos=self.turbos)


def get_turbos(enterprise_project_id: Optional[str] = None,
               name: Optional[str] = None,
               region: Optional[str] = None,
               share_proto: Optional[str] = None,
               share_type: Optional[str] = None,
               size: Optional[int] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTurbosResult:
    """
    Use this data source to get the list of the available SFS turbos.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    sfs_turbo_name = config.require_object("sfsTurboName")
    test = huaweicloud.Sfs.get_turbos(name=sfs_turbo_name)
    ```


    :param str enterprise_project_id: The enterprise project ID of the SFS turbo file system.
    :param str name: Specifies the name of the SFS turbo file system.
    :param str region: Specifies the region in which to obtain the SFS turbo file systems.
           If omitted, the provider-level region will be used.
    :param str share_proto: Specifies the protocol of the SFS turbo file system. The valid value is **NFS**.
    :param str share_type: Specifies the type of the SFS turbo file system.
           The valid values are **STANDARD** and **PERFORMANCE**.
    :param int size: Specifies the capacity of the SFS turbo file system, in GB.
           The value ranges from `500` to `32,768`, and must be large than `10,240` for an enhanced file system.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['shareProto'] = share_proto
    __args__['shareType'] = share_type
    __args__['size'] = size
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Sfs/getTurbos:getTurbos', __args__, opts=opts, typ=GetTurbosResult).value

    return AwaitableGetTurbosResult(
        enterprise_project_id=__ret__.enterprise_project_id,
        id=__ret__.id,
        name=__ret__.name,
        region=__ret__.region,
        share_proto=__ret__.share_proto,
        share_type=__ret__.share_type,
        size=__ret__.size,
        turbos=__ret__.turbos)


@_utilities.lift_output_func(get_turbos)
def get_turbos_output(enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                      name: Optional[pulumi.Input[Optional[str]]] = None,
                      region: Optional[pulumi.Input[Optional[str]]] = None,
                      share_proto: Optional[pulumi.Input[Optional[str]]] = None,
                      share_type: Optional[pulumi.Input[Optional[str]]] = None,
                      size: Optional[pulumi.Input[Optional[int]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTurbosResult]:
    """
    Use this data source to get the list of the available SFS turbos.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    sfs_turbo_name = config.require_object("sfsTurboName")
    test = huaweicloud.Sfs.get_turbos(name=sfs_turbo_name)
    ```


    :param str enterprise_project_id: The enterprise project ID of the SFS turbo file system.
    :param str name: Specifies the name of the SFS turbo file system.
    :param str region: Specifies the region in which to obtain the SFS turbo file systems.
           If omitted, the provider-level region will be used.
    :param str share_proto: Specifies the protocol of the SFS turbo file system. The valid value is **NFS**.
    :param str share_type: Specifies the type of the SFS turbo file system.
           The valid values are **STANDARD** and **PERFORMANCE**.
    :param int size: Specifies the capacity of the SFS turbo file system, in GB.
           The value ranges from `500` to `32,768`, and must be large than `10,240` for an enhanced file system.
    """
    ...
