# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RepoTokenAuthorizationArgs', 'RepoTokenAuthorization']

@pulumi.input_type
class RepoTokenAuthorizationArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[str],
                 token: pulumi.Input[str],
                 type: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RepoTokenAuthorization resource.
        :param pulumi.Input[str] host: Specified the host name of the repository.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] token: Specified the personal access token of the repository.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] type: Specified the repository type. The valid values are as follows:
               + **github**
               + **gitlab**
               + **gitee**
        :param pulumi.Input[str] name: Specified the authorization name. The name can contain of 4 to 63 characters,
               only letters, digits, underscores (_), hyphens (-) and dots (.) are allowed.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] region: Specified the region in which to create the repository authorization.
               If omitted, the provider-level region will be used. Changing this parameter will create a new authorization.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[str]:
        """
        Specified the host name of the repository.
        Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        Specified the personal access token of the repository.
        Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specified the repository type. The valid values are as follows:
        + **github**
        + **gitlab**
        + **gitee**
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specified the authorization name. The name can contain of 4 to 63 characters,
        only letters, digits, underscores (_), hyphens (-) and dots (.) are allowed.
        Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specified the region in which to create the repository authorization.
        If omitted, the provider-level region will be used. Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _RepoTokenAuthorizationState:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RepoTokenAuthorization resources.
        :param pulumi.Input[str] host: Specified the host name of the repository.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] name: Specified the authorization name. The name can contain of 4 to 63 characters,
               only letters, digits, underscores (_), hyphens (-) and dots (.) are allowed.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] region: Specified the region in which to create the repository authorization.
               If omitted, the provider-level region will be used. Changing this parameter will create a new authorization.
        :param pulumi.Input[str] token: Specified the personal access token of the repository.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] type: Specified the repository type. The valid values are as follows:
               + **github**
               + **gitlab**
               + **gitee**
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Specified the host name of the repository.
        Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specified the authorization name. The name can contain of 4 to 63 characters,
        only letters, digits, underscores (_), hyphens (-) and dots (.) are allowed.
        Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specified the region in which to create the repository authorization.
        If omitted, the provider-level region will be used. Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Specified the personal access token of the repository.
        Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specified the repository type. The valid values are as follows:
        + **github**
        + **gitlab**
        + **gitee**
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class RepoTokenAuthorization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource is used for the ServiceStage service to establish the authorization relationship through personal access
        token with various types of the Open-Source repository.

        ## Import

        Authorizations can be imported using their `id` or `name`, e.g.

        ```sh
         $ pulumi import huaweicloud:ServiceStage/repoTokenAuthorization:RepoTokenAuthorization test terraform-test
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] host: Specified the host name of the repository.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] name: Specified the authorization name. The name can contain of 4 to 63 characters,
               only letters, digits, underscores (_), hyphens (-) and dots (.) are allowed.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] region: Specified the region in which to create the repository authorization.
               If omitted, the provider-level region will be used. Changing this parameter will create a new authorization.
        :param pulumi.Input[str] token: Specified the personal access token of the repository.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] type: Specified the repository type. The valid values are as follows:
               + **github**
               + **gitlab**
               + **gitee**
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepoTokenAuthorizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource is used for the ServiceStage service to establish the authorization relationship through personal access
        token with various types of the Open-Source repository.

        ## Import

        Authorizations can be imported using their `id` or `name`, e.g.

        ```sh
         $ pulumi import huaweicloud:ServiceStage/repoTokenAuthorization:RepoTokenAuthorization test terraform-test
        ```

        :param str resource_name: The name of the resource.
        :param RepoTokenAuthorizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepoTokenAuthorizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepoTokenAuthorizationArgs.__new__(RepoTokenAuthorizationArgs)

            if host is None and not opts.urn:
                raise TypeError("Missing required property 'host'")
            __props__.__dict__["host"] = host
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if token is None and not opts.urn:
                raise TypeError("Missing required property 'token'")
            __props__.__dict__["token"] = token
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(RepoTokenAuthorization, __self__).__init__(
            'huaweicloud:ServiceStage/repoTokenAuthorization:RepoTokenAuthorization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            host: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            token: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'RepoTokenAuthorization':
        """
        Get an existing RepoTokenAuthorization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] host: Specified the host name of the repository.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] name: Specified the authorization name. The name can contain of 4 to 63 characters,
               only letters, digits, underscores (_), hyphens (-) and dots (.) are allowed.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] region: Specified the region in which to create the repository authorization.
               If omitted, the provider-level region will be used. Changing this parameter will create a new authorization.
        :param pulumi.Input[str] token: Specified the personal access token of the repository.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] type: Specified the repository type. The valid values are as follows:
               + **github**
               + **gitlab**
               + **gitee**
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepoTokenAuthorizationState.__new__(_RepoTokenAuthorizationState)

        __props__.__dict__["host"] = host
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["token"] = token
        __props__.__dict__["type"] = type
        return RepoTokenAuthorization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        Specified the host name of the repository.
        Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specified the authorization name. The name can contain of 4 to 63 characters,
        only letters, digits, underscores (_), hyphens (-) and dots (.) are allowed.
        Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specified the region in which to create the repository authorization.
        If omitted, the provider-level region will be used. Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        """
        Specified the personal access token of the repository.
        Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specified the repository type. The valid values are as follows:
        + **github**
        + **gitlab**
        + **gitee**
        """
        return pulumi.get(self, "type")

