# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetComponentRuntimesResult',
    'AwaitableGetComponentRuntimesResult',
    'get_component_runtimes',
    'get_component_runtimes_output',
]

@pulumi.output_type
class GetComponentRuntimesResult:
    """
    A collection of values returned by getComponentRuntimes.
    """
    def __init__(__self__, default_port=None, id=None, name=None, region=None, runtimes=None):
        if default_port and not isinstance(default_port, int):
            raise TypeError("Expected argument 'default_port' to be a int")
        pulumi.set(__self__, "default_port", default_port)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if runtimes and not isinstance(runtimes, list):
            raise TypeError("Expected argument 'runtimes' to be a list")
        pulumi.set(__self__, "runtimes", runtimes)

    @property
    @pulumi.getter(name="defaultPort")
    def default_port(self) -> Optional[int]:
        """
        The default container port.
        """
        return pulumi.get(self, "default_port")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The runtime name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def runtimes(self) -> Sequence['outputs.GetComponentRuntimesRuntimeResult']:
        """
        The list of runtime details.
        """
        return pulumi.get(self, "runtimes")


class AwaitableGetComponentRuntimesResult(GetComponentRuntimesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComponentRuntimesResult(
            default_port=self.default_port,
            id=self.id,
            name=self.name,
            region=self.region,
            runtimes=self.runtimes)


def get_component_runtimes(default_port: Optional[int] = None,
                           name: Optional[str] = None,
                           region: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComponentRuntimesResult:
    """
    Use this data source to query available runtimes within HuaweiCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.ServiceStage.get_component_runtimes()
    ```


    :param int default_port: Specifies the default container port to use for filtering.
    :param str name: Specifies the runtime name to use for filtering.
           For the runtime names corresponding to each type of component, please refer to the [document](https://support.huaweicloud.com/intl/en-us/usermanual-servicestage/servicestage_user_0411.html).
    :param str region: Specifies the region in which to obtain the component runtimes.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['defaultPort'] = default_port
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:ServiceStage/getComponentRuntimes:getComponentRuntimes', __args__, opts=opts, typ=GetComponentRuntimesResult).value

    return AwaitableGetComponentRuntimesResult(
        default_port=__ret__.default_port,
        id=__ret__.id,
        name=__ret__.name,
        region=__ret__.region,
        runtimes=__ret__.runtimes)


@_utilities.lift_output_func(get_component_runtimes)
def get_component_runtimes_output(default_port: Optional[pulumi.Input[Optional[int]]] = None,
                                  name: Optional[pulumi.Input[Optional[str]]] = None,
                                  region: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetComponentRuntimesResult]:
    """
    Use this data source to query available runtimes within HuaweiCloud.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.ServiceStage.get_component_runtimes()
    ```


    :param int default_port: Specifies the default container port to use for filtering.
    :param str name: Specifies the runtime name to use for filtering.
           For the runtime names corresponding to each type of component, please refer to the [document](https://support.huaweicloud.com/intl/en-us/usermanual-servicestage/servicestage_user_0411.html).
    :param str region: Specifies the region in which to obtain the component runtimes.
           If omitted, the provider-level region will be used.
    """
    ...
