# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'CertificateAuthentification',
    'CertificateTarget',
    'GetCertificatesCertificateResult',
]

@pulumi.output_type
class CertificateAuthentification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordName":
            suggest = "record_name"
        elif key == "recordType":
            suggest = "record_type"
        elif key == "recordValue":
            suggest = "record_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthentification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthentification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthentification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: Optional[str] = None,
                 record_name: Optional[str] = None,
                 record_type: Optional[str] = None,
                 record_value: Optional[str] = None):
        """
        :param str domain: Domain name mapping to the verification value
        :param str record_name: Name of a domain ownership verification value.
        :param str record_type: Type of the domain name verification value.
        :param str record_value: Domain verification value.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if record_name is not None:
            pulumi.set(__self__, "record_name", record_name)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if record_value is not None:
            pulumi.set(__self__, "record_value", record_value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        Domain name mapping to the verification value
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="recordName")
    def record_name(self) -> Optional[str]:
        """
        Name of a domain ownership verification value.
        """
        return pulumi.get(self, "record_name")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[str]:
        """
        Type of the domain name verification value.
        """
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter(name="recordValue")
    def record_value(self) -> Optional[str]:
        """
        Domain verification value.
        """
        return pulumi.get(self, "record_value")


@pulumi.output_type
class CertificateTarget(dict):
    def __init__(__self__, *,
                 service: str,
                 projects: Optional[Sequence[str]] = None):
        """
        :param str service: Service to which the certificate is pushed. The options include `CDN`,`WAF`
               and `Enhance_ELB`.
        :param Sequence[str] projects: The project where the service you want to push a certificate to. The same certificate
               can be pushed repeatedly to the same WAF or ELB service in the same `project`, but the CDN service can only be pushed
               once.
        """
        pulumi.set(__self__, "service", service)
        if projects is not None:
            pulumi.set(__self__, "projects", projects)

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Service to which the certificate is pushed. The options include `CDN`,`WAF`
        and `Enhance_ELB`.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def projects(self) -> Optional[Sequence[str]]:
        """
        The project where the service you want to push a certificate to. The same certificate
        can be pushed repeatedly to the same WAF or ELB service in the same `project`, but the CDN service can only be pushed
        once.
        """
        return pulumi.get(self, "projects")


@pulumi.output_type
class GetCertificatesCertificateResult(dict):
    def __init__(__self__, *,
                 brand: str,
                 deploy_support: bool,
                 description: str,
                 domain: str,
                 domain_count: int,
                 domain_type: str,
                 enterprise_project_id: str,
                 expire_time: str,
                 id: str,
                 name: str,
                 sans: str,
                 signature_algorithm: str,
                 status: str,
                 type: str,
                 validity_period: int,
                 wildcard_count: int):
        """
        :param str brand: Certificate authority.  
               The value can be: **GLOBALSIGN**, **SYMANTEC**, **GEOTRUST**, **CFCA**.
        :param bool deploy_support: Whether to support deployment.
        :param str description: Certificate description.
        :param str domain: Domain name associated with the certificate.
        :param int domain_count: Number of domain names that can be associated with the certificate.
        :param str domain_type: Domain name type.  
               The options are as follows:
               - SINGLE_DOMAIN: Single domain names
               - WILDCARD: Wildcard domain names
               - MULTI_DOMAIN: Multiple domain names
        :param str enterprise_project_id: The enterprise project id of the project.
        :param str expire_time: Certificate expiration time.
        :param str id: Certificate ID.
        :param str name: Certificate name.
        :param str sans: Additional domain name associated with the certificate.
        :param str signature_algorithm: Signature algorithm.
        :param str status: Certificate status.  
               The options are as follows:
               - ALL: All certificate status.
               - PAID: The certificate has been paid and needs to be applied for from the CA.
               - ISSUED: The certificate has been issued.
               - CHECKING: The certificate application is being reviewed.
               - CANCELCHECKING: The certificate application cancellation is being reviewed.
               - UNPASSED: The certificate application fails.
               - EXPIRED: The certificate has expired.
               - REVOKING: The certificate revocation application is being reviewed.
               - REVOKED: The certificate has been revoked.
               - UPLOAD: The certificate is being managed.
               - CHECKING_ORG: The organization verification is to be completed.
               - ISSUING: The certificate is to be issued.
               - SUPPLEMENTCHECKING: Additional domain names to be added for a multi-domain certificate are being reviewed.
        :param str type: Certificate type.  
               The value can be: **DV_SSL_CERT**, **DV_SSL_CERT_BASIC**, **EV_SSL_CERT**, **EV_SSL_CERT_PRO**, **OV_SSL_CERT**, **OV_SSL_CERT_PRO**.
        :param int validity_period: Certificate validity period, in months.
        :param int wildcard_count: Number of wildcard domain names that can be associated with the certificate.
        """
        pulumi.set(__self__, "brand", brand)
        pulumi.set(__self__, "deploy_support", deploy_support)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "domain_count", domain_count)
        pulumi.set(__self__, "domain_type", domain_type)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sans", sans)
        pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "validity_period", validity_period)
        pulumi.set(__self__, "wildcard_count", wildcard_count)

    @property
    @pulumi.getter
    def brand(self) -> str:
        """
        Certificate authority.  
        The value can be: **GLOBALSIGN**, **SYMANTEC**, **GEOTRUST**, **CFCA**.
        """
        return pulumi.get(self, "brand")

    @property
    @pulumi.getter(name="deploySupport")
    def deploy_support(self) -> bool:
        """
        Whether to support deployment.
        """
        return pulumi.get(self, "deploy_support")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Certificate description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        Domain name associated with the certificate.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainCount")
    def domain_count(self) -> int:
        """
        Number of domain names that can be associated with the certificate.
        """
        return pulumi.get(self, "domain_count")

    @property
    @pulumi.getter(name="domainType")
    def domain_type(self) -> str:
        """
        Domain name type.  
        The options are as follows:
        - SINGLE_DOMAIN: Single domain names
        - WILDCARD: Wildcard domain names
        - MULTI_DOMAIN: Multiple domain names
        """
        return pulumi.get(self, "domain_type")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        """
        The enterprise project id of the project.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        Certificate expiration time.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Certificate ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Certificate name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def sans(self) -> str:
        """
        Additional domain name associated with the certificate.
        """
        return pulumi.get(self, "sans")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> str:
        """
        Signature algorithm.
        """
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Certificate status.  
        The options are as follows:
        - ALL: All certificate status.
        - PAID: The certificate has been paid and needs to be applied for from the CA.
        - ISSUED: The certificate has been issued.
        - CHECKING: The certificate application is being reviewed.
        - CANCELCHECKING: The certificate application cancellation is being reviewed.
        - UNPASSED: The certificate application fails.
        - EXPIRED: The certificate has expired.
        - REVOKING: The certificate revocation application is being reviewed.
        - REVOKED: The certificate has been revoked.
        - UPLOAD: The certificate is being managed.
        - CHECKING_ORG: The organization verification is to be completed.
        - ISSUING: The certificate is to be issued.
        - SUPPLEMENTCHECKING: Additional domain names to be added for a multi-domain certificate are being reviewed.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Certificate type.  
        The value can be: **DV_SSL_CERT**, **DV_SSL_CERT_BASIC**, **EV_SSL_CERT**, **EV_SSL_CERT_PRO**, **OV_SSL_CERT**, **OV_SSL_CERT_PRO**.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="validityPeriod")
    def validity_period(self) -> int:
        """
        Certificate validity period, in months.
        """
        return pulumi.get(self, "validity_period")

    @property
    @pulumi.getter(name="wildcardCount")
    def wildcard_count(self) -> int:
        """
        Number of wildcard domain names that can be associated with the certificate.
        """
        return pulumi.get(self, "wildcard_count")


