# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BucketCorsRule',
    'BucketLifecycleRule',
    'BucketLifecycleRuleExpiration',
    'BucketLifecycleRuleNoncurrentVersionExpiration',
    'BucketLifecycleRuleNoncurrentVersionTransition',
    'BucketLifecycleRuleTransition',
    'BucketLogging',
    'BucketWebsite',
    'GetBucketsBucketResult',
]

@pulumi.output_type
class BucketCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 allowed_headers: Optional[Sequence[str]] = None,
                 expose_headers: Optional[Sequence[str]] = None,
                 max_age_seconds: Optional[int] = None):
        """
        :param Sequence[str] allowed_methods: Specifies the acceptable operation type of buckets and objects. The methods
               include `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        :param Sequence[str] allowed_origins: Requests from this origin can access the bucket. Multiple matching rules are
               allowed. One rule occupies one line, and allows one wildcard character (*) at most.
        :param Sequence[str] allowed_headers: Specifies the allowed header of cross-origin requests. Only CORS requests
               matching the allowed header are valid.
        :param Sequence[str] expose_headers: Specifies the exposed header in CORS responses, providing additional information
               for clients.
        :param int max_age_seconds: Specifies the duration that your browser can cache CORS responses, expressed in
               seconds. The default value is 100.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        """
        Specifies the acceptable operation type of buckets and objects. The methods
        include `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        """
        Requests from this origin can access the bucket. Multiple matching rules are
        allowed. One rule occupies one line, and allows one wildcard character (*) at most.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[str]]:
        """
        Specifies the allowed header of cross-origin requests. Only CORS requests
        matching the allowed header are valid.
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        Specifies the exposed header in CORS responses, providing additional information
        for clients.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[int]:
        """
        Specifies the duration that your browser can cache CORS responses, expressed in
        seconds. The default value is 100.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class BucketLifecycleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "noncurrentVersionExpirations":
            suggest = "noncurrent_version_expirations"
        elif key == "noncurrentVersionTransitions":
            suggest = "noncurrent_version_transitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 name: str,
                 expirations: Optional[Sequence['outputs.BucketLifecycleRuleExpiration']] = None,
                 noncurrent_version_expirations: Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionExpiration']] = None,
                 noncurrent_version_transitions: Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionTransition']] = None,
                 prefix: Optional[str] = None,
                 transitions: Optional[Sequence['outputs.BucketLifecycleRuleTransition']] = None):
        """
        :param bool enabled: Specifies lifecycle rule status.
        :param str name: Unique identifier for lifecycle rules. The Rule Name contains a maximum of 255 characters.
        :param Sequence['BucketLifecycleRuleExpirationArgs'] expirations: Specifies a period when objects that have been last updated are automatically
               deleted. (documented below).
        :param Sequence['BucketLifecycleRuleNoncurrentVersionExpirationArgs'] noncurrent_version_expirations: Specifies a period when noncurrent object versions are
               automatically deleted. (documented below).
        :param Sequence['BucketLifecycleRuleNoncurrentVersionTransitionArgs'] noncurrent_version_transitions: Specifies a period when noncurrent object versions are
               automatically transitioned to `WARM` or `COLD` storage class (documented below).
        :param str prefix: Object key prefix identifying one or more objects to which the rule applies. If omitted,
               all objects in the bucket will be managed by the lifecycle rule. The prefix cannot start or end with a slash (/),
               cannot have consecutive slashes (/), and cannot contain the following special characters: \\:*?"<>|.
        :param Sequence['BucketLifecycleRuleTransitionArgs'] transitions: Specifies a period when objects that have been last updated are automatically
               transitioned to `WARM` or `COLD` storage class (documented below).
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "name", name)
        if expirations is not None:
            pulumi.set(__self__, "expirations", expirations)
        if noncurrent_version_expirations is not None:
            pulumi.set(__self__, "noncurrent_version_expirations", noncurrent_version_expirations)
        if noncurrent_version_transitions is not None:
            pulumi.set(__self__, "noncurrent_version_transitions", noncurrent_version_transitions)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if transitions is not None:
            pulumi.set(__self__, "transitions", transitions)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Specifies lifecycle rule status.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique identifier for lifecycle rules. The Rule Name contains a maximum of 255 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def expirations(self) -> Optional[Sequence['outputs.BucketLifecycleRuleExpiration']]:
        """
        Specifies a period when objects that have been last updated are automatically
        deleted. (documented below).
        """
        return pulumi.get(self, "expirations")

    @property
    @pulumi.getter(name="noncurrentVersionExpirations")
    def noncurrent_version_expirations(self) -> Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionExpiration']]:
        """
        Specifies a period when noncurrent object versions are
        automatically deleted. (documented below).
        """
        return pulumi.get(self, "noncurrent_version_expirations")

    @property
    @pulumi.getter(name="noncurrentVersionTransitions")
    def noncurrent_version_transitions(self) -> Optional[Sequence['outputs.BucketLifecycleRuleNoncurrentVersionTransition']]:
        """
        Specifies a period when noncurrent object versions are
        automatically transitioned to `WARM` or `COLD` storage class (documented below).
        """
        return pulumi.get(self, "noncurrent_version_transitions")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object key prefix identifying one or more objects to which the rule applies. If omitted,
        all objects in the bucket will be managed by the lifecycle rule. The prefix cannot start or end with a slash (/),
        cannot have consecutive slashes (/), and cannot contain the following special characters: \\:*?"<>|.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def transitions(self) -> Optional[Sequence['outputs.BucketLifecycleRuleTransition']]:
        """
        Specifies a period when objects that have been last updated are automatically
        transitioned to `WARM` or `COLD` storage class (documented below).
        """
        return pulumi.get(self, "transitions")


@pulumi.output_type
class BucketLifecycleRuleExpiration(dict):
    def __init__(__self__, *,
                 days: int):
        """
        :param int days: Specifies the number of days when objects that have been last updated are automatically
               deleted. The expiration time must be greater than the transition times.
        """
        pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> int:
        """
        Specifies the number of days when objects that have been last updated are automatically
        deleted. The expiration time must be greater than the transition times.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleRuleNoncurrentVersionExpiration(dict):
    def __init__(__self__, *,
                 days: int):
        """
        :param int days: Specifies the number of days when noncurrent object versions are automatically deleted.
        """
        pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> int:
        """
        Specifies the number of days when noncurrent object versions are automatically deleted.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class BucketLifecycleRuleNoncurrentVersionTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleNoncurrentVersionTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleNoncurrentVersionTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleNoncurrentVersionTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days: int,
                 storage_class: str):
        """
        :param int days: Specifies the number of days when noncurrent object versions are automatically transitioned
               to the specified storage class.
        :param str storage_class: The class of storage used to store the object. Only `WARM` and `COLD` are
               supported.
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def days(self) -> int:
        """
        Specifies the number of days when noncurrent object versions are automatically transitioned
        to the specified storage class.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        The class of storage used to store the object. Only `WARM` and `COLD` are
        supported.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class BucketLifecycleRuleTransition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleTransition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleTransition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleTransition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days: int,
                 storage_class: str):
        """
        :param int days: Specifies the number of days when objects that have been last updated are automatically
               transitioned to the specified storage class.
        :param str storage_class: The class of storage used to store the object. Only `WARM` and `COLD` are
               supported.
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def days(self) -> int:
        """
        Specifies the number of days when objects that have been last updated are automatically
        transitioned to the specified storage class.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        The class of storage used to store the object. Only `WARM` and `COLD` are
        supported.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class BucketLogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetBucket":
            suggest = "target_bucket"
        elif key == "targetPrefix":
            suggest = "target_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_bucket: str,
                 target_prefix: Optional[str] = None):
        """
        :param str target_bucket: The name of the bucket that will receive the log objects. The acl policy of the
               target bucket should be `log-delivery-write`.
        :param str target_prefix: To specify a key prefix for log objects.
        """
        pulumi.set(__self__, "target_bucket", target_bucket)
        if target_prefix is not None:
            pulumi.set(__self__, "target_prefix", target_prefix)

    @property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> str:
        """
        The name of the bucket that will receive the log objects. The acl policy of the
        target bucket should be `log-delivery-write`.
        """
        return pulumi.get(self, "target_bucket")

    @property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> Optional[str]:
        """
        To specify a key prefix for log objects.
        """
        return pulumi.get(self, "target_prefix")


@pulumi.output_type
class BucketWebsite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorDocument":
            suggest = "error_document"
        elif key == "indexDocument":
            suggest = "index_document"
        elif key == "redirectAllRequestsTo":
            suggest = "redirect_all_requests_to"
        elif key == "routingRules":
            suggest = "routing_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_document: Optional[str] = None,
                 index_document: Optional[str] = None,
                 redirect_all_requests_to: Optional[str] = None,
                 routing_rules: Optional[str] = None):
        """
        :param str error_document: Specifies the error page returned when an error occurs during static website
               access. Only HTML, JPG, PNG, BMP, and WEBP files under the root directory are supported.
        :param str index_document: Unless using `redirect_all_requests_to`. Specifies the default homepage of the
               static website, only HTML web pages are supported. OBS only allows files such as `index.html` in the root directory of
               a bucket to function as the default homepage. That is to say, do not set the default homepage with a multi-level
               directory structure (for example, /page/index.html).
        :param str redirect_all_requests_to: A hostname to redirect all website requests for this bucket to.
               Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The
               default is the protocol that is used in the original request.
        :param str routing_rules: A JSON or XML format containing routing rules describing redirect behavior and
               when redirects are applied. Each rule contains a `Condition` and a `Redirect` as shown in the following table:
        """
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if redirect_all_requests_to is not None:
            pulumi.set(__self__, "redirect_all_requests_to", redirect_all_requests_to)
        if routing_rules is not None:
            pulumi.set(__self__, "routing_rules", routing_rules)

    @property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[str]:
        """
        Specifies the error page returned when an error occurs during static website
        access. Only HTML, JPG, PNG, BMP, and WEBP files under the root directory are supported.
        """
        return pulumi.get(self, "error_document")

    @property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[str]:
        """
        Unless using `redirect_all_requests_to`. Specifies the default homepage of the
        static website, only HTML web pages are supported. OBS only allows files such as `index.html` in the root directory of
        a bucket to function as the default homepage. That is to say, do not set the default homepage with a multi-level
        directory structure (for example, /page/index.html).
        """
        return pulumi.get(self, "index_document")

    @property
    @pulumi.getter(name="redirectAllRequestsTo")
    def redirect_all_requests_to(self) -> Optional[str]:
        """
        A hostname to redirect all website requests for this bucket to.
        Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The
        default is the protocol that is used in the original request.
        """
        return pulumi.get(self, "redirect_all_requests_to")

    @property
    @pulumi.getter(name="routingRules")
    def routing_rules(self) -> Optional[str]:
        """
        A JSON or XML format containing routing rules describing redirect behavior and
        when redirects are applied. Each rule contains a `Condition` and a `Redirect` as shown in the following table:
        """
        return pulumi.get(self, "routing_rules")


@pulumi.output_type
class GetBucketsBucketResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 created_at: str,
                 enterprise_project_id: str,
                 region: str,
                 storage_class: str):
        """
        :param str bucket: The name of the OBS bucket.
        :param str created_at: The date when the OBS bucket was created.
        :param str enterprise_project_id: The enterprise project id of the OBS bucket.
        :param str region: The region in which to obtain the OBS bucket.
               If omitted, the provider-level region will be used.
        :param str storage_class: The storage class of the OBS bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the OBS bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The date when the OBS bucket was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        """
        The enterprise project id of the OBS bucket.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region in which to obtain the OBS bucket.
        If omitted, the provider-level region will be used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> str:
        """
        The storage class of the OBS bucket.
        """
        return pulumi.get(self, "storage_class")


