# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['GatewayArgs', 'Gateway']

@pulumi.input_type
class GatewayArgs:
    def __init__(__self__, *,
                 spec: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 internal_network_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Gateway resource.
        :param pulumi.Input[str] spec: Specifies the nat gateway type. The value can be:
               + `1`: small type, which supports up to 10,000 SNAT connections.
               + `2`: medium type, which supports up to 50,000 SNAT connections.
               + `3`: large type, which supports up to 200,000 SNAT connections.
               + `4`: extra-large type, which supports up to 1,000,000 SNAT connections.
        :param pulumi.Input[str] description: Specifies the description of the nat gateway. The value contains 0 to 255
               characters, and angle brackets (<)
               and (>) are not allowed.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the nat gateway. The
               value can contains maximum of 36 characters which it is string "0" or in UUID format with hyphens (-). Changing this
               creates a new nat gateway.
        :param pulumi.Input[str] name: Specifies the nat gateway name. The name can contain only digits, letters, underscores (_)
               , and hyphens(-).
        :param pulumi.Input[str] region: Specifies the region in which to create the Nat gateway resource. If omitted,
               the provider-level region will be used. Changing this creates a new nat gateway.
        :param pulumi.Input[str] subnet_id: Specifies the subnet ID of the downstream interface (the next hop of the
               DVR) of the NAT gateway. Changing this creates a new nat gateway.
        :param pulumi.Input[str] vpc_id: Specifies the ID of the VPC this nat gateway belongs to. Changing this creates
               a new nat gateway.
        """
        pulumi.set(__self__, "spec", spec)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if internal_network_id is not None:
            warnings.warn("""use subnet_id instead""", DeprecationWarning)
            pulumi.log.warn("""internal_network_id is deprecated: use subnet_id instead""")
        if internal_network_id is not None:
            pulumi.set(__self__, "internal_network_id", internal_network_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if router_id is not None:
            warnings.warn("""use vpc_id instead""", DeprecationWarning)
            pulumi.log.warn("""router_id is deprecated: use vpc_id instead""")
        if router_id is not None:
            pulumi.set(__self__, "router_id", router_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input[str]:
        """
        Specifies the nat gateway type. The value can be:
        + `1`: small type, which supports up to 10,000 SNAT connections.
        + `2`: medium type, which supports up to 50,000 SNAT connections.
        + `3`: large type, which supports up to 200,000 SNAT connections.
        + `4`: extra-large type, which supports up to 1,000,000 SNAT connections.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input[str]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the nat gateway. The value contains 0 to 255
        characters, and angle brackets (<)
        and (>) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the nat gateway. The
        value can contains maximum of 36 characters which it is string "0" or in UUID format with hyphens (-). Changing this
        creates a new nat gateway.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="internalNetworkId")
    def internal_network_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "internal_network_id")

    @internal_network_id.setter
    def internal_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internal_network_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the nat gateway name. The name can contain only digits, letters, underscores (_)
        , and hyphens(-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the Nat gateway resource. If omitted,
        the provider-level region will be used. Changing this creates a new nat gateway.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "router_id")

    @router_id.setter
    def router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "router_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the subnet ID of the downstream interface (the next hop of the
        DVR) of the NAT gateway. Changing this creates a new nat gateway.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the VPC this nat gateway belongs to. Changing this creates
        a new nat gateway.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _GatewayState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 internal_network_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router_id: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Gateway resources.
        :param pulumi.Input[str] description: Specifies the description of the nat gateway. The value contains 0 to 255
               characters, and angle brackets (<)
               and (>) are not allowed.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the nat gateway. The
               value can contains maximum of 36 characters which it is string "0" or in UUID format with hyphens (-). Changing this
               creates a new nat gateway.
        :param pulumi.Input[str] name: Specifies the nat gateway name. The name can contain only digits, letters, underscores (_)
               , and hyphens(-).
        :param pulumi.Input[str] region: Specifies the region in which to create the Nat gateway resource. If omitted,
               the provider-level region will be used. Changing this creates a new nat gateway.
        :param pulumi.Input[str] spec: Specifies the nat gateway type. The value can be:
               + `1`: small type, which supports up to 10,000 SNAT connections.
               + `2`: medium type, which supports up to 50,000 SNAT connections.
               + `3`: large type, which supports up to 200,000 SNAT connections.
               + `4`: extra-large type, which supports up to 1,000,000 SNAT connections.
        :param pulumi.Input[str] status: The status of the nat gateway.
        :param pulumi.Input[str] subnet_id: Specifies the subnet ID of the downstream interface (the next hop of the
               DVR) of the NAT gateway. Changing this creates a new nat gateway.
        :param pulumi.Input[str] vpc_id: Specifies the ID of the VPC this nat gateway belongs to. Changing this creates
               a new nat gateway.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if internal_network_id is not None:
            warnings.warn("""use subnet_id instead""", DeprecationWarning)
            pulumi.log.warn("""internal_network_id is deprecated: use subnet_id instead""")
        if internal_network_id is not None:
            pulumi.set(__self__, "internal_network_id", internal_network_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if router_id is not None:
            warnings.warn("""use vpc_id instead""", DeprecationWarning)
            pulumi.log.warn("""router_id is deprecated: use vpc_id instead""")
        if router_id is not None:
            pulumi.set(__self__, "router_id", router_id)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the nat gateway. The value contains 0 to 255
        characters, and angle brackets (<)
        and (>) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the nat gateway. The
        value can contains maximum of 36 characters which it is string "0" or in UUID format with hyphens (-). Changing this
        creates a new nat gateway.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="internalNetworkId")
    def internal_network_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "internal_network_id")

    @internal_network_id.setter
    def internal_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internal_network_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the nat gateway name. The name can contain only digits, letters, underscores (_)
        , and hyphens(-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the Nat gateway resource. If omitted,
        the provider-level region will be used. Changing this creates a new nat gateway.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "router_id")

    @router_id.setter
    def router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "router_id", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the nat gateway type. The value can be:
        + `1`: small type, which supports up to 10,000 SNAT connections.
        + `2`: medium type, which supports up to 50,000 SNAT connections.
        + `3`: large type, which supports up to 200,000 SNAT connections.
        + `4`: extra-large type, which supports up to 1,000,000 SNAT connections.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the nat gateway.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the subnet ID of the downstream interface (the next hop of the
        DVR) of the NAT gateway. Changing this creates a new nat gateway.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the VPC this nat gateway belongs to. Changing this creates
        a new nat gateway.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Gateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 internal_network_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router_id: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Nat gateway resource within HuaweiCloud Nat.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        nat1 = huaweicloud.nat.Gateway("nat1",
            description="test for terraform",
            spec="3",
            subnet_id="dc8632e2-d9ff-41b1-aa0c-d455557314a0",
            vpc_id="2c1fe4bd-ebad-44ca-ae9d-e94e63847b75")
        ```

        ## Import

        Nat gateway can be imported using the following format

        ```sh
         $ pulumi import huaweicloud:Nat/gateway:Gateway nat_1 d126fb87-43ce-4867-a2ff-cf34af3765d9
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the description of the nat gateway. The value contains 0 to 255
               characters, and angle brackets (<)
               and (>) are not allowed.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the nat gateway. The
               value can contains maximum of 36 characters which it is string "0" or in UUID format with hyphens (-). Changing this
               creates a new nat gateway.
        :param pulumi.Input[str] name: Specifies the nat gateway name. The name can contain only digits, letters, underscores (_)
               , and hyphens(-).
        :param pulumi.Input[str] region: Specifies the region in which to create the Nat gateway resource. If omitted,
               the provider-level region will be used. Changing this creates a new nat gateway.
        :param pulumi.Input[str] spec: Specifies the nat gateway type. The value can be:
               + `1`: small type, which supports up to 10,000 SNAT connections.
               + `2`: medium type, which supports up to 50,000 SNAT connections.
               + `3`: large type, which supports up to 200,000 SNAT connections.
               + `4`: extra-large type, which supports up to 1,000,000 SNAT connections.
        :param pulumi.Input[str] subnet_id: Specifies the subnet ID of the downstream interface (the next hop of the
               DVR) of the NAT gateway. Changing this creates a new nat gateway.
        :param pulumi.Input[str] vpc_id: Specifies the ID of the VPC this nat gateway belongs to. Changing this creates
               a new nat gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Nat gateway resource within HuaweiCloud Nat.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        nat1 = huaweicloud.nat.Gateway("nat1",
            description="test for terraform",
            spec="3",
            subnet_id="dc8632e2-d9ff-41b1-aa0c-d455557314a0",
            vpc_id="2c1fe4bd-ebad-44ca-ae9d-e94e63847b75")
        ```

        ## Import

        Nat gateway can be imported using the following format

        ```sh
         $ pulumi import huaweicloud:Nat/gateway:Gateway nat_1 d126fb87-43ce-4867-a2ff-cf34af3765d9
        ```

        :param str resource_name: The name of the resource.
        :param GatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 internal_network_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router_id: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayArgs.__new__(GatewayArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if internal_network_id is not None and not opts.urn:
                warnings.warn("""use subnet_id instead""", DeprecationWarning)
                pulumi.log.warn("""internal_network_id is deprecated: use subnet_id instead""")
            __props__.__dict__["internal_network_id"] = internal_network_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if router_id is not None and not opts.urn:
                warnings.warn("""use vpc_id instead""", DeprecationWarning)
                pulumi.log.warn("""router_id is deprecated: use vpc_id instead""")
            __props__.__dict__["router_id"] = router_id
            if spec is None and not opts.urn:
                raise TypeError("Missing required property 'spec'")
            __props__.__dict__["spec"] = spec
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["status"] = None
        super(Gateway, __self__).__init__(
            'huaweicloud:Nat/gateway:Gateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            internal_network_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            router_id: Optional[pulumi.Input[str]] = None,
            spec: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Gateway':
        """
        Get an existing Gateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the description of the nat gateway. The value contains 0 to 255
               characters, and angle brackets (<)
               and (>) are not allowed.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the nat gateway. The
               value can contains maximum of 36 characters which it is string "0" or in UUID format with hyphens (-). Changing this
               creates a new nat gateway.
        :param pulumi.Input[str] name: Specifies the nat gateway name. The name can contain only digits, letters, underscores (_)
               , and hyphens(-).
        :param pulumi.Input[str] region: Specifies the region in which to create the Nat gateway resource. If omitted,
               the provider-level region will be used. Changing this creates a new nat gateway.
        :param pulumi.Input[str] spec: Specifies the nat gateway type. The value can be:
               + `1`: small type, which supports up to 10,000 SNAT connections.
               + `2`: medium type, which supports up to 50,000 SNAT connections.
               + `3`: large type, which supports up to 200,000 SNAT connections.
               + `4`: extra-large type, which supports up to 1,000,000 SNAT connections.
        :param pulumi.Input[str] status: The status of the nat gateway.
        :param pulumi.Input[str] subnet_id: Specifies the subnet ID of the downstream interface (the next hop of the
               DVR) of the NAT gateway. Changing this creates a new nat gateway.
        :param pulumi.Input[str] vpc_id: Specifies the ID of the VPC this nat gateway belongs to. Changing this creates
               a new nat gateway.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayState.__new__(_GatewayState)

        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["internal_network_id"] = internal_network_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["router_id"] = router_id
        __props__.__dict__["spec"] = spec
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["vpc_id"] = vpc_id
        return Gateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Specifies the description of the nat gateway. The value contains 0 to 255
        characters, and angle brackets (<)
        and (>) are not allowed.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise project id of the nat gateway. The
        value can contains maximum of 36 characters which it is string "0" or in UUID format with hyphens (-). Changing this
        creates a new nat gateway.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="internalNetworkId")
    def internal_network_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "internal_network_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the nat gateway name. The name can contain only digits, letters, underscores (_)
        , and hyphens(-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the Nat gateway resource. If omitted,
        the provider-level region will be used. Changing this creates a new nat gateway.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "router_id")

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Output[str]:
        """
        Specifies the nat gateway type. The value can be:
        + `1`: small type, which supports up to 10,000 SNAT connections.
        + `2`: medium type, which supports up to 50,000 SNAT connections.
        + `3`: large type, which supports up to 200,000 SNAT connections.
        + `4`: extra-large type, which supports up to 1,000,000 SNAT connections.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the nat gateway.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Specifies the subnet ID of the downstream interface (the next hop of the
        DVR) of the NAT gateway. Changing this creates a new nat gateway.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the VPC this nat gateway belongs to. Changing this creates
        a new nat gateway.
        """
        return pulumi.get(self, "vpc_id")

