# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'TranscodingTemplateAudioArgs',
    'TranscodingTemplateGroupAudioArgs',
    'TranscodingTemplateGroupVideoArgs',
    'TranscodingTemplateGroupVideoCommonArgs',
    'TranscodingTemplateVideoArgs',
]

@pulumi.input_type
class TranscodingTemplateAudioArgs:
    def __init__(__self__, *,
                 channels: pulumi.Input[int],
                 codec: pulumi.Input[int],
                 sample_rate: pulumi.Input[int],
                 bitrate: Optional[pulumi.Input[int]] = None,
                 output_policy: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] channels: Specifies the number of audio channels. Possible values are:
               + **1**: AUDIO_CHANNELS_1
               + **2**: AUDIO_CHANNELS_2
               + **6**: AUDIO_CHANNELS_5_1
        :param pulumi.Input[int] codec: Specifies the video codec. Possible values are:
               + **1**: H.264
               + **2**: H.265
        :param pulumi.Input[int] sample_rate: Specifies the audio sampling rate. Possible values are:
               + **1**: AUDIO_SAMPLE_AUTO
               + **2**: AUDIO_SAMPLE_22050 (22,050 Hz)
               + **3**: AUDIO_SAMPLE_32000 (32,000 Hz)
               + **4**: AUDIO_SAMPLE_44100 (44,100 Hz)
               + **5**: AUDIO_SAMPLE_48000 (48,000 Hz)
               + **6**: AUDIO_SAMPLE_96000 (96,000 Hz)
        :param pulumi.Input[int] bitrate: Specifies the average output bitrate. The value is 0 or an integer ranging from 40 to
               30,000. The default value is 0. The unit is kbit/s. If this parameter is set to 0, the average output bitrate is an
               adaptive value.
        :param pulumi.Input[str] output_policy: Specifies the output policy. Possible values are **discard** and **transcode**.
               The default value is transcode.
        """
        pulumi.set(__self__, "channels", channels)
        pulumi.set(__self__, "codec", codec)
        pulumi.set(__self__, "sample_rate", sample_rate)
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if output_policy is not None:
            pulumi.set(__self__, "output_policy", output_policy)

    @property
    @pulumi.getter
    def channels(self) -> pulumi.Input[int]:
        """
        Specifies the number of audio channels. Possible values are:
        + **1**: AUDIO_CHANNELS_1
        + **2**: AUDIO_CHANNELS_2
        + **6**: AUDIO_CHANNELS_5_1
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: pulumi.Input[int]):
        pulumi.set(self, "channels", value)

    @property
    @pulumi.getter
    def codec(self) -> pulumi.Input[int]:
        """
        Specifies the video codec. Possible values are:
        + **1**: H.264
        + **2**: H.265
        """
        return pulumi.get(self, "codec")

    @codec.setter
    def codec(self, value: pulumi.Input[int]):
        pulumi.set(self, "codec", value)

    @property
    @pulumi.getter(name="sampleRate")
    def sample_rate(self) -> pulumi.Input[int]:
        """
        Specifies the audio sampling rate. Possible values are:
        + **1**: AUDIO_SAMPLE_AUTO
        + **2**: AUDIO_SAMPLE_22050 (22,050 Hz)
        + **3**: AUDIO_SAMPLE_32000 (32,000 Hz)
        + **4**: AUDIO_SAMPLE_44100 (44,100 Hz)
        + **5**: AUDIO_SAMPLE_48000 (48,000 Hz)
        + **6**: AUDIO_SAMPLE_96000 (96,000 Hz)
        """
        return pulumi.get(self, "sample_rate")

    @sample_rate.setter
    def sample_rate(self, value: pulumi.Input[int]):
        pulumi.set(self, "sample_rate", value)

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the average output bitrate. The value is 0 or an integer ranging from 40 to
        30,000. The default value is 0. The unit is kbit/s. If this parameter is set to 0, the average output bitrate is an
        adaptive value.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter(name="outputPolicy")
    def output_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the output policy. Possible values are **discard** and **transcode**.
        The default value is transcode.
        """
        return pulumi.get(self, "output_policy")

    @output_policy.setter
    def output_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_policy", value)


@pulumi.input_type
class TranscodingTemplateGroupAudioArgs:
    def __init__(__self__, *,
                 channels: pulumi.Input[int],
                 codec: pulumi.Input[int],
                 sample_rate: pulumi.Input[int],
                 bitrate: Optional[pulumi.Input[int]] = None,
                 output_policy: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] channels: Specifies the number of audio channels. Possible values are:
               + **1**: AUDIO_CHANNELS_1
               + **2**: AUDIO_CHANNELS_2
               + **6**: AUDIO_CHANNELS_5_1
        :param pulumi.Input[int] codec: Specifies the video codec. Possible values are:
               + **1**: H.264
               + **2**: H.265
        :param pulumi.Input[int] sample_rate: Specifies the audio sampling rate. Possible values are:
               + **1**: AUDIO_SAMPLE_AUTO
               + **2**: AUDIO_SAMPLE_22050 (22,050 Hz)
               + **3**: AUDIO_SAMPLE_32000 (32,000 Hz)
               + **4**: AUDIO_SAMPLE_44100 (44,100 Hz)
               + **5**: AUDIO_SAMPLE_48000 (48,000 Hz)
               + **6**: AUDIO_SAMPLE_96000 (96,000 Hz)
        :param pulumi.Input[int] bitrate: Specifies the average output bitrate. The value is 0 or an integer ranging from 40 to
               30,000. The default value is 0. The unit is kbit/s. If this parameter is set to 0, the average output bitrate is an
               adaptive value.
        :param pulumi.Input[str] output_policy: Specifies the output policy. Possible values are **discard** and **transcode**.
               The default value is transcode.
        """
        pulumi.set(__self__, "channels", channels)
        pulumi.set(__self__, "codec", codec)
        pulumi.set(__self__, "sample_rate", sample_rate)
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if output_policy is not None:
            pulumi.set(__self__, "output_policy", output_policy)

    @property
    @pulumi.getter
    def channels(self) -> pulumi.Input[int]:
        """
        Specifies the number of audio channels. Possible values are:
        + **1**: AUDIO_CHANNELS_1
        + **2**: AUDIO_CHANNELS_2
        + **6**: AUDIO_CHANNELS_5_1
        """
        return pulumi.get(self, "channels")

    @channels.setter
    def channels(self, value: pulumi.Input[int]):
        pulumi.set(self, "channels", value)

    @property
    @pulumi.getter
    def codec(self) -> pulumi.Input[int]:
        """
        Specifies the video codec. Possible values are:
        + **1**: H.264
        + **2**: H.265
        """
        return pulumi.get(self, "codec")

    @codec.setter
    def codec(self, value: pulumi.Input[int]):
        pulumi.set(self, "codec", value)

    @property
    @pulumi.getter(name="sampleRate")
    def sample_rate(self) -> pulumi.Input[int]:
        """
        Specifies the audio sampling rate. Possible values are:
        + **1**: AUDIO_SAMPLE_AUTO
        + **2**: AUDIO_SAMPLE_22050 (22,050 Hz)
        + **3**: AUDIO_SAMPLE_32000 (32,000 Hz)
        + **4**: AUDIO_SAMPLE_44100 (44,100 Hz)
        + **5**: AUDIO_SAMPLE_48000 (48,000 Hz)
        + **6**: AUDIO_SAMPLE_96000 (96,000 Hz)
        """
        return pulumi.get(self, "sample_rate")

    @sample_rate.setter
    def sample_rate(self, value: pulumi.Input[int]):
        pulumi.set(self, "sample_rate", value)

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the average output bitrate. The value is 0 or an integer ranging from 40 to
        30,000. The default value is 0. The unit is kbit/s. If this parameter is set to 0, the average output bitrate is an
        adaptive value.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter(name="outputPolicy")
    def output_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the output policy. Possible values are **discard** and **transcode**.
        The default value is transcode.
        """
        return pulumi.get(self, "output_policy")

    @output_policy.setter
    def output_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_policy", value)


@pulumi.input_type
class TranscodingTemplateGroupVideoArgs:
    def __init__(__self__, *,
                 bitrate: Optional[pulumi.Input[int]] = None,
                 height: Optional[pulumi.Input[int]] = None,
                 width: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] bitrate: Specifies the average output bitrate. The value is 0 or an integer ranging from 40 to
               30,000. The default value is 0. The unit is kbit/s. If this parameter is set to 0, the average output bitrate is an
               adaptive value.
        :param pulumi.Input[int] height: Specifies the video height. The value is 0 or a multiple of 2 from 32 to 2,880 for H.264,
               and 0 or a multiple of 4 from 96 to 2,880 for H.265. The unit is pixel. If this parameter is set to 0, the video height
               is an adaptive value. The default value is 0.
        :param pulumi.Input[int] width: Specifies the video width. The value can be 0 or a multiple of 2 from 32 to 4,096 for H.264
               and 0 or a multiple of 4 from 160 to 4,096 for H.265. The unit is pixel. If this parameter is set to 0, the video width
               is an adaptive value. The default value is 0.
        """
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the average output bitrate. The value is 0 or an integer ranging from 40 to
        30,000. The default value is 0. The unit is kbit/s. If this parameter is set to 0, the average output bitrate is an
        adaptive value.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the video height. The value is 0 or a multiple of 2 from 32 to 2,880 for H.264,
        and 0 or a multiple of 4 from 96 to 2,880 for H.265. The unit is pixel. If this parameter is set to 0, the video height
        is an adaptive value. The default value is 0.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the video width. The value can be 0 or a multiple of 2 from 32 to 4,096 for H.264
        and 0 or a multiple of 4 from 160 to 4,096 for H.265. The unit is pixel. If this parameter is set to 0, the video width
        is an adaptive value. The default value is 0.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class TranscodingTemplateGroupVideoCommonArgs:
    def __init__(__self__, *,
                 black_bar_removal: Optional[pulumi.Input[int]] = None,
                 codec: Optional[pulumi.Input[int]] = None,
                 fps: Optional[pulumi.Input[int]] = None,
                 level: Optional[pulumi.Input[int]] = None,
                 max_consecutive_bframes: Optional[pulumi.Input[int]] = None,
                 max_iframes_interval: Optional[pulumi.Input[int]] = None,
                 max_reference_frames: Optional[pulumi.Input[int]] = None,
                 output_policy: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[int]] = None,
                 quality: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] black_bar_removal: Specifies whether to enable black bar removal. Possible values are:
               + **0**: Disable black bar removal.
               + **1**: Enable black bar removal and low-complexity algorithms for long videos (>5 minutes).
               + **2**: Enable black bar removal and high-complexity algorithms for short videos (≤5 minutes).
        :param pulumi.Input[int] codec: Specifies the video codec. Possible values are:
               + **1**: H.264
               + **2**: H.265
        :param pulumi.Input[int] fps: Specifies the frame rate. Its value is 0 or an integer ranging from 5 to 30.
               The default value is 0. The unit is FPS.
        :param pulumi.Input[int] level: Specifies the encoding level. Possible values are:
               + **1**: VIDEO_LEVEL_1_0
               + **2**: VIDEO_LEVEL_1_1
               + **3**: VIDEO_LEVEL_1_2
               + **4**: VIDEO_LEVEL_1_3
               + **5**: VIDEO_LEVEL_2_0
               + **6**: VIDEO_LEVEL_2_1
               + **7**: VIDEO_LEVEL_2_2
               + **8**: VIDEO_LEVEL_3_0
               + **9**: VIDEO_LEVEL_3_1
               + **10**: VIDEO_LEVEL_3_2
               + **11**: VIDEO_LEVEL_4_0
               + **12**: VIDEO_LEVEL_4_1
               + **13**: VIDEO_LEVEL_4_2
               + **14**: VIDEO_LEVEL_5_0
               + **15**: VIDEO_LEVEL_5_1
        :param pulumi.Input[int] max_consecutive_bframes: Specifies the maximum number of B-frames.
               The vaule range is  0 to 7, and the default value is 4. The unit is frame.
        :param pulumi.Input[int] max_iframes_interval: Specifies the mximum I-frame interval. The value ranges from 2 to 10.
               The default value is 5. The unit is second.
        :param pulumi.Input[int] max_reference_frames: Specifies the maximum reference frames. When the `codec` is H.264,
               the vaule rang is 1 to 8. When the `codec` is H.265, the value is fixed at 4. The default value is 4. The unit is frame.
        :param pulumi.Input[str] output_policy: Specifies the output policy. Possible values are **discard** and **transcode**.
               The default value is transcode.
        :param pulumi.Input[int] profile: Specifies the encoding profile. The recommended value is 3. Possible values are:
               + **1**: VIDEO_PROFILE_H264_BASE
               + **2**: VIDEO_PROFILE_H264_MAIN
               + **3**: VIDEO_PROFILE_H264_HIGH
               + **4**: VIDEO_PROFILE_H265_MAIN
        :param pulumi.Input[int] quality: Specifies the encoding quality. A larger value indicates higher encoding quality and
               longer transcoding time. Possible values are:
               + **1**: VIDEO_PRESET_HSPEED2
               + **2**: VIDEO_PRESET_HSPEED
               + **3**: VIDEO_PRESET_NORMAL
        """
        if black_bar_removal is not None:
            pulumi.set(__self__, "black_bar_removal", black_bar_removal)
        if codec is not None:
            pulumi.set(__self__, "codec", codec)
        if fps is not None:
            pulumi.set(__self__, "fps", fps)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if max_consecutive_bframes is not None:
            pulumi.set(__self__, "max_consecutive_bframes", max_consecutive_bframes)
        if max_iframes_interval is not None:
            pulumi.set(__self__, "max_iframes_interval", max_iframes_interval)
        if max_reference_frames is not None:
            pulumi.set(__self__, "max_reference_frames", max_reference_frames)
        if output_policy is not None:
            pulumi.set(__self__, "output_policy", output_policy)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if quality is not None:
            pulumi.set(__self__, "quality", quality)

    @property
    @pulumi.getter(name="blackBarRemoval")
    def black_bar_removal(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether to enable black bar removal. Possible values are:
        + **0**: Disable black bar removal.
        + **1**: Enable black bar removal and low-complexity algorithms for long videos (>5 minutes).
        + **2**: Enable black bar removal and high-complexity algorithms for short videos (≤5 minutes).
        """
        return pulumi.get(self, "black_bar_removal")

    @black_bar_removal.setter
    def black_bar_removal(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "black_bar_removal", value)

    @property
    @pulumi.getter
    def codec(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the video codec. Possible values are:
        + **1**: H.264
        + **2**: H.265
        """
        return pulumi.get(self, "codec")

    @codec.setter
    def codec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "codec", value)

    @property
    @pulumi.getter
    def fps(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the frame rate. Its value is 0 or an integer ranging from 5 to 30.
        The default value is 0. The unit is FPS.
        """
        return pulumi.get(self, "fps")

    @fps.setter
    def fps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fps", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the encoding level. Possible values are:
        + **1**: VIDEO_LEVEL_1_0
        + **2**: VIDEO_LEVEL_1_1
        + **3**: VIDEO_LEVEL_1_2
        + **4**: VIDEO_LEVEL_1_3
        + **5**: VIDEO_LEVEL_2_0
        + **6**: VIDEO_LEVEL_2_1
        + **7**: VIDEO_LEVEL_2_2
        + **8**: VIDEO_LEVEL_3_0
        + **9**: VIDEO_LEVEL_3_1
        + **10**: VIDEO_LEVEL_3_2
        + **11**: VIDEO_LEVEL_4_0
        + **12**: VIDEO_LEVEL_4_1
        + **13**: VIDEO_LEVEL_4_2
        + **14**: VIDEO_LEVEL_5_0
        + **15**: VIDEO_LEVEL_5_1
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="maxConsecutiveBframes")
    def max_consecutive_bframes(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of B-frames.
        The vaule range is  0 to 7, and the default value is 4. The unit is frame.
        """
        return pulumi.get(self, "max_consecutive_bframes")

    @max_consecutive_bframes.setter
    def max_consecutive_bframes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_consecutive_bframes", value)

    @property
    @pulumi.getter(name="maxIframesInterval")
    def max_iframes_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the mximum I-frame interval. The value ranges from 2 to 10.
        The default value is 5. The unit is second.
        """
        return pulumi.get(self, "max_iframes_interval")

    @max_iframes_interval.setter
    def max_iframes_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_iframes_interval", value)

    @property
    @pulumi.getter(name="maxReferenceFrames")
    def max_reference_frames(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum reference frames. When the `codec` is H.264,
        the vaule rang is 1 to 8. When the `codec` is H.265, the value is fixed at 4. The default value is 4. The unit is frame.
        """
        return pulumi.get(self, "max_reference_frames")

    @max_reference_frames.setter
    def max_reference_frames(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_reference_frames", value)

    @property
    @pulumi.getter(name="outputPolicy")
    def output_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the output policy. Possible values are **discard** and **transcode**.
        The default value is transcode.
        """
        return pulumi.get(self, "output_policy")

    @output_policy.setter
    def output_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_policy", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the encoding profile. The recommended value is 3. Possible values are:
        + **1**: VIDEO_PROFILE_H264_BASE
        + **2**: VIDEO_PROFILE_H264_MAIN
        + **3**: VIDEO_PROFILE_H264_HIGH
        + **4**: VIDEO_PROFILE_H265_MAIN
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter
    def quality(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the encoding quality. A larger value indicates higher encoding quality and
        longer transcoding time. Possible values are:
        + **1**: VIDEO_PRESET_HSPEED2
        + **2**: VIDEO_PRESET_HSPEED
        + **3**: VIDEO_PRESET_NORMAL
        """
        return pulumi.get(self, "quality")

    @quality.setter
    def quality(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quality", value)


@pulumi.input_type
class TranscodingTemplateVideoArgs:
    def __init__(__self__, *,
                 bitrate: Optional[pulumi.Input[int]] = None,
                 black_bar_removal: Optional[pulumi.Input[int]] = None,
                 codec: Optional[pulumi.Input[int]] = None,
                 fps: Optional[pulumi.Input[int]] = None,
                 height: Optional[pulumi.Input[int]] = None,
                 level: Optional[pulumi.Input[int]] = None,
                 max_consecutive_bframes: Optional[pulumi.Input[int]] = None,
                 max_iframes_interval: Optional[pulumi.Input[int]] = None,
                 max_reference_frames: Optional[pulumi.Input[int]] = None,
                 output_policy: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[int]] = None,
                 quality: Optional[pulumi.Input[int]] = None,
                 width: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] bitrate: Specifies the average output bitrate. The value is 0 or an integer ranging from 40 to
               30,000. The default value is 0. The unit is kbit/s. If this parameter is set to 0, the average output bitrate is an
               adaptive value.
        :param pulumi.Input[int] black_bar_removal: Specifies whether to enable black bar removal. Possible values are:
               + **0**: Disable black bar removal.
               + **1**: Enable black bar removal and low-complexity algorithms for long videos (>5 minutes).
               + **2**: Enable black bar removal and high-complexity algorithms for short videos (≤5 minutes).
        :param pulumi.Input[int] codec: Specifies the video codec. Possible values are:
               + **1**: H.264
               + **2**: H.265
        :param pulumi.Input[int] fps: Specifies the frame rate. Its value is 0 or an integer ranging from 5 to 30.
               The default value is 0. The unit is FPS.
        :param pulumi.Input[int] height: Specifies the video height. The value is 0 or a multiple of 2 from 32 to 2,880 for H.264,
               and 0 or a multiple of 4 from 96 to 2,880 for H.265. The unit is pixel. If this parameter is set to 0, the video height
               is an adaptive value. The default value is 0.
        :param pulumi.Input[int] level: Specifies the encoding level. Possible values are:
               + **1**: VIDEO_LEVEL_1_0
               + **2**: VIDEO_LEVEL_1_1
               + **3**: VIDEO_LEVEL_1_2
               + **4**: VIDEO_LEVEL_1_3
               + **5**: VIDEO_LEVEL_2_0
               + **6**: VIDEO_LEVEL_2_1
               + **7**: VIDEO_LEVEL_2_2
               + **8**: VIDEO_LEVEL_3_0
               + **9**: VIDEO_LEVEL_3_1
               + **10**: VIDEO_LEVEL_3_2
               + **11**: VIDEO_LEVEL_4_0
               + **12**: VIDEO_LEVEL_4_1
               + **13**: VIDEO_LEVEL_4_2
               + **14**: VIDEO_LEVEL_5_0
               + **15**: VIDEO_LEVEL_5_1
        :param pulumi.Input[int] max_consecutive_bframes: Specifies the maximum number of B-frames.
               The vaule range is  0 to 7, and the default value is 4. The unit is frame.
        :param pulumi.Input[int] max_iframes_interval: Specifies the mximum I-frame interval. The value ranges from 2 to 10.
               The default value is 5. The unit is second.
        :param pulumi.Input[int] max_reference_frames: Specifies the maximum reference frames. When the `codec` is H.264,
               the vaule rang is 1 to 8. When the `codec` is H.265, the value is fixed at 4. The default value is 4. The unit is frame.
        :param pulumi.Input[str] output_policy: Specifies the output policy. Possible values are **discard** and **transcode**.
               The default value is transcode.
        :param pulumi.Input[int] profile: Specifies the encoding profile. The recommended value is 3. Possible values are:
               + **1**: VIDEO_PROFILE_H264_BASE
               + **2**: VIDEO_PROFILE_H264_MAIN
               + **3**: VIDEO_PROFILE_H264_HIGH
               + **4**: VIDEO_PROFILE_H265_MAIN
        :param pulumi.Input[int] quality: Specifies the encoding quality. A larger value indicates higher encoding quality and
               longer transcoding time. Possible values are:
               + **1**: VIDEO_PRESET_HSPEED2
               + **2**: VIDEO_PRESET_HSPEED
               + **3**: VIDEO_PRESET_NORMAL
        :param pulumi.Input[int] width: Specifies the video width. The value can be 0 or a multiple of 2 from 32 to 4,096 for H.264
               and 0 or a multiple of 4 from 160 to 4,096 for H.265. The unit is pixel. If this parameter is set to 0, the video width
               is an adaptive value. The default value is 0.
        """
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if black_bar_removal is not None:
            pulumi.set(__self__, "black_bar_removal", black_bar_removal)
        if codec is not None:
            pulumi.set(__self__, "codec", codec)
        if fps is not None:
            pulumi.set(__self__, "fps", fps)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if max_consecutive_bframes is not None:
            pulumi.set(__self__, "max_consecutive_bframes", max_consecutive_bframes)
        if max_iframes_interval is not None:
            pulumi.set(__self__, "max_iframes_interval", max_iframes_interval)
        if max_reference_frames is not None:
            pulumi.set(__self__, "max_reference_frames", max_reference_frames)
        if output_policy is not None:
            pulumi.set(__self__, "output_policy", output_policy)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if quality is not None:
            pulumi.set(__self__, "quality", quality)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the average output bitrate. The value is 0 or an integer ranging from 40 to
        30,000. The default value is 0. The unit is kbit/s. If this parameter is set to 0, the average output bitrate is an
        adaptive value.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter(name="blackBarRemoval")
    def black_bar_removal(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether to enable black bar removal. Possible values are:
        + **0**: Disable black bar removal.
        + **1**: Enable black bar removal and low-complexity algorithms for long videos (>5 minutes).
        + **2**: Enable black bar removal and high-complexity algorithms for short videos (≤5 minutes).
        """
        return pulumi.get(self, "black_bar_removal")

    @black_bar_removal.setter
    def black_bar_removal(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "black_bar_removal", value)

    @property
    @pulumi.getter
    def codec(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the video codec. Possible values are:
        + **1**: H.264
        + **2**: H.265
        """
        return pulumi.get(self, "codec")

    @codec.setter
    def codec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "codec", value)

    @property
    @pulumi.getter
    def fps(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the frame rate. Its value is 0 or an integer ranging from 5 to 30.
        The default value is 0. The unit is FPS.
        """
        return pulumi.get(self, "fps")

    @fps.setter
    def fps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fps", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the video height. The value is 0 or a multiple of 2 from 32 to 2,880 for H.264,
        and 0 or a multiple of 4 from 96 to 2,880 for H.265. The unit is pixel. If this parameter is set to 0, the video height
        is an adaptive value. The default value is 0.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the encoding level. Possible values are:
        + **1**: VIDEO_LEVEL_1_0
        + **2**: VIDEO_LEVEL_1_1
        + **3**: VIDEO_LEVEL_1_2
        + **4**: VIDEO_LEVEL_1_3
        + **5**: VIDEO_LEVEL_2_0
        + **6**: VIDEO_LEVEL_2_1
        + **7**: VIDEO_LEVEL_2_2
        + **8**: VIDEO_LEVEL_3_0
        + **9**: VIDEO_LEVEL_3_1
        + **10**: VIDEO_LEVEL_3_2
        + **11**: VIDEO_LEVEL_4_0
        + **12**: VIDEO_LEVEL_4_1
        + **13**: VIDEO_LEVEL_4_2
        + **14**: VIDEO_LEVEL_5_0
        + **15**: VIDEO_LEVEL_5_1
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="maxConsecutiveBframes")
    def max_consecutive_bframes(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum number of B-frames.
        The vaule range is  0 to 7, and the default value is 4. The unit is frame.
        """
        return pulumi.get(self, "max_consecutive_bframes")

    @max_consecutive_bframes.setter
    def max_consecutive_bframes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_consecutive_bframes", value)

    @property
    @pulumi.getter(name="maxIframesInterval")
    def max_iframes_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the mximum I-frame interval. The value ranges from 2 to 10.
        The default value is 5. The unit is second.
        """
        return pulumi.get(self, "max_iframes_interval")

    @max_iframes_interval.setter
    def max_iframes_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_iframes_interval", value)

    @property
    @pulumi.getter(name="maxReferenceFrames")
    def max_reference_frames(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum reference frames. When the `codec` is H.264,
        the vaule rang is 1 to 8. When the `codec` is H.265, the value is fixed at 4. The default value is 4. The unit is frame.
        """
        return pulumi.get(self, "max_reference_frames")

    @max_reference_frames.setter
    def max_reference_frames(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_reference_frames", value)

    @property
    @pulumi.getter(name="outputPolicy")
    def output_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the output policy. Possible values are **discard** and **transcode**.
        The default value is transcode.
        """
        return pulumi.get(self, "output_policy")

    @output_policy.setter
    def output_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_policy", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the encoding profile. The recommended value is 3. Possible values are:
        + **1**: VIDEO_PROFILE_H264_BASE
        + **2**: VIDEO_PROFILE_H264_MAIN
        + **3**: VIDEO_PROFILE_H264_HIGH
        + **4**: VIDEO_PROFILE_H265_MAIN
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter
    def quality(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the encoding quality. A larger value indicates higher encoding quality and
        longer transcoding time. Possible values are:
        + **1**: VIDEO_PRESET_HSPEED2
        + **2**: VIDEO_PRESET_HSPEED
        + **3**: VIDEO_PRESET_NORMAL
        """
        return pulumi.get(self, "quality")

    @quality.setter
    def quality(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quality", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the video width. The value can be 0 or a multiple of 2 from 32 to 4,096 for H.264
        and 0 or a multiple of 4 from 160 to 4,096 for H.265. The unit is pixel. If this parameter is set to 0, the video width
        is an adaptive value. The default value is 0.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "width", value)


