# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DatasetDataSource',
    'DatasetLabel',
    'DatasetLabelFormat',
    'DatasetSchema',
    'NotebookMountStorage',
    'NotebookVolume',
    'GetDataset_versionsVersionResult',
    'GetDatasetsDatasetResult',
    'GetDatasetsDatasetDataSourceResult',
    'GetDatasetsDatasetLabelResult',
    'GetDatasetsDatasetSchemaResult',
    'GetNotebookImagesImageResult',
]

@pulumi.output_type
class DatasetDataSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "dataType":
            suggest = "data_type"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "queueName":
            suggest = "queue_name"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "userName":
            suggest = "user_name"
        elif key == "withColumnHeader":
            suggest = "with_column_header"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetDataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetDataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetDataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: Optional[str] = None,
                 data_type: Optional[int] = None,
                 database_name: Optional[str] = None,
                 password: Optional[str] = None,
                 path: Optional[str] = None,
                 queue_name: Optional[str] = None,
                 table_name: Optional[str] = None,
                 user_name: Optional[str] = None,
                 with_column_header: Optional[bool] = None):
        """
        :param str cluster_id: Specifies the cluster ID of DWS/MRS when `data_type` is `1` or `4`.
               Changing this parameter will create a new resource.
        :param int data_type: Specifies the type of data source. The options are as follows:
               + **0**: OBS.
               + **1**: GaussDB(DWS).
               + **2**: DLI.
               + **4**: MRS.
        :param str database_name: Specifies the database name of DWS/DLI when `data_type` is `1` or `2`.
               Changing this parameter will create a new resource.
        :param str password: Specifies the password of database when `data_type` is `1`.
               Changing this parameter will create a new resource.
        :param str path: Specifies the OBS path when `data_type` is `0`
               or the hdsf path when `data_type` is `4`. All the file in this directory and subdirectories will be which be imported
               to the dataset. Changing this parameter will create a new resource.
        :param str queue_name: Specifies the queue name of DLI when `data_type` is `2`.
               Changing this parameter will create a new resource.
        :param str table_name: Specifies the table name of DWS/DLI when `data_type` is `1` or `2`.
               Changing this parameter will create a new resource.
        :param str user_name: Specifies the user name of databse when `data_type` is `1`.
               Changing this parameter will create a new resource.
        :param bool with_column_header: Specifies whether the data contains table header when the type
               of dataset is `400`(Table type). Default value is `true`. Changing this parameter will create a new resource.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if with_column_header is not None:
            pulumi.set(__self__, "with_column_header", with_column_header)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[str]:
        """
        Specifies the cluster ID of DWS/MRS when `data_type` is `1` or `4`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[int]:
        """
        Specifies the type of data source. The options are as follows:
        + **0**: OBS.
        + **1**: GaussDB(DWS).
        + **2**: DLI.
        + **4**: MRS.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[str]:
        """
        Specifies the database name of DWS/DLI when `data_type` is `1` or `2`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Specifies the password of database when `data_type` is `1`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Specifies the OBS path when `data_type` is `0`
        or the hdsf path when `data_type` is `4`. All the file in this directory and subdirectories will be which be imported
        to the dataset. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[str]:
        """
        Specifies the queue name of DLI when `data_type` is `2`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[str]:
        """
        Specifies the table name of DWS/DLI when `data_type` is `1` or `2`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        Specifies the user name of databse when `data_type` is `1`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="withColumnHeader")
    def with_column_header(self) -> Optional[bool]:
        """
        Specifies whether the data contains table header when the type
        of dataset is `400`(Table type). Default value is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "with_column_header")


@pulumi.output_type
class DatasetLabel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertyColor":
            suggest = "property_color"
        elif key == "propertyShape":
            suggest = "property_shape"
        elif key == "propertyShortcut":
            suggest = "property_shortcut"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetLabel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetLabel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetLabel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 property_color: Optional[str] = None,
                 property_shape: Optional[str] = None,
                 property_shortcut: Optional[str] = None):
        """
        :param str name: Specifies the name of label.
        :param str property_color: Specifies color of label.
        :param str property_shape: Specifies shape of label. Valid values include: `bndbox`, `polygon`,
               `circle`, `line`, `dashed`, `point`, `polyline`.
        :param str property_shortcut: Specifies shortcut of label.
        """
        pulumi.set(__self__, "name", name)
        if property_color is not None:
            pulumi.set(__self__, "property_color", property_color)
        if property_shape is not None:
            pulumi.set(__self__, "property_shape", property_shape)
        if property_shortcut is not None:
            pulumi.set(__self__, "property_shortcut", property_shortcut)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of label.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="propertyColor")
    def property_color(self) -> Optional[str]:
        """
        Specifies color of label.
        """
        return pulumi.get(self, "property_color")

    @property
    @pulumi.getter(name="propertyShape")
    def property_shape(self) -> Optional[str]:
        """
        Specifies shape of label. Valid values include: `bndbox`, `polygon`,
        `circle`, `line`, `dashed`, `point`, `polyline`.
        """
        return pulumi.get(self, "property_shape")

    @property
    @pulumi.getter(name="propertyShortcut")
    def property_shortcut(self) -> Optional[str]:
        """
        Specifies shortcut of label.
        """
        return pulumi.get(self, "property_shortcut")


@pulumi.output_type
class DatasetLabelFormat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelSeparator":
            suggest = "label_separator"
        elif key == "textLabelSeparator":
            suggest = "text_label_separator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetLabelFormat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetLabelFormat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetLabelFormat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_separator: Optional[str] = None,
                 text_label_separator: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str label_separator: Specifies the separator between label and label.
               Changing this parameter will create a new resource.
        :param str text_label_separator: Specifies the separator between text and label.
               Changing this parameter will create a new resource.
        :param str type: Specifies Label type for text classification.
               The optional values are as follows:
        """
        if label_separator is not None:
            pulumi.set(__self__, "label_separator", label_separator)
        if text_label_separator is not None:
            pulumi.set(__self__, "text_label_separator", text_label_separator)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="labelSeparator")
    def label_separator(self) -> Optional[str]:
        """
        Specifies the separator between label and label.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "label_separator")

    @property
    @pulumi.getter(name="textLabelSeparator")
    def text_label_separator(self) -> Optional[str]:
        """
        Specifies the separator between text and label.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "text_label_separator")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies Label type for text classification.
        The optional values are as follows:
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DatasetSchema(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        :param str name: Specifies the name of label.
        :param str type: Specifies Label type for text classification.
               The optional values are as follows:
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of label.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies Label type for text classification.
        The optional values are as follows:
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NotebookMountStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotebookMountStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotebookMountStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotebookMountStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 mount_path: Optional[str] = None,
                 path: Optional[str] = None,
                 status: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str id: The mount ID.
        :param str mount_path: The local mount path.
        :param str path: The path of storage which be mounted.
        :param str status: The status of mount.
        :param str type: Specifies the volume type. The options are as follows:
               - *EFS*: use Scalable File Service, default 50GB is **free**.
               - *EVS*: use Elastic Volume Service, default size is 5 GB.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The mount ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[str]:
        """
        The local mount path.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path of storage which be mounted.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of mount.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the volume type. The options are as follows:
        - *EFS*: use Scalable File Service, default 50GB is **free**.
        - *EVS*: use Elastic Volume Service, default size is 5 GB.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NotebookVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotebookVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotebookVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotebookVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 mount_path: Optional[str] = None,
                 ownership: Optional[str] = None,
                 size: Optional[int] = None,
                 uri: Optional[str] = None):
        """
        :param str type: Specifies the volume type. The options are as follows:
               - *EFS*: use Scalable File Service, default 50GB is **free**.
               - *EVS*: use Elastic Volume Service, default size is 5 GB.
        :param str mount_path: The local mount path.
        :param str ownership: Specifies the volume ownership. The options are as follows:
               - *MANAGED*: shared storage disk of the ModelArts service.
               - *DEDICATED*: dedicated storage disk, only supported when the category is `EFS`.
        :param int size: Specifies the volume size. Its value range is from 5 GB to 4096 GB.
        :param str uri: Specifies the uri of dedicated storage disk, which is mandatory when the `type`
               is `EFS` and the `ownership` is `DEDICATED`. Example: `192.168.0.1:/user-9sfdsdgdfgh5ea4d56871e75d6966aa274/mount/`.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "type", type)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if ownership is not None:
            pulumi.set(__self__, "ownership", ownership)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the volume type. The options are as follows:
        - *EFS*: use Scalable File Service, default 50GB is **free**.
        - *EVS*: use Elastic Volume Service, default size is 5 GB.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[str]:
        """
        The local mount path.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def ownership(self) -> Optional[str]:
        """
        Specifies the volume ownership. The options are as follows:
        - *MANAGED*: shared storage disk of the ModelArts service.
        - *DEDICATED*: dedicated storage disk, only supported when the category is `EFS`.
        """
        return pulumi.get(self, "ownership")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        Specifies the volume size. Its value range is from 5 GB to 4096 GB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Specifies the uri of dedicated storage disk, which is mandatory when the `type`
        is `EFS` and the `ownership` is `DEDICATED`. Example: `192.168.0.1:/user-9sfdsdgdfgh5ea4d56871e75d6966aa274/mount/`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetDataset_versionsVersionResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 description: str,
                 files: int,
                 id: str,
                 is_current: bool,
                 name: str,
                 split_ratio: str,
                 status: int,
                 storage_path: str,
                 updated_at: str):
        """
        :param str created_at: The creation time, in UTC format.
        :param str description: The description of the dataset version.
        :param int files: The total number of samples.
        :param str id: The ID of the dataset version.
        :param bool is_current: Whether this version is current version.
        :param str name: Specifies the name of the dataset version.
        :param str split_ratio: Specifies the range of splitting ratio which randomly divides a labeled sample
               into a training set and a validation set. Separate the minimum and maximum split ratios with commas,
               for example: "0.0,1.0".
        :param int status: Dataset version status. Valid values are as follows:
               + **0**: Creating.
               + **1**: Normal.
               + **2**: Deleting.
               + **3**: Deleted.
               + **4**: Exception.
        :param str storage_path: The path to save the manifest file of the version.
        :param str updated_at: The last update time, in UTC format.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "files", files)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_current", is_current)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "split_ratio", split_ratio)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage_path", storage_path)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The creation time, in UTC format.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the dataset version.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def files(self) -> int:
        """
        The total number of samples.
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the dataset version.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCurrent")
    def is_current(self) -> bool:
        """
        Whether this version is current version.
        """
        return pulumi.get(self, "is_current")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the dataset version.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="splitRatio")
    def split_ratio(self) -> str:
        """
        Specifies the range of splitting ratio which randomly divides a labeled sample
        into a training set and a validation set. Separate the minimum and maximum split ratios with commas,
        for example: "0.0,1.0".
        """
        return pulumi.get(self, "split_ratio")

    @property
    @pulumi.getter
    def status(self) -> int:
        """
        Dataset version status. Valid values are as follows:
        + **0**: Creating.
        + **1**: Normal.
        + **2**: Deleting.
        + **3**: Deleted.
        + **4**: Exception.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storagePath")
    def storage_path(self) -> str:
        """
        The path to save the manifest file of the version.
        """
        return pulumi.get(self, "storage_path")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        The last update time, in UTC format.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetDatasetsDatasetResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 data_format: str,
                 data_sources: Sequence['outputs.GetDatasetsDatasetDataSourceResult'],
                 description: str,
                 id: str,
                 name: str,
                 output_path: str,
                 schemas: Sequence['outputs.GetDatasetsDatasetSchemaResult'],
                 status: int,
                 type: int,
                 labels: Optional[Sequence['outputs.GetDatasetsDatasetLabelResult']] = None):
        """
        :param str created_at: The dataset creation time.
        :param str data_format: The dataset format. Valid values include: `Default`, `CarbonData`: Carbon format(Supported only for
               table type dataset.).
        :param Sequence['GetDatasetsDatasetDataSourceArgs'] data_sources: The data sources which is used to imported the source data (such as pictures/files/audio, etc.) in
               this directory and subdirectories to the dataset. Structure is documented below.
        :param str description: The description of the dataset.
        :param str id: The ID of the dataset.
        :param str name: Specifies the name of datasets.
        :param str output_path: The OBS path for storing output files such as labeled files.
        :param Sequence['GetDatasetsDatasetSchemaArgs'] schemas: The schema information of source data when `type` is `400`(Table Type). Structure is documented below.
        :param int status: Dataset status. Valid values are as follows:
               + **0**: Creating.
               + **1**: Completed.
               + **2**: Deleting.
               + **3**: Deleted.
               + **4**: Exception.
               + **5**: Syncing.
               + **6**: Releasing.
               + **7**: Version switching.
               + **8**: Importing.
        :param int type: Specifies the type of datasets. The options are:
               + **0**: Image classification, supported formats: `.jpg`, `.png`, `.jpeg`, `.bmp`.
               + **1**: Object detection, supported formats: `.jpg`, `.png`, `.jpeg`, `.bmp`.
               + **3**: Image segmentation, supported formats: `.jpg`, `.png`, `.jpeg`, `.bmp`.
               + **100**: Text classification, supported formats: `.txt`, `.csv`.
               + **200**: Sound classification, Supported formats: `.wav`.
               + **400**: Table type, supported formats: Carbon type.
               + **600**: Video, supported formats: `.mp4`
               + **900**: Free format.
        :param Sequence['GetDatasetsDatasetLabelArgs'] labels: The labels information. Structure is documented below.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "data_format", data_format)
        pulumi.set(__self__, "data_sources", data_sources)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "output_path", output_path)
        pulumi.set(__self__, "schemas", schemas)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The dataset creation time.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> str:
        """
        The dataset format. Valid values include: `Default`, `CarbonData`: Carbon format(Supported only for
        table type dataset.).
        """
        return pulumi.get(self, "data_format")

    @property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> Sequence['outputs.GetDatasetsDatasetDataSourceResult']:
        """
        The data sources which is used to imported the source data (such as pictures/files/audio, etc.) in
        this directory and subdirectories to the dataset. Structure is documented below.
        """
        return pulumi.get(self, "data_sources")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the dataset.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the dataset.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of datasets.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputPath")
    def output_path(self) -> str:
        """
        The OBS path for storing output files such as labeled files.
        """
        return pulumi.get(self, "output_path")

    @property
    @pulumi.getter
    def schemas(self) -> Sequence['outputs.GetDatasetsDatasetSchemaResult']:
        """
        The schema information of source data when `type` is `400`(Table Type). Structure is documented below.
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def status(self) -> int:
        """
        Dataset status. Valid values are as follows:
        + **0**: Creating.
        + **1**: Completed.
        + **2**: Deleting.
        + **3**: Deleted.
        + **4**: Exception.
        + **5**: Syncing.
        + **6**: Releasing.
        + **7**: Version switching.
        + **8**: Importing.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> int:
        """
        Specifies the type of datasets. The options are:
        + **0**: Image classification, supported formats: `.jpg`, `.png`, `.jpeg`, `.bmp`.
        + **1**: Object detection, supported formats: `.jpg`, `.png`, `.jpeg`, `.bmp`.
        + **3**: Image segmentation, supported formats: `.jpg`, `.png`, `.jpeg`, `.bmp`.
        + **100**: Text classification, supported formats: `.txt`, `.csv`.
        + **200**: Sound classification, Supported formats: `.wav`.
        + **400**: Table type, supported formats: Carbon type.
        + **600**: Video, supported formats: `.mp4`
        + **900**: Free format.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence['outputs.GetDatasetsDatasetLabelResult']]:
        """
        The labels information. Structure is documented below.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class GetDatasetsDatasetDataSourceResult(dict):
    def __init__(__self__, *,
                 data_type: int,
                 path: str,
                 with_column_header: bool):
        """
        :param int data_type: The type of data source. Valid values are as follows:
               + *0*: OBS.
               + *1*: GaussDB(DWS).
               + *2*: DLI.
               + *4*: MRS.
        :param str path: The OBS path when `data_type` is `0`(OBS) or the HDFS path when `data_type` is `4`(MRS). All the file in this
               directory and subdirectories will be which be imported to the dataset.
        :param bool with_column_header: Whether the data contains table header when the type of dataset is `400`(Table type).
        """
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "with_column_header", with_column_header)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> int:
        """
        The type of data source. Valid values are as follows:
        + *0*: OBS.
        + *1*: GaussDB(DWS).
        + *2*: DLI.
        + *4*: MRS.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The OBS path when `data_type` is `0`(OBS) or the HDFS path when `data_type` is `4`(MRS). All the file in this
        directory and subdirectories will be which be imported to the dataset.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="withColumnHeader")
    def with_column_header(self) -> bool:
        """
        Whether the data contains table header when the type of dataset is `400`(Table type).
        """
        return pulumi.get(self, "with_column_header")


@pulumi.output_type
class GetDatasetsDatasetLabelResult(dict):
    def __init__(__self__, *,
                 name: str,
                 property_color: str,
                 property_shape: str,
                 property_shortcut: str):
        """
        :param str name: Specifies the name of datasets.
        :param str property_color: The color of label.
        :param str property_shape: The shape of label. Valid values include: `bndbox`, `polygon`, `circle`, `line`, `dashed`,
               `point`, `polyline`.
        :param str property_shortcut: The shortcut of label.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "property_color", property_color)
        pulumi.set(__self__, "property_shape", property_shape)
        pulumi.set(__self__, "property_shortcut", property_shortcut)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of datasets.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="propertyColor")
    def property_color(self) -> str:
        """
        The color of label.
        """
        return pulumi.get(self, "property_color")

    @property
    @pulumi.getter(name="propertyShape")
    def property_shape(self) -> str:
        """
        The shape of label. Valid values include: `bndbox`, `polygon`, `circle`, `line`, `dashed`,
        `point`, `polyline`.
        """
        return pulumi.get(self, "property_shape")

    @property
    @pulumi.getter(name="propertyShortcut")
    def property_shortcut(self) -> str:
        """
        The shortcut of label.
        """
        return pulumi.get(self, "property_shortcut")


@pulumi.output_type
class GetDatasetsDatasetSchemaResult(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str):
        """
        :param str name: Specifies the name of datasets.
        :param str type: Specifies the type of datasets. The options are:
               + **0**: Image classification, supported formats: `.jpg`, `.png`, `.jpeg`, `.bmp`.
               + **1**: Object detection, supported formats: `.jpg`, `.png`, `.jpeg`, `.bmp`.
               + **3**: Image segmentation, supported formats: `.jpg`, `.png`, `.jpeg`, `.bmp`.
               + **100**: Text classification, supported formats: `.txt`, `.csv`.
               + **200**: Sound classification, Supported formats: `.wav`.
               + **400**: Table type, supported formats: Carbon type.
               + **600**: Video, supported formats: `.mp4`
               + **900**: Free format.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of datasets.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of datasets. The options are:
        + **0**: Image classification, supported formats: `.jpg`, `.png`, `.jpeg`, `.bmp`.
        + **1**: Object detection, supported formats: `.jpg`, `.png`, `.jpeg`, `.bmp`.
        + **3**: Image segmentation, supported formats: `.jpg`, `.png`, `.jpeg`, `.bmp`.
        + **100**: Text classification, supported formats: `.txt`, `.csv`.
        + **200**: Sound classification, Supported formats: `.wav`.
        + **400**: Table type, supported formats: Carbon type.
        + **600**: Video, supported formats: `.mp4`
        + **900**: Free format.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNotebookImagesImageResult(dict):
    def __init__(__self__, *,
                 cpu_arch: str,
                 description: str,
                 id: str,
                 name: str,
                 swr_path: str,
                 type: str):
        """
        :param str cpu_arch: Specifies the CPU architecture of image. The value can be **x86_64** and **aarch64**.
        :param str description: The description of the image.
        :param str id: The ID of the image.
        :param str name: Specifies the name of image.
        :param str swr_path: The path the image in HuaweiCloud SWR service (SoftWare Repository for Container).
        :param str type: Specifies the type of image. The options are:
               + `BUILD_IN`: The system built-in image.
               + `DEDICATED`: User-saved images.
        """
        pulumi.set(__self__, "cpu_arch", cpu_arch)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "swr_path", swr_path)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cpuArch")
    def cpu_arch(self) -> str:
        """
        Specifies the CPU architecture of image. The value can be **x86_64** and **aarch64**.
        """
        return pulumi.get(self, "cpu_arch")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the image.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the image.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of image.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="swrPath")
    def swr_path(self) -> str:
        """
        The path the image in HuaweiCloud SWR service (SoftWare Repository for Container).
        """
        return pulumi.get(self, "swr_path")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of image. The options are:
        + `BUILD_IN`: The system built-in image.
        + `DEDICATED`: User-saved images.
        """
        return pulumi.get(self, "type")


