# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['NotebookMountStorageInitArgs', 'NotebookMountStorage']

@pulumi.input_type
class NotebookMountStorageInitArgs:
    def __init__(__self__, *,
                 local_mount_directory: pulumi.Input[str],
                 notebook_id: pulumi.Input[str],
                 storage_path: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NotebookMountStorage resource.
        :param pulumi.Input[str] local_mount_directory: Specifies the local mount directory. Only the sub directory of `/data/`
               can be mounted. The format is : `/data/dir1/`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] notebook_id: Specifies ID of notebook which the storage be mounted to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] storage_path: Specifies the path of Parallel File System (PFS) or its folders in OBS.
               The format is : `obs://obs-bucket/folder/`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "local_mount_directory", local_mount_directory)
        pulumi.set(__self__, "notebook_id", notebook_id)
        pulumi.set(__self__, "storage_path", storage_path)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="localMountDirectory")
    def local_mount_directory(self) -> pulumi.Input[str]:
        """
        Specifies the local mount directory. Only the sub directory of `/data/`
        can be mounted. The format is : `/data/dir1/`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "local_mount_directory")

    @local_mount_directory.setter
    def local_mount_directory(self, value: pulumi.Input[str]):
        pulumi.set(self, "local_mount_directory", value)

    @property
    @pulumi.getter(name="notebookId")
    def notebook_id(self) -> pulumi.Input[str]:
        """
        Specifies ID of notebook which the storage be mounted to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "notebook_id")

    @notebook_id.setter
    def notebook_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "notebook_id", value)

    @property
    @pulumi.getter(name="storagePath")
    def storage_path(self) -> pulumi.Input[str]:
        """
        Specifies the path of Parallel File System (PFS) or its folders in OBS.
        The format is : `obs://obs-bucket/folder/`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "storage_path")

    @storage_path.setter
    def storage_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_path", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _NotebookMountStorageState:
    def __init__(__self__, *,
                 local_mount_directory: Optional[pulumi.Input[str]] = None,
                 mount_id: Optional[pulumi.Input[str]] = None,
                 notebook_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_path: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NotebookMountStorage resources.
        :param pulumi.Input[str] local_mount_directory: Specifies the local mount directory. Only the sub directory of `/data/`
               can be mounted. The format is : `/data/dir1/`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] mount_id: The mount ID.
        :param pulumi.Input[str] notebook_id: Specifies ID of notebook which the storage be mounted to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: mount status. Valid values include: `MOUNTING`, `MOUNT_FAILED`, `MOUNTED`, `UNMOUNTING`,
               `UNMOUNT_FAILED`, `UNMOUNTED`.
        :param pulumi.Input[str] storage_path: Specifies the path of Parallel File System (PFS) or its folders in OBS.
               The format is : `obs://obs-bucket/folder/`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] type: The type of storage system.  The value is `OBSFS`.
        """
        if local_mount_directory is not None:
            pulumi.set(__self__, "local_mount_directory", local_mount_directory)
        if mount_id is not None:
            pulumi.set(__self__, "mount_id", mount_id)
        if notebook_id is not None:
            pulumi.set(__self__, "notebook_id", notebook_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_path is not None:
            pulumi.set(__self__, "storage_path", storage_path)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="localMountDirectory")
    def local_mount_directory(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the local mount directory. Only the sub directory of `/data/`
        can be mounted. The format is : `/data/dir1/`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "local_mount_directory")

    @local_mount_directory.setter
    def local_mount_directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_mount_directory", value)

    @property
    @pulumi.getter(name="mountId")
    def mount_id(self) -> Optional[pulumi.Input[str]]:
        """
        The mount ID.
        """
        return pulumi.get(self, "mount_id")

    @mount_id.setter
    def mount_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_id", value)

    @property
    @pulumi.getter(name="notebookId")
    def notebook_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies ID of notebook which the storage be mounted to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "notebook_id")

    @notebook_id.setter
    def notebook_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notebook_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        mount status. Valid values include: `MOUNTING`, `MOUNT_FAILED`, `MOUNTED`, `UNMOUNTING`,
        `UNMOUNT_FAILED`, `UNMOUNTED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storagePath")
    def storage_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path of Parallel File System (PFS) or its folders in OBS.
        The format is : `obs://obs-bucket/folder/`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "storage_path")

    @storage_path.setter
    def storage_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_path", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of storage system.  The value is `OBSFS`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class NotebookMountStorage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 local_mount_directory: Optional[pulumi.Input[str]] = None,
                 notebook_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 storage_path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manage storages mounted to the notebook resource within HuaweiCloud. A maximum of 10 storages can be mounted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        notebook_id = config.require_object("notebookId")
        uri_parallel_obs = config.require_object("uriParallelObs")
        test = huaweicloud.model_arts.NotebookMountStorage("test",
            notebook_id=notebook_id,
            storage_path=uri_parallel_obs,
            local_mount_directory="/data/test/")
        ```

        ## Import

        The mount storage can be imported by `id`, It is composed of the ID of notebook and mount ID, separated by a slash.

        For example,

        ```sh
         $ pulumi import huaweicloud:ModelArts/notebookMountStorage:NotebookMountStorage test b11b407c-e604-4e8d-8bc4-92398320b847/4e206d3c-6831-4267-b93d-e236105cda38
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] local_mount_directory: Specifies the local mount directory. Only the sub directory of `/data/`
               can be mounted. The format is : `/data/dir1/`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] notebook_id: Specifies ID of notebook which the storage be mounted to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] storage_path: Specifies the path of Parallel File System (PFS) or its folders in OBS.
               The format is : `obs://obs-bucket/folder/`. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotebookMountStorageInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage storages mounted to the notebook resource within HuaweiCloud. A maximum of 10 storages can be mounted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        notebook_id = config.require_object("notebookId")
        uri_parallel_obs = config.require_object("uriParallelObs")
        test = huaweicloud.model_arts.NotebookMountStorage("test",
            notebook_id=notebook_id,
            storage_path=uri_parallel_obs,
            local_mount_directory="/data/test/")
        ```

        ## Import

        The mount storage can be imported by `id`, It is composed of the ID of notebook and mount ID, separated by a slash.

        For example,

        ```sh
         $ pulumi import huaweicloud:ModelArts/notebookMountStorage:NotebookMountStorage test b11b407c-e604-4e8d-8bc4-92398320b847/4e206d3c-6831-4267-b93d-e236105cda38
        ```

        :param str resource_name: The name of the resource.
        :param NotebookMountStorageInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotebookMountStorageInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 local_mount_directory: Optional[pulumi.Input[str]] = None,
                 notebook_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 storage_path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotebookMountStorageInitArgs.__new__(NotebookMountStorageInitArgs)

            if local_mount_directory is None and not opts.urn:
                raise TypeError("Missing required property 'local_mount_directory'")
            __props__.__dict__["local_mount_directory"] = local_mount_directory
            if notebook_id is None and not opts.urn:
                raise TypeError("Missing required property 'notebook_id'")
            __props__.__dict__["notebook_id"] = notebook_id
            __props__.__dict__["region"] = region
            if storage_path is None and not opts.urn:
                raise TypeError("Missing required property 'storage_path'")
            __props__.__dict__["storage_path"] = storage_path
            __props__.__dict__["mount_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
        super(NotebookMountStorage, __self__).__init__(
            'huaweicloud:ModelArts/notebookMountStorage:NotebookMountStorage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            local_mount_directory: Optional[pulumi.Input[str]] = None,
            mount_id: Optional[pulumi.Input[str]] = None,
            notebook_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            storage_path: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'NotebookMountStorage':
        """
        Get an existing NotebookMountStorage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] local_mount_directory: Specifies the local mount directory. Only the sub directory of `/data/`
               can be mounted. The format is : `/data/dir1/`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] mount_id: The mount ID.
        :param pulumi.Input[str] notebook_id: Specifies ID of notebook which the storage be mounted to.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: mount status. Valid values include: `MOUNTING`, `MOUNT_FAILED`, `MOUNTED`, `UNMOUNTING`,
               `UNMOUNT_FAILED`, `UNMOUNTED`.
        :param pulumi.Input[str] storage_path: Specifies the path of Parallel File System (PFS) or its folders in OBS.
               The format is : `obs://obs-bucket/folder/`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] type: The type of storage system.  The value is `OBSFS`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotebookMountStorageState.__new__(_NotebookMountStorageState)

        __props__.__dict__["local_mount_directory"] = local_mount_directory
        __props__.__dict__["mount_id"] = mount_id
        __props__.__dict__["notebook_id"] = notebook_id
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_path"] = storage_path
        __props__.__dict__["type"] = type
        return NotebookMountStorage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="localMountDirectory")
    def local_mount_directory(self) -> pulumi.Output[str]:
        """
        Specifies the local mount directory. Only the sub directory of `/data/`
        can be mounted. The format is : `/data/dir1/`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "local_mount_directory")

    @property
    @pulumi.getter(name="mountId")
    def mount_id(self) -> pulumi.Output[str]:
        """
        The mount ID.
        """
        return pulumi.get(self, "mount_id")

    @property
    @pulumi.getter(name="notebookId")
    def notebook_id(self) -> pulumi.Output[str]:
        """
        Specifies ID of notebook which the storage be mounted to.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "notebook_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        mount status. Valid values include: `MOUNTING`, `MOUNT_FAILED`, `MOUNTED`, `UNMOUNTING`,
        `UNMOUNT_FAILED`, `UNMOUNTED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storagePath")
    def storage_path(self) -> pulumi.Output[str]:
        """
        Specifies the path of Parallel File System (PFS) or its folders in OBS.
        The format is : `obs://obs-bucket/folder/`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "storage_path")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of storage system.  The value is `OBSFS`.
        """
        return pulumi.get(self, "type")

