# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DatasetDataSourceArgs',
    'DatasetLabelArgs',
    'DatasetLabelFormatArgs',
    'DatasetSchemaArgs',
    'NotebookMountStorageArgs',
    'NotebookVolumeArgs',
]

@pulumi.input_type
class DatasetDataSourceArgs:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 data_type: Optional[pulumi.Input[int]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 with_column_header: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] cluster_id: Specifies the cluster ID of DWS/MRS when `data_type` is `1` or `4`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] data_type: Specifies the type of data source. The options are as follows:
               + **0**: OBS.
               + **1**: GaussDB(DWS).
               + **2**: DLI.
               + **4**: MRS.
        :param pulumi.Input[str] database_name: Specifies the database name of DWS/DLI when `data_type` is `1` or `2`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] password: Specifies the password of database when `data_type` is `1`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] path: Specifies the OBS path when `data_type` is `0`
               or the hdsf path when `data_type` is `4`. All the file in this directory and subdirectories will be which be imported
               to the dataset. Changing this parameter will create a new resource.
        :param pulumi.Input[str] queue_name: Specifies the queue name of DLI when `data_type` is `2`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] table_name: Specifies the table name of DWS/DLI when `data_type` is `1` or `2`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] user_name: Specifies the user name of databse when `data_type` is `1`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] with_column_header: Specifies whether the data contains table header when the type
               of dataset is `400`(Table type). Default value is `true`. Changing this parameter will create a new resource.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if with_column_header is not None:
            pulumi.set(__self__, "with_column_header", with_column_header)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the cluster ID of DWS/MRS when `data_type` is `1` or `4`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the type of data source. The options are as follows:
        + **0**: OBS.
        + **1**: GaussDB(DWS).
        + **2**: DLI.
        + **4**: MRS.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database name of DWS/DLI when `data_type` is `1` or `2`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password of database when `data_type` is `1`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OBS path when `data_type` is `0`
        or the hdsf path when `data_type` is `4`. All the file in this directory and subdirectories will be which be imported
        to the dataset. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the queue name of DLI when `data_type` is `2`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the table name of DWS/DLI when `data_type` is `1` or `2`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user name of databse when `data_type` is `1`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="withColumnHeader")
    def with_column_header(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the data contains table header when the type
        of dataset is `400`(Table type). Default value is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "with_column_header")

    @with_column_header.setter
    def with_column_header(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_column_header", value)


@pulumi.input_type
class DatasetLabelArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 property_color: Optional[pulumi.Input[str]] = None,
                 property_shape: Optional[pulumi.Input[str]] = None,
                 property_shortcut: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Specifies the name of label.
        :param pulumi.Input[str] property_color: Specifies color of label.
        :param pulumi.Input[str] property_shape: Specifies shape of label. Valid values include: `bndbox`, `polygon`,
               `circle`, `line`, `dashed`, `point`, `polyline`.
        :param pulumi.Input[str] property_shortcut: Specifies shortcut of label.
        """
        pulumi.set(__self__, "name", name)
        if property_color is not None:
            pulumi.set(__self__, "property_color", property_color)
        if property_shape is not None:
            pulumi.set(__self__, "property_shape", property_shape)
        if property_shortcut is not None:
            pulumi.set(__self__, "property_shortcut", property_shortcut)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the name of label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="propertyColor")
    def property_color(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies color of label.
        """
        return pulumi.get(self, "property_color")

    @property_color.setter
    def property_color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property_color", value)

    @property
    @pulumi.getter(name="propertyShape")
    def property_shape(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies shape of label. Valid values include: `bndbox`, `polygon`,
        `circle`, `line`, `dashed`, `point`, `polyline`.
        """
        return pulumi.get(self, "property_shape")

    @property_shape.setter
    def property_shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property_shape", value)

    @property
    @pulumi.getter(name="propertyShortcut")
    def property_shortcut(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies shortcut of label.
        """
        return pulumi.get(self, "property_shortcut")

    @property_shortcut.setter
    def property_shortcut(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property_shortcut", value)


@pulumi.input_type
class DatasetLabelFormatArgs:
    def __init__(__self__, *,
                 label_separator: Optional[pulumi.Input[str]] = None,
                 text_label_separator: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] label_separator: Specifies the separator between label and label.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] text_label_separator: Specifies the separator between text and label.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] type: Specifies Label type for text classification.
               The optional values are as follows:
        """
        if label_separator is not None:
            pulumi.set(__self__, "label_separator", label_separator)
        if text_label_separator is not None:
            pulumi.set(__self__, "text_label_separator", text_label_separator)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="labelSeparator")
    def label_separator(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the separator between label and label.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "label_separator")

    @label_separator.setter
    def label_separator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label_separator", value)

    @property
    @pulumi.getter(name="textLabelSeparator")
    def text_label_separator(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the separator between text and label.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "text_label_separator")

    @text_label_separator.setter
    def text_label_separator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text_label_separator", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies Label type for text classification.
        The optional values are as follows:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DatasetSchemaArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: Specifies the name of label.
        :param pulumi.Input[str] type: Specifies Label type for text classification.
               The optional values are as follows:
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the name of label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies Label type for text classification.
        The optional values are as follows:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class NotebookMountStorageArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 mount_path: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The mount ID.
        :param pulumi.Input[str] mount_path: The local mount path.
        :param pulumi.Input[str] path: The path of storage which be mounted.
        :param pulumi.Input[str] status: The status of mount.
        :param pulumi.Input[str] type: Specifies the volume type. The options are as follows:
               - *EFS*: use Scalable File Service, default 50GB is **free**.
               - *EVS*: use Elastic Volume Service, default size is 5 GB.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The mount ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        The local mount path.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of storage which be mounted.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of mount.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the volume type. The options are as follows:
        - *EFS*: use Scalable File Service, default 50GB is **free**.
        - *EVS*: use Elastic Volume Service, default size is 5 GB.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class NotebookVolumeArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 mount_path: Optional[pulumi.Input[str]] = None,
                 ownership: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Specifies the volume type. The options are as follows:
               - *EFS*: use Scalable File Service, default 50GB is **free**.
               - *EVS*: use Elastic Volume Service, default size is 5 GB.
        :param pulumi.Input[str] mount_path: The local mount path.
        :param pulumi.Input[str] ownership: Specifies the volume ownership. The options are as follows:
               - *MANAGED*: shared storage disk of the ModelArts service.
               - *DEDICATED*: dedicated storage disk, only supported when the category is `EFS`.
        :param pulumi.Input[int] size: Specifies the volume size. Its value range is from 5 GB to 4096 GB.
        :param pulumi.Input[str] uri: Specifies the uri of dedicated storage disk, which is mandatory when the `type`
               is `EFS` and the `ownership` is `DEDICATED`. Example: `192.168.0.1:/user-9sfdsdgdfgh5ea4d56871e75d6966aa274/mount/`.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "type", type)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if ownership is not None:
            pulumi.set(__self__, "ownership", ownership)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the volume type. The options are as follows:
        - *EFS*: use Scalable File Service, default 50GB is **free**.
        - *EVS*: use Elastic Volume Service, default size is 5 GB.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        The local mount path.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter
    def ownership(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the volume ownership. The options are as follows:
        - *MANAGED*: shared storage disk of the ModelArts service.
        - *DEDICATED*: dedicated storage disk, only supported when the category is `EFS`.
        """
        return pulumi.get(self, "ownership")

    @ownership.setter
    def ownership(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ownership", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the volume size. Its value range is from 5 GB to 4096 GB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the uri of dedicated storage disk, which is mandatory when the `type`
        is `EFS` and the `ownership` is `DEDICATED`. Example: `192.168.0.1:/user-9sfdsdgdfgh5ea4d56871e75d6966aa274/mount/`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


