# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 account: Optional[pulumi.Input[str]] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 account_password: Optional[pulumi.Input[str]] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 app_key: Optional[pulumi.Input[str]] = None,
                 corp_id: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 department_code: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 english_name: Optional[pulumi.Input[str]] = None,
                 hide_phone: Optional[pulumi.Input[bool]] = None,
                 is_admin: Optional[pulumi.Input[bool]] = None,
                 is_send_notify: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 phone: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None,
                 sort_level: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[int]] = None,
                 third_account: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] password: Specifies the user password.
               The following conditions must be met:
               + **8** to **32** characters
               + It cannot be consistent with the positive and reverse order of the `account` parameter.
               + Contains at least two character types: lowercase letters, uppercase letters, numbers, special characters
               (**`~!@#$%^&*()-_=+|[{}];:",'<.>/?**).
        :param pulumi.Input[str] account: Specifies the user account. The value can contain **1** to **64** characters.
               If omitted, the service will automatically generate a value.
        :param pulumi.Input[str] account_name: Specifies the (HUAWEI Cloud meeting) user account name to which the
               administrator belongs. Changing this parameter will create a new resource.
        :param pulumi.Input[str] account_password: Specifies the user password.
               Required if `account_name` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_id: Specifies the ID of the Third-party application.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_key: Specifies the Key information of the Third-party APP.
               Required if `app_id` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] corp_id: Specifies the corporation ID.
               Required if the application is used in multiple enterprises. Only availabe if `app_id` is set.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] country: Specifies the country to which the phone number belongs to.
        :param pulumi.Input[str] department_code: Specifies the department code. Defaults to **1** (Root department).
        :param pulumi.Input[str] description: Specifies the description. The value can contain **0** to **128** characters.
        :param pulumi.Input[str] email: Specifies the email address.
        :param pulumi.Input[str] english_name: Specifies the english name. The value can contain **0** to **64** characters.
        :param pulumi.Input[bool] hide_phone: Specifies whether to hide the phone number.
        :param pulumi.Input[bool] is_admin: Specifies whether to send email and SMS notifications for account opening.
               Defaults to **true**.
        :param pulumi.Input[bool] is_send_notify: Specifies whether to send email and SMS notifications for account opening.
               Defaults to **true**.
        :param pulumi.Input[str] name: Specifies the user name. The value can contain **1** to **64** characters.
        :param pulumi.Input[str] phone: Specifies the phone number.
               The phone number must start with a country (region) code.
        :param pulumi.Input[str] signature: Specifies the signature. The value can contain **0** to **512** characters.
        :param pulumi.Input[int] sort_level: Specifies the address book sorting level.
               The lower the serial number, the higher the priority.
               The valid value is range from **1** to **10000**. Defaults to **10000**.
        :param pulumi.Input[int] status: Specifies the status. The valid values are as follows:
               + **0**: Normal.
               + **1**: Disable.
        :param pulumi.Input[str] third_account: Specifies the third-party account name.
        :param pulumi.Input[str] title: Specifies the title name. The value can contain **0** to **32** characters.
        :param pulumi.Input[str] user_id: Specifies the user ID of the administrator.
               Only availabe if `app_id` is set. If omitted, the user ID of default administrator will be used.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "password", password)
        if account is not None:
            pulumi.set(__self__, "account", account)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if account_password is not None:
            pulumi.set(__self__, "account_password", account_password)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_key is not None:
            pulumi.set(__self__, "app_key", app_key)
        if corp_id is not None:
            pulumi.set(__self__, "corp_id", corp_id)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if department_code is not None:
            pulumi.set(__self__, "department_code", department_code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if english_name is not None:
            pulumi.set(__self__, "english_name", english_name)
        if hide_phone is not None:
            pulumi.set(__self__, "hide_phone", hide_phone)
        if is_admin is not None:
            pulumi.set(__self__, "is_admin", is_admin)
        if is_send_notify is not None:
            pulumi.set(__self__, "is_send_notify", is_send_notify)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if phone is not None:
            pulumi.set(__self__, "phone", phone)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)
        if sort_level is not None:
            pulumi.set(__self__, "sort_level", sort_level)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if third_account is not None:
            pulumi.set(__self__, "third_account", third_account)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Specifies the user password.
        The following conditions must be met:
        + **8** to **32** characters
        + It cannot be consistent with the positive and reverse order of the `account` parameter.
        + Contains at least two character types: lowercase letters, uppercase letters, numbers, special characters
        (**`~!@#$%^&*()-_=+|[{}];:",'<.>/?**).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user account. The value can contain **1** to **64** characters.
        If omitted, the service will automatically generate a value.
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the (HUAWEI Cloud meeting) user account name to which the
        administrator belongs. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user password.
        Required if `account_name` is set. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_password", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the Third-party application.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Key information of the Third-party APP.
        Required if `app_id` is set. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "app_key")

    @app_key.setter
    def app_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_key", value)

    @property
    @pulumi.getter(name="corpId")
    def corp_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the corporation ID.
        Required if the application is used in multiple enterprises. Only availabe if `app_id` is set.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "corp_id")

    @corp_id.setter
    def corp_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "corp_id", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the country to which the phone number belongs to.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="departmentCode")
    def department_code(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the department code. Defaults to **1** (Root department).
        """
        return pulumi.get(self, "department_code")

    @department_code.setter
    def department_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "department_code", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description. The value can contain **0** to **128** characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the email address.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="englishName")
    def english_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the english name. The value can contain **0** to **64** characters.
        """
        return pulumi.get(self, "english_name")

    @english_name.setter
    def english_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "english_name", value)

    @property
    @pulumi.getter(name="hidePhone")
    def hide_phone(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to hide the phone number.
        """
        return pulumi.get(self, "hide_phone")

    @hide_phone.setter
    def hide_phone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_phone", value)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to send email and SMS notifications for account opening.
        Defaults to **true**.
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_admin", value)

    @property
    @pulumi.getter(name="isSendNotify")
    def is_send_notify(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to send email and SMS notifications for account opening.
        Defaults to **true**.
        """
        return pulumi.get(self, "is_send_notify")

    @is_send_notify.setter
    def is_send_notify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_send_notify", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user name. The value can contain **1** to **64** characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def phone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the phone number.
        The phone number must start with a country (region) code.
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone", value)

    @property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the signature. The value can contain **0** to **512** characters.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature", value)

    @property
    @pulumi.getter(name="sortLevel")
    def sort_level(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the address book sorting level.
        The lower the serial number, the higher the priority.
        The valid value is range from **1** to **10000**. Defaults to **10000**.
        """
        return pulumi.get(self, "sort_level")

    @sort_level.setter
    def sort_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sort_level", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the status. The valid values are as follows:
        + **0**: Normal.
        + **1**: Disable.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="thirdAccount")
    def third_account(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the third-party account name.
        """
        return pulumi.get(self, "third_account")

    @third_account.setter
    def third_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "third_account", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the title name. The value can contain **0** to **32** characters.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user ID of the administrator.
        Only availabe if `app_id` is set. If omitted, the user ID of default administrator will be used.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 account: Optional[pulumi.Input[str]] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 account_password: Optional[pulumi.Input[str]] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 app_key: Optional[pulumi.Input[str]] = None,
                 corp_id: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 department_code: Optional[pulumi.Input[str]] = None,
                 department_name: Optional[pulumi.Input[str]] = None,
                 department_name_path: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 english_name: Optional[pulumi.Input[str]] = None,
                 hide_phone: Optional[pulumi.Input[bool]] = None,
                 is_admin: Optional[pulumi.Input[bool]] = None,
                 is_send_notify: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 phone: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None,
                 sip_number: Optional[pulumi.Input[str]] = None,
                 sort_level: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[int]] = None,
                 third_account: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[str] account: Specifies the user account. The value can contain **1** to **64** characters.
               If omitted, the service will automatically generate a value.
        :param pulumi.Input[str] account_name: Specifies the (HUAWEI Cloud meeting) user account name to which the
               administrator belongs. Changing this parameter will create a new resource.
        :param pulumi.Input[str] account_password: Specifies the user password.
               Required if `account_name` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_id: Specifies the ID of the Third-party application.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_key: Specifies the Key information of the Third-party APP.
               Required if `app_id` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] corp_id: Specifies the corporation ID.
               Required if the application is used in multiple enterprises. Only availabe if `app_id` is set.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] country: Specifies the country to which the phone number belongs to.
        :param pulumi.Input[str] department_code: Specifies the department code. Defaults to **1** (Root department).
        :param pulumi.Input[str] department_name: The department name.
        :param pulumi.Input[str] department_name_path: The department full name.
        :param pulumi.Input[str] description: Specifies the description. The value can contain **0** to **128** characters.
        :param pulumi.Input[str] email: Specifies the email address.
        :param pulumi.Input[str] english_name: Specifies the english name. The value can contain **0** to **64** characters.
        :param pulumi.Input[bool] hide_phone: Specifies whether to hide the phone number.
        :param pulumi.Input[bool] is_admin: Specifies whether to send email and SMS notifications for account opening.
               Defaults to **true**.
        :param pulumi.Input[bool] is_send_notify: Specifies whether to send email and SMS notifications for account opening.
               Defaults to **true**.
        :param pulumi.Input[str] name: Specifies the user name. The value can contain **1** to **64** characters.
        :param pulumi.Input[str] password: Specifies the user password.
               The following conditions must be met:
               + **8** to **32** characters
               + It cannot be consistent with the positive and reverse order of the `account` parameter.
               + Contains at least two character types: lowercase letters, uppercase letters, numbers, special characters
               (**`~!@#$%^&*()-_=+|[{}];:",'<.>/?**).
        :param pulumi.Input[str] phone: Specifies the phone number.
               The phone number must start with a country (region) code.
        :param pulumi.Input[str] signature: Specifies the signature. The value can contain **0** to **512** characters.
        :param pulumi.Input[str] sip_number: The SIP number.
        :param pulumi.Input[int] sort_level: Specifies the address book sorting level.
               The lower the serial number, the higher the priority.
               The valid value is range from **1** to **10000**. Defaults to **10000**.
        :param pulumi.Input[int] status: Specifies the status. The valid values are as follows:
               + **0**: Normal.
               + **1**: Disable.
        :param pulumi.Input[str] third_account: Specifies the third-party account name.
        :param pulumi.Input[str] title: Specifies the title name. The value can contain **0** to **32** characters.
        :param pulumi.Input[int] type: The user type.
               + **2**: Enterprise member account.
        :param pulumi.Input[str] user_id: Specifies the user ID of the administrator.
               Only availabe if `app_id` is set. If omitted, the user ID of default administrator will be used.
               Changing this parameter will create a new resource.
        """
        if account is not None:
            pulumi.set(__self__, "account", account)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if account_password is not None:
            pulumi.set(__self__, "account_password", account_password)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_key is not None:
            pulumi.set(__self__, "app_key", app_key)
        if corp_id is not None:
            pulumi.set(__self__, "corp_id", corp_id)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if department_code is not None:
            pulumi.set(__self__, "department_code", department_code)
        if department_name is not None:
            pulumi.set(__self__, "department_name", department_name)
        if department_name_path is not None:
            pulumi.set(__self__, "department_name_path", department_name_path)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if english_name is not None:
            pulumi.set(__self__, "english_name", english_name)
        if hide_phone is not None:
            pulumi.set(__self__, "hide_phone", hide_phone)
        if is_admin is not None:
            pulumi.set(__self__, "is_admin", is_admin)
        if is_send_notify is not None:
            pulumi.set(__self__, "is_send_notify", is_send_notify)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if phone is not None:
            pulumi.set(__self__, "phone", phone)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)
        if sip_number is not None:
            pulumi.set(__self__, "sip_number", sip_number)
        if sort_level is not None:
            pulumi.set(__self__, "sort_level", sort_level)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if third_account is not None:
            pulumi.set(__self__, "third_account", third_account)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user account. The value can contain **1** to **64** characters.
        If omitted, the service will automatically generate a value.
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the (HUAWEI Cloud meeting) user account name to which the
        administrator belongs. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user password.
        Required if `account_name` is set. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_password", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the Third-party application.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Key information of the Third-party APP.
        Required if `app_id` is set. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "app_key")

    @app_key.setter
    def app_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_key", value)

    @property
    @pulumi.getter(name="corpId")
    def corp_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the corporation ID.
        Required if the application is used in multiple enterprises. Only availabe if `app_id` is set.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "corp_id")

    @corp_id.setter
    def corp_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "corp_id", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the country to which the phone number belongs to.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="departmentCode")
    def department_code(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the department code. Defaults to **1** (Root department).
        """
        return pulumi.get(self, "department_code")

    @department_code.setter
    def department_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "department_code", value)

    @property
    @pulumi.getter(name="departmentName")
    def department_name(self) -> Optional[pulumi.Input[str]]:
        """
        The department name.
        """
        return pulumi.get(self, "department_name")

    @department_name.setter
    def department_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "department_name", value)

    @property
    @pulumi.getter(name="departmentNamePath")
    def department_name_path(self) -> Optional[pulumi.Input[str]]:
        """
        The department full name.
        """
        return pulumi.get(self, "department_name_path")

    @department_name_path.setter
    def department_name_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "department_name_path", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description. The value can contain **0** to **128** characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the email address.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="englishName")
    def english_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the english name. The value can contain **0** to **64** characters.
        """
        return pulumi.get(self, "english_name")

    @english_name.setter
    def english_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "english_name", value)

    @property
    @pulumi.getter(name="hidePhone")
    def hide_phone(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to hide the phone number.
        """
        return pulumi.get(self, "hide_phone")

    @hide_phone.setter
    def hide_phone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_phone", value)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to send email and SMS notifications for account opening.
        Defaults to **true**.
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_admin", value)

    @property
    @pulumi.getter(name="isSendNotify")
    def is_send_notify(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to send email and SMS notifications for account opening.
        Defaults to **true**.
        """
        return pulumi.get(self, "is_send_notify")

    @is_send_notify.setter
    def is_send_notify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_send_notify", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user name. The value can contain **1** to **64** characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user password.
        The following conditions must be met:
        + **8** to **32** characters
        + It cannot be consistent with the positive and reverse order of the `account` parameter.
        + Contains at least two character types: lowercase letters, uppercase letters, numbers, special characters
        (**`~!@#$%^&*()-_=+|[{}];:",'<.>/?**).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def phone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the phone number.
        The phone number must start with a country (region) code.
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone", value)

    @property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the signature. The value can contain **0** to **512** characters.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature", value)

    @property
    @pulumi.getter(name="sipNumber")
    def sip_number(self) -> Optional[pulumi.Input[str]]:
        """
        The SIP number.
        """
        return pulumi.get(self, "sip_number")

    @sip_number.setter
    def sip_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sip_number", value)

    @property
    @pulumi.getter(name="sortLevel")
    def sort_level(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the address book sorting level.
        The lower the serial number, the higher the priority.
        The valid value is range from **1** to **10000**. Defaults to **10000**.
        """
        return pulumi.get(self, "sort_level")

    @sort_level.setter
    def sort_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sort_level", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the status. The valid values are as follows:
        + **0**: Normal.
        + **1**: Disable.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="thirdAccount")
    def third_account(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the third-party account name.
        """
        return pulumi.get(self, "third_account")

    @third_account.setter
    def third_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "third_account", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the title name. The value can contain **0** to **32** characters.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[int]]:
        """
        The user type.
        + **2**: Enterprise member account.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user ID of the administrator.
        Only availabe if `app_id` is set. If omitted, the user ID of default administrator will be used.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[str]] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 account_password: Optional[pulumi.Input[str]] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 app_key: Optional[pulumi.Input[str]] = None,
                 corp_id: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 department_code: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 english_name: Optional[pulumi.Input[str]] = None,
                 hide_phone: Optional[pulumi.Input[bool]] = None,
                 is_admin: Optional[pulumi.Input[bool]] = None,
                 is_send_notify: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 phone: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None,
                 sort_level: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[int]] = None,
                 third_account: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a meeting user resource within HuaweiCloud.

        ## Example Usage
        ### Create a user using third-party application authorization and specifies the account parameters

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        app_id = config.require_object("appId")
        app_key = config.require_object("appKey")
        user_account = config.require_object("userAccount")
        third_account = config.require_object("thirdAccount")
        user_name = config.require_object("userName")
        user_password = config.require_object("userPassword")
        english_name = config.require_object("englishName")
        signature = config.require_object("signature")
        title = config.require_object("title")
        test = huaweicloud.meeting.User("test",
            app_id=app_id,
            app_key=app_key,
            account=user_account,
            third_account=third_account,
            password=user_password,
            country="chinaPR",
            description="Created by script",
            email="123456789@example.com",
            english_name=english_name,
            phone="+8612345678987",
            signature=signature,
            title=title,
            sort_level=5)
        ```
        ### Create a user using account authorization

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        account_name = config.require_object("accountName")
        account_password = config.require_object("accountPassword")
        user_name = config.require_object("userName")
        user_password = config.require_object("userPassword")
        english_name = config.require_object("englishName")
        signature = config.require_object("signature")
        title = config.require_object("title")
        test = huaweicloud.meeting.User("test",
            account_name=account_name,
            account_password=account_password,
            password=user_password,
            country="chinaPR",
            email="123456789@example.com",
            english_name=english_name,
            phone="+8612345678987",
            signature=signature,
            title=title,
            sort_level=5)
        ```
        ## Appendix

        <a name="phone_number_mapping"></a>
        The countries (or regions) and phone numbers mapping relationship supports:

        | Country Or Region | Country Code |
        | ---- | ---- |
        | chinaPR | +86 |
        | chinaHKG | +852|
        | chinaOMA | +853 |
        | chinaTPE | +886 |
        | BVl | +1284  |
        | Bolivia | +591 |
        | CZ | +420 |
        | GB | +245 |
        | SVGrenadines | +1784 |
        | TAT | +1868 |
        | UK | +44 |
        | afghanistan | +93 |
        | albania | +355 |
        | algeria | +213 |
        | andorra | +376 |
        | angola | +244 |
        | argentina | +54 |
        | armenia | +374 |
        | australia | +61 |
        | austria | +43 |
        | azerbaijan | +994 |
        | bahamas | +1242 |
        | bahrain | +973 |
        | bangladesh | +880 |
        | belarus | +375 |
        | belgium | +32 |
        | belize | +501 |
        | benin | +229 |
        | bosniaAndHerzegovina | +387 |
        | botswana | +267 |
        | brazil | +55 |
        | brunei | +673 |
        | bulgaria | +359 |
        | burkinaFaso | +226 |
        | burundi | +257 |
        | cambodia | +855 |
        | cameroon | +237 |
        | canada | +1 |
        | capeVerde | +238 |
        | caymanIslands | +1345 |
        | centralAfrican | +236 |
        | chad | +235 |
        | chile | +56 |
        | columbia | +57 |
        | comoros | +269 |
        | congoB | +242 |
        | congoJ | +243 |
        | costarica | +506 |
        | croatia | +385 |
        | curacao | +599 |
        | cyprus | +357 |
        | denmark | +45 |
        | djibouti | +253 |
        | dominica | +1809 |
        | ecuador | +593 |
        | egypt | +20 |
        | equatorialGuinea | +240 |
        | estonia | +372 |
        | finland | +358 |
        | france | +33 |
        | gabon | +241 |
        | gambia | +220 |
        | georgia | +995 |
        | germany | +49 |
        | ghana | +233 |
        | greece | +30 |
        | grenada | +1473 |
        | guatemala | +502 |
        | guinea | +224 |
        | guyana | +592 |
        | honduras | +504 |
        | hungary | +36 |
        | india | +91 |
        | indonesia | +62 |
        | iraq | +964 |
        | ireland | +353 |
        | israel | +972 |
        | italy | +39 |
        | ivoryCoast | +225 |
        | jamaica | +1876 |
        | japan | +81 |
        | jordan | +962 |
        | kazakhstan | +7 |
        | kenya | +254 |
        | kuwait | +965 |
        | kyrgyzstan | +996 |
        | laos | +856 |
        | latvia | +371 |
        | lebanon | +961 |
        | lesotho | +266 |
        | liberia | +231 |
        | libya | +218 |
        | lithuania | +370 |
        | luxembourg | +352 |
        | macedonia | +389 |
        | madagascar | +261 |
        | malawi | +265 |
        | malaysia | +60 |
        | maldives | +960 |
        | mali | +223 |
        | malta | +356 |
        | mauritania | +222 |
        | mauritius | +230 |
        | mexico | +52 |
        | moldova | +373 |
        | mongolia | +976 |
        | montenegro | +382  |
        | morocco | +212 |
        | mozambique | +258 |
        | myanmar | +95 |
        | namibia | +264 |
        | nepal | +977 |
        | netherlands | +31 |
        | newZealand | +64 |
        | nicaragua | +505 |
        | niger | +227 |
        | nigeria | +234 |
        | norway | +47 |
        | oman | +968 |
        | pakistan | +92 |
        | palestine | +970 |
        | panama | +507 |
        | papuaNewGuinea | +675 |
        | peru | +51 |
        | philippines | +63 |
        | poland | +48 |
        | portugal | +351 |
        | puertoRico | +1787 |
        | qatar | +974 |
        | romania | +40 |
        | russia | +7 |
        | rwanda | +250 |
        | saintMartin | +590 |
        | salvatore | +503 |
        | saudiArabia | +966 |
        | senegal | +221 |
        | serbia | +381 |
        | seychelles | +248 |
        | sierraLeone | +232 |
        | singapore | +65 |
        | slovakia | +421 |
        | slovenia | +386 |
        | somalia | +252 |
        | southAfrica | +27 |
        | southKorea | +82 |
        | spain | +34 |
        | sriLanka | +94 |
        | suriname | +597 |
        | swaziland | +268 |
        | sweden | +46 |
        | switzerland | +41 |
        | tajikistan | +992 |
        | tanzania | +255 |
        | thailand | +66 |
        | togo | +228 |
        | tunisia | +216 |
        | turkey | +90 |
        | turkmenistan | +993 |
        | uae | +971 |
        | uganda | +256 |
        | ukraine | +380 |
        | uruguay | +598 |
        | usa | +1 |
        | uzbekistan | +998 |
        | venezuela | +58 |
        | vietNam | +84 |
        | yemen | +967 |
        | zambia | +260 |
        | zimbabwe | +263 |

        ## Import

        Users can be imported using their `id` and authorization parameters, separated by slashes, e.g. Import a user and authenticated by account.

        ```sh
         $ pulumi import huaweicloud:Meeting/user:User test &ltid&gt/&ltaccount_name&gt/&ltaccount_password&gt
        ```

         Import a user and authenticated by `APP ID`/`APP Key`.

        ```sh
         $ pulumi import huaweicloud:Meeting/user:User test &ltid&gt/&ltapp_id&gt/&ltapp_key&gt/&ltcorp_id&gt/&ltuser_id&gt
        ```

         The slashes cannot be missing even corporation ID and user ID are empty. Note that some parameters do not support import due to missing API responses or privacy, such as `password`, `is_send_notify` and `is_admin`. You can ignore this change as below. resource "huaweicloud_meeting_user" "test" {

         ...

         lifecycle {

         ignore_changes = [

         password, is_send_notify,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account: Specifies the user account. The value can contain **1** to **64** characters.
               If omitted, the service will automatically generate a value.
        :param pulumi.Input[str] account_name: Specifies the (HUAWEI Cloud meeting) user account name to which the
               administrator belongs. Changing this parameter will create a new resource.
        :param pulumi.Input[str] account_password: Specifies the user password.
               Required if `account_name` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_id: Specifies the ID of the Third-party application.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_key: Specifies the Key information of the Third-party APP.
               Required if `app_id` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] corp_id: Specifies the corporation ID.
               Required if the application is used in multiple enterprises. Only availabe if `app_id` is set.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] country: Specifies the country to which the phone number belongs to.
        :param pulumi.Input[str] department_code: Specifies the department code. Defaults to **1** (Root department).
        :param pulumi.Input[str] description: Specifies the description. The value can contain **0** to **128** characters.
        :param pulumi.Input[str] email: Specifies the email address.
        :param pulumi.Input[str] english_name: Specifies the english name. The value can contain **0** to **64** characters.
        :param pulumi.Input[bool] hide_phone: Specifies whether to hide the phone number.
        :param pulumi.Input[bool] is_admin: Specifies whether to send email and SMS notifications for account opening.
               Defaults to **true**.
        :param pulumi.Input[bool] is_send_notify: Specifies whether to send email and SMS notifications for account opening.
               Defaults to **true**.
        :param pulumi.Input[str] name: Specifies the user name. The value can contain **1** to **64** characters.
        :param pulumi.Input[str] password: Specifies the user password.
               The following conditions must be met:
               + **8** to **32** characters
               + It cannot be consistent with the positive and reverse order of the `account` parameter.
               + Contains at least two character types: lowercase letters, uppercase letters, numbers, special characters
               (**`~!@#$%^&*()-_=+|[{}];:",'<.>/?**).
        :param pulumi.Input[str] phone: Specifies the phone number.
               The phone number must start with a country (region) code.
        :param pulumi.Input[str] signature: Specifies the signature. The value can contain **0** to **512** characters.
        :param pulumi.Input[int] sort_level: Specifies the address book sorting level.
               The lower the serial number, the higher the priority.
               The valid value is range from **1** to **10000**. Defaults to **10000**.
        :param pulumi.Input[int] status: Specifies the status. The valid values are as follows:
               + **0**: Normal.
               + **1**: Disable.
        :param pulumi.Input[str] third_account: Specifies the third-party account name.
        :param pulumi.Input[str] title: Specifies the title name. The value can contain **0** to **32** characters.
        :param pulumi.Input[str] user_id: Specifies the user ID of the administrator.
               Only availabe if `app_id` is set. If omitted, the user ID of default administrator will be used.
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a meeting user resource within HuaweiCloud.

        ## Example Usage
        ### Create a user using third-party application authorization and specifies the account parameters

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        app_id = config.require_object("appId")
        app_key = config.require_object("appKey")
        user_account = config.require_object("userAccount")
        third_account = config.require_object("thirdAccount")
        user_name = config.require_object("userName")
        user_password = config.require_object("userPassword")
        english_name = config.require_object("englishName")
        signature = config.require_object("signature")
        title = config.require_object("title")
        test = huaweicloud.meeting.User("test",
            app_id=app_id,
            app_key=app_key,
            account=user_account,
            third_account=third_account,
            password=user_password,
            country="chinaPR",
            description="Created by script",
            email="123456789@example.com",
            english_name=english_name,
            phone="+8612345678987",
            signature=signature,
            title=title,
            sort_level=5)
        ```
        ### Create a user using account authorization

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        account_name = config.require_object("accountName")
        account_password = config.require_object("accountPassword")
        user_name = config.require_object("userName")
        user_password = config.require_object("userPassword")
        english_name = config.require_object("englishName")
        signature = config.require_object("signature")
        title = config.require_object("title")
        test = huaweicloud.meeting.User("test",
            account_name=account_name,
            account_password=account_password,
            password=user_password,
            country="chinaPR",
            email="123456789@example.com",
            english_name=english_name,
            phone="+8612345678987",
            signature=signature,
            title=title,
            sort_level=5)
        ```
        ## Appendix

        <a name="phone_number_mapping"></a>
        The countries (or regions) and phone numbers mapping relationship supports:

        | Country Or Region | Country Code |
        | ---- | ---- |
        | chinaPR | +86 |
        | chinaHKG | +852|
        | chinaOMA | +853 |
        | chinaTPE | +886 |
        | BVl | +1284  |
        | Bolivia | +591 |
        | CZ | +420 |
        | GB | +245 |
        | SVGrenadines | +1784 |
        | TAT | +1868 |
        | UK | +44 |
        | afghanistan | +93 |
        | albania | +355 |
        | algeria | +213 |
        | andorra | +376 |
        | angola | +244 |
        | argentina | +54 |
        | armenia | +374 |
        | australia | +61 |
        | austria | +43 |
        | azerbaijan | +994 |
        | bahamas | +1242 |
        | bahrain | +973 |
        | bangladesh | +880 |
        | belarus | +375 |
        | belgium | +32 |
        | belize | +501 |
        | benin | +229 |
        | bosniaAndHerzegovina | +387 |
        | botswana | +267 |
        | brazil | +55 |
        | brunei | +673 |
        | bulgaria | +359 |
        | burkinaFaso | +226 |
        | burundi | +257 |
        | cambodia | +855 |
        | cameroon | +237 |
        | canada | +1 |
        | capeVerde | +238 |
        | caymanIslands | +1345 |
        | centralAfrican | +236 |
        | chad | +235 |
        | chile | +56 |
        | columbia | +57 |
        | comoros | +269 |
        | congoB | +242 |
        | congoJ | +243 |
        | costarica | +506 |
        | croatia | +385 |
        | curacao | +599 |
        | cyprus | +357 |
        | denmark | +45 |
        | djibouti | +253 |
        | dominica | +1809 |
        | ecuador | +593 |
        | egypt | +20 |
        | equatorialGuinea | +240 |
        | estonia | +372 |
        | finland | +358 |
        | france | +33 |
        | gabon | +241 |
        | gambia | +220 |
        | georgia | +995 |
        | germany | +49 |
        | ghana | +233 |
        | greece | +30 |
        | grenada | +1473 |
        | guatemala | +502 |
        | guinea | +224 |
        | guyana | +592 |
        | honduras | +504 |
        | hungary | +36 |
        | india | +91 |
        | indonesia | +62 |
        | iraq | +964 |
        | ireland | +353 |
        | israel | +972 |
        | italy | +39 |
        | ivoryCoast | +225 |
        | jamaica | +1876 |
        | japan | +81 |
        | jordan | +962 |
        | kazakhstan | +7 |
        | kenya | +254 |
        | kuwait | +965 |
        | kyrgyzstan | +996 |
        | laos | +856 |
        | latvia | +371 |
        | lebanon | +961 |
        | lesotho | +266 |
        | liberia | +231 |
        | libya | +218 |
        | lithuania | +370 |
        | luxembourg | +352 |
        | macedonia | +389 |
        | madagascar | +261 |
        | malawi | +265 |
        | malaysia | +60 |
        | maldives | +960 |
        | mali | +223 |
        | malta | +356 |
        | mauritania | +222 |
        | mauritius | +230 |
        | mexico | +52 |
        | moldova | +373 |
        | mongolia | +976 |
        | montenegro | +382  |
        | morocco | +212 |
        | mozambique | +258 |
        | myanmar | +95 |
        | namibia | +264 |
        | nepal | +977 |
        | netherlands | +31 |
        | newZealand | +64 |
        | nicaragua | +505 |
        | niger | +227 |
        | nigeria | +234 |
        | norway | +47 |
        | oman | +968 |
        | pakistan | +92 |
        | palestine | +970 |
        | panama | +507 |
        | papuaNewGuinea | +675 |
        | peru | +51 |
        | philippines | +63 |
        | poland | +48 |
        | portugal | +351 |
        | puertoRico | +1787 |
        | qatar | +974 |
        | romania | +40 |
        | russia | +7 |
        | rwanda | +250 |
        | saintMartin | +590 |
        | salvatore | +503 |
        | saudiArabia | +966 |
        | senegal | +221 |
        | serbia | +381 |
        | seychelles | +248 |
        | sierraLeone | +232 |
        | singapore | +65 |
        | slovakia | +421 |
        | slovenia | +386 |
        | somalia | +252 |
        | southAfrica | +27 |
        | southKorea | +82 |
        | spain | +34 |
        | sriLanka | +94 |
        | suriname | +597 |
        | swaziland | +268 |
        | sweden | +46 |
        | switzerland | +41 |
        | tajikistan | +992 |
        | tanzania | +255 |
        | thailand | +66 |
        | togo | +228 |
        | tunisia | +216 |
        | turkey | +90 |
        | turkmenistan | +993 |
        | uae | +971 |
        | uganda | +256 |
        | ukraine | +380 |
        | uruguay | +598 |
        | usa | +1 |
        | uzbekistan | +998 |
        | venezuela | +58 |
        | vietNam | +84 |
        | yemen | +967 |
        | zambia | +260 |
        | zimbabwe | +263 |

        ## Import

        Users can be imported using their `id` and authorization parameters, separated by slashes, e.g. Import a user and authenticated by account.

        ```sh
         $ pulumi import huaweicloud:Meeting/user:User test &ltid&gt/&ltaccount_name&gt/&ltaccount_password&gt
        ```

         Import a user and authenticated by `APP ID`/`APP Key`.

        ```sh
         $ pulumi import huaweicloud:Meeting/user:User test &ltid&gt/&ltapp_id&gt/&ltapp_key&gt/&ltcorp_id&gt/&ltuser_id&gt
        ```

         The slashes cannot be missing even corporation ID and user ID are empty. Note that some parameters do not support import due to missing API responses or privacy, such as `password`, `is_send_notify` and `is_admin`. You can ignore this change as below. resource "huaweicloud_meeting_user" "test" {

         ...

         lifecycle {

         ignore_changes = [

         password, is_send_notify,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account: Optional[pulumi.Input[str]] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 account_password: Optional[pulumi.Input[str]] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 app_key: Optional[pulumi.Input[str]] = None,
                 corp_id: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 department_code: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 english_name: Optional[pulumi.Input[str]] = None,
                 hide_phone: Optional[pulumi.Input[bool]] = None,
                 is_admin: Optional[pulumi.Input[bool]] = None,
                 is_send_notify: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 phone: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None,
                 sort_level: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[int]] = None,
                 third_account: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["account"] = account
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["account_password"] = account_password
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["app_key"] = app_key
            __props__.__dict__["corp_id"] = corp_id
            __props__.__dict__["country"] = country
            __props__.__dict__["department_code"] = department_code
            __props__.__dict__["description"] = description
            __props__.__dict__["email"] = email
            __props__.__dict__["english_name"] = english_name
            __props__.__dict__["hide_phone"] = hide_phone
            __props__.__dict__["is_admin"] = is_admin
            __props__.__dict__["is_send_notify"] = is_send_notify
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            __props__.__dict__["phone"] = phone
            __props__.__dict__["signature"] = signature
            __props__.__dict__["sort_level"] = sort_level
            __props__.__dict__["status"] = status
            __props__.__dict__["third_account"] = third_account
            __props__.__dict__["title"] = title
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["department_name"] = None
            __props__.__dict__["department_name_path"] = None
            __props__.__dict__["sip_number"] = None
            __props__.__dict__["type"] = None
        super(User, __self__).__init__(
            'huaweicloud:Meeting/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account: Optional[pulumi.Input[str]] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            account_password: Optional[pulumi.Input[str]] = None,
            app_id: Optional[pulumi.Input[str]] = None,
            app_key: Optional[pulumi.Input[str]] = None,
            corp_id: Optional[pulumi.Input[str]] = None,
            country: Optional[pulumi.Input[str]] = None,
            department_code: Optional[pulumi.Input[str]] = None,
            department_name: Optional[pulumi.Input[str]] = None,
            department_name_path: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            english_name: Optional[pulumi.Input[str]] = None,
            hide_phone: Optional[pulumi.Input[bool]] = None,
            is_admin: Optional[pulumi.Input[bool]] = None,
            is_send_notify: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            phone: Optional[pulumi.Input[str]] = None,
            signature: Optional[pulumi.Input[str]] = None,
            sip_number: Optional[pulumi.Input[str]] = None,
            sort_level: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[int]] = None,
            third_account: Optional[pulumi.Input[str]] = None,
            title: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[int]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account: Specifies the user account. The value can contain **1** to **64** characters.
               If omitted, the service will automatically generate a value.
        :param pulumi.Input[str] account_name: Specifies the (HUAWEI Cloud meeting) user account name to which the
               administrator belongs. Changing this parameter will create a new resource.
        :param pulumi.Input[str] account_password: Specifies the user password.
               Required if `account_name` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_id: Specifies the ID of the Third-party application.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_key: Specifies the Key information of the Third-party APP.
               Required if `app_id` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] corp_id: Specifies the corporation ID.
               Required if the application is used in multiple enterprises. Only availabe if `app_id` is set.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] country: Specifies the country to which the phone number belongs to.
        :param pulumi.Input[str] department_code: Specifies the department code. Defaults to **1** (Root department).
        :param pulumi.Input[str] department_name: The department name.
        :param pulumi.Input[str] department_name_path: The department full name.
        :param pulumi.Input[str] description: Specifies the description. The value can contain **0** to **128** characters.
        :param pulumi.Input[str] email: Specifies the email address.
        :param pulumi.Input[str] english_name: Specifies the english name. The value can contain **0** to **64** characters.
        :param pulumi.Input[bool] hide_phone: Specifies whether to hide the phone number.
        :param pulumi.Input[bool] is_admin: Specifies whether to send email and SMS notifications for account opening.
               Defaults to **true**.
        :param pulumi.Input[bool] is_send_notify: Specifies whether to send email and SMS notifications for account opening.
               Defaults to **true**.
        :param pulumi.Input[str] name: Specifies the user name. The value can contain **1** to **64** characters.
        :param pulumi.Input[str] password: Specifies the user password.
               The following conditions must be met:
               + **8** to **32** characters
               + It cannot be consistent with the positive and reverse order of the `account` parameter.
               + Contains at least two character types: lowercase letters, uppercase letters, numbers, special characters
               (**`~!@#$%^&*()-_=+|[{}];:",'<.>/?**).
        :param pulumi.Input[str] phone: Specifies the phone number.
               The phone number must start with a country (region) code.
        :param pulumi.Input[str] signature: Specifies the signature. The value can contain **0** to **512** characters.
        :param pulumi.Input[str] sip_number: The SIP number.
        :param pulumi.Input[int] sort_level: Specifies the address book sorting level.
               The lower the serial number, the higher the priority.
               The valid value is range from **1** to **10000**. Defaults to **10000**.
        :param pulumi.Input[int] status: Specifies the status. The valid values are as follows:
               + **0**: Normal.
               + **1**: Disable.
        :param pulumi.Input[str] third_account: Specifies the third-party account name.
        :param pulumi.Input[str] title: Specifies the title name. The value can contain **0** to **32** characters.
        :param pulumi.Input[int] type: The user type.
               + **2**: Enterprise member account.
        :param pulumi.Input[str] user_id: Specifies the user ID of the administrator.
               Only availabe if `app_id` is set. If omitted, the user ID of default administrator will be used.
               Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["account"] = account
        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["account_password"] = account_password
        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["app_key"] = app_key
        __props__.__dict__["corp_id"] = corp_id
        __props__.__dict__["country"] = country
        __props__.__dict__["department_code"] = department_code
        __props__.__dict__["department_name"] = department_name
        __props__.__dict__["department_name_path"] = department_name_path
        __props__.__dict__["description"] = description
        __props__.__dict__["email"] = email
        __props__.__dict__["english_name"] = english_name
        __props__.__dict__["hide_phone"] = hide_phone
        __props__.__dict__["is_admin"] = is_admin
        __props__.__dict__["is_send_notify"] = is_send_notify
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["phone"] = phone
        __props__.__dict__["signature"] = signature
        __props__.__dict__["sip_number"] = sip_number
        __props__.__dict__["sort_level"] = sort_level
        __props__.__dict__["status"] = status
        __props__.__dict__["third_account"] = third_account
        __props__.__dict__["title"] = title
        __props__.__dict__["type"] = type
        __props__.__dict__["user_id"] = user_id
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def account(self) -> pulumi.Output[str]:
        """
        Specifies the user account. The value can contain **1** to **64** characters.
        If omitted, the service will automatically generate a value.
        """
        return pulumi.get(self, "account")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the (HUAWEI Cloud meeting) user account name to which the
        administrator belongs. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the user password.
        Required if `account_name` is set. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "account_password")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ID of the Third-party application.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the Key information of the Third-party APP.
        Required if `app_id` is set. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "app_key")

    @property
    @pulumi.getter(name="corpId")
    def corp_id(self) -> pulumi.Output[str]:
        """
        Specifies the corporation ID.
        Required if the application is used in multiple enterprises. Only availabe if `app_id` is set.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "corp_id")

    @property
    @pulumi.getter
    def country(self) -> pulumi.Output[str]:
        """
        Specifies the country to which the phone number belongs to.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="departmentCode")
    def department_code(self) -> pulumi.Output[str]:
        """
        Specifies the department code. Defaults to **1** (Root department).
        """
        return pulumi.get(self, "department_code")

    @property
    @pulumi.getter(name="departmentName")
    def department_name(self) -> pulumi.Output[str]:
        """
        The department name.
        """
        return pulumi.get(self, "department_name")

    @property
    @pulumi.getter(name="departmentNamePath")
    def department_name_path(self) -> pulumi.Output[str]:
        """
        The department full name.
        """
        return pulumi.get(self, "department_name_path")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description. The value can contain **0** to **128** characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        Specifies the email address.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="englishName")
    def english_name(self) -> pulumi.Output[str]:
        """
        Specifies the english name. The value can contain **0** to **64** characters.
        """
        return pulumi.get(self, "english_name")

    @property
    @pulumi.getter(name="hidePhone")
    def hide_phone(self) -> pulumi.Output[bool]:
        """
        Specifies whether to hide the phone number.
        """
        return pulumi.get(self, "hide_phone")

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> pulumi.Output[bool]:
        """
        Specifies whether to send email and SMS notifications for account opening.
        Defaults to **true**.
        """
        return pulumi.get(self, "is_admin")

    @property
    @pulumi.getter(name="isSendNotify")
    def is_send_notify(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to send email and SMS notifications for account opening.
        Defaults to **true**.
        """
        return pulumi.get(self, "is_send_notify")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the user name. The value can contain **1** to **64** characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Specifies the user password.
        The following conditions must be met:
        + **8** to **32** characters
        + It cannot be consistent with the positive and reverse order of the `account` parameter.
        + Contains at least two character types: lowercase letters, uppercase letters, numbers, special characters
        (**`~!@#$%^&*()-_=+|[{}];:",'<.>/?**).
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def phone(self) -> pulumi.Output[str]:
        """
        Specifies the phone number.
        The phone number must start with a country (region) code.
        """
        return pulumi.get(self, "phone")

    @property
    @pulumi.getter
    def signature(self) -> pulumi.Output[str]:
        """
        Specifies the signature. The value can contain **0** to **512** characters.
        """
        return pulumi.get(self, "signature")

    @property
    @pulumi.getter(name="sipNumber")
    def sip_number(self) -> pulumi.Output[str]:
        """
        The SIP number.
        """
        return pulumi.get(self, "sip_number")

    @property
    @pulumi.getter(name="sortLevel")
    def sort_level(self) -> pulumi.Output[int]:
        """
        Specifies the address book sorting level.
        The lower the serial number, the higher the priority.
        The valid value is range from **1** to **10000**. Defaults to **10000**.
        """
        return pulumi.get(self, "sort_level")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[int]:
        """
        Specifies the status. The valid values are as follows:
        + **0**: Normal.
        + **1**: Disable.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="thirdAccount")
    def third_account(self) -> pulumi.Output[str]:
        """
        Specifies the third-party account name.
        """
        return pulumi.get(self, "third_account")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        Specifies the title name. The value can contain **0** to **32** characters.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[int]:
        """
        The user type.
        + **2**: Enterprise member account.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        Specifies the user ID of the administrator.
        Only availabe if `app_id` is set. If omitted, the user ID of default administrator will be used.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "user_id")

