# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConferenceArgs', 'Conference']

@pulumi.input_type
class ConferenceArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[int],
                 meeting_room_id: pulumi.Input[str],
                 topic: pulumi.Input[str],
                 account_name: Optional[pulumi.Input[str]] = None,
                 account_password: Optional[pulumi.Input[str]] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 app_key: Optional[pulumi.Input[str]] = None,
                 aux_address: Optional[pulumi.Input[str]] = None,
                 configuration: Optional[pulumi.Input['ConferenceConfigurationArgs']] = None,
                 corp_id: Optional[pulumi.Input[str]] = None,
                 cycle_params: Optional[pulumi.Input['ConferenceCycleParamsArgs']] = None,
                 encrypt_mode: Optional[pulumi.Input[int]] = None,
                 is_auto_record: Optional[pulumi.Input[int]] = None,
                 is_record_aux_stream: Optional[pulumi.Input[int]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 live_address: Optional[pulumi.Input[str]] = None,
                 media_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 participant_number: Optional[pulumi.Input[int]] = None,
                 participants: Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceParticipantArgs']]]] = None,
                 record_auth_type: Optional[pulumi.Input[int]] = None,
                 record_type: Optional[pulumi.Input[int]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 timezone_id: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Conference resource.
        :param pulumi.Input[int] duration: Specifies the duration of the conference, in minutes.
               The valid value is range from `15` to `1440`, defaults to `30`.
        :param pulumi.Input[str] meeting_room_id: Specifies the cloud meeting room ID.
        :param pulumi.Input[str] topic: Specifies the conference topic. The topic can contain `1` to `128` characters.
        :param pulumi.Input[str] account_name: Specifies the (HUAWEI Cloud meeting) user account name to which the
               meeting initiator belongs. Changing this parameter will create a new resource.
        :param pulumi.Input[str] account_password: Specifies the user password.
               Required if `account_name` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_id: Specifies the ID of the Third-party application.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_key: Specifies the Key information of the Third-party APP.
               Required if `app_id` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] aux_address: Specifies the auxiliary streaming address, the maximum length is 255 characters.
               Only availabe if `record_type` is **2** or **3**.
        :param pulumi.Input['ConferenceConfigurationArgs'] configuration: Specifies the other conference configurations.
               The object structure is documented below.
        :param pulumi.Input[str] corp_id: Specifies the corporation ID.
               Required if the application is used in multiple enterprises. Only availabe if `app_id` is set.
               Changing this parameter will create a new resource.
        :param pulumi.Input['ConferenceCycleParamsArgs'] cycle_params: Specifies the configurations of the cyclical conference.
               The object structure is documented below.
        :param pulumi.Input[int] encrypt_mode: Specifies the conference media encryption mode.
               **0**: Adaptive encryption.
               **1**: Force encryption.
               **2**: Do not encrypt.
        :param pulumi.Input[int] is_auto_record: Specifies whether the conference automatically starts recording, it only takes
               effect when the recording type is:
               + **1**: Automatically start recording.
               + **0**: Do not start recording automatically.
        :param pulumi.Input[int] is_record_aux_stream: Specifies whether to record auxiliary stream.
               + **0**: Do not record.
               + **1**: Record.
        :param pulumi.Input[str] language: Specifies the default language of the conference, the default value is defined by the
               conference cloud service. For languages supported by the system, it is passed according to the RFC3066 specification.
               The valid values are as follows:
               + **zh-CN**: Simplified Chinese.
               + **en-US**: US English.
        :param pulumi.Input[str] live_address: Specifies the mainstream live broadcast address, with a maximum of 255 characters.
               Only availabe if `record_type` is **2** or **3**.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] media_types: Specifies the conference media type list.
               It consists of one or more enumerations, and the valid values are as follows:
               + **Voice**: Voice.
               + **Video**: SD video.
               + **HDVideo**: High-definition video (mutually exclusive with Video, if Video and HDVideo are selected at the same
               time, the system will select Video by default).
               + **Data**: Multimedia (If omitted, the system configuration will determines whether to automatically add **Data**).
        :param pulumi.Input[int] participant_number: Specifies the number of parties in the conference, the maximum number of
               participants in the conference. Defaults to **0** (Unlimited).
        :param pulumi.Input[Sequence[pulumi.Input['ConferenceParticipantArgs']]] participants: Specifies the attendee list.
               The object structure is documented below.
        :param pulumi.Input[int] record_auth_type: Specifies the recording authentication method.
               **0**: Viewable/downloadable via link.
               **1**: Enterprise users can watch/download.
               **2**: Attendees can watch/download.
        :param pulumi.Input[int] record_type: Specifies the recording type.
               + **0**: Disabled.
               + **1**: Live broadcast.
               + **2**: Record and broadcast.
               + **3**: Live + Recording.
        :param pulumi.Input[str] start_time: Specifies the conference start time (UTC time).
               The time format is `YYYY-MM-DD hh:mm`, e.g. `2006-01-02 15:04`.
               There is no need to set if you book a cyclical conference.
        :param pulumi.Input[int] timezone_id: Specifies the time zone information of the conference time in the conference
               notification. For time zone information, refer to the time zone mapping relationship.
        :param pulumi.Input[str] user_id: Specifies the user ID of the participant.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "meeting_room_id", meeting_room_id)
        pulumi.set(__self__, "topic", topic)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if account_password is not None:
            pulumi.set(__self__, "account_password", account_password)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_key is not None:
            pulumi.set(__self__, "app_key", app_key)
        if aux_address is not None:
            pulumi.set(__self__, "aux_address", aux_address)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if corp_id is not None:
            pulumi.set(__self__, "corp_id", corp_id)
        if cycle_params is not None:
            pulumi.set(__self__, "cycle_params", cycle_params)
        if encrypt_mode is not None:
            pulumi.set(__self__, "encrypt_mode", encrypt_mode)
        if is_auto_record is not None:
            pulumi.set(__self__, "is_auto_record", is_auto_record)
        if is_record_aux_stream is not None:
            pulumi.set(__self__, "is_record_aux_stream", is_record_aux_stream)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if live_address is not None:
            pulumi.set(__self__, "live_address", live_address)
        if media_types is not None:
            pulumi.set(__self__, "media_types", media_types)
        if participant_number is not None:
            pulumi.set(__self__, "participant_number", participant_number)
        if participants is not None:
            pulumi.set(__self__, "participants", participants)
        if record_auth_type is not None:
            pulumi.set(__self__, "record_auth_type", record_auth_type)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if timezone_id is not None:
            pulumi.set(__self__, "timezone_id", timezone_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[int]:
        """
        Specifies the duration of the conference, in minutes.
        The valid value is range from `15` to `1440`, defaults to `30`.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[int]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="meetingRoomId")
    def meeting_room_id(self) -> pulumi.Input[str]:
        """
        Specifies the cloud meeting room ID.
        """
        return pulumi.get(self, "meeting_room_id")

    @meeting_room_id.setter
    def meeting_room_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "meeting_room_id", value)

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Input[str]:
        """
        Specifies the conference topic. The topic can contain `1` to `128` characters.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the (HUAWEI Cloud meeting) user account name to which the
        meeting initiator belongs. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user password.
        Required if `account_name` is set. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_password", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the Third-party application.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Key information of the Third-party APP.
        Required if `app_id` is set. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "app_key")

    @app_key.setter
    def app_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_key", value)

    @property
    @pulumi.getter(name="auxAddress")
    def aux_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the auxiliary streaming address, the maximum length is 255 characters.
        Only availabe if `record_type` is **2** or **3**.
        """
        return pulumi.get(self, "aux_address")

    @aux_address.setter
    def aux_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aux_address", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['ConferenceConfigurationArgs']]:
        """
        Specifies the other conference configurations.
        The object structure is documented below.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['ConferenceConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="corpId")
    def corp_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the corporation ID.
        Required if the application is used in multiple enterprises. Only availabe if `app_id` is set.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "corp_id")

    @corp_id.setter
    def corp_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "corp_id", value)

    @property
    @pulumi.getter(name="cycleParams")
    def cycle_params(self) -> Optional[pulumi.Input['ConferenceCycleParamsArgs']]:
        """
        Specifies the configurations of the cyclical conference.
        The object structure is documented below.
        """
        return pulumi.get(self, "cycle_params")

    @cycle_params.setter
    def cycle_params(self, value: Optional[pulumi.Input['ConferenceCycleParamsArgs']]):
        pulumi.set(self, "cycle_params", value)

    @property
    @pulumi.getter(name="encryptMode")
    def encrypt_mode(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the conference media encryption mode.
        **0**: Adaptive encryption.
        **1**: Force encryption.
        **2**: Do not encrypt.
        """
        return pulumi.get(self, "encrypt_mode")

    @encrypt_mode.setter
    def encrypt_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "encrypt_mode", value)

    @property
    @pulumi.getter(name="isAutoRecord")
    def is_auto_record(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether the conference automatically starts recording, it only takes
        effect when the recording type is:
        + **1**: Automatically start recording.
        + **0**: Do not start recording automatically.
        """
        return pulumi.get(self, "is_auto_record")

    @is_auto_record.setter
    def is_auto_record(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "is_auto_record", value)

    @property
    @pulumi.getter(name="isRecordAuxStream")
    def is_record_aux_stream(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether to record auxiliary stream.
        + **0**: Do not record.
        + **1**: Record.
        """
        return pulumi.get(self, "is_record_aux_stream")

    @is_record_aux_stream.setter
    def is_record_aux_stream(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "is_record_aux_stream", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the default language of the conference, the default value is defined by the
        conference cloud service. For languages supported by the system, it is passed according to the RFC3066 specification.
        The valid values are as follows:
        + **zh-CN**: Simplified Chinese.
        + **en-US**: US English.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="liveAddress")
    def live_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the mainstream live broadcast address, with a maximum of 255 characters.
        Only availabe if `record_type` is **2** or **3**.
        """
        return pulumi.get(self, "live_address")

    @live_address.setter
    def live_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "live_address", value)

    @property
    @pulumi.getter(name="mediaTypes")
    def media_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the conference media type list.
        It consists of one or more enumerations, and the valid values are as follows:
        + **Voice**: Voice.
        + **Video**: SD video.
        + **HDVideo**: High-definition video (mutually exclusive with Video, if Video and HDVideo are selected at the same
        time, the system will select Video by default).
        + **Data**: Multimedia (If omitted, the system configuration will determines whether to automatically add **Data**).
        """
        return pulumi.get(self, "media_types")

    @media_types.setter
    def media_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "media_types", value)

    @property
    @pulumi.getter(name="participantNumber")
    def participant_number(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of parties in the conference, the maximum number of
        participants in the conference. Defaults to **0** (Unlimited).
        """
        return pulumi.get(self, "participant_number")

    @participant_number.setter
    def participant_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "participant_number", value)

    @property
    @pulumi.getter
    def participants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceParticipantArgs']]]]:
        """
        Specifies the attendee list.
        The object structure is documented below.
        """
        return pulumi.get(self, "participants")

    @participants.setter
    def participants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceParticipantArgs']]]]):
        pulumi.set(self, "participants", value)

    @property
    @pulumi.getter(name="recordAuthType")
    def record_auth_type(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the recording authentication method.
        **0**: Viewable/downloadable via link.
        **1**: Enterprise users can watch/download.
        **2**: Attendees can watch/download.
        """
        return pulumi.get(self, "record_auth_type")

    @record_auth_type.setter
    def record_auth_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "record_auth_type", value)

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the recording type.
        + **0**: Disabled.
        + **1**: Live broadcast.
        + **2**: Record and broadcast.
        + **3**: Live + Recording.
        """
        return pulumi.get(self, "record_type")

    @record_type.setter
    def record_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "record_type", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the conference start time (UTC time).
        The time format is `YYYY-MM-DD hh:mm`, e.g. `2006-01-02 15:04`.
        There is no need to set if you book a cyclical conference.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="timezoneId")
    def timezone_id(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the time zone information of the conference time in the conference
        notification. For time zone information, refer to the time zone mapping relationship.
        """
        return pulumi.get(self, "timezone_id")

    @timezone_id.setter
    def timezone_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timezone_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user ID of the participant.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _ConferenceState:
    def __init__(__self__, *,
                 access_number: Optional[pulumi.Input[str]] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 account_password: Optional[pulumi.Input[str]] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 app_key: Optional[pulumi.Input[str]] = None,
                 audience_join_uri: Optional[pulumi.Input[str]] = None,
                 aux_address: Optional[pulumi.Input[str]] = None,
                 chair_join_uri: Optional[pulumi.Input[str]] = None,
                 conference_type: Optional[pulumi.Input[str]] = None,
                 conference_uuid: Optional[pulumi.Input[str]] = None,
                 configuration: Optional[pulumi.Input['ConferenceConfigurationArgs']] = None,
                 corp_id: Optional[pulumi.Input[str]] = None,
                 cycle_params: Optional[pulumi.Input['ConferenceCycleParamsArgs']] = None,
                 duration: Optional[pulumi.Input[int]] = None,
                 encrypt_mode: Optional[pulumi.Input[int]] = None,
                 guest_join_uri: Optional[pulumi.Input[str]] = None,
                 is_auto_record: Optional[pulumi.Input[int]] = None,
                 is_record_aux_stream: Optional[pulumi.Input[int]] = None,
                 join_passwords: Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceJoinPasswordArgs']]]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 live_address: Optional[pulumi.Input[str]] = None,
                 media_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 meeting_room_id: Optional[pulumi.Input[str]] = None,
                 participant_number: Optional[pulumi.Input[int]] = None,
                 participants: Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceParticipantArgs']]]] = None,
                 record_auth_type: Optional[pulumi.Input[int]] = None,
                 record_type: Optional[pulumi.Input[int]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subconferences: Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceSubconferenceArgs']]]] = None,
                 timezone_id: Optional[pulumi.Input[int]] = None,
                 topic: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Conference resources.
        :param pulumi.Input[str] access_number: The access number of the conference.
        :param pulumi.Input[str] account_name: Specifies the (HUAWEI Cloud meeting) user account name to which the
               meeting initiator belongs. Changing this parameter will create a new resource.
        :param pulumi.Input[str] account_password: Specifies the user password.
               Required if `account_name` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_id: Specifies the ID of the Third-party application.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_key: Specifies the Key information of the Third-party APP.
               Required if `app_id` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] audience_join_uri: The audience meeting link address.
        :param pulumi.Input[str] aux_address: Specifies the auxiliary streaming address, the maximum length is 255 characters.
               Only availabe if `record_type` is **2** or **3**.
        :param pulumi.Input[str] chair_join_uri: The host meeting link address.
        :param pulumi.Input[str] conference_type: The conference type, the valid values are as follows:
               + **FUTURE**
               + **IMMEDIATELY**
               + **CYCLE**
        :param pulumi.Input[str] conference_uuid: The conference UUID.
        :param pulumi.Input['ConferenceConfigurationArgs'] configuration: Specifies the other conference configurations.
               The object structure is documented below.
        :param pulumi.Input[str] corp_id: Specifies the corporation ID.
               Required if the application is used in multiple enterprises. Only availabe if `app_id` is set.
               Changing this parameter will create a new resource.
        :param pulumi.Input['ConferenceCycleParamsArgs'] cycle_params: Specifies the configurations of the cyclical conference.
               The object structure is documented below.
        :param pulumi.Input[int] duration: Specifies the duration of the conference, in minutes.
               The valid value is range from `15` to `1440`, defaults to `30`.
        :param pulumi.Input[int] encrypt_mode: Specifies the conference media encryption mode.
               **0**: Adaptive encryption.
               **1**: Force encryption.
               **2**: Do not encrypt.
        :param pulumi.Input[str] guest_join_uri: The common attendee meeting link address.
        :param pulumi.Input[int] is_auto_record: Specifies whether the conference automatically starts recording, it only takes
               effect when the recording type is:
               + **1**: Automatically start recording.
               + **0**: Do not start recording automatically.
        :param pulumi.Input[int] is_record_aux_stream: Specifies whether to record auxiliary stream.
               + **0**: Do not record.
               + **1**: Record.
        :param pulumi.Input[str] language: Specifies the default language of the conference, the default value is defined by the
               conference cloud service. For languages supported by the system, it is passed according to the RFC3066 specification.
               The valid values are as follows:
               + **zh-CN**: Simplified Chinese.
               + **en-US**: US English.
        :param pulumi.Input[str] live_address: Specifies the mainstream live broadcast address, with a maximum of 255 characters.
               Only availabe if `record_type` is **2** or **3**.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] media_types: Specifies the conference media type list.
               It consists of one or more enumerations, and the valid values are as follows:
               + **Voice**: Voice.
               + **Video**: SD video.
               + **HDVideo**: High-definition video (mutually exclusive with Video, if Video and HDVideo are selected at the same
               time, the system will select Video by default).
               + **Data**: Multimedia (If omitted, the system configuration will determines whether to automatically add **Data**).
        :param pulumi.Input[str] meeting_room_id: Specifies the cloud meeting room ID.
        :param pulumi.Input[int] participant_number: Specifies the number of parties in the conference, the maximum number of
               participants in the conference. Defaults to **0** (Unlimited).
        :param pulumi.Input[Sequence[pulumi.Input['ConferenceParticipantArgs']]] participants: Specifies the attendee list.
               The object structure is documented below.
        :param pulumi.Input[int] record_auth_type: Specifies the recording authentication method.
               **0**: Viewable/downloadable via link.
               **1**: Enterprise users can watch/download.
               **2**: Attendees can watch/download.
        :param pulumi.Input[int] record_type: Specifies the recording type.
               + **0**: Disabled.
               + **1**: Live broadcast.
               + **2**: Record and broadcast.
               + **3**: Live + Recording.
        :param pulumi.Input[str] start_time: Specifies the conference start time (UTC time).
               The time format is `YYYY-MM-DD hh:mm`, e.g. `2006-01-02 15:04`.
               There is no need to set if you book a cyclical conference.
        :param pulumi.Input[str] status: The conference status, the valid values are as follows:
               + **Schedule**: the conference is in schedule.
               + **Created**: The conference is in progress.
        :param pulumi.Input[Sequence[pulumi.Input['ConferenceSubconferenceArgs']]] subconferences: The list of periodic sub-conferences.
               The object structure is documented below.
        :param pulumi.Input[int] timezone_id: Specifies the time zone information of the conference time in the conference
               notification. For time zone information, refer to the time zone mapping relationship.
        :param pulumi.Input[str] topic: Specifies the conference topic. The topic can contain `1` to `128` characters.
        :param pulumi.Input[str] user_id: Specifies the user ID of the participant.
        """
        if access_number is not None:
            pulumi.set(__self__, "access_number", access_number)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if account_password is not None:
            pulumi.set(__self__, "account_password", account_password)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_key is not None:
            pulumi.set(__self__, "app_key", app_key)
        if audience_join_uri is not None:
            pulumi.set(__self__, "audience_join_uri", audience_join_uri)
        if aux_address is not None:
            pulumi.set(__self__, "aux_address", aux_address)
        if chair_join_uri is not None:
            pulumi.set(__self__, "chair_join_uri", chair_join_uri)
        if conference_type is not None:
            pulumi.set(__self__, "conference_type", conference_type)
        if conference_uuid is not None:
            pulumi.set(__self__, "conference_uuid", conference_uuid)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if corp_id is not None:
            pulumi.set(__self__, "corp_id", corp_id)
        if cycle_params is not None:
            pulumi.set(__self__, "cycle_params", cycle_params)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if encrypt_mode is not None:
            pulumi.set(__self__, "encrypt_mode", encrypt_mode)
        if guest_join_uri is not None:
            pulumi.set(__self__, "guest_join_uri", guest_join_uri)
        if is_auto_record is not None:
            pulumi.set(__self__, "is_auto_record", is_auto_record)
        if is_record_aux_stream is not None:
            pulumi.set(__self__, "is_record_aux_stream", is_record_aux_stream)
        if join_passwords is not None:
            pulumi.set(__self__, "join_passwords", join_passwords)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if live_address is not None:
            pulumi.set(__self__, "live_address", live_address)
        if media_types is not None:
            pulumi.set(__self__, "media_types", media_types)
        if meeting_room_id is not None:
            pulumi.set(__self__, "meeting_room_id", meeting_room_id)
        if participant_number is not None:
            pulumi.set(__self__, "participant_number", participant_number)
        if participants is not None:
            pulumi.set(__self__, "participants", participants)
        if record_auth_type is not None:
            pulumi.set(__self__, "record_auth_type", record_auth_type)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subconferences is not None:
            pulumi.set(__self__, "subconferences", subconferences)
        if timezone_id is not None:
            pulumi.set(__self__, "timezone_id", timezone_id)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessNumber")
    def access_number(self) -> Optional[pulumi.Input[str]]:
        """
        The access number of the conference.
        """
        return pulumi.get(self, "access_number")

    @access_number.setter
    def access_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_number", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the (HUAWEI Cloud meeting) user account name to which the
        meeting initiator belongs. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user password.
        Required if `account_name` is set. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_password", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the Third-party application.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Key information of the Third-party APP.
        Required if `app_id` is set. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "app_key")

    @app_key.setter
    def app_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_key", value)

    @property
    @pulumi.getter(name="audienceJoinUri")
    def audience_join_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The audience meeting link address.
        """
        return pulumi.get(self, "audience_join_uri")

    @audience_join_uri.setter
    def audience_join_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audience_join_uri", value)

    @property
    @pulumi.getter(name="auxAddress")
    def aux_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the auxiliary streaming address, the maximum length is 255 characters.
        Only availabe if `record_type` is **2** or **3**.
        """
        return pulumi.get(self, "aux_address")

    @aux_address.setter
    def aux_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aux_address", value)

    @property
    @pulumi.getter(name="chairJoinUri")
    def chair_join_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The host meeting link address.
        """
        return pulumi.get(self, "chair_join_uri")

    @chair_join_uri.setter
    def chair_join_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chair_join_uri", value)

    @property
    @pulumi.getter(name="conferenceType")
    def conference_type(self) -> Optional[pulumi.Input[str]]:
        """
        The conference type, the valid values are as follows:
        + **FUTURE**
        + **IMMEDIATELY**
        + **CYCLE**
        """
        return pulumi.get(self, "conference_type")

    @conference_type.setter
    def conference_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "conference_type", value)

    @property
    @pulumi.getter(name="conferenceUuid")
    def conference_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        The conference UUID.
        """
        return pulumi.get(self, "conference_uuid")

    @conference_uuid.setter
    def conference_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "conference_uuid", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['ConferenceConfigurationArgs']]:
        """
        Specifies the other conference configurations.
        The object structure is documented below.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['ConferenceConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="corpId")
    def corp_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the corporation ID.
        Required if the application is used in multiple enterprises. Only availabe if `app_id` is set.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "corp_id")

    @corp_id.setter
    def corp_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "corp_id", value)

    @property
    @pulumi.getter(name="cycleParams")
    def cycle_params(self) -> Optional[pulumi.Input['ConferenceCycleParamsArgs']]:
        """
        Specifies the configurations of the cyclical conference.
        The object structure is documented below.
        """
        return pulumi.get(self, "cycle_params")

    @cycle_params.setter
    def cycle_params(self, value: Optional[pulumi.Input['ConferenceCycleParamsArgs']]):
        pulumi.set(self, "cycle_params", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the duration of the conference, in minutes.
        The valid value is range from `15` to `1440`, defaults to `30`.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="encryptMode")
    def encrypt_mode(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the conference media encryption mode.
        **0**: Adaptive encryption.
        **1**: Force encryption.
        **2**: Do not encrypt.
        """
        return pulumi.get(self, "encrypt_mode")

    @encrypt_mode.setter
    def encrypt_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "encrypt_mode", value)

    @property
    @pulumi.getter(name="guestJoinUri")
    def guest_join_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The common attendee meeting link address.
        """
        return pulumi.get(self, "guest_join_uri")

    @guest_join_uri.setter
    def guest_join_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "guest_join_uri", value)

    @property
    @pulumi.getter(name="isAutoRecord")
    def is_auto_record(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether the conference automatically starts recording, it only takes
        effect when the recording type is:
        + **1**: Automatically start recording.
        + **0**: Do not start recording automatically.
        """
        return pulumi.get(self, "is_auto_record")

    @is_auto_record.setter
    def is_auto_record(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "is_auto_record", value)

    @property
    @pulumi.getter(name="isRecordAuxStream")
    def is_record_aux_stream(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies whether to record auxiliary stream.
        + **0**: Do not record.
        + **1**: Record.
        """
        return pulumi.get(self, "is_record_aux_stream")

    @is_record_aux_stream.setter
    def is_record_aux_stream(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "is_record_aux_stream", value)

    @property
    @pulumi.getter(name="joinPasswords")
    def join_passwords(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceJoinPasswordArgs']]]]:
        return pulumi.get(self, "join_passwords")

    @join_passwords.setter
    def join_passwords(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceJoinPasswordArgs']]]]):
        pulumi.set(self, "join_passwords", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the default language of the conference, the default value is defined by the
        conference cloud service. For languages supported by the system, it is passed according to the RFC3066 specification.
        The valid values are as follows:
        + **zh-CN**: Simplified Chinese.
        + **en-US**: US English.
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="liveAddress")
    def live_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the mainstream live broadcast address, with a maximum of 255 characters.
        Only availabe if `record_type` is **2** or **3**.
        """
        return pulumi.get(self, "live_address")

    @live_address.setter
    def live_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "live_address", value)

    @property
    @pulumi.getter(name="mediaTypes")
    def media_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the conference media type list.
        It consists of one or more enumerations, and the valid values are as follows:
        + **Voice**: Voice.
        + **Video**: SD video.
        + **HDVideo**: High-definition video (mutually exclusive with Video, if Video and HDVideo are selected at the same
        time, the system will select Video by default).
        + **Data**: Multimedia (If omitted, the system configuration will determines whether to automatically add **Data**).
        """
        return pulumi.get(self, "media_types")

    @media_types.setter
    def media_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "media_types", value)

    @property
    @pulumi.getter(name="meetingRoomId")
    def meeting_room_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the cloud meeting room ID.
        """
        return pulumi.get(self, "meeting_room_id")

    @meeting_room_id.setter
    def meeting_room_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "meeting_room_id", value)

    @property
    @pulumi.getter(name="participantNumber")
    def participant_number(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of parties in the conference, the maximum number of
        participants in the conference. Defaults to **0** (Unlimited).
        """
        return pulumi.get(self, "participant_number")

    @participant_number.setter
    def participant_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "participant_number", value)

    @property
    @pulumi.getter
    def participants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceParticipantArgs']]]]:
        """
        Specifies the attendee list.
        The object structure is documented below.
        """
        return pulumi.get(self, "participants")

    @participants.setter
    def participants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceParticipantArgs']]]]):
        pulumi.set(self, "participants", value)

    @property
    @pulumi.getter(name="recordAuthType")
    def record_auth_type(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the recording authentication method.
        **0**: Viewable/downloadable via link.
        **1**: Enterprise users can watch/download.
        **2**: Attendees can watch/download.
        """
        return pulumi.get(self, "record_auth_type")

    @record_auth_type.setter
    def record_auth_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "record_auth_type", value)

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the recording type.
        + **0**: Disabled.
        + **1**: Live broadcast.
        + **2**: Record and broadcast.
        + **3**: Live + Recording.
        """
        return pulumi.get(self, "record_type")

    @record_type.setter
    def record_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "record_type", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the conference start time (UTC time).
        The time format is `YYYY-MM-DD hh:mm`, e.g. `2006-01-02 15:04`.
        There is no need to set if you book a cyclical conference.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The conference status, the valid values are as follows:
        + **Schedule**: the conference is in schedule.
        + **Created**: The conference is in progress.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def subconferences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceSubconferenceArgs']]]]:
        """
        The list of periodic sub-conferences.
        The object structure is documented below.
        """
        return pulumi.get(self, "subconferences")

    @subconferences.setter
    def subconferences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConferenceSubconferenceArgs']]]]):
        pulumi.set(self, "subconferences", value)

    @property
    @pulumi.getter(name="timezoneId")
    def timezone_id(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the time zone information of the conference time in the conference
        notification. For time zone information, refer to the time zone mapping relationship.
        """
        return pulumi.get(self, "timezone_id")

    @timezone_id.setter
    def timezone_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timezone_id", value)

    @property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the conference topic. The topic can contain `1` to `128` characters.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user ID of the participant.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)


class Conference(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 account_password: Optional[pulumi.Input[str]] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 app_key: Optional[pulumi.Input[str]] = None,
                 aux_address: Optional[pulumi.Input[str]] = None,
                 configuration: Optional[pulumi.Input[pulumi.InputType['ConferenceConfigurationArgs']]] = None,
                 corp_id: Optional[pulumi.Input[str]] = None,
                 cycle_params: Optional[pulumi.Input[pulumi.InputType['ConferenceCycleParamsArgs']]] = None,
                 duration: Optional[pulumi.Input[int]] = None,
                 encrypt_mode: Optional[pulumi.Input[int]] = None,
                 is_auto_record: Optional[pulumi.Input[int]] = None,
                 is_record_aux_stream: Optional[pulumi.Input[int]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 live_address: Optional[pulumi.Input[str]] = None,
                 media_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 meeting_room_id: Optional[pulumi.Input[str]] = None,
                 participant_number: Optional[pulumi.Input[int]] = None,
                 participants: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConferenceParticipantArgs']]]]] = None,
                 record_auth_type: Optional[pulumi.Input[int]] = None,
                 record_type: Optional[pulumi.Input[int]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 timezone_id: Optional[pulumi.Input[int]] = None,
                 topic: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ## Appendix

        <a name="time_zone_mapping"></a>
        The time zone mapping relationship supports:

        | Timezone ID | Timezone |
        | ---- | ---- |
        | 1 | (GMT-12:00) Eniwetok, Kwajalein |
        | 2 | (GMT-11:00) Midway Island, Samoa |
        | 3 | (GMT-10:00) Hawaii |
        | 4 | (GMT-09:00) Alaska |
        | 5 | (GMT-08:00) Pacific Time(US&Canada);Tijuana |
        | 6 | (GMT-07:00) Arizona |
        | 7 | (GMT-07:00) Mountain Time(US&Canada) |
        | 8 | (GMT-06:00) Central America |
        | 9 | (GMT-06:00) Central Time(US&Canada) |
        | 10 | (GMT-06:00) Mexico City |
        | 11 | (GMT-06:00) Saskatchewan |
        | 12 | (GMT-05:00) Bogota, Lima, Quito |
        | 13 | (GMT-05:00) Eastern Time(US&Canada) |
        | 14 | (GMT-05:00) Indiana(East) |
        | 15 | (GMT-04:00) Atlantic time(Canada) |
        | 16 | (GMT-04:00) Caracas, La Paz |
        | 17 | (GMT-04:00) Santiago |
        | 18 | (GMT-03:30) Newfoundland |
        | 19 | (GMT-03:00) Brasilia |
        | 20 | (GMT-03:00) Buenos Aires, Georgetown |
        | 21 | (GMT-03:00) Greenland |
        | 22 | (GMT-02:00) Mid-Atlantic |
        | 23 | (GMT-01:00) Azores |
        | 24 | (GMT-01:00) Cape Verde Is. |
        | 25 | (GMT) Casablanca, Monrovia |
        | 26 | (GMT) Greenwich Mean Time:Dublin, Edinburgh, Lisbon, London |
        | 27 | (GMT+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna |
        | 28 | (GMT+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague |
        | 29 | (GMT+01:00) Brussels, Copenhagen, Madrid, Paris |
        | 30 | (GMT+01:00) Sarajevo, Skopje, Sofija, Warsaw, Zagreb |
        | 31 | (GMT+01:00) West Central Africa |
        | 32 | (GMT+02:00) Athens, Istanbul, Vilnius |
        | 33 | (GMT+02:00) Bucharest |
        | 34 | (GMT+02:00) Cairo |
        | 35 | (GMT+02:00) Harare, Pretoria |
        | 36 | (GMT+02:00) Helsinki, Riga, Tallinn |
        | 37 | (GMT+02:00) Jerusalem |
        | 38 | (GMT+03:00) Baghdad, Minsk |
        | 39 | (GMT+03:00) Kuwait, Riyadh |
        | 40 | (GMT+03:00) Moscow, St. Petersburg, Volgograd |
        | 41 | (GMT+03:00) Nairobi |
        | 42 | (GMT+03:30) Tehran |
        | 43 | (GMT+04:00) Abu Dhabi, Muscat |
        | 44 | (GMT+04:00) Baku, Tbilisi, Yerevan |
        | 45 | (GMT+04:30) Kabul |
        | 46 | (GMT+05:00) Ekaterinburg |
        | 47 | (GMT+05:00) Islamabad, Karachi, Tashkent |
        | 48 | (GMT+05:30) Calcutta, Chennai, Mumbai, New Delhi |
        | 49 | (GMT+05:45) Kathmandu |
        | 50 | (GMT+06:00) Almaty, Novosibirsk |
        | 51 | (GMT+06:00) Astana, Dhaka |
        | 52 | (GMT+06:00) Sri Jayawardenepura |
        | 53 | (GMT+06:30) Rangoon |
        | 54 | (GMT+07:00) Bangkok, Hanoi, Jakarta |
        | 55 | (GMT+07:00) Krasnoyarsk |
        | 56 | (GMT+08:00) Beijing, Chongqing, Hong Kong, Urumqi, Taipei |
        | 57 | (GMT+08:00) Irkutsk, Ulaan Bataar |
        | 58 | (GMT+08:00) Kuala Lumpur, Singapore |
        | 59 | (GMT+08:00) Perth |
        | 60 | (GMT+09:00) Osaka, Sapporo, Tokyo |
        | 61 | (GMT+09:00) Seoul |
        | 62 | (GMT+09:00) Yakutsk |
        | 63 | (GMT+09:30) Adelaide |
        | 64 | (GMT+09:30) Darwin |
        | 65 | (GMT+10:00) Brisbane |
        | 66 | (GMT+10:00) Canberra, Melbourne, Sydney |
        | 67 | (GMT+10:00) Guam, Port Moresby |
        | 68 | (GMT+10:00) Hobart |
        | 69 | (GMT+10:00) Vladivostok |
        | 70 | (GMT+11:00) Magadan, Solomon Is., New Caledonia |
        | 71 | (GMT+12:00) Auckland, Welington |
        | 72 | (GMT+12:00) Fiji |
        | 73 | (GMT+13:00) Nuku'alofa |
        | 74 | (GMT+09:00) Irkutsk |
        | 75 | (GMT) Casablanca |
        | 76 | (GMT+04:00) Baku |
        | 77 | (GMT+12:00) Kamchatka, Marshall Is. |

        ## Import

        Conferences (only scheduled conference and progressing conference) can be imported using their `id` and authorization parameters, separated by slashes, e.g. Import a conference and authenticated by account.

        ```sh
         $ pulumi import huaweicloud:Meeting/conference:Conference test &ltid&gt/&ltaccount_name&gt/&ltaccount_password&gt
        ```

         Import a conference and authenticated by `APP ID`/`APP Key`.

        ```sh
         $ pulumi import huaweicloud:Meeting/conference:Conference test &ltid&gt/&ltapp_id&gt/&ltapp_key&gt/&ltcorp_id&gt/&ltuser_id&gt
        ```

         The slashes cannot be missing even corporation ID and user ID are empty. Note that importing is not supported for expired conferences and the start time of the meeting is not imported along with it. You can ignore this change as below. resource "huaweicloud_meeting_conference" "test" {

         ...

         lifecycle {

         ignore_changes = [

         start_time,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: Specifies the (HUAWEI Cloud meeting) user account name to which the
               meeting initiator belongs. Changing this parameter will create a new resource.
        :param pulumi.Input[str] account_password: Specifies the user password.
               Required if `account_name` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_id: Specifies the ID of the Third-party application.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_key: Specifies the Key information of the Third-party APP.
               Required if `app_id` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] aux_address: Specifies the auxiliary streaming address, the maximum length is 255 characters.
               Only availabe if `record_type` is **2** or **3**.
        :param pulumi.Input[pulumi.InputType['ConferenceConfigurationArgs']] configuration: Specifies the other conference configurations.
               The object structure is documented below.
        :param pulumi.Input[str] corp_id: Specifies the corporation ID.
               Required if the application is used in multiple enterprises. Only availabe if `app_id` is set.
               Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['ConferenceCycleParamsArgs']] cycle_params: Specifies the configurations of the cyclical conference.
               The object structure is documented below.
        :param pulumi.Input[int] duration: Specifies the duration of the conference, in minutes.
               The valid value is range from `15` to `1440`, defaults to `30`.
        :param pulumi.Input[int] encrypt_mode: Specifies the conference media encryption mode.
               **0**: Adaptive encryption.
               **1**: Force encryption.
               **2**: Do not encrypt.
        :param pulumi.Input[int] is_auto_record: Specifies whether the conference automatically starts recording, it only takes
               effect when the recording type is:
               + **1**: Automatically start recording.
               + **0**: Do not start recording automatically.
        :param pulumi.Input[int] is_record_aux_stream: Specifies whether to record auxiliary stream.
               + **0**: Do not record.
               + **1**: Record.
        :param pulumi.Input[str] language: Specifies the default language of the conference, the default value is defined by the
               conference cloud service. For languages supported by the system, it is passed according to the RFC3066 specification.
               The valid values are as follows:
               + **zh-CN**: Simplified Chinese.
               + **en-US**: US English.
        :param pulumi.Input[str] live_address: Specifies the mainstream live broadcast address, with a maximum of 255 characters.
               Only availabe if `record_type` is **2** or **3**.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] media_types: Specifies the conference media type list.
               It consists of one or more enumerations, and the valid values are as follows:
               + **Voice**: Voice.
               + **Video**: SD video.
               + **HDVideo**: High-definition video (mutually exclusive with Video, if Video and HDVideo are selected at the same
               time, the system will select Video by default).
               + **Data**: Multimedia (If omitted, the system configuration will determines whether to automatically add **Data**).
        :param pulumi.Input[str] meeting_room_id: Specifies the cloud meeting room ID.
        :param pulumi.Input[int] participant_number: Specifies the number of parties in the conference, the maximum number of
               participants in the conference. Defaults to **0** (Unlimited).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConferenceParticipantArgs']]]] participants: Specifies the attendee list.
               The object structure is documented below.
        :param pulumi.Input[int] record_auth_type: Specifies the recording authentication method.
               **0**: Viewable/downloadable via link.
               **1**: Enterprise users can watch/download.
               **2**: Attendees can watch/download.
        :param pulumi.Input[int] record_type: Specifies the recording type.
               + **0**: Disabled.
               + **1**: Live broadcast.
               + **2**: Record and broadcast.
               + **3**: Live + Recording.
        :param pulumi.Input[str] start_time: Specifies the conference start time (UTC time).
               The time format is `YYYY-MM-DD hh:mm`, e.g. `2006-01-02 15:04`.
               There is no need to set if you book a cyclical conference.
        :param pulumi.Input[int] timezone_id: Specifies the time zone information of the conference time in the conference
               notification. For time zone information, refer to the time zone mapping relationship.
        :param pulumi.Input[str] topic: Specifies the conference topic. The topic can contain `1` to `128` characters.
        :param pulumi.Input[str] user_id: Specifies the user ID of the participant.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConferenceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ## Appendix

        <a name="time_zone_mapping"></a>
        The time zone mapping relationship supports:

        | Timezone ID | Timezone |
        | ---- | ---- |
        | 1 | (GMT-12:00) Eniwetok, Kwajalein |
        | 2 | (GMT-11:00) Midway Island, Samoa |
        | 3 | (GMT-10:00) Hawaii |
        | 4 | (GMT-09:00) Alaska |
        | 5 | (GMT-08:00) Pacific Time(US&Canada);Tijuana |
        | 6 | (GMT-07:00) Arizona |
        | 7 | (GMT-07:00) Mountain Time(US&Canada) |
        | 8 | (GMT-06:00) Central America |
        | 9 | (GMT-06:00) Central Time(US&Canada) |
        | 10 | (GMT-06:00) Mexico City |
        | 11 | (GMT-06:00) Saskatchewan |
        | 12 | (GMT-05:00) Bogota, Lima, Quito |
        | 13 | (GMT-05:00) Eastern Time(US&Canada) |
        | 14 | (GMT-05:00) Indiana(East) |
        | 15 | (GMT-04:00) Atlantic time(Canada) |
        | 16 | (GMT-04:00) Caracas, La Paz |
        | 17 | (GMT-04:00) Santiago |
        | 18 | (GMT-03:30) Newfoundland |
        | 19 | (GMT-03:00) Brasilia |
        | 20 | (GMT-03:00) Buenos Aires, Georgetown |
        | 21 | (GMT-03:00) Greenland |
        | 22 | (GMT-02:00) Mid-Atlantic |
        | 23 | (GMT-01:00) Azores |
        | 24 | (GMT-01:00) Cape Verde Is. |
        | 25 | (GMT) Casablanca, Monrovia |
        | 26 | (GMT) Greenwich Mean Time:Dublin, Edinburgh, Lisbon, London |
        | 27 | (GMT+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna |
        | 28 | (GMT+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague |
        | 29 | (GMT+01:00) Brussels, Copenhagen, Madrid, Paris |
        | 30 | (GMT+01:00) Sarajevo, Skopje, Sofija, Warsaw, Zagreb |
        | 31 | (GMT+01:00) West Central Africa |
        | 32 | (GMT+02:00) Athens, Istanbul, Vilnius |
        | 33 | (GMT+02:00) Bucharest |
        | 34 | (GMT+02:00) Cairo |
        | 35 | (GMT+02:00) Harare, Pretoria |
        | 36 | (GMT+02:00) Helsinki, Riga, Tallinn |
        | 37 | (GMT+02:00) Jerusalem |
        | 38 | (GMT+03:00) Baghdad, Minsk |
        | 39 | (GMT+03:00) Kuwait, Riyadh |
        | 40 | (GMT+03:00) Moscow, St. Petersburg, Volgograd |
        | 41 | (GMT+03:00) Nairobi |
        | 42 | (GMT+03:30) Tehran |
        | 43 | (GMT+04:00) Abu Dhabi, Muscat |
        | 44 | (GMT+04:00) Baku, Tbilisi, Yerevan |
        | 45 | (GMT+04:30) Kabul |
        | 46 | (GMT+05:00) Ekaterinburg |
        | 47 | (GMT+05:00) Islamabad, Karachi, Tashkent |
        | 48 | (GMT+05:30) Calcutta, Chennai, Mumbai, New Delhi |
        | 49 | (GMT+05:45) Kathmandu |
        | 50 | (GMT+06:00) Almaty, Novosibirsk |
        | 51 | (GMT+06:00) Astana, Dhaka |
        | 52 | (GMT+06:00) Sri Jayawardenepura |
        | 53 | (GMT+06:30) Rangoon |
        | 54 | (GMT+07:00) Bangkok, Hanoi, Jakarta |
        | 55 | (GMT+07:00) Krasnoyarsk |
        | 56 | (GMT+08:00) Beijing, Chongqing, Hong Kong, Urumqi, Taipei |
        | 57 | (GMT+08:00) Irkutsk, Ulaan Bataar |
        | 58 | (GMT+08:00) Kuala Lumpur, Singapore |
        | 59 | (GMT+08:00) Perth |
        | 60 | (GMT+09:00) Osaka, Sapporo, Tokyo |
        | 61 | (GMT+09:00) Seoul |
        | 62 | (GMT+09:00) Yakutsk |
        | 63 | (GMT+09:30) Adelaide |
        | 64 | (GMT+09:30) Darwin |
        | 65 | (GMT+10:00) Brisbane |
        | 66 | (GMT+10:00) Canberra, Melbourne, Sydney |
        | 67 | (GMT+10:00) Guam, Port Moresby |
        | 68 | (GMT+10:00) Hobart |
        | 69 | (GMT+10:00) Vladivostok |
        | 70 | (GMT+11:00) Magadan, Solomon Is., New Caledonia |
        | 71 | (GMT+12:00) Auckland, Welington |
        | 72 | (GMT+12:00) Fiji |
        | 73 | (GMT+13:00) Nuku'alofa |
        | 74 | (GMT+09:00) Irkutsk |
        | 75 | (GMT) Casablanca |
        | 76 | (GMT+04:00) Baku |
        | 77 | (GMT+12:00) Kamchatka, Marshall Is. |

        ## Import

        Conferences (only scheduled conference and progressing conference) can be imported using their `id` and authorization parameters, separated by slashes, e.g. Import a conference and authenticated by account.

        ```sh
         $ pulumi import huaweicloud:Meeting/conference:Conference test &ltid&gt/&ltaccount_name&gt/&ltaccount_password&gt
        ```

         Import a conference and authenticated by `APP ID`/`APP Key`.

        ```sh
         $ pulumi import huaweicloud:Meeting/conference:Conference test &ltid&gt/&ltapp_id&gt/&ltapp_key&gt/&ltcorp_id&gt/&ltuser_id&gt
        ```

         The slashes cannot be missing even corporation ID and user ID are empty. Note that importing is not supported for expired conferences and the start time of the meeting is not imported along with it. You can ignore this change as below. resource "huaweicloud_meeting_conference" "test" {

         ...

         lifecycle {

         ignore_changes = [

         start_time,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param ConferenceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConferenceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 account_password: Optional[pulumi.Input[str]] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 app_key: Optional[pulumi.Input[str]] = None,
                 aux_address: Optional[pulumi.Input[str]] = None,
                 configuration: Optional[pulumi.Input[pulumi.InputType['ConferenceConfigurationArgs']]] = None,
                 corp_id: Optional[pulumi.Input[str]] = None,
                 cycle_params: Optional[pulumi.Input[pulumi.InputType['ConferenceCycleParamsArgs']]] = None,
                 duration: Optional[pulumi.Input[int]] = None,
                 encrypt_mode: Optional[pulumi.Input[int]] = None,
                 is_auto_record: Optional[pulumi.Input[int]] = None,
                 is_record_aux_stream: Optional[pulumi.Input[int]] = None,
                 language: Optional[pulumi.Input[str]] = None,
                 live_address: Optional[pulumi.Input[str]] = None,
                 media_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 meeting_room_id: Optional[pulumi.Input[str]] = None,
                 participant_number: Optional[pulumi.Input[int]] = None,
                 participants: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConferenceParticipantArgs']]]]] = None,
                 record_auth_type: Optional[pulumi.Input[int]] = None,
                 record_type: Optional[pulumi.Input[int]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 timezone_id: Optional[pulumi.Input[int]] = None,
                 topic: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConferenceArgs.__new__(ConferenceArgs)

            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["account_password"] = account_password
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["app_key"] = app_key
            __props__.__dict__["aux_address"] = aux_address
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["corp_id"] = corp_id
            __props__.__dict__["cycle_params"] = cycle_params
            if duration is None and not opts.urn:
                raise TypeError("Missing required property 'duration'")
            __props__.__dict__["duration"] = duration
            __props__.__dict__["encrypt_mode"] = encrypt_mode
            __props__.__dict__["is_auto_record"] = is_auto_record
            __props__.__dict__["is_record_aux_stream"] = is_record_aux_stream
            __props__.__dict__["language"] = language
            __props__.__dict__["live_address"] = live_address
            __props__.__dict__["media_types"] = media_types
            if meeting_room_id is None and not opts.urn:
                raise TypeError("Missing required property 'meeting_room_id'")
            __props__.__dict__["meeting_room_id"] = meeting_room_id
            __props__.__dict__["participant_number"] = participant_number
            __props__.__dict__["participants"] = participants
            __props__.__dict__["record_auth_type"] = record_auth_type
            __props__.__dict__["record_type"] = record_type
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["timezone_id"] = timezone_id
            if topic is None and not opts.urn:
                raise TypeError("Missing required property 'topic'")
            __props__.__dict__["topic"] = topic
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["access_number"] = None
            __props__.__dict__["audience_join_uri"] = None
            __props__.__dict__["chair_join_uri"] = None
            __props__.__dict__["conference_type"] = None
            __props__.__dict__["conference_uuid"] = None
            __props__.__dict__["guest_join_uri"] = None
            __props__.__dict__["join_passwords"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["subconferences"] = None
        super(Conference, __self__).__init__(
            'huaweicloud:Meeting/conference:Conference',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_number: Optional[pulumi.Input[str]] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            account_password: Optional[pulumi.Input[str]] = None,
            app_id: Optional[pulumi.Input[str]] = None,
            app_key: Optional[pulumi.Input[str]] = None,
            audience_join_uri: Optional[pulumi.Input[str]] = None,
            aux_address: Optional[pulumi.Input[str]] = None,
            chair_join_uri: Optional[pulumi.Input[str]] = None,
            conference_type: Optional[pulumi.Input[str]] = None,
            conference_uuid: Optional[pulumi.Input[str]] = None,
            configuration: Optional[pulumi.Input[pulumi.InputType['ConferenceConfigurationArgs']]] = None,
            corp_id: Optional[pulumi.Input[str]] = None,
            cycle_params: Optional[pulumi.Input[pulumi.InputType['ConferenceCycleParamsArgs']]] = None,
            duration: Optional[pulumi.Input[int]] = None,
            encrypt_mode: Optional[pulumi.Input[int]] = None,
            guest_join_uri: Optional[pulumi.Input[str]] = None,
            is_auto_record: Optional[pulumi.Input[int]] = None,
            is_record_aux_stream: Optional[pulumi.Input[int]] = None,
            join_passwords: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConferenceJoinPasswordArgs']]]]] = None,
            language: Optional[pulumi.Input[str]] = None,
            live_address: Optional[pulumi.Input[str]] = None,
            media_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            meeting_room_id: Optional[pulumi.Input[str]] = None,
            participant_number: Optional[pulumi.Input[int]] = None,
            participants: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConferenceParticipantArgs']]]]] = None,
            record_auth_type: Optional[pulumi.Input[int]] = None,
            record_type: Optional[pulumi.Input[int]] = None,
            start_time: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subconferences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConferenceSubconferenceArgs']]]]] = None,
            timezone_id: Optional[pulumi.Input[int]] = None,
            topic: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None) -> 'Conference':
        """
        Get an existing Conference resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_number: The access number of the conference.
        :param pulumi.Input[str] account_name: Specifies the (HUAWEI Cloud meeting) user account name to which the
               meeting initiator belongs. Changing this parameter will create a new resource.
        :param pulumi.Input[str] account_password: Specifies the user password.
               Required if `account_name` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_id: Specifies the ID of the Third-party application.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] app_key: Specifies the Key information of the Third-party APP.
               Required if `app_id` is set. Changing this parameter will create a new resource.
        :param pulumi.Input[str] audience_join_uri: The audience meeting link address.
        :param pulumi.Input[str] aux_address: Specifies the auxiliary streaming address, the maximum length is 255 characters.
               Only availabe if `record_type` is **2** or **3**.
        :param pulumi.Input[str] chair_join_uri: The host meeting link address.
        :param pulumi.Input[str] conference_type: The conference type, the valid values are as follows:
               + **FUTURE**
               + **IMMEDIATELY**
               + **CYCLE**
        :param pulumi.Input[str] conference_uuid: The conference UUID.
        :param pulumi.Input[pulumi.InputType['ConferenceConfigurationArgs']] configuration: Specifies the other conference configurations.
               The object structure is documented below.
        :param pulumi.Input[str] corp_id: Specifies the corporation ID.
               Required if the application is used in multiple enterprises. Only availabe if `app_id` is set.
               Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['ConferenceCycleParamsArgs']] cycle_params: Specifies the configurations of the cyclical conference.
               The object structure is documented below.
        :param pulumi.Input[int] duration: Specifies the duration of the conference, in minutes.
               The valid value is range from `15` to `1440`, defaults to `30`.
        :param pulumi.Input[int] encrypt_mode: Specifies the conference media encryption mode.
               **0**: Adaptive encryption.
               **1**: Force encryption.
               **2**: Do not encrypt.
        :param pulumi.Input[str] guest_join_uri: The common attendee meeting link address.
        :param pulumi.Input[int] is_auto_record: Specifies whether the conference automatically starts recording, it only takes
               effect when the recording type is:
               + **1**: Automatically start recording.
               + **0**: Do not start recording automatically.
        :param pulumi.Input[int] is_record_aux_stream: Specifies whether to record auxiliary stream.
               + **0**: Do not record.
               + **1**: Record.
        :param pulumi.Input[str] language: Specifies the default language of the conference, the default value is defined by the
               conference cloud service. For languages supported by the system, it is passed according to the RFC3066 specification.
               The valid values are as follows:
               + **zh-CN**: Simplified Chinese.
               + **en-US**: US English.
        :param pulumi.Input[str] live_address: Specifies the mainstream live broadcast address, with a maximum of 255 characters.
               Only availabe if `record_type` is **2** or **3**.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] media_types: Specifies the conference media type list.
               It consists of one or more enumerations, and the valid values are as follows:
               + **Voice**: Voice.
               + **Video**: SD video.
               + **HDVideo**: High-definition video (mutually exclusive with Video, if Video and HDVideo are selected at the same
               time, the system will select Video by default).
               + **Data**: Multimedia (If omitted, the system configuration will determines whether to automatically add **Data**).
        :param pulumi.Input[str] meeting_room_id: Specifies the cloud meeting room ID.
        :param pulumi.Input[int] participant_number: Specifies the number of parties in the conference, the maximum number of
               participants in the conference. Defaults to **0** (Unlimited).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConferenceParticipantArgs']]]] participants: Specifies the attendee list.
               The object structure is documented below.
        :param pulumi.Input[int] record_auth_type: Specifies the recording authentication method.
               **0**: Viewable/downloadable via link.
               **1**: Enterprise users can watch/download.
               **2**: Attendees can watch/download.
        :param pulumi.Input[int] record_type: Specifies the recording type.
               + **0**: Disabled.
               + **1**: Live broadcast.
               + **2**: Record and broadcast.
               + **3**: Live + Recording.
        :param pulumi.Input[str] start_time: Specifies the conference start time (UTC time).
               The time format is `YYYY-MM-DD hh:mm`, e.g. `2006-01-02 15:04`.
               There is no need to set if you book a cyclical conference.
        :param pulumi.Input[str] status: The conference status, the valid values are as follows:
               + **Schedule**: the conference is in schedule.
               + **Created**: The conference is in progress.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConferenceSubconferenceArgs']]]] subconferences: The list of periodic sub-conferences.
               The object structure is documented below.
        :param pulumi.Input[int] timezone_id: Specifies the time zone information of the conference time in the conference
               notification. For time zone information, refer to the time zone mapping relationship.
        :param pulumi.Input[str] topic: Specifies the conference topic. The topic can contain `1` to `128` characters.
        :param pulumi.Input[str] user_id: Specifies the user ID of the participant.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConferenceState.__new__(_ConferenceState)

        __props__.__dict__["access_number"] = access_number
        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["account_password"] = account_password
        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["app_key"] = app_key
        __props__.__dict__["audience_join_uri"] = audience_join_uri
        __props__.__dict__["aux_address"] = aux_address
        __props__.__dict__["chair_join_uri"] = chair_join_uri
        __props__.__dict__["conference_type"] = conference_type
        __props__.__dict__["conference_uuid"] = conference_uuid
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["corp_id"] = corp_id
        __props__.__dict__["cycle_params"] = cycle_params
        __props__.__dict__["duration"] = duration
        __props__.__dict__["encrypt_mode"] = encrypt_mode
        __props__.__dict__["guest_join_uri"] = guest_join_uri
        __props__.__dict__["is_auto_record"] = is_auto_record
        __props__.__dict__["is_record_aux_stream"] = is_record_aux_stream
        __props__.__dict__["join_passwords"] = join_passwords
        __props__.__dict__["language"] = language
        __props__.__dict__["live_address"] = live_address
        __props__.__dict__["media_types"] = media_types
        __props__.__dict__["meeting_room_id"] = meeting_room_id
        __props__.__dict__["participant_number"] = participant_number
        __props__.__dict__["participants"] = participants
        __props__.__dict__["record_auth_type"] = record_auth_type
        __props__.__dict__["record_type"] = record_type
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["status"] = status
        __props__.__dict__["subconferences"] = subconferences
        __props__.__dict__["timezone_id"] = timezone_id
        __props__.__dict__["topic"] = topic
        __props__.__dict__["user_id"] = user_id
        return Conference(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessNumber")
    def access_number(self) -> pulumi.Output[str]:
        """
        The access number of the conference.
        """
        return pulumi.get(self, "access_number")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the (HUAWEI Cloud meeting) user account name to which the
        meeting initiator belongs. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the user password.
        Required if `account_name` is set. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "account_password")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ID of the Third-party application.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the Key information of the Third-party APP.
        Required if `app_id` is set. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "app_key")

    @property
    @pulumi.getter(name="audienceJoinUri")
    def audience_join_uri(self) -> pulumi.Output[str]:
        """
        The audience meeting link address.
        """
        return pulumi.get(self, "audience_join_uri")

    @property
    @pulumi.getter(name="auxAddress")
    def aux_address(self) -> pulumi.Output[str]:
        """
        Specifies the auxiliary streaming address, the maximum length is 255 characters.
        Only availabe if `record_type` is **2** or **3**.
        """
        return pulumi.get(self, "aux_address")

    @property
    @pulumi.getter(name="chairJoinUri")
    def chair_join_uri(self) -> pulumi.Output[str]:
        """
        The host meeting link address.
        """
        return pulumi.get(self, "chair_join_uri")

    @property
    @pulumi.getter(name="conferenceType")
    def conference_type(self) -> pulumi.Output[str]:
        """
        The conference type, the valid values are as follows:
        + **FUTURE**
        + **IMMEDIATELY**
        + **CYCLE**
        """
        return pulumi.get(self, "conference_type")

    @property
    @pulumi.getter(name="conferenceUuid")
    def conference_uuid(self) -> pulumi.Output[str]:
        """
        The conference UUID.
        """
        return pulumi.get(self, "conference_uuid")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Optional['outputs.ConferenceConfiguration']]:
        """
        Specifies the other conference configurations.
        The object structure is documented below.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="corpId")
    def corp_id(self) -> pulumi.Output[str]:
        """
        Specifies the corporation ID.
        Required if the application is used in multiple enterprises. Only availabe if `app_id` is set.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "corp_id")

    @property
    @pulumi.getter(name="cycleParams")
    def cycle_params(self) -> pulumi.Output['outputs.ConferenceCycleParams']:
        """
        Specifies the configurations of the cyclical conference.
        The object structure is documented below.
        """
        return pulumi.get(self, "cycle_params")

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Output[int]:
        """
        Specifies the duration of the conference, in minutes.
        The valid value is range from `15` to `1440`, defaults to `30`.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="encryptMode")
    def encrypt_mode(self) -> pulumi.Output[int]:
        """
        Specifies the conference media encryption mode.
        **0**: Adaptive encryption.
        **1**: Force encryption.
        **2**: Do not encrypt.
        """
        return pulumi.get(self, "encrypt_mode")

    @property
    @pulumi.getter(name="guestJoinUri")
    def guest_join_uri(self) -> pulumi.Output[str]:
        """
        The common attendee meeting link address.
        """
        return pulumi.get(self, "guest_join_uri")

    @property
    @pulumi.getter(name="isAutoRecord")
    def is_auto_record(self) -> pulumi.Output[int]:
        """
        Specifies whether the conference automatically starts recording, it only takes
        effect when the recording type is:
        + **1**: Automatically start recording.
        + **0**: Do not start recording automatically.
        """
        return pulumi.get(self, "is_auto_record")

    @property
    @pulumi.getter(name="isRecordAuxStream")
    def is_record_aux_stream(self) -> pulumi.Output[int]:
        """
        Specifies whether to record auxiliary stream.
        + **0**: Do not record.
        + **1**: Record.
        """
        return pulumi.get(self, "is_record_aux_stream")

    @property
    @pulumi.getter(name="joinPasswords")
    def join_passwords(self) -> pulumi.Output[Sequence['outputs.ConferenceJoinPassword']]:
        return pulumi.get(self, "join_passwords")

    @property
    @pulumi.getter
    def language(self) -> pulumi.Output[str]:
        """
        Specifies the default language of the conference, the default value is defined by the
        conference cloud service. For languages supported by the system, it is passed according to the RFC3066 specification.
        The valid values are as follows:
        + **zh-CN**: Simplified Chinese.
        + **en-US**: US English.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="liveAddress")
    def live_address(self) -> pulumi.Output[str]:
        """
        Specifies the mainstream live broadcast address, with a maximum of 255 characters.
        Only availabe if `record_type` is **2** or **3**.
        """
        return pulumi.get(self, "live_address")

    @property
    @pulumi.getter(name="mediaTypes")
    def media_types(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the conference media type list.
        It consists of one or more enumerations, and the valid values are as follows:
        + **Voice**: Voice.
        + **Video**: SD video.
        + **HDVideo**: High-definition video (mutually exclusive with Video, if Video and HDVideo are selected at the same
        time, the system will select Video by default).
        + **Data**: Multimedia (If omitted, the system configuration will determines whether to automatically add **Data**).
        """
        return pulumi.get(self, "media_types")

    @property
    @pulumi.getter(name="meetingRoomId")
    def meeting_room_id(self) -> pulumi.Output[str]:
        """
        Specifies the cloud meeting room ID.
        """
        return pulumi.get(self, "meeting_room_id")

    @property
    @pulumi.getter(name="participantNumber")
    def participant_number(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the number of parties in the conference, the maximum number of
        participants in the conference. Defaults to **0** (Unlimited).
        """
        return pulumi.get(self, "participant_number")

    @property
    @pulumi.getter
    def participants(self) -> pulumi.Output[Optional[Sequence['outputs.ConferenceParticipant']]]:
        """
        Specifies the attendee list.
        The object structure is documented below.
        """
        return pulumi.get(self, "participants")

    @property
    @pulumi.getter(name="recordAuthType")
    def record_auth_type(self) -> pulumi.Output[int]:
        """
        Specifies the recording authentication method.
        **0**: Viewable/downloadable via link.
        **1**: Enterprise users can watch/download.
        **2**: Attendees can watch/download.
        """
        return pulumi.get(self, "record_auth_type")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> pulumi.Output[int]:
        """
        Specifies the recording type.
        + **0**: Disabled.
        + **1**: Live broadcast.
        + **2**: Record and broadcast.
        + **3**: Live + Recording.
        """
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the conference start time (UTC time).
        The time format is `YYYY-MM-DD hh:mm`, e.g. `2006-01-02 15:04`.
        There is no need to set if you book a cyclical conference.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The conference status, the valid values are as follows:
        + **Schedule**: the conference is in schedule.
        + **Created**: The conference is in progress.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def subconferences(self) -> pulumi.Output[Sequence['outputs.ConferenceSubconference']]:
        """
        The list of periodic sub-conferences.
        The object structure is documented below.
        """
        return pulumi.get(self, "subconferences")

    @property
    @pulumi.getter(name="timezoneId")
    def timezone_id(self) -> pulumi.Output[int]:
        """
        Specifies the time zone information of the conference time in the conference
        notification. For time zone information, refer to the time zone mapping relationship.
        """
        return pulumi.get(self, "timezone_id")

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Output[str]:
        """
        Specifies the conference topic. The topic can contain `1` to `128` characters.
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        Specifies the user ID of the participant.
        """
        return pulumi.get(self, "user_id")

