# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RecordingArgs', 'Recording']

@pulumi.input_type
class RecordingArgs:
    def __init__(__self__, *,
                 app_name: pulumi.Input[str],
                 domain_name: pulumi.Input[str],
                 obs: pulumi.Input['RecordingObsArgs'],
                 stream_name: pulumi.Input[str],
                 flv: Optional[pulumi.Input['RecordingFlvArgs']] = None,
                 hls: Optional[pulumi.Input['RecordingHlsArgs']] = None,
                 mp4: Optional[pulumi.Input['RecordingMp4Args']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Recording resource.
        :param pulumi.Input[str] app_name: Specifies the application name. To match all names, use an asterisk (*).
        :param pulumi.Input[str] domain_name: Specifies the ingest domain name.
        :param pulumi.Input['RecordingObsArgs'] obs: Specifies the obs for storing recordings.
               The obs structure is documented below.
        :param pulumi.Input[str] stream_name: Specifies the stream name. To match all names, use an asterisk (*).
        :param pulumi.Input['RecordingFlvArgs'] flv: Specifies the FLV configuration rule for storing recording as FLV.
               The flv structure is documented below.
        :param pulumi.Input['RecordingHlsArgs'] hls: Specifies the HLS configuration rule for storing recording as HLS.
               The hls structure is documented below.
        :param pulumi.Input['RecordingMp4Args'] mp4: Specifies the MP4 configuration rule for storing recording as MP4.
               The mp4 structure is documented below.
        :param pulumi.Input[str] region: Specifies the region of OBS.
        :param pulumi.Input[str] type: Specifies the types of recording notifications. The options are as follows:
               + **CONTINUOUS_RECORD**: continuous recording. Recording is triggered once streams are pushed to the recording system.
               + **COMMAND_RECORD**: command-based recording. Tenants need to run commands to start and stop recording after streams
               are pushed to the recording system.
        """
        pulumi.set(__self__, "app_name", app_name)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "obs", obs)
        pulumi.set(__self__, "stream_name", stream_name)
        if flv is not None:
            pulumi.set(__self__, "flv", flv)
        if hls is not None:
            pulumi.set(__self__, "hls", hls)
        if mp4 is not None:
            pulumi.set(__self__, "mp4", mp4)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Input[str]:
        """
        Specifies the application name. To match all names, use an asterisk (*).
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_name", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        Specifies the ingest domain name.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def obs(self) -> pulumi.Input['RecordingObsArgs']:
        """
        Specifies the obs for storing recordings.
        The obs structure is documented below.
        """
        return pulumi.get(self, "obs")

    @obs.setter
    def obs(self, value: pulumi.Input['RecordingObsArgs']):
        pulumi.set(self, "obs", value)

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> pulumi.Input[str]:
        """
        Specifies the stream name. To match all names, use an asterisk (*).
        """
        return pulumi.get(self, "stream_name")

    @stream_name.setter
    def stream_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "stream_name", value)

    @property
    @pulumi.getter
    def flv(self) -> Optional[pulumi.Input['RecordingFlvArgs']]:
        """
        Specifies the FLV configuration rule for storing recording as FLV.
        The flv structure is documented below.
        """
        return pulumi.get(self, "flv")

    @flv.setter
    def flv(self, value: Optional[pulumi.Input['RecordingFlvArgs']]):
        pulumi.set(self, "flv", value)

    @property
    @pulumi.getter
    def hls(self) -> Optional[pulumi.Input['RecordingHlsArgs']]:
        """
        Specifies the HLS configuration rule for storing recording as HLS.
        The hls structure is documented below.
        """
        return pulumi.get(self, "hls")

    @hls.setter
    def hls(self, value: Optional[pulumi.Input['RecordingHlsArgs']]):
        pulumi.set(self, "hls", value)

    @property
    @pulumi.getter
    def mp4(self) -> Optional[pulumi.Input['RecordingMp4Args']]:
        """
        Specifies the MP4 configuration rule for storing recording as MP4.
        The mp4 structure is documented below.
        """
        return pulumi.get(self, "mp4")

    @mp4.setter
    def mp4(self, value: Optional[pulumi.Input['RecordingMp4Args']]):
        pulumi.set(self, "mp4", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region of OBS.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the types of recording notifications. The options are as follows:
        + **CONTINUOUS_RECORD**: continuous recording. Recording is triggered once streams are pushed to the recording system.
        + **COMMAND_RECORD**: command-based recording. Tenants need to run commands to start and stop recording after streams
        are pushed to the recording system.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _RecordingState:
    def __init__(__self__, *,
                 app_name: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 flv: Optional[pulumi.Input['RecordingFlvArgs']] = None,
                 hls: Optional[pulumi.Input['RecordingHlsArgs']] = None,
                 mp4: Optional[pulumi.Input['RecordingMp4Args']] = None,
                 obs: Optional[pulumi.Input['RecordingObsArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 stream_name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Recording resources.
        :param pulumi.Input[str] app_name: Specifies the application name. To match all names, use an asterisk (*).
        :param pulumi.Input[str] domain_name: Specifies the ingest domain name.
        :param pulumi.Input['RecordingFlvArgs'] flv: Specifies the FLV configuration rule for storing recording as FLV.
               The flv structure is documented below.
        :param pulumi.Input['RecordingHlsArgs'] hls: Specifies the HLS configuration rule for storing recording as HLS.
               The hls structure is documented below.
        :param pulumi.Input['RecordingMp4Args'] mp4: Specifies the MP4 configuration rule for storing recording as MP4.
               The mp4 structure is documented below.
        :param pulumi.Input['RecordingObsArgs'] obs: Specifies the obs for storing recordings.
               The obs structure is documented below.
        :param pulumi.Input[str] region: Specifies the region of OBS.
        :param pulumi.Input[str] stream_name: Specifies the stream name. To match all names, use an asterisk (*).
        :param pulumi.Input[str] type: Specifies the types of recording notifications. The options are as follows:
               + **CONTINUOUS_RECORD**: continuous recording. Recording is triggered once streams are pushed to the recording system.
               + **COMMAND_RECORD**: command-based recording. Tenants need to run commands to start and stop recording after streams
               are pushed to the recording system.
        """
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if flv is not None:
            pulumi.set(__self__, "flv", flv)
        if hls is not None:
            pulumi.set(__self__, "hls", hls)
        if mp4 is not None:
            pulumi.set(__self__, "mp4", mp4)
        if obs is not None:
            pulumi.set(__self__, "obs", obs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if stream_name is not None:
            pulumi.set(__self__, "stream_name", stream_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the application name. To match all names, use an asterisk (*).
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_name", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ingest domain name.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def flv(self) -> Optional[pulumi.Input['RecordingFlvArgs']]:
        """
        Specifies the FLV configuration rule for storing recording as FLV.
        The flv structure is documented below.
        """
        return pulumi.get(self, "flv")

    @flv.setter
    def flv(self, value: Optional[pulumi.Input['RecordingFlvArgs']]):
        pulumi.set(self, "flv", value)

    @property
    @pulumi.getter
    def hls(self) -> Optional[pulumi.Input['RecordingHlsArgs']]:
        """
        Specifies the HLS configuration rule for storing recording as HLS.
        The hls structure is documented below.
        """
        return pulumi.get(self, "hls")

    @hls.setter
    def hls(self, value: Optional[pulumi.Input['RecordingHlsArgs']]):
        pulumi.set(self, "hls", value)

    @property
    @pulumi.getter
    def mp4(self) -> Optional[pulumi.Input['RecordingMp4Args']]:
        """
        Specifies the MP4 configuration rule for storing recording as MP4.
        The mp4 structure is documented below.
        """
        return pulumi.get(self, "mp4")

    @mp4.setter
    def mp4(self, value: Optional[pulumi.Input['RecordingMp4Args']]):
        pulumi.set(self, "mp4", value)

    @property
    @pulumi.getter
    def obs(self) -> Optional[pulumi.Input['RecordingObsArgs']]:
        """
        Specifies the obs for storing recordings.
        The obs structure is documented below.
        """
        return pulumi.get(self, "obs")

    @obs.setter
    def obs(self, value: Optional[pulumi.Input['RecordingObsArgs']]):
        pulumi.set(self, "obs", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region of OBS.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the stream name. To match all names, use an asterisk (*).
        """
        return pulumi.get(self, "stream_name")

    @stream_name.setter
    def stream_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the types of recording notifications. The options are as follows:
        + **CONTINUOUS_RECORD**: continuous recording. Recording is triggered once streams are pushed to the recording system.
        + **COMMAND_RECORD**: command-based recording. Tenants need to run commands to start and stop recording after streams
        are pushed to the recording system.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Recording(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 flv: Optional[pulumi.Input[pulumi.InputType['RecordingFlvArgs']]] = None,
                 hls: Optional[pulumi.Input[pulumi.InputType['RecordingHlsArgs']]] = None,
                 mp4: Optional[pulumi.Input[pulumi.InputType['RecordingMp4Args']]] = None,
                 obs: Optional[pulumi.Input[pulumi.InputType['RecordingObsArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 stream_name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a recording template within HuaweiCloud Live.

        ## Example Usage
        ### Create a recording template for an ingest domain name

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        ingest_domain_name = config.require_object("ingestDomainName")
        bucket_region = config.require_object("bucketRegion")
        bucket_name = config.require_object("bucketName")
        ingest_domain = huaweicloud.live.Domain("ingestDomain", type="push")
        recording = huaweicloud.live.Recording("recording",
            domain_name=ingest_domain.name,
            app_name="live",
            stream_name="stream_name",
            type="CONTINUOUS_RECORD",
            obs=huaweicloud.live.RecordingObsArgs(
                region=bucket_region,
                bucket=bucket_name,
            ),
            hls=huaweicloud.live.RecordingHlsArgs(
                recording_length=15,
            ))
        ```

        ## Import

        Recording templates can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Live/recording:Recording test 55534eaa-533a-419d-9b40-ec427ea7195a
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_name: Specifies the application name. To match all names, use an asterisk (*).
        :param pulumi.Input[str] domain_name: Specifies the ingest domain name.
        :param pulumi.Input[pulumi.InputType['RecordingFlvArgs']] flv: Specifies the FLV configuration rule for storing recording as FLV.
               The flv structure is documented below.
        :param pulumi.Input[pulumi.InputType['RecordingHlsArgs']] hls: Specifies the HLS configuration rule for storing recording as HLS.
               The hls structure is documented below.
        :param pulumi.Input[pulumi.InputType['RecordingMp4Args']] mp4: Specifies the MP4 configuration rule for storing recording as MP4.
               The mp4 structure is documented below.
        :param pulumi.Input[pulumi.InputType['RecordingObsArgs']] obs: Specifies the obs for storing recordings.
               The obs structure is documented below.
        :param pulumi.Input[str] region: Specifies the region of OBS.
        :param pulumi.Input[str] stream_name: Specifies the stream name. To match all names, use an asterisk (*).
        :param pulumi.Input[str] type: Specifies the types of recording notifications. The options are as follows:
               + **CONTINUOUS_RECORD**: continuous recording. Recording is triggered once streams are pushed to the recording system.
               + **COMMAND_RECORD**: command-based recording. Tenants need to run commands to start and stop recording after streams
               are pushed to the recording system.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecordingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a recording template within HuaweiCloud Live.

        ## Example Usage
        ### Create a recording template for an ingest domain name

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        ingest_domain_name = config.require_object("ingestDomainName")
        bucket_region = config.require_object("bucketRegion")
        bucket_name = config.require_object("bucketName")
        ingest_domain = huaweicloud.live.Domain("ingestDomain", type="push")
        recording = huaweicloud.live.Recording("recording",
            domain_name=ingest_domain.name,
            app_name="live",
            stream_name="stream_name",
            type="CONTINUOUS_RECORD",
            obs=huaweicloud.live.RecordingObsArgs(
                region=bucket_region,
                bucket=bucket_name,
            ),
            hls=huaweicloud.live.RecordingHlsArgs(
                recording_length=15,
            ))
        ```

        ## Import

        Recording templates can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Live/recording:Recording test 55534eaa-533a-419d-9b40-ec427ea7195a
        ```

        :param str resource_name: The name of the resource.
        :param RecordingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecordingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 flv: Optional[pulumi.Input[pulumi.InputType['RecordingFlvArgs']]] = None,
                 hls: Optional[pulumi.Input[pulumi.InputType['RecordingHlsArgs']]] = None,
                 mp4: Optional[pulumi.Input[pulumi.InputType['RecordingMp4Args']]] = None,
                 obs: Optional[pulumi.Input[pulumi.InputType['RecordingObsArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 stream_name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecordingArgs.__new__(RecordingArgs)

            if app_name is None and not opts.urn:
                raise TypeError("Missing required property 'app_name'")
            __props__.__dict__["app_name"] = app_name
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["flv"] = flv
            __props__.__dict__["hls"] = hls
            __props__.__dict__["mp4"] = mp4
            if obs is None and not opts.urn:
                raise TypeError("Missing required property 'obs'")
            __props__.__dict__["obs"] = obs
            __props__.__dict__["region"] = region
            if stream_name is None and not opts.urn:
                raise TypeError("Missing required property 'stream_name'")
            __props__.__dict__["stream_name"] = stream_name
            __props__.__dict__["type"] = type
        super(Recording, __self__).__init__(
            'huaweicloud:Live/recording:Recording',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_name: Optional[pulumi.Input[str]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            flv: Optional[pulumi.Input[pulumi.InputType['RecordingFlvArgs']]] = None,
            hls: Optional[pulumi.Input[pulumi.InputType['RecordingHlsArgs']]] = None,
            mp4: Optional[pulumi.Input[pulumi.InputType['RecordingMp4Args']]] = None,
            obs: Optional[pulumi.Input[pulumi.InputType['RecordingObsArgs']]] = None,
            region: Optional[pulumi.Input[str]] = None,
            stream_name: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Recording':
        """
        Get an existing Recording resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_name: Specifies the application name. To match all names, use an asterisk (*).
        :param pulumi.Input[str] domain_name: Specifies the ingest domain name.
        :param pulumi.Input[pulumi.InputType['RecordingFlvArgs']] flv: Specifies the FLV configuration rule for storing recording as FLV.
               The flv structure is documented below.
        :param pulumi.Input[pulumi.InputType['RecordingHlsArgs']] hls: Specifies the HLS configuration rule for storing recording as HLS.
               The hls structure is documented below.
        :param pulumi.Input[pulumi.InputType['RecordingMp4Args']] mp4: Specifies the MP4 configuration rule for storing recording as MP4.
               The mp4 structure is documented below.
        :param pulumi.Input[pulumi.InputType['RecordingObsArgs']] obs: Specifies the obs for storing recordings.
               The obs structure is documented below.
        :param pulumi.Input[str] region: Specifies the region of OBS.
        :param pulumi.Input[str] stream_name: Specifies the stream name. To match all names, use an asterisk (*).
        :param pulumi.Input[str] type: Specifies the types of recording notifications. The options are as follows:
               + **CONTINUOUS_RECORD**: continuous recording. Recording is triggered once streams are pushed to the recording system.
               + **COMMAND_RECORD**: command-based recording. Tenants need to run commands to start and stop recording after streams
               are pushed to the recording system.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecordingState.__new__(_RecordingState)

        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["flv"] = flv
        __props__.__dict__["hls"] = hls
        __props__.__dict__["mp4"] = mp4
        __props__.__dict__["obs"] = obs
        __props__.__dict__["region"] = region
        __props__.__dict__["stream_name"] = stream_name
        __props__.__dict__["type"] = type
        return Recording(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[str]:
        """
        Specifies the application name. To match all names, use an asterisk (*).
        """
        return pulumi.get(self, "app_name")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        Specifies the ingest domain name.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def flv(self) -> pulumi.Output[Optional['outputs.RecordingFlv']]:
        """
        Specifies the FLV configuration rule for storing recording as FLV.
        The flv structure is documented below.
        """
        return pulumi.get(self, "flv")

    @property
    @pulumi.getter
    def hls(self) -> pulumi.Output[Optional['outputs.RecordingHls']]:
        """
        Specifies the HLS configuration rule for storing recording as HLS.
        The hls structure is documented below.
        """
        return pulumi.get(self, "hls")

    @property
    @pulumi.getter
    def mp4(self) -> pulumi.Output[Optional['outputs.RecordingMp4']]:
        """
        Specifies the MP4 configuration rule for storing recording as MP4.
        The mp4 structure is documented below.
        """
        return pulumi.get(self, "mp4")

    @property
    @pulumi.getter
    def obs(self) -> pulumi.Output['outputs.RecordingObs']:
        """
        Specifies the obs for storing recordings.
        The obs structure is documented below.
        """
        return pulumi.get(self, "obs")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region of OBS.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> pulumi.Output[str]:
        """
        Specifies the stream name. To match all names, use an asterisk (*).
        """
        return pulumi.get(self, "stream_name")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the types of recording notifications. The options are as follows:
        + **CONTINUOUS_RECORD**: continuous recording. Recording is triggered once streams are pushed to the recording system.
        + **COMMAND_RECORD**: command-based recording. Tenants need to run commands to start and stop recording after streams
        are pushed to the recording system.
        """
        return pulumi.get(self, "type")

