# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'RecordingFlvArgs',
    'RecordingHlsArgs',
    'RecordingMp4Args',
    'RecordingObsArgs',
    'TranscodingTemplateArgs',
]

@pulumi.input_type
class RecordingFlvArgs:
    def __init__(__self__, *,
                 recording_length: pulumi.Input[int],
                 file_naming: Optional[pulumi.Input[str]] = None,
                 max_stream_pause_length: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] recording_length: Specifies the recording length. Value range: 15 ~ 180, unit: `minute`.
               A stream exceeding the recording length will generate a new recording.
        :param pulumi.Input[str] file_naming: Specifies the path and file name prefix of a recording file. The default value is
               `Record/{publish_domain}/{app}/{record_type}/{record_format}/{stream}_{file_start_time}/{file_start_time}`.
        :param pulumi.Input[int] max_stream_pause_length: Specifies the interval threshold for combining recording chunks. If the
               stream pause length exceeds the value of this parameter, a new recording is generated.
               Value range: 0 ~ 300, unit: `second`.
               If the value is set to `0`, a new file will be generated once the stream is interrupted. Defaults to `0`.
        """
        pulumi.set(__self__, "recording_length", recording_length)
        if file_naming is not None:
            pulumi.set(__self__, "file_naming", file_naming)
        if max_stream_pause_length is not None:
            pulumi.set(__self__, "max_stream_pause_length", max_stream_pause_length)

    @property
    @pulumi.getter(name="recordingLength")
    def recording_length(self) -> pulumi.Input[int]:
        """
        Specifies the recording length. Value range: 15 ~ 180, unit: `minute`.
        A stream exceeding the recording length will generate a new recording.
        """
        return pulumi.get(self, "recording_length")

    @recording_length.setter
    def recording_length(self, value: pulumi.Input[int]):
        pulumi.set(self, "recording_length", value)

    @property
    @pulumi.getter(name="fileNaming")
    def file_naming(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path and file name prefix of a recording file. The default value is
        `Record/{publish_domain}/{app}/{record_type}/{record_format}/{stream}_{file_start_time}/{file_start_time}`.
        """
        return pulumi.get(self, "file_naming")

    @file_naming.setter
    def file_naming(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_naming", value)

    @property
    @pulumi.getter(name="maxStreamPauseLength")
    def max_stream_pause_length(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the interval threshold for combining recording chunks. If the
        stream pause length exceeds the value of this parameter, a new recording is generated.
        Value range: 0 ~ 300, unit: `second`.
        If the value is set to `0`, a new file will be generated once the stream is interrupted. Defaults to `0`.
        """
        return pulumi.get(self, "max_stream_pause_length")

    @max_stream_pause_length.setter
    def max_stream_pause_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_stream_pause_length", value)


@pulumi.input_type
class RecordingHlsArgs:
    def __init__(__self__, *,
                 recording_length: pulumi.Input[int],
                 file_naming: Optional[pulumi.Input[str]] = None,
                 max_stream_pause_length: Optional[pulumi.Input[int]] = None,
                 ts_file_naming: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] recording_length: Specifies the recording length. Value range: 15 ~ 180, unit: `minute`.
               A stream exceeding the recording length will generate a new recording.
        :param pulumi.Input[str] file_naming: Specifies the path and file name prefix of a recording file. The default value is
               `Record/{publish_domain}/{app}/{record_type}/{record_format}/{stream}_{file_start_time}/{file_start_time}`.
        :param pulumi.Input[int] max_stream_pause_length: Specifies the interval threshold for combining recording chunks. If the
               stream pause length exceeds the value of this parameter, a new recording is generated.
               Value range: 0 ~ 300, unit: `second`.
               If the value is set to `0`, a new file will be generated once the stream is interrupted. Defaults to `0`.
        :param pulumi.Input[str] ts_file_naming: Specifies TS file name prefix.
               The default value is `{file_start_time_unix}_{file_end_time_unix}_{ts_sequence_number}`.
        """
        pulumi.set(__self__, "recording_length", recording_length)
        if file_naming is not None:
            pulumi.set(__self__, "file_naming", file_naming)
        if max_stream_pause_length is not None:
            pulumi.set(__self__, "max_stream_pause_length", max_stream_pause_length)
        if ts_file_naming is not None:
            pulumi.set(__self__, "ts_file_naming", ts_file_naming)

    @property
    @pulumi.getter(name="recordingLength")
    def recording_length(self) -> pulumi.Input[int]:
        """
        Specifies the recording length. Value range: 15 ~ 180, unit: `minute`.
        A stream exceeding the recording length will generate a new recording.
        """
        return pulumi.get(self, "recording_length")

    @recording_length.setter
    def recording_length(self, value: pulumi.Input[int]):
        pulumi.set(self, "recording_length", value)

    @property
    @pulumi.getter(name="fileNaming")
    def file_naming(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path and file name prefix of a recording file. The default value is
        `Record/{publish_domain}/{app}/{record_type}/{record_format}/{stream}_{file_start_time}/{file_start_time}`.
        """
        return pulumi.get(self, "file_naming")

    @file_naming.setter
    def file_naming(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_naming", value)

    @property
    @pulumi.getter(name="maxStreamPauseLength")
    def max_stream_pause_length(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the interval threshold for combining recording chunks. If the
        stream pause length exceeds the value of this parameter, a new recording is generated.
        Value range: 0 ~ 300, unit: `second`.
        If the value is set to `0`, a new file will be generated once the stream is interrupted. Defaults to `0`.
        """
        return pulumi.get(self, "max_stream_pause_length")

    @max_stream_pause_length.setter
    def max_stream_pause_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_stream_pause_length", value)

    @property
    @pulumi.getter(name="tsFileNaming")
    def ts_file_naming(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies TS file name prefix.
        The default value is `{file_start_time_unix}_{file_end_time_unix}_{ts_sequence_number}`.
        """
        return pulumi.get(self, "ts_file_naming")

    @ts_file_naming.setter
    def ts_file_naming(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ts_file_naming", value)


@pulumi.input_type
class RecordingMp4Args:
    def __init__(__self__, *,
                 recording_length: pulumi.Input[int],
                 file_naming: Optional[pulumi.Input[str]] = None,
                 max_stream_pause_length: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] recording_length: Specifies the recording length. Value range: 15 ~ 180, unit: `minute`.
               A stream exceeding the recording length will generate a new recording.
        :param pulumi.Input[str] file_naming: Specifies the path and file name prefix of a recording file. The default value is
               `Record/{publish_domain}/{app}/{record_type}/{record_format}/{stream}_{file_start_time}/{file_start_time}`.
        :param pulumi.Input[int] max_stream_pause_length: Specifies the interval threshold for combining recording chunks. If the
               stream pause length exceeds the value of this parameter, a new recording is generated.
               Value range: 0 ~ 300, unit: `second`.
               If the value is set to `0`, a new file will be generated once the stream is interrupted. Defaults to `0`.
        """
        pulumi.set(__self__, "recording_length", recording_length)
        if file_naming is not None:
            pulumi.set(__self__, "file_naming", file_naming)
        if max_stream_pause_length is not None:
            pulumi.set(__self__, "max_stream_pause_length", max_stream_pause_length)

    @property
    @pulumi.getter(name="recordingLength")
    def recording_length(self) -> pulumi.Input[int]:
        """
        Specifies the recording length. Value range: 15 ~ 180, unit: `minute`.
        A stream exceeding the recording length will generate a new recording.
        """
        return pulumi.get(self, "recording_length")

    @recording_length.setter
    def recording_length(self, value: pulumi.Input[int]):
        pulumi.set(self, "recording_length", value)

    @property
    @pulumi.getter(name="fileNaming")
    def file_naming(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path and file name prefix of a recording file. The default value is
        `Record/{publish_domain}/{app}/{record_type}/{record_format}/{stream}_{file_start_time}/{file_start_time}`.
        """
        return pulumi.get(self, "file_naming")

    @file_naming.setter
    def file_naming(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_naming", value)

    @property
    @pulumi.getter(name="maxStreamPauseLength")
    def max_stream_pause_length(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the interval threshold for combining recording chunks. If the
        stream pause length exceeds the value of this parameter, a new recording is generated.
        Value range: 0 ~ 300, unit: `second`.
        If the value is set to `0`, a new file will be generated once the stream is interrupted. Defaults to `0`.
        """
        return pulumi.get(self, "max_stream_pause_length")

    @max_stream_pause_length.setter
    def max_stream_pause_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_stream_pause_length", value)


@pulumi.input_type
class RecordingObsArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 region: pulumi.Input[str],
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Specifies OBS bucket.
        :param pulumi.Input[str] region: Specifies the region of OBS.
        :param pulumi.Input[str] object: Specifies OBS object path. If omitted, recordings will be saved to the root directory.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "region", region)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Specifies OBS bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Specifies the region of OBS.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies OBS object path. If omitted, recordings will be saved to the root directory.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class TranscodingTemplateArgs:
    def __init__(__self__, *,
                 bitrate: pulumi.Input[int],
                 height: pulumi.Input[int],
                 name: pulumi.Input[str],
                 width: pulumi.Input[int],
                 frame_rate: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] bitrate: Specifies the bitrate of a transcoded video, in kbit/s. Value range: 40 ~ 30000.
        :param pulumi.Input[int] height: Specifies video height (unit: pixel).
               + **When the video encoding is H264**, value range: 32 ~ 2160 and must be a multiple of 2.
               + **When the video encoding is H265**, value range: 240 ~ 2160 and must be a multiple of 4.
        :param pulumi.Input[str] name: Specifies the template name. The name can contain a maximum of 64 characters, and only
               contains letters, digits and hyphens (-).
        :param pulumi.Input[int] width: Specifies video width (unit: pixel).
               + **When the video encoding is H264**, value range: 32 ~ 3840 and must be a multiple of 2.
               + **When the video encoding is H265**, value range: 320 ~ 3840 and must be a multiple of 4.
        :param pulumi.Input[int] frame_rate: Specifies the frame rate of the transcoded video, in fps. Value range: 0 ~ 30.
               Value 0 indicates that the frame rate remains unchanged.
        """
        pulumi.set(__self__, "bitrate", bitrate)
        pulumi.set(__self__, "height", height)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "width", width)
        if frame_rate is not None:
            pulumi.set(__self__, "frame_rate", frame_rate)

    @property
    @pulumi.getter
    def bitrate(self) -> pulumi.Input[int]:
        """
        Specifies the bitrate of a transcoded video, in kbit/s. Value range: 40 ~ 30000.
        """
        return pulumi.get(self, "bitrate")

    @bitrate.setter
    def bitrate(self, value: pulumi.Input[int]):
        pulumi.set(self, "bitrate", value)

    @property
    @pulumi.getter
    def height(self) -> pulumi.Input[int]:
        """
        Specifies video height (unit: pixel).
        + **When the video encoding is H264**, value range: 32 ~ 2160 and must be a multiple of 2.
        + **When the video encoding is H265**, value range: 240 ~ 2160 and must be a multiple of 4.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: pulumi.Input[int]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the template name. The name can contain a maximum of 64 characters, and only
        contains letters, digits and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def width(self) -> pulumi.Input[int]:
        """
        Specifies video width (unit: pixel).
        + **When the video encoding is H264**, value range: 32 ~ 3840 and must be a multiple of 2.
        + **When the video encoding is H265**, value range: 320 ~ 3840 and must be a multiple of 4.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: pulumi.Input[int]):
        pulumi.set(self, "width", value)

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the frame rate of the transcoded video, in fps. Value range: 0 ~ 30.
        Value 0 indicates that the frame rate remains unchanged.
        """
        return pulumi.get(self, "frame_rate")

    @frame_rate.setter
    def frame_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frame_rate", value)


