# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProductArgs', 'Product']

@pulumi.input_type
class ProductArgs:
    def __init__(__self__, *,
                 data_type: pulumi.Input[str],
                 device_type: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 services: pulumi.Input[Sequence[pulumi.Input['ProductServiceArgs']]],
                 description: Optional[pulumi.Input[str]] = None,
                 industry: Optional[pulumi.Input[str]] = None,
                 manufacturer_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 space_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Product resource.
        :param pulumi.Input[str] data_type: Specifies the type of data.
               The valid values are **json** and **binary**.
        :param pulumi.Input[str] device_type: Specifies the device type. The device type contains a maximum of 32 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters
               are allowed: `?'#().,&%@!`. Example: StreetLight, GasMeter, or WaterMeter.
        :param pulumi.Input[str] protocol: Specifies the protocal.
               The valid values are **MQTT**, **CoAP**, **HTTP**, **HTTPS**, **Modbus**, **ONVIF**, **OPC-UA**, **OPC-DA**, **Other**.
        :param pulumi.Input[Sequence[pulumi.Input['ProductServiceArgs']]] services: Specifies the list of services.
               The services structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the parameter. The description contains a maximum of
               128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] industry: Specifies the industry which the device belongs to. The industry contains a maximum of
               64 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and
               the following specail characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] manufacturer_name: Specifies the manufacturer name. The name contains a maximum of 32 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] name: Specifies the name of the parameter. The name contains a maximum of 64 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] product_id: Specifies the product ID. The product ID contains a maximum of 32
               characters. Only letters, digits, hyphens (-) and underscores (_) are allowed. If omitted, the platform will
               automatically allocate a product ID. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA product resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] space_id: Specifies the resource space ID which the product belongs to. If omitted,
               the product will belong to the default resource space. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "device_type", device_type)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "services", services)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if industry is not None:
            pulumi.set(__self__, "industry", industry)
        if manufacturer_name is not None:
            pulumi.set(__self__, "manufacturer_name", manufacturer_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if space_id is not None:
            pulumi.set(__self__, "space_id", space_id)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Input[str]:
        """
        Specifies the type of data.
        The valid values are **json** and **binary**.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> pulumi.Input[str]:
        """
        Specifies the device type. The device type contains a maximum of 32 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters
        are allowed: `?'#().,&%@!`. Example: StreetLight, GasMeter, or WaterMeter.
        """
        return pulumi.get(self, "device_type")

    @device_type.setter
    def device_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "device_type", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        Specifies the protocal.
        The valid values are **MQTT**, **CoAP**, **HTTP**, **HTTPS**, **Modbus**, **ONVIF**, **OPC-UA**, **OPC-DA**, **Other**.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def services(self) -> pulumi.Input[Sequence[pulumi.Input['ProductServiceArgs']]]:
        """
        Specifies the list of services.
        The services structure is documented below.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: pulumi.Input[Sequence[pulumi.Input['ProductServiceArgs']]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the parameter. The description contains a maximum of
        128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
        characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def industry(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the industry which the device belongs to. The industry contains a maximum of
        64 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and
        the following specail characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "industry")

    @industry.setter
    def industry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "industry", value)

    @property
    @pulumi.getter(name="manufacturerName")
    def manufacturer_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the manufacturer name. The name contains a maximum of 32 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
        characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "manufacturer_name")

    @manufacturer_name.setter
    def manufacturer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manufacturer_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the parameter. The name contains a maximum of 64 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
        allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the product ID. The product ID contains a maximum of 32
        characters. Only letters, digits, hyphens (-) and underscores (_) are allowed. If omitted, the platform will
        automatically allocate a product ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the IoTDA product resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="spaceId")
    def space_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the resource space ID which the product belongs to. If omitted,
        the product will belong to the default resource space. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "space_id")

    @space_id.setter
    def space_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "space_id", value)


@pulumi.input_type
class _ProductState:
    def __init__(__self__, *,
                 data_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_type: Optional[pulumi.Input[str]] = None,
                 industry: Optional[pulumi.Input[str]] = None,
                 manufacturer_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['ProductServiceArgs']]]] = None,
                 space_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Product resources.
        :param pulumi.Input[str] data_type: Specifies the type of data.
               The valid values are **json** and **binary**.
        :param pulumi.Input[str] description: Specifies the description of the parameter. The description contains a maximum of
               128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] device_type: Specifies the device type. The device type contains a maximum of 32 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters
               are allowed: `?'#().,&%@!`. Example: StreetLight, GasMeter, or WaterMeter.
        :param pulumi.Input[str] industry: Specifies the industry which the device belongs to. The industry contains a maximum of
               64 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and
               the following specail characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] manufacturer_name: Specifies the manufacturer name. The name contains a maximum of 32 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] name: Specifies the name of the parameter. The name contains a maximum of 64 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] product_id: Specifies the product ID. The product ID contains a maximum of 32
               characters. Only letters, digits, hyphens (-) and underscores (_) are allowed. If omitted, the platform will
               automatically allocate a product ID. Changing this parameter will create a new resource.
        :param pulumi.Input[str] protocol: Specifies the protocal.
               The valid values are **MQTT**, **CoAP**, **HTTP**, **HTTPS**, **Modbus**, **ONVIF**, **OPC-UA**, **OPC-DA**, **Other**.
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA product resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['ProductServiceArgs']]] services: Specifies the list of services.
               The services structure is documented below.
        :param pulumi.Input[str] space_id: Specifies the resource space ID which the product belongs to. If omitted,
               the product will belong to the default resource space. Changing this parameter will create a new resource.
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)
        if industry is not None:
            pulumi.set(__self__, "industry", industry)
        if manufacturer_name is not None:
            pulumi.set(__self__, "manufacturer_name", manufacturer_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if space_id is not None:
            pulumi.set(__self__, "space_id", space_id)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of data.
        The valid values are **json** and **binary**.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the parameter. The description contains a maximum of
        128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
        characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the device type. The device type contains a maximum of 32 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters
        are allowed: `?'#().,&%@!`. Example: StreetLight, GasMeter, or WaterMeter.
        """
        return pulumi.get(self, "device_type")

    @device_type.setter
    def device_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_type", value)

    @property
    @pulumi.getter
    def industry(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the industry which the device belongs to. The industry contains a maximum of
        64 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and
        the following specail characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "industry")

    @industry.setter
    def industry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "industry", value)

    @property
    @pulumi.getter(name="manufacturerName")
    def manufacturer_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the manufacturer name. The name contains a maximum of 32 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
        characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "manufacturer_name")

    @manufacturer_name.setter
    def manufacturer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manufacturer_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the parameter. The name contains a maximum of 64 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
        allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the product ID. The product ID contains a maximum of 32
        characters. Only letters, digits, hyphens (-) and underscores (_) are allowed. If omitted, the platform will
        automatically allocate a product ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the protocal.
        The valid values are **MQTT**, **CoAP**, **HTTP**, **HTTPS**, **Modbus**, **ONVIF**, **OPC-UA**, **OPC-DA**, **Other**.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the IoTDA product resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProductServiceArgs']]]]:
        """
        Specifies the list of services.
        The services structure is documented below.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProductServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter(name="spaceId")
    def space_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the resource space ID which the product belongs to. If omitted,
        the product will belong to the default resource space. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "space_id")

    @space_id.setter
    def space_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "space_id", value)


class Product(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_type: Optional[pulumi.Input[str]] = None,
                 industry: Optional[pulumi.Input[str]] = None,
                 manufacturer_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProductServiceArgs']]]]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an IoTDA product within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        product_name = config.require_object("productName")
        space = huaweicloud.io_tda.Space("space")
        test = huaweicloud.io_tda.Product("test",
            device_type="WaterMeter",
            protocol="MQTT",
            space_id=huaweicloud_iotda_space["test"]["id"],
            data_type="json",
            manufacturer_name="demo_manufacturer_name",
            industry="demo_industry",
            services=[huaweicloud.io_tda.ProductServiceArgs(
                id="service_1",
                type="serv_type",
                properties=[
                    huaweicloud.io_tda.ProductServicePropertyArgs(
                        name="p_1",
                        type="int",
                        min="3",
                        max="666",
                        description="desc",
                        method="RW",
                    ),
                    huaweicloud.io_tda.ProductServicePropertyArgs(
                        name="p_2",
                        type="string",
                        max_length=20,
                        enum_lists=[
                            "1",
                            "E",
                        ],
                        method="R",
                    ),
                    huaweicloud.io_tda.ProductServicePropertyArgs(
                        name="p_3",
                        type="string",
                        method="W",
                        max_length=200,
                    ),
                    huaweicloud.io_tda.ProductServicePropertyArgs(
                        name="p_4",
                        type="decimal",
                        method="W",
                        min="3.1",
                        max="666.99",
                    ),
                ],
                commands=[huaweicloud.io_tda.ProductServiceCommandArgs(
                    name="cmd_1",
                    paras=[huaweicloud.io_tda.ProductServiceCommandParaArgs(
                        name="cmd_p_1",
                        type="int",
                        description="desc",
                        min="1",
                        max="33",
                    )],
                    responses=[huaweicloud.io_tda.ProductServiceCommandResponseArgs(
                        name="cmd_r_1",
                        type="int",
                        description="desc",
                        min="1",
                        max="22",
                    )],
                )],
            )])
        ```

        ## Import

        Products can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:IoTDA/product:Product test 10022532f4f94f26b01daa1e424853e1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] data_type: Specifies the type of data.
               The valid values are **json** and **binary**.
        :param pulumi.Input[str] description: Specifies the description of the parameter. The description contains a maximum of
               128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] device_type: Specifies the device type. The device type contains a maximum of 32 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters
               are allowed: `?'#().,&%@!`. Example: StreetLight, GasMeter, or WaterMeter.
        :param pulumi.Input[str] industry: Specifies the industry which the device belongs to. The industry contains a maximum of
               64 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and
               the following specail characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] manufacturer_name: Specifies the manufacturer name. The name contains a maximum of 32 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] name: Specifies the name of the parameter. The name contains a maximum of 64 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] product_id: Specifies the product ID. The product ID contains a maximum of 32
               characters. Only letters, digits, hyphens (-) and underscores (_) are allowed. If omitted, the platform will
               automatically allocate a product ID. Changing this parameter will create a new resource.
        :param pulumi.Input[str] protocol: Specifies the protocal.
               The valid values are **MQTT**, **CoAP**, **HTTP**, **HTTPS**, **Modbus**, **ONVIF**, **OPC-UA**, **OPC-DA**, **Other**.
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA product resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProductServiceArgs']]]] services: Specifies the list of services.
               The services structure is documented below.
        :param pulumi.Input[str] space_id: Specifies the resource space ID which the product belongs to. If omitted,
               the product will belong to the default resource space. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProductArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IoTDA product within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        product_name = config.require_object("productName")
        space = huaweicloud.io_tda.Space("space")
        test = huaweicloud.io_tda.Product("test",
            device_type="WaterMeter",
            protocol="MQTT",
            space_id=huaweicloud_iotda_space["test"]["id"],
            data_type="json",
            manufacturer_name="demo_manufacturer_name",
            industry="demo_industry",
            services=[huaweicloud.io_tda.ProductServiceArgs(
                id="service_1",
                type="serv_type",
                properties=[
                    huaweicloud.io_tda.ProductServicePropertyArgs(
                        name="p_1",
                        type="int",
                        min="3",
                        max="666",
                        description="desc",
                        method="RW",
                    ),
                    huaweicloud.io_tda.ProductServicePropertyArgs(
                        name="p_2",
                        type="string",
                        max_length=20,
                        enum_lists=[
                            "1",
                            "E",
                        ],
                        method="R",
                    ),
                    huaweicloud.io_tda.ProductServicePropertyArgs(
                        name="p_3",
                        type="string",
                        method="W",
                        max_length=200,
                    ),
                    huaweicloud.io_tda.ProductServicePropertyArgs(
                        name="p_4",
                        type="decimal",
                        method="W",
                        min="3.1",
                        max="666.99",
                    ),
                ],
                commands=[huaweicloud.io_tda.ProductServiceCommandArgs(
                    name="cmd_1",
                    paras=[huaweicloud.io_tda.ProductServiceCommandParaArgs(
                        name="cmd_p_1",
                        type="int",
                        description="desc",
                        min="1",
                        max="33",
                    )],
                    responses=[huaweicloud.io_tda.ProductServiceCommandResponseArgs(
                        name="cmd_r_1",
                        type="int",
                        description="desc",
                        min="1",
                        max="22",
                    )],
                )],
            )])
        ```

        ## Import

        Products can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:IoTDA/product:Product test 10022532f4f94f26b01daa1e424853e1
        ```

        :param str resource_name: The name of the resource.
        :param ProductArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProductArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_type: Optional[pulumi.Input[str]] = None,
                 industry: Optional[pulumi.Input[str]] = None,
                 manufacturer_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProductServiceArgs']]]]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProductArgs.__new__(ProductArgs)

            if data_type is None and not opts.urn:
                raise TypeError("Missing required property 'data_type'")
            __props__.__dict__["data_type"] = data_type
            __props__.__dict__["description"] = description
            if device_type is None and not opts.urn:
                raise TypeError("Missing required property 'device_type'")
            __props__.__dict__["device_type"] = device_type
            __props__.__dict__["industry"] = industry
            __props__.__dict__["manufacturer_name"] = manufacturer_name
            __props__.__dict__["name"] = name
            __props__.__dict__["product_id"] = product_id
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            if services is None and not opts.urn:
                raise TypeError("Missing required property 'services'")
            __props__.__dict__["services"] = services
            __props__.__dict__["space_id"] = space_id
        super(Product, __self__).__init__(
            'huaweicloud:IoTDA/product:Product',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_type: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_type: Optional[pulumi.Input[str]] = None,
            industry: Optional[pulumi.Input[str]] = None,
            manufacturer_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            product_id: Optional[pulumi.Input[str]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProductServiceArgs']]]]] = None,
            space_id: Optional[pulumi.Input[str]] = None) -> 'Product':
        """
        Get an existing Product resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] data_type: Specifies the type of data.
               The valid values are **json** and **binary**.
        :param pulumi.Input[str] description: Specifies the description of the parameter. The description contains a maximum of
               128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] device_type: Specifies the device type. The device type contains a maximum of 32 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters
               are allowed: `?'#().,&%@!`. Example: StreetLight, GasMeter, or WaterMeter.
        :param pulumi.Input[str] industry: Specifies the industry which the device belongs to. The industry contains a maximum of
               64 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and
               the following specail characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] manufacturer_name: Specifies the manufacturer name. The name contains a maximum of 32 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
               characters are allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] name: Specifies the name of the parameter. The name contains a maximum of 64 characters.
               Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
               allowed: `?'#().,&%@!`.
        :param pulumi.Input[str] product_id: Specifies the product ID. The product ID contains a maximum of 32
               characters. Only letters, digits, hyphens (-) and underscores (_) are allowed. If omitted, the platform will
               automatically allocate a product ID. Changing this parameter will create a new resource.
        :param pulumi.Input[str] protocol: Specifies the protocal.
               The valid values are **MQTT**, **CoAP**, **HTTP**, **HTTPS**, **Modbus**, **ONVIF**, **OPC-UA**, **OPC-DA**, **Other**.
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA product resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProductServiceArgs']]]] services: Specifies the list of services.
               The services structure is documented below.
        :param pulumi.Input[str] space_id: Specifies the resource space ID which the product belongs to. If omitted,
               the product will belong to the default resource space. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProductState.__new__(_ProductState)

        __props__.__dict__["data_type"] = data_type
        __props__.__dict__["description"] = description
        __props__.__dict__["device_type"] = device_type
        __props__.__dict__["industry"] = industry
        __props__.__dict__["manufacturer_name"] = manufacturer_name
        __props__.__dict__["name"] = name
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["services"] = services
        __props__.__dict__["space_id"] = space_id
        return Product(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Output[str]:
        """
        Specifies the type of data.
        The valid values are **json** and **binary**.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the parameter. The description contains a maximum of
        128 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
        characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> pulumi.Output[str]:
        """
        Specifies the device type. The device type contains a maximum of 32 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters
        are allowed: `?'#().,&%@!`. Example: StreetLight, GasMeter, or WaterMeter.
        """
        return pulumi.get(self, "device_type")

    @property
    @pulumi.getter
    def industry(self) -> pulumi.Output[str]:
        """
        Specifies the industry which the device belongs to. The industry contains a maximum of
        64 characters. Only letters, Chinese characters, digits, hyphens (-), underscores (_) and
        the following specail characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "industry")

    @property
    @pulumi.getter(name="manufacturerName")
    def manufacturer_name(self) -> pulumi.Output[str]:
        """
        Specifies the manufacturer name. The name contains a maximum of 32 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail
        characters are allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "manufacturer_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the parameter. The name contains a maximum of 64 characters.
        Only letters, Chinese characters, digits, hyphens (-), underscores (_) and the following specail characters are
        allowed: `?'#().,&%@!`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[str]:
        """
        Specifies the product ID. The product ID contains a maximum of 32
        characters. Only letters, digits, hyphens (-) and underscores (_) are allowed. If omitted, the platform will
        automatically allocate a product ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        Specifies the protocal.
        The valid values are **MQTT**, **CoAP**, **HTTP**, **HTTPS**, **Modbus**, **ONVIF**, **OPC-UA**, **OPC-DA**, **Other**.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the IoTDA product resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def services(self) -> pulumi.Output[Sequence['outputs.ProductService']]:
        """
        Specifies the list of services.
        The services structure is documented below.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="spaceId")
    def space_id(self) -> pulumi.Output[str]:
        """
        Specifies the resource space ID which the product belongs to. If omitted,
        the product will belong to the default resource space. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "space_id")

