# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeviceLinkageRuleArgs', 'DeviceLinkageRule']

@pulumi.input_type
class DeviceLinkageRuleArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleActionArgs']]],
                 space_id: pulumi.Input[str],
                 triggers: pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleTriggerArgs']]],
                 description: Optional[pulumi.Input[str]] = None,
                 effective_period: Optional[pulumi.Input['DeviceLinkageRuleEffectivePeriodArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 trigger_logic: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DeviceLinkageRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleActionArgs']]] actions: Specifies the list of the actions, at most 10 actions.
               The actions structure is documented below.
        :param pulumi.Input[str] space_id: Specifies the resource space ID to which the device linkage rule belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleTriggerArgs']]] triggers: Specifies the list of the triggers, at most 10 triggers.
               The triggers structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the alarm.
        :param pulumi.Input['DeviceLinkageRuleEffectivePeriodArgs'] effective_period: Specifies the effective period of the device linkage rule. Always effectives
               by default. The effective_period structure is documented below.
        :param pulumi.Input[bool] enabled: Specifies whether to enable the device linkage rule. Defaults to `true`.
        :param pulumi.Input[str] name: Specifies the name of the alarm.
        :param pulumi.Input[str] region: Specifies the region to which the SMN belongs.
        :param pulumi.Input[str] trigger_logic: Specifies the logical relationship between multiple triggers.
               The options are as follows:
               + **and**: All of the triggers are met.
               + **or**: Any of the triggers are met.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "space_id", space_id)
        pulumi.set(__self__, "triggers", triggers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_period is not None:
            pulumi.set(__self__, "effective_period", effective_period)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if trigger_logic is not None:
            pulumi.set(__self__, "trigger_logic", trigger_logic)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleActionArgs']]]:
        """
        Specifies the list of the actions, at most 10 actions.
        The actions structure is documented below.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleActionArgs']]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter(name="spaceId")
    def space_id(self) -> pulumi.Input[str]:
        """
        Specifies the resource space ID to which the device linkage rule belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "space_id")

    @space_id.setter
    def space_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "space_id", value)

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleTriggerArgs']]]:
        """
        Specifies the list of the triggers, at most 10 triggers.
        The triggers structure is documented below.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleTriggerArgs']]]):
        pulumi.set(self, "triggers", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the alarm.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectivePeriod")
    def effective_period(self) -> Optional[pulumi.Input['DeviceLinkageRuleEffectivePeriodArgs']]:
        """
        Specifies the effective period of the device linkage rule. Always effectives
        by default. The effective_period structure is documented below.
        """
        return pulumi.get(self, "effective_period")

    @effective_period.setter
    def effective_period(self, value: Optional[pulumi.Input['DeviceLinkageRuleEffectivePeriodArgs']]):
        pulumi.set(self, "effective_period", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the device linkage rule. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the alarm.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region to which the SMN belongs.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="triggerLogic")
    def trigger_logic(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the logical relationship between multiple triggers.
        The options are as follows:
        + **and**: All of the triggers are met.
        + **or**: Any of the triggers are met.
        """
        return pulumi.get(self, "trigger_logic")

    @trigger_logic.setter
    def trigger_logic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger_logic", value)


@pulumi.input_type
class _DeviceLinkageRuleState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleActionArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 effective_period: Optional[pulumi.Input['DeviceLinkageRuleEffectivePeriodArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 trigger_logic: Optional[pulumi.Input[str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleTriggerArgs']]]] = None):
        """
        Input properties used for looking up and filtering DeviceLinkageRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleActionArgs']]] actions: Specifies the list of the actions, at most 10 actions.
               The actions structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the alarm.
        :param pulumi.Input['DeviceLinkageRuleEffectivePeriodArgs'] effective_period: Specifies the effective period of the device linkage rule. Always effectives
               by default. The effective_period structure is documented below.
        :param pulumi.Input[bool] enabled: Specifies whether to enable the device linkage rule. Defaults to `true`.
        :param pulumi.Input[str] name: Specifies the name of the alarm.
        :param pulumi.Input[str] region: Specifies the region to which the SMN belongs.
        :param pulumi.Input[str] space_id: Specifies the resource space ID to which the device linkage rule belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] trigger_logic: Specifies the logical relationship between multiple triggers.
               The options are as follows:
               + **and**: All of the triggers are met.
               + **or**: Any of the triggers are met.
        :param pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleTriggerArgs']]] triggers: Specifies the list of the triggers, at most 10 triggers.
               The triggers structure is documented below.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_period is not None:
            pulumi.set(__self__, "effective_period", effective_period)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if space_id is not None:
            pulumi.set(__self__, "space_id", space_id)
        if trigger_logic is not None:
            pulumi.set(__self__, "trigger_logic", trigger_logic)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleActionArgs']]]]:
        """
        Specifies the list of the actions, at most 10 actions.
        The actions structure is documented below.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the alarm.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectivePeriod")
    def effective_period(self) -> Optional[pulumi.Input['DeviceLinkageRuleEffectivePeriodArgs']]:
        """
        Specifies the effective period of the device linkage rule. Always effectives
        by default. The effective_period structure is documented below.
        """
        return pulumi.get(self, "effective_period")

    @effective_period.setter
    def effective_period(self, value: Optional[pulumi.Input['DeviceLinkageRuleEffectivePeriodArgs']]):
        pulumi.set(self, "effective_period", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the device linkage rule. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the alarm.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region to which the SMN belongs.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="spaceId")
    def space_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the resource space ID to which the device linkage rule belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "space_id")

    @space_id.setter
    def space_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "space_id", value)

    @property
    @pulumi.getter(name="triggerLogic")
    def trigger_logic(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the logical relationship between multiple triggers.
        The options are as follows:
        + **and**: All of the triggers are met.
        + **or**: Any of the triggers are met.
        """
        return pulumi.get(self, "trigger_logic")

    @trigger_logic.setter
    def trigger_logic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger_logic", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleTriggerArgs']]]]:
        """
        Specifies the list of the triggers, at most 10 triggers.
        The triggers structure is documented below.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceLinkageRuleTriggerArgs']]]]):
        pulumi.set(self, "triggers", value)


class DeviceLinkageRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeviceLinkageRuleActionArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 effective_period: Optional[pulumi.Input[pulumi.InputType['DeviceLinkageRuleEffectivePeriodArgs']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 trigger_logic: Optional[pulumi.Input[str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeviceLinkageRuleTriggerArgs']]]]] = None,
                 __props__=None):
        """
        Manages an IoTDA device linkage rule within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        space_id = config.require_object("spaceId")
        trigger_device_id = config.require_object("triggerDeviceId")
        action_device_id = config.require_object("actionDeviceId")
        topic = huaweicloud.smn.Topic("topic")
        test = huaweicloud.io_tda.DeviceLinkageRule("test",
            space_id=space_id,
            triggers=[
                huaweicloud.io_tda.DeviceLinkageRuleTriggerArgs(
                    type="SIMPLE_TIMER",
                    simple_timer_condition=huaweicloud.io_tda.DeviceLinkageRuleTriggerSimpleTimerConditionArgs(
                        start_time="20220622T160000Z",
                        repeat_interval=2,
                        repeat_count=2,
                    ),
                ),
                huaweicloud.io_tda.DeviceLinkageRuleTriggerArgs(
                    type="DEVICE_DATA",
                    device_data_condition=huaweicloud.io_tda.DeviceLinkageRuleTriggerDeviceDataConditionArgs(
                        device_id=trigger_device_id,
                        path="service_id/propertyName_1",
                        operator="=",
                        value="5",
                        trigger_strategy="pulse",
                        data_validatiy_period=300,
                    ),
                ),
                huaweicloud.io_tda.DeviceLinkageRuleTriggerArgs(
                    type="DAILY_TIMER",
                    daily_timer_condition=huaweicloud.io_tda.DeviceLinkageRuleTriggerDailyTimerConditionArgs(
                        start_time="19:02",
                    ),
                ),
            ],
            actions=[
                huaweicloud.io_tda.DeviceLinkageRuleActionArgs(
                    type="SMN_FORWARDING",
                    smn_forwarding=huaweicloud.io_tda.DeviceLinkageRuleActionSmnForwardingArgs(
                        region=topic.region,
                        topic_name=topic.name,
                        topic_urn=topic.topic_urn,
                        message_title="message_title",
                        message_content="message_content",
                    ),
                ),
                huaweicloud.io_tda.DeviceLinkageRuleActionArgs(
                    type="DEVICE_CMD",
                    device_command=huaweicloud.io_tda.DeviceLinkageRuleActionDeviceCommandArgs(
                        device_id=action_device_id,
                        service_id="service_id",
                        command_name="cmd_name",
                        command_body="{\\"cmd_parameter_1\\":\\"3\\"}",
                    ),
                ),
            ],
            effective_period=huaweicloud.io_tda.DeviceLinkageRuleEffectivePeriodArgs(
                start_time="00:00",
                end_time="23:59",
                days_of_week="1,2,3",
            ))
        ```

        ## Import

        Device linkage rules can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:IoTDA/deviceLinkageRule:DeviceLinkageRule test 62b6cc5aa367f403fea86127
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeviceLinkageRuleActionArgs']]]] actions: Specifies the list of the actions, at most 10 actions.
               The actions structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the alarm.
        :param pulumi.Input[pulumi.InputType['DeviceLinkageRuleEffectivePeriodArgs']] effective_period: Specifies the effective period of the device linkage rule. Always effectives
               by default. The effective_period structure is documented below.
        :param pulumi.Input[bool] enabled: Specifies whether to enable the device linkage rule. Defaults to `true`.
        :param pulumi.Input[str] name: Specifies the name of the alarm.
        :param pulumi.Input[str] region: Specifies the region to which the SMN belongs.
        :param pulumi.Input[str] space_id: Specifies the resource space ID to which the device linkage rule belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] trigger_logic: Specifies the logical relationship between multiple triggers.
               The options are as follows:
               + **and**: All of the triggers are met.
               + **or**: Any of the triggers are met.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeviceLinkageRuleTriggerArgs']]]] triggers: Specifies the list of the triggers, at most 10 triggers.
               The triggers structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeviceLinkageRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IoTDA device linkage rule within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        space_id = config.require_object("spaceId")
        trigger_device_id = config.require_object("triggerDeviceId")
        action_device_id = config.require_object("actionDeviceId")
        topic = huaweicloud.smn.Topic("topic")
        test = huaweicloud.io_tda.DeviceLinkageRule("test",
            space_id=space_id,
            triggers=[
                huaweicloud.io_tda.DeviceLinkageRuleTriggerArgs(
                    type="SIMPLE_TIMER",
                    simple_timer_condition=huaweicloud.io_tda.DeviceLinkageRuleTriggerSimpleTimerConditionArgs(
                        start_time="20220622T160000Z",
                        repeat_interval=2,
                        repeat_count=2,
                    ),
                ),
                huaweicloud.io_tda.DeviceLinkageRuleTriggerArgs(
                    type="DEVICE_DATA",
                    device_data_condition=huaweicloud.io_tda.DeviceLinkageRuleTriggerDeviceDataConditionArgs(
                        device_id=trigger_device_id,
                        path="service_id/propertyName_1",
                        operator="=",
                        value="5",
                        trigger_strategy="pulse",
                        data_validatiy_period=300,
                    ),
                ),
                huaweicloud.io_tda.DeviceLinkageRuleTriggerArgs(
                    type="DAILY_TIMER",
                    daily_timer_condition=huaweicloud.io_tda.DeviceLinkageRuleTriggerDailyTimerConditionArgs(
                        start_time="19:02",
                    ),
                ),
            ],
            actions=[
                huaweicloud.io_tda.DeviceLinkageRuleActionArgs(
                    type="SMN_FORWARDING",
                    smn_forwarding=huaweicloud.io_tda.DeviceLinkageRuleActionSmnForwardingArgs(
                        region=topic.region,
                        topic_name=topic.name,
                        topic_urn=topic.topic_urn,
                        message_title="message_title",
                        message_content="message_content",
                    ),
                ),
                huaweicloud.io_tda.DeviceLinkageRuleActionArgs(
                    type="DEVICE_CMD",
                    device_command=huaweicloud.io_tda.DeviceLinkageRuleActionDeviceCommandArgs(
                        device_id=action_device_id,
                        service_id="service_id",
                        command_name="cmd_name",
                        command_body="{\\"cmd_parameter_1\\":\\"3\\"}",
                    ),
                ),
            ],
            effective_period=huaweicloud.io_tda.DeviceLinkageRuleEffectivePeriodArgs(
                start_time="00:00",
                end_time="23:59",
                days_of_week="1,2,3",
            ))
        ```

        ## Import

        Device linkage rules can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:IoTDA/deviceLinkageRule:DeviceLinkageRule test 62b6cc5aa367f403fea86127
        ```

        :param str resource_name: The name of the resource.
        :param DeviceLinkageRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeviceLinkageRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeviceLinkageRuleActionArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 effective_period: Optional[pulumi.Input[pulumi.InputType['DeviceLinkageRuleEffectivePeriodArgs']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 space_id: Optional[pulumi.Input[str]] = None,
                 trigger_logic: Optional[pulumi.Input[str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeviceLinkageRuleTriggerArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeviceLinkageRuleArgs.__new__(DeviceLinkageRuleArgs)

            if actions is None and not opts.urn:
                raise TypeError("Missing required property 'actions'")
            __props__.__dict__["actions"] = actions
            __props__.__dict__["description"] = description
            __props__.__dict__["effective_period"] = effective_period
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if space_id is None and not opts.urn:
                raise TypeError("Missing required property 'space_id'")
            __props__.__dict__["space_id"] = space_id
            __props__.__dict__["trigger_logic"] = trigger_logic
            if triggers is None and not opts.urn:
                raise TypeError("Missing required property 'triggers'")
            __props__.__dict__["triggers"] = triggers
        super(DeviceLinkageRule, __self__).__init__(
            'huaweicloud:IoTDA/deviceLinkageRule:DeviceLinkageRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeviceLinkageRuleActionArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            effective_period: Optional[pulumi.Input[pulumi.InputType['DeviceLinkageRuleEffectivePeriodArgs']]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            space_id: Optional[pulumi.Input[str]] = None,
            trigger_logic: Optional[pulumi.Input[str]] = None,
            triggers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeviceLinkageRuleTriggerArgs']]]]] = None) -> 'DeviceLinkageRule':
        """
        Get an existing DeviceLinkageRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeviceLinkageRuleActionArgs']]]] actions: Specifies the list of the actions, at most 10 actions.
               The actions structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the alarm.
        :param pulumi.Input[pulumi.InputType['DeviceLinkageRuleEffectivePeriodArgs']] effective_period: Specifies the effective period of the device linkage rule. Always effectives
               by default. The effective_period structure is documented below.
        :param pulumi.Input[bool] enabled: Specifies whether to enable the device linkage rule. Defaults to `true`.
        :param pulumi.Input[str] name: Specifies the name of the alarm.
        :param pulumi.Input[str] region: Specifies the region to which the SMN belongs.
        :param pulumi.Input[str] space_id: Specifies the resource space ID to which the device linkage rule belongs.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] trigger_logic: Specifies the logical relationship between multiple triggers.
               The options are as follows:
               + **and**: All of the triggers are met.
               + **or**: Any of the triggers are met.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeviceLinkageRuleTriggerArgs']]]] triggers: Specifies the list of the triggers, at most 10 triggers.
               The triggers structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeviceLinkageRuleState.__new__(_DeviceLinkageRuleState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_period"] = effective_period
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["space_id"] = space_id
        __props__.__dict__["trigger_logic"] = trigger_logic
        __props__.__dict__["triggers"] = triggers
        return DeviceLinkageRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.DeviceLinkageRuleAction']]:
        """
        Specifies the list of the actions, at most 10 actions.
        The actions structure is documented below.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the alarm.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectivePeriod")
    def effective_period(self) -> pulumi.Output[Optional['outputs.DeviceLinkageRuleEffectivePeriod']]:
        """
        Specifies the effective period of the device linkage rule. Always effectives
        by default. The effective_period structure is documented below.
        """
        return pulumi.get(self, "effective_period")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the device linkage rule. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the alarm.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region to which the SMN belongs.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="spaceId")
    def space_id(self) -> pulumi.Output[str]:
        """
        Specifies the resource space ID to which the device linkage rule belongs.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "space_id")

    @property
    @pulumi.getter(name="triggerLogic")
    def trigger_logic(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the logical relationship between multiple triggers.
        The options are as follows:
        + **and**: All of the triggers are met.
        + **or**: Any of the triggers are met.
        """
        return pulumi.get(self, "trigger_logic")

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Sequence['outputs.DeviceLinkageRuleTrigger']]:
        """
        Specifies the list of the triggers, at most 10 triggers.
        The triggers structure is documented below.
        """
        return pulumi.get(self, "triggers")

