# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetImageResult',
    'AwaitableGetImageResult',
    'get_image',
    'get_image_output',
]

@pulumi.output_type
class GetImageResult:
    """
    A collection of values returned by getImage.
    """
    def __init__(__self__, architecture=None, checksum=None, container_format=None, created_at=None, disk_format=None, enterprise_project_id=None, file=None, id=None, image_type=None, metadata=None, min_disk_gb=None, min_ram_mb=None, most_recent=None, name=None, name_regex=None, os=None, os_version=None, owner=None, protected=None, region=None, schema=None, size_bytes=None, size_max=None, size_min=None, sort_direction=None, sort_key=None, status=None, tag=None, updated_at=None, visibility=None):
        if architecture and not isinstance(architecture, str):
            raise TypeError("Expected argument 'architecture' to be a str")
        pulumi.set(__self__, "architecture", architecture)
        if checksum and not isinstance(checksum, str):
            raise TypeError("Expected argument 'checksum' to be a str")
        pulumi.set(__self__, "checksum", checksum)
        if container_format and not isinstance(container_format, str):
            raise TypeError("Expected argument 'container_format' to be a str")
        pulumi.set(__self__, "container_format", container_format)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if disk_format and not isinstance(disk_format, str):
            raise TypeError("Expected argument 'disk_format' to be a str")
        pulumi.set(__self__, "disk_format", disk_format)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if file and not isinstance(file, str):
            raise TypeError("Expected argument 'file' to be a str")
        pulumi.set(__self__, "file", file)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_type and not isinstance(image_type, str):
            raise TypeError("Expected argument 'image_type' to be a str")
        pulumi.set(__self__, "image_type", image_type)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if min_disk_gb and not isinstance(min_disk_gb, int):
            raise TypeError("Expected argument 'min_disk_gb' to be a int")
        pulumi.set(__self__, "min_disk_gb", min_disk_gb)
        if min_ram_mb and not isinstance(min_ram_mb, int):
            raise TypeError("Expected argument 'min_ram_mb' to be a int")
        pulumi.set(__self__, "min_ram_mb", min_ram_mb)
        if most_recent and not isinstance(most_recent, bool):
            raise TypeError("Expected argument 'most_recent' to be a bool")
        pulumi.set(__self__, "most_recent", most_recent)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if os and not isinstance(os, str):
            raise TypeError("Expected argument 'os' to be a str")
        pulumi.set(__self__, "os", os)
        if os_version and not isinstance(os_version, str):
            raise TypeError("Expected argument 'os_version' to be a str")
        pulumi.set(__self__, "os_version", os_version)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if protected and not isinstance(protected, bool):
            raise TypeError("Expected argument 'protected' to be a bool")
        pulumi.set(__self__, "protected", protected)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if schema and not isinstance(schema, str):
            raise TypeError("Expected argument 'schema' to be a str")
        pulumi.set(__self__, "schema", schema)
        if size_bytes and not isinstance(size_bytes, int):
            raise TypeError("Expected argument 'size_bytes' to be a int")
        pulumi.set(__self__, "size_bytes", size_bytes)
        if size_max and not isinstance(size_max, int):
            raise TypeError("Expected argument 'size_max' to be a int")
        if size_max is not None:
            warnings.warn("""size_max is deprecated""", DeprecationWarning)
            pulumi.log.warn("""size_max is deprecated: size_max is deprecated""")

        pulumi.set(__self__, "size_max", size_max)
        if size_min and not isinstance(size_min, int):
            raise TypeError("Expected argument 'size_min' to be a int")
        if size_min is not None:
            warnings.warn("""size_min is deprecated""", DeprecationWarning)
            pulumi.log.warn("""size_min is deprecated: size_min is deprecated""")

        pulumi.set(__self__, "size_min", size_min)
        if sort_direction and not isinstance(sort_direction, str):
            raise TypeError("Expected argument 'sort_direction' to be a str")
        pulumi.set(__self__, "sort_direction", sort_direction)
        if sort_key and not isinstance(sort_key, str):
            raise TypeError("Expected argument 'sort_key' to be a str")
        pulumi.set(__self__, "sort_key", sort_key)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if visibility and not isinstance(visibility, str):
            raise TypeError("Expected argument 'visibility' to be a str")
        pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[str]:
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        The checksum of the data associated with the image.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter(name="containerFormat")
    def container_format(self) -> str:
        """
        The format of the image's container.
        """
        return pulumi.get(self, "container_format")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The date when the image was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="diskFormat")
    def disk_format(self) -> str:
        """
        The format of the image's disk.
        """
        return pulumi.get(self, "disk_format")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def file(self) -> str:
        """
        the trailing path after the glance endpoint that represent the location of the image or the path to retrieve
        it.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> str:
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        The metadata associated with the image. Image metadata allow for meaningfully define the image properties
        and tags.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="minDiskGb")
    def min_disk_gb(self) -> int:
        """
        The minimum amount of disk space required to use the image.
        """
        return pulumi.get(self, "min_disk_gb")

    @property
    @pulumi.getter(name="minRamMb")
    def min_ram_mb(self) -> int:
        """
        The minimum amount of ram required to use the image.
        """
        return pulumi.get(self, "min_ram_mb")

    @property
    @pulumi.getter(name="mostRecent")
    def most_recent(self) -> Optional[bool]:
        return pulumi.get(self, "most_recent")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def os(self) -> str:
        return pulumi.get(self, "os")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter
    def owner(self) -> str:
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def protected(self) -> bool:
        """
        Whether or not the image is protected.
        """
        return pulumi.get(self, "protected")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        The path to the JSON-schema that represent the image or image.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> int:
        """
        The size of the image (in bytes).
        """
        return pulumi.get(self, "size_bytes")

    @property
    @pulumi.getter(name="sizeMax")
    def size_max(self) -> Optional[int]:
        return pulumi.get(self, "size_max")

    @property
    @pulumi.getter(name="sizeMin")
    def size_min(self) -> Optional[int]:
        return pulumi.get(self, "size_min")

    @property
    @pulumi.getter(name="sortDirection")
    def sort_direction(self) -> Optional[str]:
        return pulumi.get(self, "sort_direction")

    @property
    @pulumi.getter(name="sortKey")
    def sort_key(self) -> Optional[str]:
        return pulumi.get(self, "sort_key")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the image.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def visibility(self) -> str:
        return pulumi.get(self, "visibility")


class AwaitableGetImageResult(GetImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageResult(
            architecture=self.architecture,
            checksum=self.checksum,
            container_format=self.container_format,
            created_at=self.created_at,
            disk_format=self.disk_format,
            enterprise_project_id=self.enterprise_project_id,
            file=self.file,
            id=self.id,
            image_type=self.image_type,
            metadata=self.metadata,
            min_disk_gb=self.min_disk_gb,
            min_ram_mb=self.min_ram_mb,
            most_recent=self.most_recent,
            name=self.name,
            name_regex=self.name_regex,
            os=self.os,
            os_version=self.os_version,
            owner=self.owner,
            protected=self.protected,
            region=self.region,
            schema=self.schema,
            size_bytes=self.size_bytes,
            size_max=self.size_max,
            size_min=self.size_min,
            sort_direction=self.sort_direction,
            sort_key=self.sort_key,
            status=self.status,
            tag=self.tag,
            updated_at=self.updated_at,
            visibility=self.visibility)


def get_image(architecture: Optional[str] = None,
              enterprise_project_id: Optional[str] = None,
              image_type: Optional[str] = None,
              most_recent: Optional[bool] = None,
              name: Optional[str] = None,
              name_regex: Optional[str] = None,
              os: Optional[str] = None,
              os_version: Optional[str] = None,
              owner: Optional[str] = None,
              region: Optional[str] = None,
              size_max: Optional[int] = None,
              size_min: Optional[int] = None,
              sort_direction: Optional[str] = None,
              sort_key: Optional[str] = None,
              tag: Optional[str] = None,
              visibility: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageResult:
    """
    Use this data source to get the ID of an available HuaweiCloud image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    ubuntu = huaweicloud.Ims.get_image(most_recent=True,
        name="Ubuntu 18.04 server 64bit",
        visibility="public")
    centos_1 = huaweicloud.Ims.get_image(architecture="x86",
        most_recent=True,
        os_version="CentOS 7.4 64bit",
        visibility="public")
    centos_2 = huaweicloud.Ims.get_image(architecture="x86",
        most_recent=True,
        name_regex="^CentOS 7.4",
        visibility="public")
    bms_image = huaweicloud.Ims.get_image(architecture="x86",
        image_type="Ironic",
        most_recent=True,
        os_version="CentOS 7.4 64bit",
        visibility="public")
    ```


    :param str architecture: Specifies the image architecture type. The value can be **x86** and **arm**.
    :param str enterprise_project_id: Specifies the enterprise project ID of the image.
    :param str image_type: Specifies the environment where the image is used. For a BMS image, the value is **Ironic**.
    :param bool most_recent: If more than one result is returned, use the latest updated image.
    :param str name: The name of the image. Cannot be used simultaneously with `name_regex`.
    :param str name_regex: The regular expressian of the name of the image.
           Cannot be used simultaneously with `name`.
    :param str os: Specifies the image OS type. The value can be **Windows**, **Ubuntu**,
           **RedHat**, **SUSE**, **CentOS**, **Debian**, **OpenSUSE**, **Oracle Linux**, **Fedora**, **Other**,
           **CoreOS**, or **EulerOS**.
    :param str os_version: Specifies the OS version. For example, *CentOS 7.4 64bit* or *Ubuntu 18.04 server 64bit*.
    :param str owner: The owner (UUID) of the image.
    :param str region: The region in which to obtain the images. If omitted, the provider-level region will be
           used.
    :param str sort_direction: Order the results in either `asc` or `desc`.
    :param str sort_key: Sort images based on a certain key. Must be one of
           "name", "container_format", "disk_format", "status", "id" or "size". Defaults to `name`.
    :param str tag: Search for images with a specific tag in "Key=Value" format.
    :param str visibility: The visibility of the image. Must be one of
           **public**, **private** or **shared**.
    """
    __args__ = dict()
    __args__['architecture'] = architecture
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['imageType'] = image_type
    __args__['mostRecent'] = most_recent
    __args__['name'] = name
    __args__['nameRegex'] = name_regex
    __args__['os'] = os
    __args__['osVersion'] = os_version
    __args__['owner'] = owner
    __args__['region'] = region
    __args__['sizeMax'] = size_max
    __args__['sizeMin'] = size_min
    __args__['sortDirection'] = sort_direction
    __args__['sortKey'] = sort_key
    __args__['tag'] = tag
    __args__['visibility'] = visibility
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Ims/getImage:getImage', __args__, opts=opts, typ=GetImageResult).value

    return AwaitableGetImageResult(
        architecture=__ret__.architecture,
        checksum=__ret__.checksum,
        container_format=__ret__.container_format,
        created_at=__ret__.created_at,
        disk_format=__ret__.disk_format,
        enterprise_project_id=__ret__.enterprise_project_id,
        file=__ret__.file,
        id=__ret__.id,
        image_type=__ret__.image_type,
        metadata=__ret__.metadata,
        min_disk_gb=__ret__.min_disk_gb,
        min_ram_mb=__ret__.min_ram_mb,
        most_recent=__ret__.most_recent,
        name=__ret__.name,
        name_regex=__ret__.name_regex,
        os=__ret__.os,
        os_version=__ret__.os_version,
        owner=__ret__.owner,
        protected=__ret__.protected,
        region=__ret__.region,
        schema=__ret__.schema,
        size_bytes=__ret__.size_bytes,
        size_max=__ret__.size_max,
        size_min=__ret__.size_min,
        sort_direction=__ret__.sort_direction,
        sort_key=__ret__.sort_key,
        status=__ret__.status,
        tag=__ret__.tag,
        updated_at=__ret__.updated_at,
        visibility=__ret__.visibility)


@_utilities.lift_output_func(get_image)
def get_image_output(architecture: Optional[pulumi.Input[Optional[str]]] = None,
                     enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                     image_type: Optional[pulumi.Input[Optional[str]]] = None,
                     most_recent: Optional[pulumi.Input[Optional[bool]]] = None,
                     name: Optional[pulumi.Input[Optional[str]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                     os: Optional[pulumi.Input[Optional[str]]] = None,
                     os_version: Optional[pulumi.Input[Optional[str]]] = None,
                     owner: Optional[pulumi.Input[Optional[str]]] = None,
                     region: Optional[pulumi.Input[Optional[str]]] = None,
                     size_max: Optional[pulumi.Input[Optional[int]]] = None,
                     size_min: Optional[pulumi.Input[Optional[int]]] = None,
                     sort_direction: Optional[pulumi.Input[Optional[str]]] = None,
                     sort_key: Optional[pulumi.Input[Optional[str]]] = None,
                     tag: Optional[pulumi.Input[Optional[str]]] = None,
                     visibility: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetImageResult]:
    """
    Use this data source to get the ID of an available HuaweiCloud image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    ubuntu = huaweicloud.Ims.get_image(most_recent=True,
        name="Ubuntu 18.04 server 64bit",
        visibility="public")
    centos_1 = huaweicloud.Ims.get_image(architecture="x86",
        most_recent=True,
        os_version="CentOS 7.4 64bit",
        visibility="public")
    centos_2 = huaweicloud.Ims.get_image(architecture="x86",
        most_recent=True,
        name_regex="^CentOS 7.4",
        visibility="public")
    bms_image = huaweicloud.Ims.get_image(architecture="x86",
        image_type="Ironic",
        most_recent=True,
        os_version="CentOS 7.4 64bit",
        visibility="public")
    ```


    :param str architecture: Specifies the image architecture type. The value can be **x86** and **arm**.
    :param str enterprise_project_id: Specifies the enterprise project ID of the image.
    :param str image_type: Specifies the environment where the image is used. For a BMS image, the value is **Ironic**.
    :param bool most_recent: If more than one result is returned, use the latest updated image.
    :param str name: The name of the image. Cannot be used simultaneously with `name_regex`.
    :param str name_regex: The regular expressian of the name of the image.
           Cannot be used simultaneously with `name`.
    :param str os: Specifies the image OS type. The value can be **Windows**, **Ubuntu**,
           **RedHat**, **SUSE**, **CentOS**, **Debian**, **OpenSUSE**, **Oracle Linux**, **Fedora**, **Other**,
           **CoreOS**, or **EulerOS**.
    :param str os_version: Specifies the OS version. For example, *CentOS 7.4 64bit* or *Ubuntu 18.04 server 64bit*.
    :param str owner: The owner (UUID) of the image.
    :param str region: The region in which to obtain the images. If omitted, the provider-level region will be
           used.
    :param str sort_direction: Order the results in either `asc` or `desc`.
    :param str sort_key: Sort images based on a certain key. Must be one of
           "name", "container_format", "disk_format", "status", "id" or "size". Defaults to `name`.
    :param str tag: Search for images with a specific tag in "Key=Value" format.
    :param str visibility: The visibility of the image. Must be one of
           **public**, **private** or **shared**.
    """
    ...
