# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VpcSubnetArgs', 'VpcSubnet']

@pulumi.input_type
class VpcSubnetArgs:
    def __init__(__self__, *,
                 cidr: pulumi.Input[str],
                 gateway_ip: pulumi.Input[str],
                 site_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 dhcp_enable: Optional[pulumi.Input[bool]] = None,
                 dns_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VpcSubnet resource.
        :param pulumi.Input[str] cidr: Specifies the network segment on which the subnet resides. The value must be in
               CIDR format and within the CIDR block of the iec vpc. Changing this parameter creates a new subnet resource.
        :param pulumi.Input[str] gateway_ip: Specifies the gateway of the subnet. The value must be a valid IP address
               and in the subnet segment. Changing this parameter creates a new subnet resource.
        :param pulumi.Input[str] site_id: Specifies the ID of the iec site. Changing this parameter creates a new
               subnet resource.
        :param pulumi.Input[str] vpc_id: Specifies the ID of the iec **CUSTOMER**
               vpc to which the subnet belongs. Changing this parameter creates a new subnet resource.
        :param pulumi.Input[bool] dhcp_enable: The status of subnet DHCP is enabled or not.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_lists: Specifies the DNS server address list of a subnet. These DNS server address must be
               valid IP addresses.
        :param pulumi.Input[str] name: Specifies the name of the iec vpc subnet. The value is a string of 1 to 64 characters that
               can contain letters, digits, underscores(_), and hyphens(-).
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "gateway_ip", gateway_ip)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if dhcp_enable is not None:
            pulumi.set(__self__, "dhcp_enable", dhcp_enable)
        if dns_lists is not None:
            pulumi.set(__self__, "dns_lists", dns_lists)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[str]:
        """
        Specifies the network segment on which the subnet resides. The value must be in
        CIDR format and within the CIDR block of the iec vpc. Changing this parameter creates a new subnet resource.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> pulumi.Input[str]:
        """
        Specifies the gateway of the subnet. The value must be a valid IP address
        and in the subnet segment. Changing this parameter creates a new subnet resource.
        """
        return pulumi.get(self, "gateway_ip")

    @gateway_ip.setter
    def gateway_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway_ip", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the iec site. Changing this parameter creates a new
        subnet resource.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the iec **CUSTOMER**
        vpc to which the subnet belongs. Changing this parameter creates a new subnet resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="dhcpEnable")
    def dhcp_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        The status of subnet DHCP is enabled or not.
        """
        return pulumi.get(self, "dhcp_enable")

    @dhcp_enable.setter
    def dhcp_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp_enable", value)

    @property
    @pulumi.getter(name="dnsLists")
    def dns_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the DNS server address list of a subnet. These DNS server address must be
        valid IP addresses.
        """
        return pulumi.get(self, "dns_lists")

    @dns_lists.setter
    def dns_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_lists", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the iec vpc subnet. The value is a string of 1 to 64 characters that
        can contain letters, digits, underscores(_), and hyphens(-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _VpcSubnetState:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[str]] = None,
                 dhcp_enable: Optional[pulumi.Input[bool]] = None,
                 dns_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway_ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 site_info: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VpcSubnet resources.
        :param pulumi.Input[str] cidr: Specifies the network segment on which the subnet resides. The value must be in
               CIDR format and within the CIDR block of the iec vpc. Changing this parameter creates a new subnet resource.
        :param pulumi.Input[bool] dhcp_enable: The status of subnet DHCP is enabled or not.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_lists: Specifies the DNS server address list of a subnet. These DNS server address must be
               valid IP addresses.
        :param pulumi.Input[str] gateway_ip: Specifies the gateway of the subnet. The value must be a valid IP address
               and in the subnet segment. Changing this parameter creates a new subnet resource.
        :param pulumi.Input[str] name: Specifies the name of the iec vpc subnet. The value is a string of 1 to 64 characters that
               can contain letters, digits, underscores(_), and hyphens(-).
        :param pulumi.Input[str] site_id: Specifies the ID of the iec site. Changing this parameter creates a new
               subnet resource.
        :param pulumi.Input[str] site_info: The located information of the iec site. It contains area, province and city.
        :param pulumi.Input[str] status: The status of the subnet.
        :param pulumi.Input[str] vpc_id: Specifies the ID of the iec **CUSTOMER**
               vpc to which the subnet belongs. Changing this parameter creates a new subnet resource.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if dhcp_enable is not None:
            pulumi.set(__self__, "dhcp_enable", dhcp_enable)
        if dns_lists is not None:
            pulumi.set(__self__, "dns_lists", dns_lists)
        if gateway_ip is not None:
            pulumi.set(__self__, "gateway_ip", gateway_ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if site_info is not None:
            pulumi.set(__self__, "site_info", site_info)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the network segment on which the subnet resides. The value must be in
        CIDR format and within the CIDR block of the iec vpc. Changing this parameter creates a new subnet resource.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="dhcpEnable")
    def dhcp_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        The status of subnet DHCP is enabled or not.
        """
        return pulumi.get(self, "dhcp_enable")

    @dhcp_enable.setter
    def dhcp_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dhcp_enable", value)

    @property
    @pulumi.getter(name="dnsLists")
    def dns_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the DNS server address list of a subnet. These DNS server address must be
        valid IP addresses.
        """
        return pulumi.get(self, "dns_lists")

    @dns_lists.setter
    def dns_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_lists", value)

    @property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the gateway of the subnet. The value must be a valid IP address
        and in the subnet segment. Changing this parameter creates a new subnet resource.
        """
        return pulumi.get(self, "gateway_ip")

    @gateway_ip.setter
    def gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the iec vpc subnet. The value is a string of 1 to 64 characters that
        can contain letters, digits, underscores(_), and hyphens(-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the iec site. Changing this parameter creates a new
        subnet resource.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="siteInfo")
    def site_info(self) -> Optional[pulumi.Input[str]]:
        """
        The located information of the iec site. It contains area, province and city.
        """
        return pulumi.get(self, "site_info")

    @site_info.setter
    def site_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site_info", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the subnet.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the iec **CUSTOMER**
        vpc to which the subnet belongs. Changing this parameter creates a new subnet resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class VpcSubnet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 dhcp_enable: Optional[pulumi.Input[bool]] = None,
                 dns_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway_ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a VPC subnet resource within HuaweiCloud IEC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        sites_test = huaweicloud.Iec.get_sites()
        vpc_test = huaweicloud.iec.Vpc("vpcTest",
            cidr="192.168.0.0/16",
            mode="CUSTOMER")
        subnet_test = huaweicloud.iec.VpcSubnet("subnetTest",
            cidr="192.168.128.0/18",
            vpc_id=vpc_test.id,
            site_id=sites_test.sites[0].id,
            gateway_ip="192.168.128.1")
        ```

        ## Import

        IEC vpc subnet can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iec/vpcSubnet:VpcSubnet subnet_demo 51be9f2b-5a3b-406a-9271-36f0c929fbcc
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr: Specifies the network segment on which the subnet resides. The value must be in
               CIDR format and within the CIDR block of the iec vpc. Changing this parameter creates a new subnet resource.
        :param pulumi.Input[bool] dhcp_enable: The status of subnet DHCP is enabled or not.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_lists: Specifies the DNS server address list of a subnet. These DNS server address must be
               valid IP addresses.
        :param pulumi.Input[str] gateway_ip: Specifies the gateway of the subnet. The value must be a valid IP address
               and in the subnet segment. Changing this parameter creates a new subnet resource.
        :param pulumi.Input[str] name: Specifies the name of the iec vpc subnet. The value is a string of 1 to 64 characters that
               can contain letters, digits, underscores(_), and hyphens(-).
        :param pulumi.Input[str] site_id: Specifies the ID of the iec site. Changing this parameter creates a new
               subnet resource.
        :param pulumi.Input[str] vpc_id: Specifies the ID of the iec **CUSTOMER**
               vpc to which the subnet belongs. Changing this parameter creates a new subnet resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcSubnetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPC subnet resource within HuaweiCloud IEC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        sites_test = huaweicloud.Iec.get_sites()
        vpc_test = huaweicloud.iec.Vpc("vpcTest",
            cidr="192.168.0.0/16",
            mode="CUSTOMER")
        subnet_test = huaweicloud.iec.VpcSubnet("subnetTest",
            cidr="192.168.128.0/18",
            vpc_id=vpc_test.id,
            site_id=sites_test.sites[0].id,
            gateway_ip="192.168.128.1")
        ```

        ## Import

        IEC vpc subnet can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iec/vpcSubnet:VpcSubnet subnet_demo 51be9f2b-5a3b-406a-9271-36f0c929fbcc
        ```

        :param str resource_name: The name of the resource.
        :param VpcSubnetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcSubnetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 dhcp_enable: Optional[pulumi.Input[bool]] = None,
                 dns_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gateway_ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcSubnetArgs.__new__(VpcSubnetArgs)

            if cidr is None and not opts.urn:
                raise TypeError("Missing required property 'cidr'")
            __props__.__dict__["cidr"] = cidr
            __props__.__dict__["dhcp_enable"] = dhcp_enable
            __props__.__dict__["dns_lists"] = dns_lists
            if gateway_ip is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_ip'")
            __props__.__dict__["gateway_ip"] = gateway_ip
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["site_info"] = None
            __props__.__dict__["status"] = None
        super(VpcSubnet, __self__).__init__(
            'huaweicloud:Iec/vpcSubnet:VpcSubnet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr: Optional[pulumi.Input[str]] = None,
            dhcp_enable: Optional[pulumi.Input[bool]] = None,
            dns_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            gateway_ip: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            site_id: Optional[pulumi.Input[str]] = None,
            site_info: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'VpcSubnet':
        """
        Get an existing VpcSubnet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr: Specifies the network segment on which the subnet resides. The value must be in
               CIDR format and within the CIDR block of the iec vpc. Changing this parameter creates a new subnet resource.
        :param pulumi.Input[bool] dhcp_enable: The status of subnet DHCP is enabled or not.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_lists: Specifies the DNS server address list of a subnet. These DNS server address must be
               valid IP addresses.
        :param pulumi.Input[str] gateway_ip: Specifies the gateway of the subnet. The value must be a valid IP address
               and in the subnet segment. Changing this parameter creates a new subnet resource.
        :param pulumi.Input[str] name: Specifies the name of the iec vpc subnet. The value is a string of 1 to 64 characters that
               can contain letters, digits, underscores(_), and hyphens(-).
        :param pulumi.Input[str] site_id: Specifies the ID of the iec site. Changing this parameter creates a new
               subnet resource.
        :param pulumi.Input[str] site_info: The located information of the iec site. It contains area, province and city.
        :param pulumi.Input[str] status: The status of the subnet.
        :param pulumi.Input[str] vpc_id: Specifies the ID of the iec **CUSTOMER**
               vpc to which the subnet belongs. Changing this parameter creates a new subnet resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcSubnetState.__new__(_VpcSubnetState)

        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["dhcp_enable"] = dhcp_enable
        __props__.__dict__["dns_lists"] = dns_lists
        __props__.__dict__["gateway_ip"] = gateway_ip
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["site_info"] = site_info
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        return VpcSubnet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[str]:
        """
        Specifies the network segment on which the subnet resides. The value must be in
        CIDR format and within the CIDR block of the iec vpc. Changing this parameter creates a new subnet resource.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="dhcpEnable")
    def dhcp_enable(self) -> pulumi.Output[Optional[bool]]:
        """
        The status of subnet DHCP is enabled or not.
        """
        return pulumi.get(self, "dhcp_enable")

    @property
    @pulumi.getter(name="dnsLists")
    def dns_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the DNS server address list of a subnet. These DNS server address must be
        valid IP addresses.
        """
        return pulumi.get(self, "dns_lists")

    @property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> pulumi.Output[str]:
        """
        Specifies the gateway of the subnet. The value must be a valid IP address
        and in the subnet segment. Changing this parameter creates a new subnet resource.
        """
        return pulumi.get(self, "gateway_ip")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the iec vpc subnet. The value is a string of 1 to 64 characters that
        can contain letters, digits, underscores(_), and hyphens(-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the iec site. Changing this parameter creates a new
        subnet resource.
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="siteInfo")
    def site_info(self) -> pulumi.Output[str]:
        """
        The located information of the iec site. It contains area, province and city.
        """
        return pulumi.get(self, "site_info")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the subnet.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the iec **CUSTOMER**
        vpc to which the subnet belongs. Changing this parameter creates a new subnet resource.
        """
        return pulumi.get(self, "vpc_id")

