# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VpcArgs', 'Vpc']

@pulumi.input_type
class VpcArgs:
    def __init__(__self__, *,
                 cidr: pulumi.Input[str],
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Vpc resource.
        :param pulumi.Input[str] cidr: Specifies the IP address range for the VPC. The subnet IP address in the VPC must be
               within the IP address range of the VPC. The following CIDR blocks are supported:
               *10.0.0.0/8-16*, *172.16.0.0/12-16*, *192.168.0.0/16*.
        :param pulumi.Input[str] mode: Specifies the mode of the IEC VPC. Possible values are "SYSTEM" and "CUSTOMER",
               defaults to "SYSTEM". Changing this creates a new IEC VPC.
        :param pulumi.Input[str] name: Specifies the name of the IEC VPC. The name can contain a maximum of 64 characters. Only
               letters, digits, underscores (_), hyphens (-), and periods (.) are allowed.
        :param pulumi.Input[str] region: The region in which to create the IEC VPC. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "cidr", cidr)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[str]:
        """
        Specifies the IP address range for the VPC. The subnet IP address in the VPC must be
        within the IP address range of the VPC. The following CIDR blocks are supported:
        *10.0.0.0/8-16*, *172.16.0.0/12-16*, *192.168.0.0/16*.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the mode of the IEC VPC. Possible values are "SYSTEM" and "CUSTOMER",
        defaults to "SYSTEM". Changing this creates a new IEC VPC.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the IEC VPC. The name can contain a maximum of 64 characters. Only
        letters, digits, underscores (_), hyphens (-), and periods (.) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the IEC VPC. If omitted, the provider-level
        region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _VpcState:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 subnet_num: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Vpc resources.
        :param pulumi.Input[str] cidr: Specifies the IP address range for the VPC. The subnet IP address in the VPC must be
               within the IP address range of the VPC. The following CIDR blocks are supported:
               *10.0.0.0/8-16*, *172.16.0.0/12-16*, *192.168.0.0/16*.
        :param pulumi.Input[str] mode: Specifies the mode of the IEC VPC. Possible values are "SYSTEM" and "CUSTOMER",
               defaults to "SYSTEM". Changing this creates a new IEC VPC.
        :param pulumi.Input[str] name: Specifies the name of the IEC VPC. The name can contain a maximum of 64 characters. Only
               letters, digits, underscores (_), hyphens (-), and periods (.) are allowed.
        :param pulumi.Input[str] region: The region in which to create the IEC VPC. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnet_num is not None:
            pulumi.set(__self__, "subnet_num", subnet_num)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IP address range for the VPC. The subnet IP address in the VPC must be
        within the IP address range of the VPC. The following CIDR blocks are supported:
        *10.0.0.0/8-16*, *172.16.0.0/12-16*, *192.168.0.0/16*.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the mode of the IEC VPC. Possible values are "SYSTEM" and "CUSTOMER",
        defaults to "SYSTEM". Changing this creates a new IEC VPC.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the IEC VPC. The name can contain a maximum of 64 characters. Only
        letters, digits, underscores (_), hyphens (-), and periods (.) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the IEC VPC. If omitted, the provider-level
        region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="subnetNum")
    def subnet_num(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "subnet_num")

    @subnet_num.setter
    def subnet_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "subnet_num", value)


class Vpc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an IEC VPC resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_name = config.require_object("vpcName")
        vpc_cidr = config.require_object("vpcCidr")
        vpc = huaweicloud.iec.Vpc("vpc", cidr=vpc_cidr)
        vpc_by_customer = huaweicloud.iec.Vpc("vpcByCustomer",
            cidr=vpc_cidr,
            mode="CUSTOMER")
        ```

        ## Import

        VPCs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iec/vpc:Vpc myvpc 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr: Specifies the IP address range for the VPC. The subnet IP address in the VPC must be
               within the IP address range of the VPC. The following CIDR blocks are supported:
               *10.0.0.0/8-16*, *172.16.0.0/12-16*, *192.168.0.0/16*.
        :param pulumi.Input[str] mode: Specifies the mode of the IEC VPC. Possible values are "SYSTEM" and "CUSTOMER",
               defaults to "SYSTEM". Changing this creates a new IEC VPC.
        :param pulumi.Input[str] name: Specifies the name of the IEC VPC. The name can contain a maximum of 64 characters. Only
               letters, digits, underscores (_), hyphens (-), and periods (.) are allowed.
        :param pulumi.Input[str] region: The region in which to create the IEC VPC. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IEC VPC resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_name = config.require_object("vpcName")
        vpc_cidr = config.require_object("vpcCidr")
        vpc = huaweicloud.iec.Vpc("vpc", cidr=vpc_cidr)
        vpc_by_customer = huaweicloud.iec.Vpc("vpcByCustomer",
            cidr=vpc_cidr,
            mode="CUSTOMER")
        ```

        ## Import

        VPCs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iec/vpc:Vpc myvpc 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param VpcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcArgs.__new__(VpcArgs)

            if cidr is None and not opts.urn:
                raise TypeError("Missing required property 'cidr'")
            __props__.__dict__["cidr"] = cidr
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["subnet_num"] = None
        super(Vpc, __self__).__init__(
            'huaweicloud:Iec/vpc:Vpc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr: Optional[pulumi.Input[str]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            subnet_num: Optional[pulumi.Input[int]] = None) -> 'Vpc':
        """
        Get an existing Vpc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr: Specifies the IP address range for the VPC. The subnet IP address in the VPC must be
               within the IP address range of the VPC. The following CIDR blocks are supported:
               *10.0.0.0/8-16*, *172.16.0.0/12-16*, *192.168.0.0/16*.
        :param pulumi.Input[str] mode: Specifies the mode of the IEC VPC. Possible values are "SYSTEM" and "CUSTOMER",
               defaults to "SYSTEM". Changing this creates a new IEC VPC.
        :param pulumi.Input[str] name: Specifies the name of the IEC VPC. The name can contain a maximum of 64 characters. Only
               letters, digits, underscores (_), hyphens (-), and periods (.) are allowed.
        :param pulumi.Input[str] region: The region in which to create the IEC VPC. If omitted, the provider-level
               region will be used. Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcState.__new__(_VpcState)

        __props__.__dict__["cidr"] = cidr
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["subnet_num"] = subnet_num
        return Vpc(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Output[str]:
        """
        Specifies the IP address range for the VPC. The subnet IP address in the VPC must be
        within the IP address range of the VPC. The following CIDR blocks are supported:
        *10.0.0.0/8-16*, *172.16.0.0/12-16*, *192.168.0.0/16*.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the mode of the IEC VPC. Possible values are "SYSTEM" and "CUSTOMER",
        defaults to "SYSTEM". Changing this creates a new IEC VPC.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the IEC VPC. The name can contain a maximum of 64 characters. Only
        letters, digits, underscores (_), hyphens (-), and periods (.) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The region in which to create the IEC VPC. If omitted, the provider-level
        region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="subnetNum")
    def subnet_num(self) -> pulumi.Output[int]:
        return pulumi.get(self, "subnet_num")

