# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'NetworkAclNetwork',
    'SecurityGroupSecurityGroupRule',
    'ServerCoverageSite',
    'ServerDataDisk',
    'ServerNic',
    'ServerVolumeAttached',
    'GetBandwidthsBandwidthResult',
    'GetEipsEipResult',
    'GetFlavorsFlavorResult',
    'GetImagesImageResult',
    'GetNetwork_aclNetworkResult',
    'GetSecurityGroupSecurityGroupRuleResult',
    'GetServerCoverageSiteResult',
    'GetServerNicResult',
    'GetServerVolumeAttachedResult',
    'GetSitesSiteResult',
    'GetSitesSiteLineResult',
    'GetVpcSubnetsSubnetResult',
]

@pulumi.output_type
class NetworkAclNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAclNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAclNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAclNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: str,
                 vpc_id: str):
        """
        :param str subnet_id: Specifies the id of the iec subnet.
        :param str vpc_id: Specifies the id of the iec vpc.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Specifies the id of the iec subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        Specifies the id of the iec vpc.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class SecurityGroupSecurityGroupRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portRangeMax":
            suggest = "port_range_max"
        elif key == "portRangeMin":
            suggest = "port_range_min"
        elif key == "remoteGroupId":
            suggest = "remote_group_id"
        elif key == "remoteIpPrefix":
            suggest = "remote_ip_prefix"
        elif key == "securityGroupId":
            suggest = "security_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityGroupSecurityGroupRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityGroupSecurityGroupRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityGroupSecurityGroupRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 direction: Optional[str] = None,
                 ethertype: Optional[str] = None,
                 id: Optional[str] = None,
                 port_range_max: Optional[int] = None,
                 port_range_min: Optional[int] = None,
                 protocol: Optional[str] = None,
                 remote_group_id: Optional[str] = None,
                 remote_ip_prefix: Optional[str] = None,
                 security_group_id: Optional[str] = None):
        """
        :param str description: Specifies the description of the iec security group. description must be
               0 to 64 characters in length, and does not contain angle brackets (<) and (>). Changing this parameter will creates a
               new iec security group resource.
        :param str direction: The direction of the iec security group rules.
        :param str ethertype: The layer 3 protocol type.
        :param str id: The id of the iec security group rules.
        :param int port_range_max: The higher part of the allowed port range.
        :param int port_range_min: The lower part of the allowed port range.
        :param str protocol: The layer 4 protocol type.
        :param str remote_group_id: The remote group id of the iec security group rules.
        :param str remote_ip_prefix: The remote CIDR of the iec security group rules.
        :param str security_group_id: The id of the iec security group rules.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if ethertype is not None:
            pulumi.set(__self__, "ethertype", ethertype)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if port_range_max is not None:
            pulumi.set(__self__, "port_range_max", port_range_max)
        if port_range_min is not None:
            pulumi.set(__self__, "port_range_min", port_range_min)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if remote_group_id is not None:
            pulumi.set(__self__, "remote_group_id", remote_group_id)
        if remote_ip_prefix is not None:
            pulumi.set(__self__, "remote_ip_prefix", remote_ip_prefix)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description of the iec security group. description must be
        0 to 64 characters in length, and does not contain angle brackets (<) and (>). Changing this parameter will creates a
        new iec security group resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The direction of the iec security group rules.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def ethertype(self) -> Optional[str]:
        """
        The layer 3 protocol type.
        """
        return pulumi.get(self, "ethertype")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The id of the iec security group rules.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="portRangeMax")
    def port_range_max(self) -> Optional[int]:
        """
        The higher part of the allowed port range.
        """
        return pulumi.get(self, "port_range_max")

    @property
    @pulumi.getter(name="portRangeMin")
    def port_range_min(self) -> Optional[int]:
        """
        The lower part of the allowed port range.
        """
        return pulumi.get(self, "port_range_min")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The layer 4 protocol type.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="remoteGroupId")
    def remote_group_id(self) -> Optional[str]:
        """
        The remote group id of the iec security group rules.
        """
        return pulumi.get(self, "remote_group_id")

    @property
    @pulumi.getter(name="remoteIpPrefix")
    def remote_ip_prefix(self) -> Optional[str]:
        """
        The remote CIDR of the iec security group rules.
        """
        return pulumi.get(self, "remote_ip_prefix")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[str]:
        """
        The id of the iec security group rules.
        """
        return pulumi.get(self, "security_group_id")


@pulumi.output_type
class ServerCoverageSite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "siteId":
            suggest = "site_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerCoverageSite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerCoverageSite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerCoverageSite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator: str,
                 site_id: str):
        """
        :param str operator: Specifies the operator of the IEC site.
        :param str site_id: Specifies the ID of IEC site.
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "site_id", site_id)

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Specifies the operator of the IEC site.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> str:
        """
        Specifies the ID of IEC site.
        """
        return pulumi.get(self, "site_id")


@pulumi.output_type
class ServerDataDisk(dict):
    def __init__(__self__, *,
                 size: int,
                 type: str):
        """
        :param int size: Specifies the size of data disk for the IEC server binding. The value range is
               10 to 500 in GB. Changing this parameter creates a new IEC server resource.
        :param str type: Specifies the type of data disk for the IEC server binding. Valid value is
               *SAS*(high I/O disk type). Changing this parameter creates a new IEC server resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Specifies the size of data disk for the IEC server binding. The value range is
        10 to 500 in GB. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of data disk for the IEC server binding. Valid value is
        *SAS*(high I/O disk type). Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServerNic(dict):
    def __init__(__self__, *,
                 address: Optional[str] = None,
                 mac: Optional[str] = None,
                 port: Optional[str] = None):
        """
        :param str address: The IPv4 address of the server on that network.
        :param str mac: The MAC address of the NIC on that network.
        :param str port: The port ID corresponding to the IP address on that network.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        The IPv4 address of the server on that network.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def mac(self) -> Optional[str]:
        """
        The MAC address of the NIC on that network.
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        The port ID corresponding to the IP address on that network.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServerVolumeAttached(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootIndex":
            suggest = "boot_index"
        elif key == "volumeId":
            suggest = "volume_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerVolumeAttached. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerVolumeAttached.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerVolumeAttached.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_index: Optional[str] = None,
                 device: Optional[str] = None,
                 size: Optional[int] = None,
                 type: Optional[str] = None,
                 volume_id: Optional[str] = None):
        """
        :param str boot_index: The volume boot index on that attachment.
        :param str device: The device name in the IEC server.
        :param int size: Specifies the size of data disk for the IEC server binding. The value range is
               10 to 500 in GB. Changing this parameter creates a new IEC server resource.
        :param str type: Specifies the type of data disk for the IEC server binding. Valid value is
               *SAS*(high I/O disk type). Changing this parameter creates a new IEC server resource.
        :param str volume_id: The volume ID on that attachment.
        """
        if boot_index is not None:
            pulumi.set(__self__, "boot_index", boot_index)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter(name="bootIndex")
    def boot_index(self) -> Optional[str]:
        """
        The volume boot index on that attachment.
        """
        return pulumi.get(self, "boot_index")

    @property
    @pulumi.getter
    def device(self) -> Optional[str]:
        """
        The device name in the IEC server.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        Specifies the size of data disk for the IEC server binding. The value range is
        10 to 500 in GB. Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the type of data disk for the IEC server binding. Valid value is
        *SAS*(high I/O disk type). Changing this parameter creates a new IEC server resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[str]:
        """
        The volume ID on that attachment.
        """
        return pulumi.get(self, "volume_id")


@pulumi.output_type
class GetBandwidthsBandwidthResult(dict):
    def __init__(__self__, *,
                 charge_mode: str,
                 id: str,
                 line: str,
                 name: str,
                 share_type: str,
                 size: int,
                 status: str):
        """
        :param str charge_mode: The charging mode of the bandwidth.
        :param str id: The ID of the bandwidth.
        :param str line: The line name of the bandwidth.
        :param str name: The name of the bandwidth.
        :param str share_type: Whether the bandwidth is shared or exclusive.
        :param int size: The size of the bandwidth.
        :param str status: The status of the bandwidth.
        """
        pulumi.set(__self__, "charge_mode", charge_mode)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "line", line)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "share_type", share_type)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> str:
        """
        The charging mode of the bandwidth.
        """
        return pulumi.get(self, "charge_mode")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the bandwidth.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def line(self) -> str:
        """
        The line name of the bandwidth.
        """
        return pulumi.get(self, "line")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the bandwidth.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> str:
        """
        Whether the bandwidth is shared or exclusive.
        """
        return pulumi.get(self, "share_type")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the bandwidth.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the bandwidth.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetEipsEipResult(dict):
    def __init__(__self__, *,
                 bandwidth_id: str,
                 bandwidth_name: str,
                 bandwidth_share_type: str,
                 bandwidth_size: int,
                 id: str,
                 ip_version: int,
                 port_id: str,
                 private_ip: str,
                 public_ip: str,
                 status: str):
        """
        :param str id: The ID of elastic IP.
        :param int ip_version: The version of elastic IP address.
        :param str port_id: Specifies the ID of the port.
        :param str private_ip: The address of private IP.
        :param str public_ip: The address of elastic IP.
        :param str status: The status elastic IP.
        """
        pulumi.set(__self__, "bandwidth_id", bandwidth_id)
        pulumi.set(__self__, "bandwidth_name", bandwidth_name)
        pulumi.set(__self__, "bandwidth_share_type", bandwidth_share_type)
        pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "port_id", port_id)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="bandwidthId")
    def bandwidth_id(self) -> str:
        return pulumi.get(self, "bandwidth_id")

    @property
    @pulumi.getter(name="bandwidthName")
    def bandwidth_name(self) -> str:
        return pulumi.get(self, "bandwidth_name")

    @property
    @pulumi.getter(name="bandwidthShareType")
    def bandwidth_share_type(self) -> str:
        return pulumi.get(self, "bandwidth_share_type")

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> int:
        return pulumi.get(self, "bandwidth_size")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of elastic IP.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> int:
        """
        The version of elastic IP address.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> str:
        """
        Specifies the ID of the port.
        """
        return pulumi.get(self, "port_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The address of private IP.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        """
        The address of elastic IP.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status elastic IP.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetFlavorsFlavorResult(dict):
    def __init__(__self__, *,
                 id: str,
                 memory: int,
                 name: str,
                 vcpus: int):
        """
        :param str id: The id of the iec flavor.
        :param int memory: The memory of the iec flavor.
        :param str name: Specifies the flavor name, which can be queried with a regular expression.
        :param int vcpus: The vcpus of the iec flavor.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vcpus", vcpus)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the iec flavor.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        The memory of the iec flavor.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the flavor name, which can be queried with a regular expression.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def vcpus(self) -> int:
        """
        The vcpus of the iec flavor.
        """
        return pulumi.get(self, "vcpus")


@pulumi.output_type
class GetImagesImageResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 os_type: str,
                 status: str):
        """
        :param str id: The id of the iec images.
        :param str name: Specifies the image Name, which can be queried with a regular expression.
        :param str os_type: Specifies the os type of the iec image.
               "Linux", "Windows" and "Other" are supported.
        :param str status: The status of the iec images.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the iec images.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the image Name, which can be queried with a regular expression.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        Specifies the os type of the iec image.
        "Linux", "Windows" and "Other" are supported.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the iec images.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNetwork_aclNetworkResult(dict):
    def __init__(__self__, *,
                 subnet_id: str,
                 vpc_id: str):
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetSecurityGroupSecurityGroupRuleResult(dict):
    def __init__(__self__, *,
                 description: str,
                 direction: str,
                 ethertype: str,
                 id: str,
                 port_range_max: int,
                 port_range_min: int,
                 protocol: str,
                 remote_group_id: str,
                 remote_ip_prefix: str,
                 security_group_id: str):
        """
        :param str description: The description for the IEC security group rules.
        :param str direction: The direction of the IEC security group rules.
        :param str ethertype: The layer 3 protocol type.
        :param str id: The ID of the IEC security group rules.
        :param int port_range_max: The higher part of the allowed port range.
        :param int port_range_min: The lower part of the allowed port range.
        :param str protocol: The layer 4 protocol type.
        :param str remote_group_id: The remote group id of the IEC security group rules.
        :param str remote_ip_prefix: The remote CIDR of the IEC security group rules.
        :param str security_group_id: The id of the IEC security group rules.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "ethertype", ethertype)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "port_range_max", port_range_max)
        pulumi.set(__self__, "port_range_min", port_range_min)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "remote_group_id", remote_group_id)
        pulumi.set(__self__, "remote_ip_prefix", remote_ip_prefix)
        pulumi.set(__self__, "security_group_id", security_group_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description for the IEC security group rules.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        The direction of the IEC security group rules.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def ethertype(self) -> str:
        """
        The layer 3 protocol type.
        """
        return pulumi.get(self, "ethertype")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the IEC security group rules.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="portRangeMax")
    def port_range_max(self) -> int:
        """
        The higher part of the allowed port range.
        """
        return pulumi.get(self, "port_range_max")

    @property
    @pulumi.getter(name="portRangeMin")
    def port_range_min(self) -> int:
        """
        The lower part of the allowed port range.
        """
        return pulumi.get(self, "port_range_min")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The layer 4 protocol type.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="remoteGroupId")
    def remote_group_id(self) -> str:
        """
        The remote group id of the IEC security group rules.
        """
        return pulumi.get(self, "remote_group_id")

    @property
    @pulumi.getter(name="remoteIpPrefix")
    def remote_ip_prefix(self) -> str:
        """
        The remote CIDR of the IEC security group rules.
        """
        return pulumi.get(self, "remote_ip_prefix")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        The id of the IEC security group rules.
        """
        return pulumi.get(self, "security_group_id")


@pulumi.output_type
class GetServerCoverageSiteResult(dict):
    def __init__(__self__, *,
                 operator: str,
                 site_id: str,
                 site_info: str):
        """
        :param str operator: The operator of the IEC site.
        :param str site_id: The ID of IEC site.
        :param str site_info: The located information of the IEC site. It contains area, province and city.
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "site_info", site_info)

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator of the IEC site.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> str:
        """
        The ID of IEC site.
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="siteInfo")
    def site_info(self) -> str:
        """
        The located information of the IEC site. It contains area, province and city.
        """
        return pulumi.get(self, "site_info")


@pulumi.output_type
class GetServerNicResult(dict):
    def __init__(__self__, *,
                 address: str,
                 mac: str,
                 port: str):
        """
        :param str address: The IPv4 address of the server on that network.
        :param str mac: The MAC address of the NIC on that network.
        :param str port: The port ID corresponding to the IP address on that network.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "mac", mac)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The IPv4 address of the server on that network.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def mac(self) -> str:
        """
        The MAC address of the NIC on that network.
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        The port ID corresponding to the IP address on that network.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetServerVolumeAttachedResult(dict):
    def __init__(__self__, *,
                 boot_index: str,
                 device: str,
                 size: int,
                 type: str,
                 volume_id: str):
        """
        :param str boot_index: The volume boot index on that attachment.
        :param str device: The device name in the IEC server.
        :param int size: The volume size on that attachment.
        :param str type: The volume type on that attachment.
        :param str volume_id: The volume ID on that attachment.
        """
        pulumi.set(__self__, "boot_index", boot_index)
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "volume_id", volume_id)

    @property
    @pulumi.getter(name="bootIndex")
    def boot_index(self) -> str:
        """
        The volume boot index on that attachment.
        """
        return pulumi.get(self, "boot_index")

    @property
    @pulumi.getter
    def device(self) -> str:
        """
        The device name in the IEC server.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The volume size on that attachment.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The volume type on that attachment.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> str:
        """
        The volume ID on that attachment.
        """
        return pulumi.get(self, "volume_id")


@pulumi.output_type
class GetSitesSiteResult(dict):
    def __init__(__self__, *,
                 area: str,
                 city: str,
                 id: str,
                 lines: Sequence['outputs.GetSitesSiteLineResult'],
                 name: str,
                 province: str,
                 status: str):
        """
        :param str area: Specifies the area of the IEC sites located.
        :param str city: Specifies the city of the IEC sites located.
        :param str id: The ID of the EIP line.
        :param Sequence['GetSitesSiteLineArgs'] lines: An array of one or more EIP lines. The object structure is documented below.
        :param str name: The name of the EIP line.
        :param str province: Specifies the province of the IEC sites located.
        :param str status: The status of the IEC service site.
        """
        pulumi.set(__self__, "area", area)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lines", lines)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "province", province)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def area(self) -> str:
        """
        Specifies the area of the IEC sites located.
        """
        return pulumi.get(self, "area")

    @property
    @pulumi.getter
    def city(self) -> str:
        """
        Specifies the city of the IEC sites located.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the EIP line.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def lines(self) -> Sequence['outputs.GetSitesSiteLineResult']:
        """
        An array of one or more EIP lines. The object structure is documented below.
        """
        return pulumi.get(self, "lines")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the EIP line.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def province(self) -> str:
        """
        Specifies the province of the IEC sites located.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the IEC service site.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetSitesSiteLineResult(dict):
    def __init__(__self__, *,
                 id: str,
                 ip_version: str,
                 name: str,
                 operator: str):
        """
        :param str id: The ID of the EIP line.
        :param str ip_version: The supported IP version.
        :param str name: The name of the EIP line.
        :param str operator: The operator information of the EIP line.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the EIP line.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> str:
        """
        The supported IP version.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the EIP line.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        The operator information of the EIP line.
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class GetVpcSubnetsSubnetResult(dict):
    def __init__(__self__, *,
                 cidr: str,
                 dns_lists: Sequence[str],
                 gateway_ip: str,
                 id: str,
                 name: str,
                 site_id: str,
                 site_info: str,
                 status: str):
        """
        :param str cidr: Indicates the cidr block of the subnet.
        :param Sequence[str] dns_lists: Indicates the DNS server address list of the subnet.
        :param str gateway_ip: Indicates the gateway of the subnet.
        :param str id: Indicates the ID of the subnet.
        :param str name: Indicates the name of the subnet.
        :param str site_id: Specifies the ID of the IEC site.
        :param str site_info: Indicates the located information of the iec site. It contains area, province and city.
        :param str status: Indicates the status of the subnet.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "dns_lists", dns_lists)
        pulumi.set(__self__, "gateway_ip", gateway_ip)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "site_info", site_info)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def cidr(self) -> str:
        """
        Indicates the cidr block of the subnet.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter(name="dnsLists")
    def dns_lists(self) -> Sequence[str]:
        """
        Indicates the DNS server address list of the subnet.
        """
        return pulumi.get(self, "dns_lists")

    @property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> str:
        """
        Indicates the gateway of the subnet.
        """
        return pulumi.get(self, "gateway_ip")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Indicates the ID of the subnet.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Indicates the name of the subnet.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> str:
        """
        Specifies the ID of the IEC site.
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="siteInfo")
    def site_info(self) -> str:
        """
        Indicates the located information of the iec site. It contains area, province and city.
        """
        return pulumi.get(self, "site_info")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the status of the subnet.
        """
        return pulumi.get(self, "status")


