# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetKeypairResult',
    'AwaitableGetKeypairResult',
    'get_keypair',
    'get_keypair_output',
]

@pulumi.output_type
class GetKeypairResult:
    """
    A collection of values returned by getKeypair.
    """
    def __init__(__self__, fingerprint=None, id=None, name=None, public_key=None):
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        The finger of iec keypair. The value contains a encoding type(SHA256) and a string of 43 characters.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        The pregenerated OpenSSH-formatted public key.
        """
        return pulumi.get(self, "public_key")


class AwaitableGetKeypairResult(GetKeypairResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeypairResult(
            fingerprint=self.fingerprint,
            id=self.id,
            name=self.name,
            public_key=self.public_key)


def get_keypair(name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeypairResult:
    """
    Use this data source to get the details of a specific IEC keypair.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    kp1 = huaweicloud.Iec.get_keypair(name="iec-keypair-demo")
    ```


    :param str name: Specifies a unique name for the keypair. This parameter can contain a maximum of 64
           characters, which may consist of letters, digits, underscores (_), and hyphens (-).
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Iec/getKeypair:getKeypair', __args__, opts=opts, typ=GetKeypairResult).value

    return AwaitableGetKeypairResult(
        fingerprint=__ret__.fingerprint,
        id=__ret__.id,
        name=__ret__.name,
        public_key=__ret__.public_key)


@_utilities.lift_output_func(get_keypair)
def get_keypair_output(name: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKeypairResult]:
    """
    Use this data source to get the details of a specific IEC keypair.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    kp1 = huaweicloud.Iec.get_keypair(name="iec-keypair-demo")
    ```


    :param str name: Specifies a unique name for the keypair. This parameter can contain a maximum of 64
           characters, which may consist of letters, digits, underscores (_), and hyphens (-).
    """
    ...
