# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetFlavorsResult',
    'AwaitableGetFlavorsResult',
    'get_flavors',
    'get_flavors_output',
]

@pulumi.output_type
class GetFlavorsResult:
    """
    A collection of values returned by getFlavors.
    """
    def __init__(__self__, area=None, city=None, flavors=None, id=None, name=None, operator=None, province=None, region=None, site_ids=None):
        if area and not isinstance(area, str):
            raise TypeError("Expected argument 'area' to be a str")
        pulumi.set(__self__, "area", area)
        if city and not isinstance(city, str):
            raise TypeError("Expected argument 'city' to be a str")
        pulumi.set(__self__, "city", city)
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if operator and not isinstance(operator, str):
            raise TypeError("Expected argument 'operator' to be a str")
        pulumi.set(__self__, "operator", operator)
        if province and not isinstance(province, str):
            raise TypeError("Expected argument 'province' to be a str")
        pulumi.set(__self__, "province", province)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if site_ids and not isinstance(site_ids, str):
            raise TypeError("Expected argument 'site_ids' to be a str")
        pulumi.set(__self__, "site_ids", site_ids)

    @property
    @pulumi.getter
    def area(self) -> Optional[str]:
        return pulumi.get(self, "area")

    @property
    @pulumi.getter
    def city(self) -> Optional[str]:
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetFlavorsFlavorResult']:
        """
        An array of one or more flavors. The flavors object structure is documented below.
        """
        return pulumi.get(self, "flavors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the iec flavor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def province(self) -> Optional[str]:
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="siteIds")
    def site_ids(self) -> Optional[str]:
        return pulumi.get(self, "site_ids")


class AwaitableGetFlavorsResult(GetFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlavorsResult(
            area=self.area,
            city=self.city,
            flavors=self.flavors,
            id=self.id,
            name=self.name,
            operator=self.operator,
            province=self.province,
            region=self.region,
            site_ids=self.site_ids)


def get_flavors(area: Optional[str] = None,
                city: Optional[str] = None,
                name: Optional[str] = None,
                operator: Optional[str] = None,
                province: Optional[str] = None,
                region: Optional[str] = None,
                site_ids: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlavorsResult:
    """
    Use this data source to get the available of HuaweiCloud IEC flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    flavor_name = config.get("flavorName")
    if flavor_name is None:
        flavor_name = "c6.large.2"
    iec_flavor_test = huaweicloud.Iec.get_flavors(name=flavor_name)
    ```


    :param str area: Specifies the province of the iec instance located.
    :param str city: Specifies the province of the iec instance located.
    :param str name: Specifies the flavor name, which can be queried with a regular expression.
    :param str operator: Specifies the operator supported of the iec instance.
    :param str province: Specifies the province of the iec instance located.
    :param str region: The region in which to obtain the flavors. If omitted, the provider-level region will be
           used.
    :param str site_ids: Specifies the list of edge service site.
    """
    __args__ = dict()
    __args__['area'] = area
    __args__['city'] = city
    __args__['name'] = name
    __args__['operator'] = operator
    __args__['province'] = province
    __args__['region'] = region
    __args__['siteIds'] = site_ids
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Iec/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult).value

    return AwaitableGetFlavorsResult(
        area=__ret__.area,
        city=__ret__.city,
        flavors=__ret__.flavors,
        id=__ret__.id,
        name=__ret__.name,
        operator=__ret__.operator,
        province=__ret__.province,
        region=__ret__.region,
        site_ids=__ret__.site_ids)


@_utilities.lift_output_func(get_flavors)
def get_flavors_output(area: Optional[pulumi.Input[Optional[str]]] = None,
                       city: Optional[pulumi.Input[Optional[str]]] = None,
                       name: Optional[pulumi.Input[Optional[str]]] = None,
                       operator: Optional[pulumi.Input[Optional[str]]] = None,
                       province: Optional[pulumi.Input[Optional[str]]] = None,
                       region: Optional[pulumi.Input[Optional[str]]] = None,
                       site_ids: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFlavorsResult]:
    """
    Use this data source to get the available of HuaweiCloud IEC flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    flavor_name = config.get("flavorName")
    if flavor_name is None:
        flavor_name = "c6.large.2"
    iec_flavor_test = huaweicloud.Iec.get_flavors(name=flavor_name)
    ```


    :param str area: Specifies the province of the iec instance located.
    :param str city: Specifies the province of the iec instance located.
    :param str name: Specifies the flavor name, which can be queried with a regular expression.
    :param str operator: Specifies the operator supported of the iec instance.
    :param str province: Specifies the province of the iec instance located.
    :param str region: The region in which to obtain the flavors. If omitted, the provider-level region will be
           used.
    :param str site_ids: Specifies the list of edge service site.
    """
    ...
